/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts.types;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseSensorGhost;
import com.fs.starfarer.api.impl.campaign.ghosts.GBDartAround;
import com.fs.starfarer.api.impl.campaign.ghosts.GBFollowClosely;
import com.fs.starfarer.api.impl.campaign.ghosts.GBGoAwayFrom;
import com.fs.starfarer.api.impl.campaign.ghosts.GBIDespawn;
import com.fs.starfarer.api.impl.campaign.ghosts.GBIGenerateSlipstream;
import com.fs.starfarer.api.impl.campaign.ghosts.GBITooClose;
import com.fs.starfarer.api.impl.campaign.ghosts.GBLeviathanCalfRun;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhostManager;

public class LeviathanCalfGhost
extends BaseSensorGhost {
    public LeviathanCalfGhost(SensorGhostManager manager, SectorEntityToken parent) {
        super(manager, 0);
        float size = this.genFloat(200.0f, 250.0f);
        this.initEntity(this.genLargeSensorProfile(), size);
        this.setDespawnRange(-100.0f);
        this.entity.addTag("unaffected_by_slipstream");
        int burnLevel = 30;
        this.setAccelMult(0.3f);
        this.setVel(parent.getVelocity());
        this.placeNearEntity(parent, 100.0f, 200.0f);
        this.addBehavior(new GBFollowClosely(parent, 1000.0f, burnLevel, 0.0f, 100.0f));
    }

    public LeviathanCalfGhost(SensorGhostManager manager) {
        super(manager, 0);
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        float size = this.genFloat(200.0f, 250.0f);
        this.initEntity(this.genLargeSensorProfile(), size);
        this.setDespawnRange(-100.0f);
        this.entity.addTag("unaffected_by_slipstream");
        int burnLevel = 25;
        this.setAccelMult(0.1f);
        if (!this.placeNearPlayer()) {
            this.setCreationFailed();
            return;
        }
        float travelDur = this.genFloat(5.0f, 8.0f);
        SectorEntityToken loc = Global.getSector().getHyperspace().createToken(this.entity.getLocation());
        this.addBehavior(new GBDartAround(loc, 20.0f, 2, 0.0f, 100.0f));
        this.addInterrupt(new GBITooClose(0.0f, pf, 100.0f));
        this.addInterrupt(new GBIDespawn(this.genFloat(10.0f, 15.0f)));
        this.addBehavior(new GBLeviathanCalfRun(travelDur, pf, 0.01f + 0.02f * manager.getRandom().nextFloat(), 0.0f + 15.0f * manager.getRandom().nextFloat(), burnLevel, true));
        this.addInterrupt(new GBIGenerateSlipstream(size, size * 1.2f, burnLevel - 5, 30.0f, 20, travelDur));
        this.addBehavior(new GBGoAwayFrom(10.0f, pf, 30));
    }
}

