/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts.types;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseSensorGhost;
import com.fs.starfarer.api.impl.campaign.ghosts.GBCircle;
import com.fs.starfarer.api.impl.campaign.ghosts.GBFollowClosely;
import com.fs.starfarer.api.impl.campaign.ghosts.GBGoAwayFrom;
import com.fs.starfarer.api.impl.campaign.ghosts.GBIRemoraDrain;
import com.fs.starfarer.api.impl.campaign.ghosts.GBIntercept;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhostManager;
import org.lwjgl.util.vector.Vector2f;

public class RemoraGhost
extends BaseSensorGhost {
    public RemoraGhost(SensorGhostManager manager, SectorEntityToken target, float duration) {
        this(manager, target, duration, null);
    }

    public RemoraGhost(SensorGhostManager manager, SectorEntityToken target, float duration, Vector2f loc) {
        super(manager, 50);
        float circleRadius = this.genFloat(0.0f, 50.0f);
        if (target instanceof CampaignFleetAPI) {
            circleRadius = this.genFloat(300.0f, 500.0f);
        }
        this.initEntity(this.genMediumSensorProfile(), this.genSmallRadius());
        this.setDespawnRange(0.0f);
        this.entity.addTag("immune_to_remora_pulse");
        if (loc != null) {
            this.setLoc(loc);
        } else if (target.isPlayerFleet()) {
            if (!this.placeNearPlayer()) {
                this.setCreationFailed();
                return;
            }
        } else {
            this.placeNearEntity(target, 200.0f, 300.0f);
        }
        this.addBehavior(new GBIntercept(target, 10.0f, 25, circleRadius + 500.0f, true));
        if (target instanceof CampaignFleetAPI) {
            this.setAccelMult(5.0f);
            this.addBehavior(new GBCircle(target, duration, 25 + manager.getRandom().nextInt(6), circleRadius, 1.0f));
        } else {
            this.setAccelMult(0.1f);
            this.addBehavior(new GBFollowClosely(target, duration, 50, 200.0f, 300.0f));
        }
        this.addInterrupt(new GBIRemoraDrain(target, 750.0f));
        this.addBehavior(new GBGoAwayFrom(5.0f, target, 20));
    }
}

