/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts.types;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseSensorGhost;
import com.fs.starfarer.api.impl.campaign.ghosts.GBCircle;
import com.fs.starfarer.api.impl.campaign.ghosts.GBITowardsEntity;
import com.fs.starfarer.api.impl.campaign.ghosts.GBIntercept;
import com.fs.starfarer.api.impl.campaign.ghosts.GBLeadPlayerTo;
import com.fs.starfarer.api.impl.campaign.ghosts.GBStayInPlace;
import com.fs.starfarer.api.impl.campaign.ghosts.GBStormArea;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhostManager;

public class StormTricksterGhost
extends BaseSensorGhost {
    public StormTricksterGhost(SensorGhostManager manager, SectorEntityToken target) {
        super(manager, 40);
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        float circleRadius = this.genFloat(300.0f, 400.0f);
        this.initEntity(this.genLargeSensorProfile(), this.genSmallRadius());
        if (!this.placeNearPlayer()) {
            this.setCreationFailed();
            return;
        }
        this.addBehavior(new GBIntercept(pf, 10.0f, 40, circleRadius + 500.0f, true));
        this.addBehavior(new GBCircle(pf, this.genDelay(2.0f), 40, circleRadius, 1.0f));
        this.addInterrupt(new GBITowardsEntity(this.genDelay(1.5f), pf, target));
        this.addBehavior(new GBLeadPlayerTo(20.0f, target, this.genFloat(500.0f, 600.0f), 25));
        this.addBehavior(new GBStayInPlace(0.4f + manager.getRandom().nextFloat() * 0.3f));
        this.addBehavior(new GBStormArea(1000.0f));
    }
}

