/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.impl.campaign.intel.bar.PortsideBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BaseBarEventCreator;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionBarEventWrapper;
import com.fs.starfarer.api.loading.BarEventSpec;

public class SpecBarEventCreator
extends BaseBarEventCreator {
    protected transient BarEventSpec spec = null;
    protected String specId = null;
    protected boolean wasAutoAdded = false;

    public SpecBarEventCreator(String specId) {
        this.specId = specId;
        this.readResolve();
    }

    protected Object readResolve() {
        this.spec = Global.getSettings().getBarEventSpec(this.specId);
        return this;
    }

    @Override
    public boolean wasAutoAdded() {
        return this.wasAutoAdded;
    }

    public void setWasAutoAdded(boolean wasAutoAdded) {
        this.wasAutoAdded = wasAutoAdded;
    }

    public BarEventSpec getSpec() {
        return this.spec;
    }

    @Override
    public String getBarEventId() {
        return this.specId;
    }

    @Override
    public PortsideBarEvent createBarEvent() {
        if (this.spec.isMission()) {
            return new HubMissionBarEventWrapper(this.specId);
        }
        return this.spec.createEvent();
    }

    @Override
    public float getBarEventActiveDuration() {
        return this.spec.getMinDur() + (this.spec.getMaxDur() - this.spec.getMinDur()) * (float)Math.random();
    }

    @Override
    public float getBarEventFrequencyWeight() {
        return this.spec.getFreq();
    }

    @Override
    public float getBarEventTimeoutDuration() {
        return this.spec.getMinTimeout() + (this.spec.getMaxTimeout() - this.spec.getMinTimeout()) * (float)Math.random();
    }

    @Override
    public float getBarEventAcceptedTimeoutDuration() {
        return this.spec.getMinAcceptedTimeout() + (this.spec.getMaxAcceptedTimeout() - this.spec.getMinAcceptedTimeout()) * (float)Math.random();
    }

    @Override
    public boolean isPriority() {
        return this.spec.hasTag("priority");
    }
}

