/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.DiktatFuelBonusScript;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.SindrianDiktatStandardActivityCause;
import com.fs.starfarer.api.impl.campaign.intel.events.TriTachyonStandardActivityCause;
import com.fs.starfarer.api.impl.campaign.intel.group.FGRaidAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FleetGroupIntel;
import com.fs.starfarer.api.impl.campaign.intel.group.GenericRaidFGI;
import com.fs.starfarer.api.impl.campaign.intel.group.SindrianDiktatPunitiveExpedition;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.CountingMap;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class SindrianDiktatHostileActivityFactor
extends BaseHostileActivityFactor
implements FleetGroupIntel.FGIEventListener {
    public static String DEFEATED_DIKTAT_ATTACK = "$defeatedDiktatAttack";
    public static String MADE_DIKTAT_DEAL = "$makeDiktatDeal";
    public static String BROKE_DIKTAT_DEAL = "$brokeDiktatDeal";
    public static String RAIDER_FLEET = "$diktatRaider";

    public static boolean isMadeDeal() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(MADE_DIKTAT_DEAL);
    }

    public static void setMadeDeal(boolean value) {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(MADE_DIKTAT_DEAL, value);
    }

    public static boolean brokeDeal() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(BROKE_DIKTAT_DEAL);
    }

    public static void setBrokeDeal(boolean broke) {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(BROKE_DIKTAT_DEAL, broke);
    }

    public static boolean isPlayerDefeatedDiktatAttack() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(DEFEATED_DIKTAT_ATTACK);
    }

    public static void setPlayerDefeatedDiktatAttack() {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(DEFEATED_DIKTAT_ATTACK, true);
    }

    public SindrianDiktatHostileActivityFactor(HostileActivityEventIntel intel) {
        super(intel);
    }

    @Override
    public String getProgressStr(BaseEventIntel intel) {
        return "";
    }

    @Override
    public String getDesc(BaseEventIntel intel) {
        return "Sindrian Diktat";
    }

    @Override
    public String getNameForThreatList(boolean first) {
        return "Sindrian Diktat";
    }

    @Override
    public Color getDescColor(BaseEventIntel intel) {
        if (this.getProgress(intel) <= 0) {
            return Misc.getGrayColor();
        }
        return Global.getSector().getFaction("sindrian_diktat").getBaseUIColor();
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getMainRowTooltip(BaseEventIntel intel) {
        return new BaseFactorTooltip(){

            @Override
            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("You've attracted the attention of the Sindrian Diktat.", 0.0f);
                tooltip.addPara("Sindrian raider fleets have been sighted in your space, attacking trade fleets regardless of their factional allegiance.", opad);
            }
        };
    }

    @Override
    public boolean shouldShow(BaseEventIntel intel) {
        return this.getProgress(intel) > 0;
    }

    @Override
    public int getProgress(BaseEventIntel intel) {
        if (!SindrianDiktatHostileActivityFactor.checkFactionExists("sindrian_diktat", true)) {
            return 0;
        }
        return super.getProgress(intel);
    }

    public Color getNameColor(float mag) {
        if (mag <= 0.0f) {
            return Misc.getGrayColor();
        }
        return Global.getSector().getFaction("sindrian_diktat").getBaseUIColor();
    }

    @Override
    public int getMaxNumFleets(StarSystemAPI system) {
        return Global.getSettings().getInt("diktatMaxFleets");
    }

    @Override
    public CampaignFleetAPI createFleet(StarSystemAPI system, Random random) {
        float f = this.intel.getMarketPresenceFactor(system);
        int difficulty = 4 + Math.round(f * 4.0f);
        FleetCreatorMission m = new FleetCreatorMission(random);
        m.beginFleet();
        Vector2f loc = system.getLocation();
        String factionId = "sindrian_diktat";
        m.createQualityFleet(difficulty, factionId, loc);
        m.triggerSetFleetType("raider");
        m.triggerSetPirateFleet();
        m.triggerMakeHostile();
        m.triggerMakeNonHostileToFaction("sindrian_diktat");
        m.triggerMakeNonHostileToFaction("pirates");
        m.triggerMakeLowRepImpact();
        m.triggerFleetAllowLongPursuit();
        m.triggerMakeHostileToAllTradeFleets();
        m.triggerMakeEveryoneJoinBattleAgainst();
        m.triggerSetFleetFlag(RAIDER_FLEET);
        m.triggerFleetMakeFaster(true, 0, true);
        CampaignFleetAPI fleet = m.createFleet();
        return fleet;
    }

    @Override
    public void addBulletPointForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        Color c = Global.getSector().getFaction("sindrian_diktat").getBaseUIColor();
        info.addPara("Impending Sindrian Diktat attack", initPad, tc, c, "Sindrian Diktat");
    }

    @Override
    public void addBulletPointForEventReset(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        info.addPara("Sindrian Diktat attack averted", tc, initPad);
    }

    @Override
    public void addStageDescriptionForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info) {
        float small = 0.0f;
        float opad = 10.0f;
        small = 8.0f;
        Color c = Global.getSector().getFaction("sindrian_diktat").getBaseUIColor();
        Color h = Misc.getHighlightColor();
        info.addPara("You've received intel that the Sindrian Diktat is planning an attack to saturation-bombard your fuel production facilities.", small, Misc.getNegativeHighlightColor(), "saturation-bombard");
        LabelAPI label = info.addPara("If the attack is defeated the Diktat will likely abandon further efforts against you, and your ability to export fuel will be improved.", opad);
        label.setHighlight("Diktat", "export fuel", "improved");
        label.setHighlightColors(Global.getSector().getFaction("sindrian_diktat").getBaseUIColor(), Misc.getPositiveHighlightColor(), Misc.getPositiveHighlightColor());
        c = Global.getSector().getFaction("sindrian_diktat").getBaseUIColor();
        stage.beginResetReqList(info, true, "crisis", opad);
        info.addPara("You go to %s and make an agreement with the Diktat", 0.0f, c, "Sindria");
        info.addPara("%s is tactically bombarded", 0.0f, c, "Sindria");
        info.addPara("Fuel production on %s is significantly disrupted", 0.0f, c, "Sindria");
        stage.endResetReqList(info, false, "crisis", -1, -1);
        this.addBorder(info, Global.getSector().getFaction("sindrian_diktat").getBaseUIColor());
    }

    @Override
    public String getEventStageIcon(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        return Global.getSector().getFaction("sindrian_diktat").getCrest();
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getStageTooltipImpl(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT) {
            return this.getDefaultEventTooltip("Sindrian Diktat attack", intel, stage);
        }
        return null;
    }

    public static Industry getSindrianFuelProd() {
        MarketAPI sindria = SindrianDiktatHostileActivityFactor.getSindria(false);
        if (sindria == null) {
            return null;
        }
        Industry prod = sindria.getIndustry("fuelprod");
        return prod;
    }

    public static MarketAPI getSindria(boolean requireMilitaryBase) {
        MarketAPI sindria = Global.getSector().getEconomy().getMarket("sindria");
        if (sindria == null || sindria.hasCondition("decivilized") || !sindria.getFactionId().equals("sindrian_diktat")) {
            return null;
        }
        if (requireMilitaryBase) {
            Industry b = sindria.getIndustry("militarybase");
            if (b == null) {
                b = sindria.getIndustry("highcommand");
            }
            if (b == null || b.isDisrupted() || !b.isFunctional()) {
                return null;
            }
        }
        return sindria;
    }

    @Override
    public float getEventFrequency(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT) {
            if (SindrianDiktatHostileActivityFactor.isPlayerDefeatedDiktatAttack() || SindrianDiktatHostileActivityFactor.getSindria(true) == null) {
                return 0.0f;
            }
            if (SindrianDiktatHostileActivityFactor.isMadeDeal()) {
                return 0.0f;
            }
            if (SindrianDiktatPunitiveExpedition.get() != null) {
                return 0.0f;
            }
            MarketAPI target = SindrianDiktatHostileActivityFactor.findExpeditionTarget(intel, stage);
            MarketAPI source = SindrianDiktatHostileActivityFactor.getSindria(true);
            if (target != null && source != null) {
                return 10.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public void rollEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        HostileActivityEventIntel.HAERandomEventData data = new HostileActivityEventIntel.HAERandomEventData(this, stage);
        stage.rollData = data;
        intel.sendUpdateIfPlayerHasIntel((Object)data, false);
    }

    @Override
    public boolean fireEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        MarketAPI target = SindrianDiktatHostileActivityFactor.findExpeditionTarget(intel, stage);
        MarketAPI source = SindrianDiktatHostileActivityFactor.getSindria(true);
        if (source == null || target == null) {
            return false;
        }
        stage.rollData = null;
        return this.startAttack(source, target, target.getStarSystem(), stage, this.getRandomizedStageRandom(3));
    }

    public static MarketAPI findExpeditionTarget(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        List<TriTachyonStandardActivityCause.CompetitorData> data = SindrianDiktatStandardActivityCause.computePlayerCompetitionData();
        CountingMap<MarketAPI> counts = new CountingMap<MarketAPI>();
        for (TriTachyonStandardActivityCause.CompetitorData curr : data) {
            for (MarketAPI market : curr.competitorProducers) {
                StarSystemAPI system = market.getStarSystem();
                if (system == null) continue;
                int weight = market.getCommodityData(curr.commodityId).getMaxSupply();
                counts.add(market, weight);
            }
        }
        return (MarketAPI)counts.getLargest();
    }

    @Override
    public void reportFGIAborted(FleetGroupIntel intel) {
        SindrianDiktatHostileActivityFactor.setPlayerDefeatedDiktatAttack();
        DiktatFuelBonusScript.grantBonus();
    }

    @Override
    public void notifyFactorRemoved() {
    }

    @Override
    public void notifyEventEnding() {
        this.notifyFactorRemoved();
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        BaseEventIntel.EventStageData stage = this.intel.getDataFor((Object)HostileActivityEventIntel.Stage.HA_EVENT);
        if (stage != null && stage.rollData instanceof HostileActivityEventIntel.HAERandomEventData && ((HostileActivityEventIntel.HAERandomEventData)stage.rollData).factor == this) {
            boolean prodOk;
            Industry prod = SindrianDiktatHostileActivityFactor.getSindrianFuelProd();
            boolean bl = prodOk = prod != null && prod.getSpecialItem() != null && !prod.isDisrupted();
            if (SindrianDiktatHostileActivityFactor.getSindria(true) == null || !prodOk) {
                this.intel.resetHA_EVENT();
            }
        }
    }

    public boolean startAttack(MarketAPI source, MarketAPI target, StarSystemAPI system, BaseEventIntel.EventStageData stage, Random random) {
        GenericRaidFGI.GenericRaidParams params = new GenericRaidFGI.GenericRaidParams(new Random(random.nextLong()), true);
        params.makeFleetsHostile = false;
        params.factionId = source.getFactionId();
        params.source = source;
        params.prepDays = 14.0f + random.nextFloat() * 14.0f;
        params.payloadDays = 27.0f + 7.0f * random.nextFloat();
        params.raidParams.where = system;
        params.raidParams.type = FGRaidAction.FGRaidType.SEQUENTIAL;
        params.raidParams.tryToCaptureObjectives = false;
        params.raidParams.allowedTargets.add(target);
        params.raidParams.allowNonHostileTargets = true;
        params.raidParams.setBombardment(MarketCMD.BombardType.SATURATION);
        params.style = FleetCreatorMission.FleetStyle.STANDARD;
        float fleetSizeMult = source.getStats().getDynamic().getMod("combat_fleet_size_mult").computeEffective(0.0f);
        float f = this.intel.getMarketPresenceFactor(system);
        float totalDifficulty = fleetSizeMult * 15.0f * (0.6f + 0.4f * f);
        if (totalDifficulty < 15.0f) {
            return false;
        }
        if (totalDifficulty > 100.0f) {
            totalDifficulty = 100.0f;
        }
        totalDifficulty -= 10.0f;
        params.fleetSizes.add(10);
        while (totalDifficulty > 0.0f) {
            int min = 6;
            int max = 10;
            int diff = min + random.nextInt(max - min + 1);
            params.fleetSizes.add(diff);
            totalDifficulty -= (float)diff;
        }
        SindrianDiktatPunitiveExpedition punex = new SindrianDiktatPunitiveExpedition(params);
        punex.setListener(this);
        Global.getSector().getIntelManager().addIntel(punex);
        return true;
    }
}

