/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.group;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.intel.group.BaseFGAction;

public class FGDurationAction
extends BaseFGAction {
    protected float durDays;
    protected float origDurDays;

    public FGDurationAction(float durDays) {
        this.durDays = durDays;
        this.origDurDays = durDays;
    }

    @Override
    public void notifyFleetsSpawnedMidSegment(RouteManager.RouteSegment segment) {
        super.notifyFleetsSpawnedMidSegment(segment);
        this.durDays *= 1.0f - segment.getProgress();
    }

    @Override
    public void directFleets(float amount) {
        super.directFleets(amount);
        float days = Global.getSector().getClock().convertToDays(amount);
        this.durDays -= days;
        if (this.durDays <= 0.0f) {
            this.setActionFinished(true);
            return;
        }
    }

    @Override
    public float getEstimatedDaysToComplete() {
        if (this.intel.isSpawnedFleets()) {
            return this.durDays;
        }
        RouteManager.RouteSegment segment = this.intel.getSegmentForAction(this);
        if (segment == null) {
            return 0.0f;
        }
        return Math.max(0.0f, segment.daysMax - segment.elapsed);
    }

    public float getDurDays() {
        return this.durDays;
    }

    public void setDurDays(float waitDays) {
        this.durDays = waitDays;
    }

    public float getOrigDurDays() {
        return this.origDurDays;
    }

    public void setOrigDurDays(float origDurDays) {
        this.origDurDays = origDurDays;
    }
}

