/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.BaseDisruptIndustry;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;

public class DisruptHeavyIndustry
extends BaseDisruptIndustry {
    @Override
    protected void createBarGiver(MarketAPI createdAt) {
        String post;
        ArrayList<String> posts = new ArrayList<String>();
        posts.add(Ranks.POST_AGENT);
        if (createdAt.getSize() >= 6) {
            posts.add(Ranks.POST_ADMINISTRATOR);
        }
        if (Misc.isMilitary(createdAt)) {
            posts.add(Ranks.POST_BASE_COMMANDER);
        }
        if (Misc.hasOrbitalStation(createdAt)) {
            posts.add(Ranks.POST_STATION_COMMANDER);
        }
        if ((post = this.pickOne(posts)) == null) {
            return;
        }
        this.setGiverRank(this.pickOne(Ranks.GROUND_CAPTAIN, Ranks.GROUND_COLONEL, Ranks.GROUND_MAJOR, Ranks.SPACE_COMMANDER, Ranks.SPACE_CAPTAIN, Ranks.SPACE_ADMIRAL));
        this.setGiverTags("military");
        this.setGiverPost(post);
        this.setGiverImportance(this.pickHighImportance());
        this.findOrCreateGiver(createdAt, false, false);
    }

    @Override
    protected boolean availableAtMarket(MarketAPI createdAt) {
        return Misc.isMilitary(createdAt);
    }

    @Override
    protected String[] getTargetIndustries() {
        return new String[]{"heavyindustry", "orbitalworks"};
    }

    @Override
    protected BaseHubMission.CreditReward getRewardTier() {
        return BaseHubMission.CreditReward.HIGH;
    }

    @Override
    protected void addExtraTriggers(MarketAPI createdAt) {
        if (this.market.getSize() <= 4) {
            this.triggerCreateMediumPatrolAroundMarket(this.market, (Object)BaseDisruptIndustry.Stage.DISRUPT, 0.0f);
        } else if (this.market.getSize() <= 6) {
            this.triggerCreateLargePatrolAroundMarket(this.market, (Object)BaseDisruptIndustry.Stage.DISRUPT, 0.0f);
        } else {
            this.triggerCreateMediumPatrolAroundMarket(this.market, (Object)BaseDisruptIndustry.Stage.DISRUPT, 0.0f);
            this.triggerCreateLargePatrolAroundMarket(this.market, (Object)BaseDisruptIndustry.Stage.DISRUPT, 0.0f);
        }
    }
}

