/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen.themes;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.AICoreOfficerPlugin;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FactionDoctrineAPI;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.events.OfficerManagerEvent;
import com.fs.starfarer.api.impl.campaign.fleets.BaseGenerateFleetOfficersPlugin;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.fleets.GenerateFleetOfficersPlugin;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

public class RemnantOfficerGeneratorPlugin
extends BaseGenerateFleetOfficersPlugin {
    protected boolean putCoresOnCivShips = false;
    protected boolean forceIntegrateCores = false;
    protected boolean forceNoCommander = false;
    protected boolean derelictMode = false;
    protected float coreMult = 1.0f;

    public RemnantOfficerGeneratorPlugin() {
    }

    public RemnantOfficerGeneratorPlugin(boolean derelictMode, float coreMult) {
        this.derelictMode = derelictMode;
        this.coreMult = coreMult;
    }

    public boolean isForceNoCommander() {
        return this.forceNoCommander;
    }

    public void setForceNoCommander(boolean forceNoCommander) {
        this.forceNoCommander = forceNoCommander;
    }

    public boolean isPutCoresOnCivShips() {
        return this.putCoresOnCivShips;
    }

    public void setPutCoresOnCivShips(boolean putCoresOnCivShips) {
        this.putCoresOnCivShips = putCoresOnCivShips;
    }

    public boolean isForceIntegrateCores() {
        return this.forceIntegrateCores;
    }

    public void setForceIntegrateCores(boolean forceIntegrateCores) {
        this.forceIntegrateCores = forceIntegrateCores;
    }

    @Override
    public int getHandlingPriority(Object params) {
        if (!(params instanceof GenerateFleetOfficersPlugin.GenerateFleetOfficersPickData)) {
            return -1;
        }
        GenerateFleetOfficersPlugin.GenerateFleetOfficersPickData data = (GenerateFleetOfficersPlugin.GenerateFleetOfficersPickData)params;
        if (data.params != null && !data.params.withOfficers) {
            return -1;
        }
        if (data.params.aiCores != null) {
            return 200;
        }
        if (data.fleet == null || !data.fleet.getFaction().getId().equals("remnant")) {
            return -1;
        }
        return 200;
    }

    @Override
    public void addCommanderAndOfficers(CampaignFleetAPI fleet, FleetParamsV3 params, Random random) {
        List<FleetMemberAPI> members;
        if (random == null) {
            random = Misc.random;
        }
        FactionAPI faction = fleet.getFaction();
        FactionDoctrineAPI doctrine = faction.getDoctrine();
        if (!this.derelictMode && params != null && params.doctrineOverride != null) {
            doctrine = params.doctrineOverride;
        }
        if ((members = fleet.getFleetData().getMembersListCopy()).isEmpty()) {
            return;
        }
        HashMap<String, AICoreOfficerPlugin> plugins = new HashMap<String, AICoreOfficerPlugin>();
        plugins.put("omega_core", Misc.getAICoreOfficerPlugin("omega_core"));
        plugins.put("alpha_core", Misc.getAICoreOfficerPlugin("alpha_core"));
        plugins.put("beta_core", Misc.getAICoreOfficerPlugin("beta_core"));
        plugins.put("gamma_core", Misc.getAICoreOfficerPlugin("gamma_core"));
        String nothing = "nothing";
        float fleetFP = 0.0f;
        for (FleetMemberAPI member : members) {
            fleetFP += (float)member.getFleetPointCost();
        }
        boolean allowAlphaAnywhere = fleetFP > 150.0f;
        boolean allowBetaAnywhere = fleetFP > 75.0f;
        boolean integrate = params != null && !params.doNotIntegrateAICores;
        integrate |= this.forceIntegrateCores;
        int numCommanderSkills = 0;
        if (allowBetaAnywhere) {
            ++numCommanderSkills;
        }
        if (allowAlphaAnywhere) {
            ++numCommanderSkills;
        }
        if (params != null && params.noCommanderSkills != null && params.noCommanderSkills.booleanValue()) {
            numCommanderSkills = 0;
        }
        float fpPerCore = Global.getSettings().getFloat("baseFPPerAICore");
        if (this.derelictMode) {
            fpPerCore = 30.0f - 20.0f * this.coreMult;
        }
        int minCores = (int)(fleetFP / fpPerCore * (params != null ? params.officerNumberMult : 1.0f));
        if (params != null) {
            minCores += params.officerNumberBonus;
        }
        if (minCores < 1) {
            minCores = 1;
        }
        boolean debug = true;
        debug = false;
        WeightedRandomPicker<FleetMemberAPI> withOfficers = new WeightedRandomPicker<FleetMemberAPI>(random);
        int maxSize = 0;
        for (FleetMemberAPI member : members) {
            int size;
            if (!Misc.isAutomated(member) || member.isFighterWing() || member.isCivilian() && !this.putCoresOnCivShips || (size = member.getHullSpec().getHullSize().ordinal()) <= maxSize) continue;
            maxSize = size;
        }
        ArrayList<FleetMemberAPI> allWithOfficers = new ArrayList<FleetMemberAPI>();
        int addedCores = 0;
        for (FleetMemberAPI member : members) {
            AICoreOfficerPlugin plugin;
            if (!Misc.isAutomated(member) || member.isCivilian() && !this.putCoresOnCivShips || member.isFighterWing()) continue;
            float fp = member.getFleetPointCost();
            WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(random);
            if (params != null && params.aiCores == HubMissionWithTriggers.OfficerQuality.AI_GAMMA) {
                picker.add("gamma_core", fp);
            } else if (params != null && params.aiCores == HubMissionWithTriggers.OfficerQuality.AI_BETA) {
                picker.add("beta_core", fp);
            } else if (params != null && params.aiCores == HubMissionWithTriggers.OfficerQuality.AI_ALPHA) {
                picker.add("alpha_core", fp);
            } else if (params != null && params.aiCores == HubMissionWithTriggers.OfficerQuality.AI_OMEGA) {
                picker.add("omega_core", fp);
            } else if (params != null && params.aiCores == HubMissionWithTriggers.OfficerQuality.AI_BETA_OR_GAMMA) {
                if (member.isCapital() || member.isCruiser()) {
                    picker.add("beta_core", fp);
                } else if (allowAlphaAnywhere) {
                    picker.add("beta_core", fp);
                } else {
                    picker.add("beta_core", fp / 2.0f);
                }
                picker.add("gamma_core", fp);
            } else if (this.derelictMode) {
                picker.add("gamma_core", fp);
            } else {
                if (member.isCapital() || member.isCruiser()) {
                    picker.add("alpha_core", fp);
                } else if (allowAlphaAnywhere) {
                    picker.add("alpha_core", fp);
                }
                if (member.isCruiser() || member.isDestroyer()) {
                    picker.add("beta_core", fp / 2.0f);
                } else if (allowBetaAnywhere && member.isFrigate()) {
                    picker.add("beta_core", fp);
                }
                if (member.isDestroyer() || member.isFrigate()) {
                    picker.add("gamma_core", fp);
                }
            }
            if (addedCores >= minCores) {
                picker.add(nothing, 10.0f * picker.getTotal() / fp);
            }
            String pick = (String)picker.pick();
            if (debug) {
                System.out.println("Picked [" + pick + "] for " + member.getHullId());
            }
            if ((plugin = (AICoreOfficerPlugin)plugins.get(pick)) != null) {
                ++addedCores;
                PersonAPI person = plugin.createPerson(pick, fleet.getFaction().getId(), random);
                member.setCaptain(person);
                if (integrate && !"omega_core".equals(pick)) {
                    RemnantOfficerGeneratorPlugin.integrateAndAdaptCoreForAIFleet(member);
                }
                if (!member.isFighterWing() && !member.isCivilian()) {
                    withOfficers.add(member, fp);
                }
                allWithOfficers.add(member);
            }
            if (addedCores > 0 && params != null && params.officerNumberMult <= 0.0f) break;
        }
        if (withOfficers.isEmpty() && !allWithOfficers.isEmpty()) {
            withOfficers.add((FleetMemberAPI)allWithOfficers.get(0), 1.0f);
        }
        FleetMemberAPI flagship = (FleetMemberAPI)withOfficers.pick();
        if (!this.derelictMode && !this.forceNoCommander && flagship != null) {
            PersonAPI commander = flagship.getCaptain();
            commander.setRankId(Ranks.SPACE_COMMANDER);
            commander.setPostId(Ranks.POST_FLEET_COMMANDER);
            fleet.setCommander(commander);
            fleet.getFleetData().setFlagship(flagship);
            RemnantOfficerGeneratorPlugin.addCommanderSkills(commander, fleet, params, numCommanderSkills, random);
        }
    }

    public static void integrateAndAdaptCoreForAIFleet(FleetMemberAPI member) {
        PersonAPI person = member.getCaptain();
        if (!person.isAICore()) {
            return;
        }
        person.getStats().setLevel(person.getStats().getLevel() + 1);
        person.getStats().setSkipRefresh(true);
        if (member.getVariant() != null && member.getVariant().getWeaponGroups() != null) {
            boolean hasEnoughMissiles;
            float weight = 0.0f;
            float pdWeight = 0.0f;
            float missileWeight = 0.0f;
            for (String slotId : member.getVariant().getFittedWeaponSlots()) {
                WeaponSpecAPI spec = member.getVariant().getWeaponSpec(slotId);
                if (spec == null) continue;
                float w = 1.0f;
                if (spec.getSize() == WeaponAPI.WeaponSize.MEDIUM) {
                    w = 2.0f;
                }
                if (spec.getSize() == WeaponAPI.WeaponSize.LARGE) {
                    w = 4.0f;
                }
                weight += w;
                if (spec.getAIHints().contains((Object)WeaponAPI.AIHints.PD)) {
                    pdWeight += w;
                }
                if (spec.getType() != WeaponAPI.WeaponType.MISSILE) continue;
                missileWeight += w;
            }
            float decks = member.getNumFlightDecks();
            if (decks > 0.0f) {
                weight += decks * 4.0f;
                pdWeight += decks * 4.0f;
            }
            boolean hasUsefulPD = pdWeight > weight * 0.25f;
            boolean bl = hasEnoughMissiles = missileWeight > weight * 0.2f;
            if (hasUsefulPD && !hasEnoughMissiles) {
                person.getStats().setSkillLevel("point_defense", 2.0f);
                person.getStats().setSkipRefresh(false);
                return;
            }
        }
        if (member.getHullSpec() != null && member.getHullSpec().hasTag("derelict") && person.getStats().getSkillLevel("ballistic_mastery") <= 0.0f) {
            person.getStats().setSkillLevel("ballistic_mastery", 2.0f);
        } else if (person.getStats().getSkillLevel("energy_weapon_mastery") <= 0.0f) {
            person.getStats().setSkillLevel("energy_weapon_mastery", 2.0f);
        } else {
            person.getStats().setSkillLevel("missile_specialization", 2.0f);
        }
        if ((member.isCapital() || member.isStation()) && person.getStats().getSkillLevel("polarized_armor") <= 0.0f) {
            person.getStats().setSkillLevel("combat_endurance", 0.0f);
            person.getStats().setSkillLevel("polarized_armor", 2.0f);
        }
        person.getStats().setSkipRefresh(false);
    }

    public static OfficerManagerEvent.SkillPickPreference getSkillPrefForShip(FleetMemberAPI member) {
        return FleetFactoryV3.getSkillPrefForShip(member);
    }

    public static void addCommanderSkills(PersonAPI commander, CampaignFleetAPI fleet, FleetParamsV3 params, int numSkills, Random random) {
        ArrayList<String> skills;
        if (random == null) {
            random = new Random();
        }
        if (numSkills <= 0) {
            return;
        }
        MutableCharacterStatsAPI stats = commander.getStats();
        FactionDoctrineAPI doctrine = fleet.getFaction().getDoctrine();
        if (params != null && params.doctrineOverride != null) {
            doctrine = params.doctrineOverride;
        }
        if ((skills = new ArrayList<String>(doctrine.getCommanderSkills())).isEmpty()) {
            return;
        }
        if (random.nextFloat() < doctrine.getCommanderSkillsShuffleProbability()) {
            Collections.shuffle(skills, random);
        }
        stats.setSkipRefresh(true);
        boolean debug = true;
        debug = false;
        if (debug) {
            System.out.println("Generating commander skills, person level " + stats.getLevel() + ", skills: " + numSkills);
        }
        int picks = 0;
        for (String skillId : skills) {
            if (debug) {
                System.out.println("Selected skill: [" + skillId + "]");
            }
            stats.setSkillLevel(skillId, 1.0f);
            if (++picks >= numSkills) break;
        }
        if (debug) {
            System.out.println("Done generating commander skills\n");
        }
        stats.setSkipRefresh(false);
        stats.refreshCharacterStatsEffects();
    }
}

