/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class FieldModulation {
    public static float SHIELD_DAMAGE_REDUCTION = 15.0f;
    public static float FLUX_SHUNT_DISSIPATION = 20.0f;
    public static float PHASE_FLUX_UPKEEP_REDUCTION = 25.0f;
    public static float PHASE_COOLDOWN_REDUCTION = 50.0f;
    public static float ELITE_DAMAGE_TO_SHIELDS_PERCENT = 5.0f;
    public static float OVERLOAD_REDUCTION = 25.0f;

    public static class Level1
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getShieldDamageTakenMult().modifyMult(id, 1.0f - SHIELD_DAMAGE_REDUCTION / 100.0f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getShieldDamageTakenMult().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "-" + (int)SHIELD_DAMAGE_REDUCTION + "% damage taken by shields";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getPhaseCloakUpkeepCostBonus().modifyMult(id, 1.0f - PHASE_FLUX_UPKEEP_REDUCTION / 100.0f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getPhaseCloakUpkeepCostBonus().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "-" + (int)PHASE_FLUX_UPKEEP_REDUCTION + "% flux generated by active phase cloak";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getHardFluxDissipationFraction().modifyFlat(id, FLUX_SHUNT_DISSIPATION / 100.0f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getHardFluxDissipationFraction().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return (int)FLUX_SHUNT_DISSIPATION + "% hard flux dissipation while shields are active";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level4
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getPhaseCloakCooldownBonus().modifyMult(id, 1.0f - PHASE_COOLDOWN_REDUCTION / 100.0f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getPhaseCloakCooldownBonus().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "-" + (int)PHASE_COOLDOWN_REDUCTION + "% phase cloak cooldown";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level5
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDamageToTargetShieldsMult().modifyPercent(id, ELITE_DAMAGE_TO_SHIELDS_PERCENT);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDamageToTargetShieldsMult().unmodifyPercent(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+" + (int)ELITE_DAMAGE_TO_SHIELDS_PERCENT + "% damage dealt to shields";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level6
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getOverloadTimeMod().modifyMult(id, 1.0f - OVERLOAD_REDUCTION / 100.0f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getOverloadTimeMod().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "-" + (int)OVERLOAD_REDUCTION + "% overload duration";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }
}

