/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class WingCommander {
    public static final float SPEED_BONUS = 25.0f;
    public static final float DAMAGE_TO_FIGHTERS_BONUS = 30.0f;
    public static final float DAMAGE_TO_MISSILES_BONUS = 30.0f;
    public static final float TARGET_LEADING_BONUS = 50.0f;

    public static class Level1
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getMaxSpeed().modifyPercent(id, 25.0f);
            stats.getAcceleration().modifyPercent(id, 25.0f);
            stats.getDeceleration().modifyPercent(id, 25.0f);
            stats.getTurnAcceleration().modifyPercent(id, 50.0f);
            stats.getMaxTurnRate().modifyPercent(id, 25.0f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMaxSpeed().unmodify(id);
            stats.getAcceleration().unmodify(id);
            stats.getDeceleration().unmodify(id);
            stats.getTurnAcceleration().unmodify(id);
            stats.getMaxTurnRate().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+25% top speed and maneuverability";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.SHIP_FIGHTERS;
        }
    }

    public static class Level2A
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDamageToFighters().modifyFlat(id, 0.3f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDamageToFighters().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+30% damage to fighters";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.SHIP_FIGHTERS;
        }
    }

    public static class Level2B
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDamageToMissiles().modifyFlat(id, 0.3f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDamageToMissiles().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+30% damage to missiles";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.SHIP_FIGHTERS;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getAutofireAimAccuracy().modifyFlat(id, 0.5f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getAutofireAimAccuracy().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+50% target leading accuracy";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.SHIP_FIGHTERS;
        }
    }
}

