/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.velfield;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.impl.campaign.velfield.SlipstreamBuilder;
import com.fs.starfarer.api.impl.campaign.velfield.SlipstreamTerrainPlugin2;
import com.fs.starfarer.api.util.Misc;
import java.util.Random;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class VelocityField {
    public static float RAD_PER_DEG = (float)Math.PI / 180;
    protected Vector2f[][] field;
    protected float cellSize;
    transient float cacheKeyAngle;
    transient float cachedSin;
    transient float cachedCos;

    public static Vector2f rotateAroundOrigin(Vector2f v, float cos, float sin) {
        Vector2f r = new Vector2f();
        r.x = v.x * cos - v.y * sin;
        r.y = v.x * sin + v.y * cos;
        return r;
    }

    public VelocityField(int width, int height, float cellSize) {
        this.field = new Vector2f[width][height];
        this.cellSize = cellSize;
        int i = 0;
        while (i < this.field.length) {
            int j = 0;
            while (j < this.field[0].length) {
                this.field[i][j] = new Vector2f();
                ++j;
            }
            ++i;
        }
    }

    public Vector2f[][] getField() {
        return this.field;
    }

    public Vector2f getCell(int i, int j) {
        if (i < 0) {
            i = 0;
        }
        if (j < 0) {
            j = 0;
        }
        if (i >= this.field.length) {
            i = this.field.length - 1;
        }
        if (j >= this.field[0].length) {
            j = this.field[0].length - 1;
        }
        return this.field[i][j];
    }

    public boolean isInsideField(float x, float y, Vector2f bottomLeft, float angle) {
        this.updateCacheIfNeeded(angle);
        Vector2f temp = new Vector2f(x -= bottomLeft.x, y -= bottomLeft.y);
        temp = VelocityField.rotateAroundOrigin(temp, this.cachedCos, -this.cachedSin);
        x = temp.x;
        y = temp.y;
        if (x < 0.0f) {
            return false;
        }
        if (y < 0.0f) {
            return false;
        }
        float w = this.cellSize * ((float)this.field.length - 1.0f);
        if (x > w) {
            return false;
        }
        float h = this.cellSize * ((float)this.field[0].length - 1.0f);
        return !(y > h);
    }

    public void updateCacheIfNeeded(float angle) {
        if (this.cacheKeyAngle != angle) {
            this.cacheKeyAngle = angle;
            this.cachedCos = (float)Math.cos(angle * RAD_PER_DEG);
            this.cachedSin = (float)Math.sin(angle * RAD_PER_DEG);
        }
    }

    public Vector2f getVelocity(float x, float y, Vector2f bottomLeft, float angle) {
        this.updateCacheIfNeeded(angle);
        Vector2f temp = new Vector2f(x -= bottomLeft.x, y -= bottomLeft.y);
        temp = VelocityField.rotateAroundOrigin(temp, this.cachedCos, -this.cachedSin);
        x = temp.x;
        y = temp.y;
        int cellX1 = (int)(x / this.cellSize);
        int cellY1 = (int)(y / this.cellSize);
        if (x < 0.0f) {
            cellX1 = (int)(-1.0f * Math.abs(x) / this.cellSize) - 1;
        }
        if (y < 0.0f) {
            cellY1 = (int)(-1.0f * Math.abs(y) / this.cellSize) - 1;
        }
        int cellX2 = cellX1 + 1;
        int cellY2 = cellY1 + 1;
        float px = x / this.cellSize - (float)cellX1;
        float py = y / this.cellSize - (float)cellY1;
        Vector2f bl = this.getCell(cellX1, cellY1);
        Vector2f br = this.getCell(cellX2, cellY1);
        Vector2f tl = this.getCell(cellX1, cellY2);
        Vector2f tr = this.getCell(cellX2, cellY2);
        Vector2f result = new Vector2f();
        result.x = (1.0f - py) * (bl.x * (1.0f - px) + br.x * px) + py * (tl.x * (1.0f - px) + tr.x * px);
        result.y = (1.0f - px) * (bl.y * (1.0f - py) + tl.y * py) + px * (br.y * (1.0f - py) + tr.y * py);
        result = VelocityField.rotateAroundOrigin(result, this.cachedCos, this.cachedSin);
        return result;
    }

    public float getCellSize() {
        return this.cellSize;
    }

    public void shiftDown() {
        int i = 0;
        while (i < this.field.length) {
            int j = 0;
            while (j < this.field[0].length - 1) {
                this.field[i][j] = this.field[i][j + 1];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.field.length) {
            this.field[i][this.field[0].length - 1] = new Vector2f();
            ++i;
        }
    }

    public static void spawnTest() {
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        SlipstreamTerrainPlugin2.SlipstreamParams2 params = new SlipstreamTerrainPlugin2.SlipstreamParams2();
        params.burnLevel = 30;
        params.minSpeed = Misc.getSpeedForBurnLevel(params.burnLevel - 5);
        params.maxSpeed = Misc.getSpeedForBurnLevel(params.burnLevel + 5);
        params.lineLengthFractionOfSpeed = 0.25f * Math.max(0.25f, Math.min(1.0f, 30.0f / (float)params.burnLevel));
        CampaignTerrainAPI slipstream = (CampaignTerrainAPI)Global.getSector().getCurrentLocation().addTerrain("slipstream", params);
        slipstream.setLocation(pf.getLocation().x + 200.0f, pf.getLocation().y + 200.0f);
        SlipstreamTerrainPlugin2 plugin = (SlipstreamTerrainPlugin2)slipstream.getPlugin();
        float spacing = 200.0f;
        long seed = 4384381378693924686L;
        seed = 0x106689D45497FDB5L ^ seed;
        Random random = new Random(seed *= 27L);
        SlipstreamBuilder builder = new SlipstreamBuilder(slipstream.getLocation(), plugin, SlipstreamBuilder.StreamType.WIDE, random);
        Vector2f to = new Vector2f((ReadableVector2f)slipstream.getLocation());
        to.x += 20000.0f;
        to.y += 20000.0f;
        Vector2f control = new Vector2f((ReadableVector2f)slipstream.getLocation());
        control.x += 10000.0f;
        builder.buildToDestination(control, to);
    }
}

