/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.impl.combat.dweller.DwellerCombatStrategyAI;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShroud;
import com.fs.starfarer.api.impl.combat.threat.RoilingSwarmEffect;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class ConvulsiveLungeSystemScript
extends BaseShipSystemScript {
    public static float PULL_DIST = 1000.0f;
    public static float PARTICLE_WINDUP_ACCEL = 1500.0f;
    public static float SPRING_CONSTANT = 4.0f;
    public static float FRICTION = 1000.0f;
    public static float MAW_WINDUP_MULT = 3.0f;
    protected Vector2f dest;
    protected boolean fadedFlash = false;

    protected void init(ShipAPI ship) {
    }

    @Override
    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        ShipAPI ship = null;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ship = (ShipAPI)stats.getEntity();
        DwellerShroud shroud = DwellerShroud.getShroudFor(ship);
        if (state == ShipSystemStatsScript.State.IN) {
            boolean destWasNull;
            boolean bl = destWasNull = this.dest == null;
            if (this.dest == null) {
                this.dest = new Vector2f((ReadableVector2f)ship.getMouseTarget());
                if (ship.getShipAI() != null && ship.getAIFlags().hasFlag(ShipwideAIFlags.AIFlags.SYSTEM_TARGET_COORDS)) {
                    this.dest = (Vector2f)ship.getAIFlags().getCustom(ShipwideAIFlags.AIFlags.SYSTEM_TARGET_COORDS);
                }
            }
            if (this.dest == null) {
                this.dest = Misc.getUnitVectorAtDegreeAngle(ship.getFacing() + 180.0f);
                this.dest.scale(PULL_DIST);
                Vector2f.add((Vector2f)this.dest, (Vector2f)ship.getLocation(), (Vector2f)this.dest);
            }
            if (destWasNull) {
                Vector2f dir;
                this.dest = dir = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(ship.getLocation(), this.dest));
                this.dest.scale(PULL_DIST);
                Vector2f.add((Vector2f)this.dest, (Vector2f)ship.getLocation(), (Vector2f)this.dest);
            }
        }
        if (this.dest != null) {
            Vector2f dir = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(ship.getLocation(), this.dest));
            float amount = Global.getCombatEngine().getElapsedInLastFrame();
            if (state == ShipSystemStatsScript.State.IN) {
                boolean isMaw = DwellerCombatStrategyAI.isMaw(ship);
                float accel = PARTICLE_WINDUP_ACCEL * amount * effectLevel;
                if (isMaw) {
                    accel *= MAW_WINDUP_MULT;
                }
                if (shroud != null) {
                    boolean affect = true;
                    for (RoilingSwarmEffect.SwarmMember p : shroud.getMembers()) {
                        if (affect) {
                            p.vel.x += dir.x * accel;
                            p.vel.y += dir.y * accel;
                        }
                        boolean bl = affect = !affect;
                    }
                }
            }
            if (state == ShipSystemStatsScript.State.ACTIVE) {
                if (!this.fadedFlash) {
                    if (shroud != null) {
                        for (RoilingSwarmEffect.SwarmMember p : shroud.getMembers()) {
                            if (p.flash == null) continue;
                            p.flash.fadeOut();
                        }
                    }
                    this.fadedFlash = true;
                }
                Vector2f loc = ship.getLocation();
                float dist = Misc.getDistance(loc, this.dest);
                float friction = FRICTION;
                float k = SPRING_CONSTANT;
                float freeLength = 0.0f;
                float stretch = dist - freeLength;
                float forceMag = k * Math.abs(stretch);
                float forceMagReduction = Math.min(Math.abs(forceMag), friction);
                friction -= forceMagReduction;
                Vector2f force = new Vector2f((ReadableVector2f)dir);
                force.scale((forceMag -= forceMagReduction) * Math.signum(stretch));
                Vector2f acc = new Vector2f((ReadableVector2f)force);
                acc.scale(amount);
                Vector2f.add((Vector2f)ship.getVelocity(), (Vector2f)acc, (Vector2f)ship.getVelocity());
            }
        }
        if (state == ShipSystemStatsScript.State.OUT) {
            this.dest = null;
            this.fadedFlash = false;
        }
        if (effectLevel > 0.85f && state != ShipSystemStatsScript.State.OUT && ship.getShield() != null) {
            if (ship.getShield().isOn()) {
                ship.getShield().toggleOff();
            }
            ship.blockCommandForOneFrame(ShipCommand.TOGGLE_SHIELD_OR_PHASE_CLOAK);
        }
        if (effectLevel > 0.0f) {
            ship.blockCommandForOneFrame(ShipCommand.ACCELERATE);
            ship.blockCommandForOneFrame(ShipCommand.ACCELERATE_BACKWARDS);
            ship.giveCommand(ShipCommand.DECELERATE, null, 0);
        }
    }

    @Override
    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        return null;
    }
}

