/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.EmpArcEntityAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.combat.RiftLanceEffect;
import com.fs.starfarer.api.impl.combat.threat.RoilingSwarmEffect;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class DwellerShroud
extends RoilingSwarmEffect {
    public static Color SHROUD_COLOR = new Color(100, 0, 25, 255);
    public static Color SHROUD_GLOW_COLOR = new Color(150, 0, 30, 255);
    public static Color SHROUD_OVERLOAD_FRINGE_COLOR = new Color(150, 0, 0, 255);
    protected IntervalUtil interval = new IntervalUtil(0.075f, 0.125f);
    protected IntervalUtil overloadInterval = new IntervalUtil(0.075f, 0.125f);
    protected ShipAPI ship;
    protected DwellerShroudParams shroudParams;

    public static DwellerShroud getShroudFor(CombatEntityAPI entity) {
        RoilingSwarmEffect swarm = RoilingSwarmEffect.getSwarmFor(entity);
        if (swarm instanceof DwellerShroud) {
            return (DwellerShroud)swarm;
        }
        return null;
    }

    public static DwellerShroudParams createBaselineParams(CombatEntityAPI attachedTo) {
        if (!(attachedTo instanceof ShipAPI)) {
            return null;
        }
        ShipAPI ship = (ShipAPI)attachedTo;
        DwellerShroudParams params = new DwellerShroudParams();
        float radius = 20.0f;
        int numMembers = 50;
        params.spriteCat = "dweller";
        params.spriteKey = "dweller_pieces";
        params.despawnSound = null;
        params.baseDur = 1.0f;
        params.durRange = 2.0f;
        params.memberRespawnRate = 100.0f;
        params.memberExchangeClass = null;
        params.flockingClass = null;
        params.maxSpeed = ship.getMaxSpeedWithoutBoost() + Math.max(ship.getMaxSpeedWithoutBoost() * 0.25f + 50.0f, 100.0f);
        params.baseSpriteSize = 256.0f;
        params.baseSpriteSize = 128.64f;
        params.maxTurnRate = 120.0f;
        numMembers = 100;
        radius = 150.0f;
        params.flashCoreRadiusMult = 0.0f;
        params.flashRadius = 300.0f;
        params.flashRadius = 150.0f;
        params.renderFlashOnSameLayer = true;
        params.flashRateMult = 0.25f;
        params.flashFrequency = 17.0f;
        params.numToFlash = 2;
        params.flashProbability = 1.0f;
        params.swarmLeadsByFractionOfVelocity = 0.0f;
        params.alphaMult = 1.0f;
        params.alphaMultBase = 1.0f;
        params.alphaMultFlash = 1.0f;
        params.color = SHROUD_COLOR;
        params.flashFringeColor = SHROUD_GLOW_COLOR;
        params.flashCoreColor = Misc.setBrightness(params.color, 255);
        params.maxOffset = radius;
        params.baseMembersToMaintain = params.initialMembers = numMembers;
        return params;
    }

    public DwellerShroud(CombatEntityAPI attachedTo) {
        this(attachedTo, DwellerShroud.createBaselineParams(attachedTo));
    }

    public DwellerShroud(CombatEntityAPI attachedTo, DwellerShroudParams params) {
        super(attachedTo, params);
        this.shroudParams = params;
        if (attachedTo instanceof ShipAPI) {
            this.ship = (ShipAPI)attachedTo;
        }
    }

    @Override
    public int getNumMembersToMaintain() {
        return super.getNumMembersToMaintain();
    }

    @Override
    public void advance(float amount) {
        boolean overloaded;
        super.advance(amount);
        boolean venting = this.ship.getFluxTracker().isVenting();
        boolean bl = overloaded = this.ship.getFluxTracker().isOverloaded() || venting;
        if (overloaded) {
            this.params.springStretchMult = 1.0f;
            this.params.flashProbability = 0.25f;
            this.params.despawnDist = this.ship.getCollisionRadius();
        } else {
            this.params.springStretchMult = 10.0f;
            this.params.flashProbability = 1.0f;
            this.params.despawnDist = 0.0f;
        }
        float empArcGenRate = this.shroudParams.overloadArcGenRate;
        this.overloadInterval.advance(amount * empArcGenRate * 1.0f);
        if (this.overloadInterval.intervalElapsed() && this.ship != null && overloaded && !this.isDespawning()) {
            EmpArcEntityAPI.EmpArcParams params = new EmpArcEntityAPI.EmpArcParams();
            params.segmentLengthMult = 4.0f;
            params.glowSizeMult = 5.0f + this.ship.getFluxLevel() * 2.0f;
            params.glowSizeMult *= this.shroudParams.overloadGlowSizeMult;
            params.flickerRateMult = 0.5f + (float)Math.random() * 0.5f;
            Color fringe = this.params.flashFringeColor;
            fringe = this.shroudParams.overloadArcFringeColor;
            Color core = Color.white;
            float thickness = this.shroudParams.overloadArcThickness;
            Vector2f loc = this.ship.getLocation();
            float r = this.params.maxOffset;
            r = r * 0.5f + r * 0.5f * (float)Math.random();
            Vector2f from = Misc.getPointAtRadius(loc, r *= this.shroudParams.overloadArcOffsetMult);
            float angle = Misc.getAngleInDegrees(from, loc);
            Vector2f dir = Misc.getUnitVectorAtDegreeAngle(angle += 90.0f * ((float)Math.random() - 0.5f));
            float dist = this.params.maxOffset;
            dist = dist * 0.5f + dist * 0.5f * (float)Math.random();
            dist *= 1.5f;
            dir.scale(dist *= this.shroudParams.overloadArcOffsetMult);
            Vector2f to = Vector2f.add((Vector2f)from, (Vector2f)dir, (Vector2f)new Vector2f());
            CombatEngineAPI engine = Global.getCombatEngine();
            EmpArcEntityAPI arc = engine.spawnEmpArcVisual(from, this.ship, to, this.ship, thickness, fringe, core, params);
            arc.setCoreWidthOverride(this.shroudParams.overloadArcCoreThickness);
            Global.getSoundPlayer().playSound("dweller_venting_or_overloaded", 1.0f, 1.0f, to, this.ship.getVelocity());
        }
        this.interval.advance(amount * this.shroudParams.negativeParticleGenRate);
        if (this.interval.intervalElapsed()) {
            CombatEngineAPI engine = Global.getCombatEngine();
            boolean smallerDark = false;
            Color c = RiftLanceEffect.getColorForDarkening(this.params.color);
            c = Misc.setAlpha(c, 100);
            int num = this.shroudParams.negativeParticleNumBase;
            if (smallerDark) {
                num = 8;
            }
            if (overloaded) {
                c = Misc.setAlpha(c, 150);
                num = this.shroudParams.negativeParticleNumOverloaded;
                if (smallerDark) {
                    num = 4;
                }
            }
            if (this.shroudParams.negativeParticleHighContrastMode) {
                c = Misc.setAlpha(c, 150);
            }
            if (this.shroudParams.negativeParticleColorOverride != null) {
                c = this.shroudParams.negativeParticleColorOverride;
            }
            if (this.shroudParams.negativeParticleAlphaIntOverride >= 0) {
                c = Misc.setAlpha(c, this.shroudParams.negativeParticleAlphaIntOverride);
            }
            float baseDuration = 2.0f;
            Vector2f vel = new Vector2f((ReadableVector2f)this.attachedTo.getVelocity());
            float speed = vel.length();
            if (this.attachedTo instanceof ShipAPI) {
                float maxSpeed = ((ShipAPI)this.attachedTo).getMaxSpeed() * this.shroudParams.negativeParticleSpeedCapMult;
                if (speed > (maxSpeed = Math.min(maxSpeed, this.shroudParams.negativeParticleSpeedCap)) && speed > 1.0f) {
                    vel.scale(maxSpeed / speed);
                }
            }
            float baseSize = this.params.maxOffset * 2.0f;
            float size = baseSize * 0.33f;
            float extraDur = 0.0f;
            Global.getCombatEngine().getViewport().setEverythingNearViewport(true);
            int i = 0;
            while (i < num) {
                Vector2f point = new Vector2f((ReadableVector2f)this.attachedTo.getLocation());
                float min = this.shroudParams.negativeParticleClearCenterAreaRadius;
                point = min > 0.0f ? Misc.getPointWithinRadiusUniform(point, min, Math.max(min, baseSize * 0.75f * (smallerDark ? 0.85f : 1.0f) * this.shroudParams.negativeParticleAreaMult), Misc.random) : Misc.getPointWithinRadiusUniform(point, baseSize * 0.75f * (smallerDark ? 0.85f : 1.0f) * this.shroudParams.negativeParticleAreaMult, Misc.random);
                float dur = baseDuration + baseDuration * (float)Math.random();
                dur += extraDur;
                float nSize = size;
                Vector2f pt = Misc.getPointWithinRadius(point, nSize * 0.5f);
                Vector2f v = Misc.getUnitVectorAtDegreeAngle((float)Math.random() * 360.0f);
                v.scale(nSize + nSize * (float)Math.random() * 0.5f);
                v.scale(0.2f * this.shroudParams.negativeParticleVelMult);
                Vector2f.add((Vector2f)vel, (Vector2f)v, (Vector2f)v);
                float maxSpeed = nSize * 1.5f * 0.2f;
                float minSpeed = nSize * 1.0f * 0.2f;
                float overMin = v.length() - minSpeed;
                if (overMin > 0.0f) {
                    float durMult = 1.0f - overMin / (maxSpeed - minSpeed);
                    if (durMult < 0.1f) {
                        durMult = 0.1f;
                    }
                    dur *= 0.5f + 0.5f * durMult;
                }
                dur *= this.shroudParams.negativeParticleDurMult;
                if (this.shroudParams.negativeParticleFilter == null || this.shroudParams.negativeParticleFilter.isParticleOk(this, pt)) {
                    engine.addNegativeNebulaParticle(pt, v, nSize * 1.0f * this.shroudParams.negativeParticleSizeMult, 2.0f, 0.5f / dur, 0.0f, dur, c);
                }
                ++i;
            }
            Global.getCombatEngine().getViewport().setEverythingNearViewport(false);
        }
    }

    public DwellerShroudParams getShroudParams() {
        return this.shroudParams;
    }

    public static class DwellerShroudParams
    extends RoilingSwarmEffect.RoilingSwarmParams {
        public float overloadGlowSizeMult = 1.0f;
        public float overloadArcThickness = 40.0f;
        public float overloadArcCoreThickness = 20.0f;
        public Color overloadArcFringeColor = SHROUD_OVERLOAD_FRINGE_COLOR;
        public float overloadArcGenRate = 0.25f;
        public float overloadArcOffsetMult = 1.0f;
        public float negativeParticleGenRate = 1.0f;
        public float negativeParticleSizeMult = 1.0f;
        public float negativeParticleVelMult = 1.0f;
        public float negativeParticleDurMult = 1.0f;
        public float negativeParticleSpeedCapMult = 1.5f;
        public float negativeParticleSpeedCap = 10000.0f;
        public float negativeParticleAreaMult = 1.0f;
        public float negativeParticleClearCenterAreaRadius = 0.0f;
        public boolean negativeParticleHighContrastMode = false;
        public int negativeParticleNumBase = 11;
        public int negativeParticleNumOverloaded = 5;
        public int negativeParticleAlphaIntOverride = -1;
        public Color negativeParticleColorOverride = null;
        public ShroudNegativeParticleFilter negativeParticleFilter = null;
    }

    public static interface ShroudNegativeParticleFilter {
        public boolean isParticleOk(DwellerShroud var1, Vector2f var2);
    }
}

