/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatFleetManagerAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShroud;
import com.fs.starfarer.api.impl.combat.dweller.VortexLauncherEffect;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public class TenebrousExpulsionSystemScript
extends BaseShipSystemScript {
    public static String EJECTA_WING = "shrouded_ejecta_wing";
    public static float REFIRE_DELAY = 0.15f;
    public static float LAUNCH_ARC = 90.0f;
    public static float BACK_OFF_ACCEL = 500.0f;
    protected Vector2f fireDir;
    protected float elapsedActive = REFIRE_DELAY;

    protected void init(ShipAPI ship) {
    }

    @Override
    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        float amount;
        ShipAPI ship = null;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ship = (ShipAPI)stats.getEntity();
        if (state == ShipSystemStatsScript.State.IN && this.fireDir == null) {
            float dir = ship.getFacing();
            if (ship.getMouseTarget() != null) {
                dir = Misc.getAngleInDegrees(ship.getLocation(), ship.getMouseTarget());
            }
            if (ship.getShipAI() != null && ship.getAIFlags().hasFlag(ShipwideAIFlags.AIFlags.SYSTEM_TARGET_COORDS)) {
                dir = Misc.getAngleInDegrees(ship.getLocation(), (Vector2f)ship.getAIFlags().getCustom(ShipwideAIFlags.AIFlags.SYSTEM_TARGET_COORDS));
            }
            this.fireDir = Misc.getUnitVectorAtDegreeAngle(dir);
        }
        if (state == ShipSystemStatsScript.State.ACTIVE && this.fireDir != null) {
            amount = Global.getCombatEngine().getElapsedInLastFrame();
            this.elapsedActive += amount;
            while (this.elapsedActive >= REFIRE_DELAY) {
                this.elapsedActive -= REFIRE_DELAY;
                TenebrousExpulsionSystemScript.fireShroudedEjecta(ship, this.fireDir);
            }
        }
        if (state == ShipSystemStatsScript.State.OUT && this.fireDir != null) {
            amount = Global.getCombatEngine().getElapsedInLastFrame();
            ship.getVelocity().x -= this.fireDir.x * BACK_OFF_ACCEL * amount;
            ship.getVelocity().y -= this.fireDir.y * BACK_OFF_ACCEL * amount;
        }
        if (state == ShipSystemStatsScript.State.IDLE || state == ShipSystemStatsScript.State.COOLDOWN) {
            this.fireDir = null;
            this.elapsedActive = REFIRE_DELAY;
        }
    }

    public static void fireShroudedEjecta(ShipAPI ship, Vector2f fireDir) {
        DwellerShroud sourceShroud;
        float dir = Misc.getAngleInDegrees(fireDir);
        CombatEngineAPI engine = Global.getCombatEngine();
        CombatFleetManagerAPI manager = engine.getFleetManager(ship.getOriginalOwner());
        manager.setSuppressDeploymentMessages(true);
        ShipAPI ejecta = manager.spawnShipOrWing(EJECTA_WING, ship.getLocation(), dir, 0.0f, null);
        manager.setSuppressDeploymentMessages(false);
        Vector2f takeoffVel = Misc.getUnitVectorAtDegreeAngle(dir + LAUNCH_ARC / 2.0f - (float)Math.random() * LAUNCH_ARC);
        float velMult = 1.0f;
        velMult = 0.5f + (float)Math.random() * 1.0f;
        takeoffVel.scale(ejecta.getMaxSpeed() * velMult);
        Vector2f.add((Vector2f)ejecta.getVelocity(), (Vector2f)takeoffVel, (Vector2f)ejecta.getVelocity());
        DwellerShroud shroud = DwellerShroud.getShroudFor(ejecta);
        if (shroud != null) {
            shroud.custom1 = ship;
        }
        if ((sourceShroud = DwellerShroud.getShroudFor(ship)) != null) {
            Vector2f offset = Vector2f.sub((Vector2f)ejecta.getLocation(), (Vector2f)sourceShroud.getAttachedTo().getLocation(), (Vector2f)new Vector2f());
            Global.getCombatEngine().addPlugin(new VortexLauncherEffect.DisturbShroudPlugin(1.0f, fireDir, ejecta, offset, sourceShroud, (int)((float)sourceShroud.getNumMembersToMaintain() * 0.1f)));
        }
        Global.getSoundPlayer().playSound("system_tenebrous_expulsion_fire", 1.0f, 1.0f, ejecta.getLocation(), ejecta.getVelocity());
    }

    @Override
    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        return null;
    }
}

