/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.graphics.util.Fader;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.loading.CampaignPingSpec;
import com.fs.starfarer.campaign.util.super;
import com.fs.starfarer.loading.SpecStore;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class ActionIndicator
implements DoNotObfuscate {
    private transient super indicator;
    private transient CampaignPingSpec spec;
    private CampaignPingSpec custom;
    private SectorEntityToken entity;
    private Fader fader;
    private String pingType;
    private Color colorOverride;

    public ActionIndicator(SectorEntityToken sectorEntityToken, CampaignPingSpec campaignPingSpec) {
        this.entity = sectorEntityToken;
        this.custom = campaignPingSpec;
        this.readResolve();
        this.fader = new Fader(0.0f, this.spec.getDuration(), 0.0f, false, false);
        this.fader.fadeIn();
    }

    public ActionIndicator(SectorEntityToken sectorEntityToken, String string, Color color) {
        this.entity = sectorEntityToken;
        this.pingType = string;
        this.colorOverride = color;
        this.readResolve();
        this.fader = new Fader(0.0f, this.spec.getDuration(), 0.0f, false, false);
        this.fader.fadeIn();
    }

    protected Object readResolve() {
        this.indicator = new super(this.entity);
        this.spec = this.pingType != null ? SpecStore.super(CampaignPingSpec.class, this.pingType) : this.custom;
        return this;
    }

    public boolean canCleanUp() {
        return this.fader.isFadedIn();
    }

    public void render(ViewportAPI viewportAPI) {
        float f2;
        if (!this.entity.isInCurrentLocation()) {
            return;
        }
        float f3 = viewportAPI.getAlphaMult();
        f3 *= this.spec.getAlphaMult();
        float f4 = this.fader.getBrightness();
        boolean bl = this.spec.isInvert();
        if (bl) {
            f4 = 1.0f - f4;
        }
        float f5 = f4;
        f5 = bl ? (f5 *= f5) : (float)Math.sqrt(f5);
        float f6 = Math.max(this.spec.getMinRange(), this.entity.getRadius());
        if (this.spec.getMinRange() <= 0.0f) {
            f6 = this.entity.getRadius();
        }
        if (f6 > 10000.0f) {
            f6 = 10000.0f;
        }
        float f7 = f6 + this.spec.getRange() * f5;
        if (!viewportAPI.isNearViewport(this.entity.getLocation(), f7 + 100.0f)) {
            return;
        }
        float f8 = this.spec.getInFraction();
        if (bl) {
            f8 = 0.5f;
        }
        if (f4 < f8) {
            f2 = f4 / f8;
        } else {
            f2 = 1.0f - (f4 - f8) / (1.0f - f8);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
        }
        f3 *= f2;
        if (f3 <= 0.0f) {
            return;
        }
        Vector2f vector2f = this.entity.getLocation();
        this.indicator.return(f7);
        if (this.colorOverride != null) {
            this.indicator.o00000(this.colorOverride, null, 0);
        } else if (this.spec.isUseFactionColor()) {
            this.indicator.o00000(this.entity.getFaction().getColor(), this.entity.getFaction().getSecondaryUIColor(), this.entity.getFaction().getSecondarySegments());
        } else {
            this.indicator.o00000(this.spec.getColor(), null, 0);
        }
        this.indicator.\u00d200000(true);
        this.indicator.Object(this.spec.getWidth() * Math.min(0.1f + f2, 1.0f));
        this.indicator.o00000(true);
        this.indicator.Object().forceIn();
        this.indicator.\u00d500000(vector2f.x, vector2f.y, f3);
    }

    public void advance(float f2) {
        this.fader.advance(f2);
    }
}

