/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.graphics.util.B;
import com.fs.starfarer.D;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignPlugin;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FactionProductionAPI;
import com.fs.starfarer.api.campaign.FactionSpecAPI;
import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.FullName;
import com.fs.starfarer.api.characters.RelationshipAPI;
import com.fs.starfarer.api.combat.ShieldAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.fleet.ShipFilter;
import com.fs.starfarer.api.fleet.ShipRolePick;
import com.fs.starfarer.api.impl.SharedUnlockData;
import com.fs.starfarer.api.impl.codex.CodexDataV2;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.loading.HullModSpecAPI;
import com.fs.starfarer.api.loading.IndustrySpecAPI;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.plugins.FactionPersonalityPickerPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.FactionManager;
import com.fs.starfarer.campaign.fleet.FleetMember;
import com.fs.starfarer.campaign.rules.Memory;
import com.fs.starfarer.loading.J;
import com.fs.starfarer.loading.O0Oo;
import com.fs.starfarer.loading.PersonNameStore;
import com.fs.starfarer.loading.ShipNameStore;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.specs.FactionDoctrine;
import com.fs.starfarer.loading.specs.FactionProduction;
import com.fs.starfarer.rpg.Person;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.json.JSONObject;

public class Faction
implements FactionAPI,
DoNotObfuscate {
    public static final Faction NO_FACTION = new Faction("neutral");
    private transient J spec;
    private String id;
    private Memory memory;
    private Set<String> illegal = null;
    private LinkedHashSet<String> shipsWhenImporting = new LinkedHashSet();
    private LinkedHashSet<String> knownShips = new LinkedHashSet();
    private LinkedHashSet<String> knownWeapons = new LinkedHashSet();
    private LinkedHashSet<String> knownFighters = new LinkedHashSet();
    private LinkedHashSet<String> knownIndustries = new LinkedHashSet();
    private LinkedHashSet<String> knownHullMods = new LinkedHashSet();
    private LinkedHashSet<String> priorityShips = new LinkedHashSet();
    private LinkedHashSet<String> priorityWeapons = new LinkedHashSet();
    private LinkedHashSet<String> priorityFighters = new LinkedHashSet();
    private LinkedHashSet<String> priorityHullMods = new LinkedHashSet();
    private Map<String, Float> hullFrequency = new LinkedHashMap<String, Float>();
    private Map<String, Float> variantOverrides = new LinkedHashMap<String, Float>();
    private LinkedHashSet<String> overriddenHulls = new LinkedHashSet();
    private FactionDoctrine doctrine = new FactionDoctrine();
    private FactionProduction production;
    private LinkedHashSet<String> restrictToVariants = new LinkedHashSet();
    transient int aggressionForPicker = 0;
    private transient WeightedRandomPicker<String> personalityPicker = null;
    private Map<String, Long> weaponTimestamps = new LinkedHashMap<String, Long>();
    private Map<String, Long> fighterTimestamps = new LinkedHashMap<String, Long>();
    private Map<String, Long> shipTimestamps = new LinkedHashMap<String, Long>();
    public boolean showInIntelTabOverridden = false;
    public boolean isShowInIntelTab = false;
    private transient Map<String, Object> customCache = new HashMap<String, Object>();
    private transient boolean updatingDoctrineInReadResolve = false;
    private boolean autoEnableKnownShips = false;
    private boolean autoEnableKnownWeapons = false;
    private boolean autoEnableKnownFighters = false;
    private boolean autoEnableKnownHullmods = false;
    private String displayNameOverride = null;
    private String displayNameWithArticleOverride = null;
    private String displayIsOrAreOverride = null;
    private String shipNamePrefixOverride = null;
    private String personNamePrefixAOrAnOverride = null;
    private String factionLogoOverride = null;
    private String factionCrestOverride = null;
    protected Color secondaryOverride = null;
    protected int secondaryColorSegmentsOverride = 0;
    public transient Map<FactionAPI.ShipPickMode, Float> approximateMaxFPPerFleet = null;
    private transient Map<O0Oo.oo, WeightedRandomPicker<O0Oo.Oo>> priorityRoleCache;
    private transient Map<O0Oo.oo, WeightedRandomPicker<O0Oo.Oo>> normalRoleCache;
    private transient Map<O0Oo.oo, WeightedRandomPicker<O0Oo.Oo>> importedRoleCache;
    private static Map<String, String> roleToCFRole = new HashMap<String, String>(){
        {
            this.put("combatSmallForSmallFleet", "combatFreighterSmall");
            this.put("combatSmall", "combatFreighterSmall");
            this.put("combatMedium", "combatFreighterMedium");
            this.put("combatLarge", "combatFreighterLarge");
        }
    };
    private static final float REP_EPSILON = 0.01f;

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Faction faction = (Faction)object;
        return !(this.id == null ? faction.id != null : !this.id.equals(faction.id));
    }

    public Faction(String string) {
        this.id = string;
        this.spec = SpecStore.super(J.class, string);
        this.spec.getDoctrine().copyTo(this.doctrine);
        this.readResolve();
    }

    public LinkedHashSet<String> getRestrictToVariants() {
        if (this.restrictToVariants == null) {
            this.restrictToVariants = new LinkedHashSet();
        }
        return this.restrictToVariants;
    }

    public void updateDoctrineAndKnown(boolean bl) {
        this.clearShipRoleCache();
        if (bl) {
            this.spec = SpecStore.super(J.class, this.id);
        }
        if (!this.isPlayerFaction()) {
            this.spec.getDoctrine().copyTo(this.doctrine);
        }
        if (bl) {
            this.variantOverrides.clear();
            this.overriddenHulls.clear();
            this.hullFrequency.clear();
            this.knownHullMods.clear();
            this.shipsWhenImporting.clear();
            this.knownShips.clear();
            this.priorityShips.clear();
            this.knownWeapons.clear();
            this.priorityWeapons.clear();
            this.knownFighters.clear();
            this.priorityFighters.clear();
            this.weaponTimestamps.clear();
            this.fighterTimestamps.clear();
            this.shipTimestamps.clear();
        }
        this.variantOverrides.putAll(this.spec.getVariantOverrides());
        this.overriddenHulls.addAll(this.spec.getOverriddenHulls());
        this.hullFrequency.putAll(this.spec.getHullFrequency());
        for (String string : this.spec.getKnownHullMods()) {
            this.knownHullMods.add(string);
        }
        for (String string : this.spec.getShipsWhenImporting()) {
            this.addUseWhenImportingShip(string);
        }
        for (String string : this.spec.getKnownShips()) {
            this.addKnownShip(string, false);
        }
        for (String string : this.spec.getPriorityShips()) {
            this.addPriorityShip(string);
        }
        for (String string : this.spec.getKnownWeapons()) {
            this.addKnownWeapon(string, false);
        }
        for (String string : this.spec.getPriorityWeapons()) {
            this.addPriorityWeapon(string);
        }
        for (String string : this.spec.getKnownFighters()) {
            this.addKnownFighter(string, false);
        }
        for (String string : this.spec.getPriorityFighters()) {
            this.addPriorityFighter(string);
        }
    }

    public LinkedHashSet<String> getOverriddenHulls() {
        return this.overriddenHulls;
    }

    public Set<String> getIllegalCommodities() {
        return this.illegal;
    }

    public boolean isShowInIntelTab() {
        if (this.showInIntelTabOverridden) {
            return this.isShowInIntelTab;
        }
        return this.spec.isShowInIntelTab();
    }

    public void setShowInIntelTab(boolean bl) {
        this.isShowInIntelTab = bl;
        this.showInIntelTabOverridden = true;
    }

    public String getInternalCommsChannel() {
        return this.spec.getInternalCommsChannel();
    }

    public void makeCommodityIllegal(String string) {
        this.illegal.add(string);
    }

    public void makeCommodityLegal(String string) {
        this.illegal.remove(string);
    }

    public String pickPersonality() {
        return (String)this.getPersonalityPicker().pick();
    }

    public WeightedRandomPicker<String> getPersonalityPicker() {
        if (this.personalityPicker == null || this.aggressionForPicker != this.getDoctrine().getAggression()) {
            if (!this.spec.getCaptainPersonalities().isEmpty()) {
                this.personalityPicker = this.spec.getCaptainPersonalities();
            } else {
                FactionPersonalityPickerPlugin factionPersonalityPickerPlugin = Misc.getFactionPersonalityPicker();
                this.personalityPicker = factionPersonalityPickerPlugin.createPersonalityPicker((FactionAPI)this);
            }
            this.aggressionForPicker = this.getDoctrine().getAggression();
        }
        return this.personalityPicker;
    }

    public Map<String, Float> getVariantOverrides() {
        return this.variantOverrides;
    }

    Object readResolve() {
        this.spec = SpecStore.super(J.class, this.id);
        if (this.illegal == null) {
            this.illegal = new HashSet<String>();
            this.illegal.addAll(this.spec.getIllegalCommodities());
        }
        if (this.customCache == null) {
            this.customCache = new HashMap<String, Object>();
        }
        if (this.production == null) {
            this.production = new FactionProduction(this);
        }
        if (this.production.getCostMult() <= 0.0f) {
            this.production.setCostMult(1.0f);
        }
        if (this.shipsWhenImporting == null) {
            this.shipsWhenImporting = new LinkedHashSet();
        }
        if (this.knownShips == null) {
            this.knownShips = new LinkedHashSet();
        }
        if (this.knownWeapons == null) {
            this.knownWeapons = new LinkedHashSet();
        }
        if (this.knownFighters == null) {
            this.knownFighters = new LinkedHashSet();
        }
        if (this.knownIndustries == null) {
            this.knownIndustries = new LinkedHashSet();
        }
        if (this.knownHullMods == null) {
            this.knownHullMods = new LinkedHashSet();
        }
        if (this.priorityShips == null) {
            this.priorityShips = new LinkedHashSet();
        }
        if (this.priorityWeapons == null) {
            this.priorityWeapons = new LinkedHashSet();
        }
        if (this.priorityFighters == null) {
            this.priorityFighters = new LinkedHashSet();
        }
        if (this.priorityHullMods == null) {
            this.priorityHullMods = new LinkedHashSet();
        }
        if (this.variantOverrides == null) {
            this.variantOverrides = new LinkedHashMap<String, Float>();
        }
        if (this.overriddenHulls == null) {
            this.overriddenHulls = new LinkedHashSet();
        }
        if (this.hullFrequency == null) {
            this.hullFrequency = new LinkedHashMap<String, Float>();
        }
        if (this.doctrine == null) {
            this.doctrine = new FactionDoctrine();
        }
        if (this.weaponTimestamps == null) {
            this.weaponTimestamps = new LinkedHashMap<String, Long>();
        }
        if (this.fighterTimestamps == null) {
            this.fighterTimestamps = new LinkedHashMap<String, Long>();
        }
        if (this.shipTimestamps == null) {
            this.shipTimestamps = new LinkedHashMap<String, Long>();
        }
        this.updatingDoctrineInReadResolve = true;
        this.updateDoctrineAndKnown(StarfarerSettings.O\u00d30000() && !this.isPlayerFaction());
        this.updatingDoctrineInReadResolve = false;
        return this;
    }

    public FactionProductionAPI getProduction() {
        return this.production;
    }

    public Map<String, Float> getHullFrequency() {
        return this.hullFrequency;
    }

    public boolean isAutoEnableKnownWeapons() {
        return this.autoEnableKnownWeapons;
    }

    public void setAutoEnableKnownWeapons(boolean bl) {
        this.autoEnableKnownWeapons = bl;
    }

    public boolean isAutoEnableKnownShips() {
        return this.autoEnableKnownShips;
    }

    public void setAutoEnableKnownShips(boolean bl) {
        this.autoEnableKnownShips = bl;
    }

    public boolean isAutoEnableKnownFighters() {
        return this.autoEnableKnownFighters;
    }

    public void setAutoEnableKnownFighters(boolean bl) {
        this.autoEnableKnownFighters = bl;
    }

    public boolean isAutoEnableKnownHullmods() {
        return this.autoEnableKnownHullmods;
    }

    public void setAutoEnableKnownHullmods(boolean bl) {
        this.autoEnableKnownHullmods = bl;
    }

    public Set<String> getAlwaysKnownShips() {
        return this.shipsWhenImporting;
    }

    public void addUseWhenImportingShip(String string) {
        this.shipsWhenImporting.add(string);
        this.clearShipRoleCache();
    }

    public void removeUseWhenImportingShip(String string) {
        this.shipsWhenImporting.remove(string);
        this.clearShipRoleCache();
    }

    public boolean useWhenImportingShip(String string) {
        return this.shipsWhenImporting.contains(string);
    }

    public Set<String> getKnownShips() {
        return this.knownShips;
    }

    public void addKnownShip(String string, boolean bl) {
        ShipHullSpecAPI shipHullSpecAPI;
        if (this.knowsShip(string)) {
            return;
        }
        if (bl) {
            this.setShipTimestampToNow(string);
        } else {
            this.shipTimestamps.remove(string);
        }
        this.knownShips.add(string);
        if (this.autoEnableKnownShips) {
            this.addPriorityShip(string);
        }
        this.clearShipRoleCache();
        if (!this.updatingDoctrineInReadResolve && this.isPlayerFaction() && (shipHullSpecAPI = Global.getSettings().getHullSpec(string)) != null && shipHullSpecAPI.hasTag("codex_unlockable")) {
            String string2 = CodexDataV2.getBaseHullId((ShipHullSpecAPI)shipHullSpecAPI);
            SharedUnlockData.get().reportPlayerAwareOfShip(string2, true);
        }
    }

    public void removeKnownShip(String string) {
        this.shipTimestamps.remove(string);
        this.knownShips.remove(string);
        this.removePriorityShip(string);
        this.clearShipRoleCache();
    }

    public boolean knowsShip(String string) {
        return this.knownShips.contains(string);
    }

    public Set<String> getKnownWeapons() {
        return this.knownWeapons;
    }

    public void addKnownWeapon(String string, boolean bl) {
        WeaponSpecAPI weaponSpecAPI;
        if (this.knowsWeapon(string)) {
            return;
        }
        if (bl) {
            this.setWeaponTimestampToNow(string);
        } else {
            this.weaponTimestamps.remove(string);
        }
        this.knownWeapons.add(string);
        if (this.autoEnableKnownWeapons) {
            this.addPriorityWeapon(string);
        }
        if (!this.updatingDoctrineInReadResolve && this.isPlayerFaction() && (weaponSpecAPI = Global.getSettings().getWeaponSpec(string)) != null && weaponSpecAPI.hasTag("codex_unlockable")) {
            SharedUnlockData.get().reportPlayerAwareOfWeapon(string, true);
        }
    }

    public void removeKnownWeapon(String string) {
        this.weaponTimestamps.remove(string);
        this.knownWeapons.remove(string);
        this.removePriorityWeapon(string);
    }

    public boolean knowsWeapon(String string) {
        return this.knownWeapons.contains(string);
    }

    public Set<String> getKnownFighters() {
        return this.knownFighters;
    }

    public void addKnownFighter(String string, boolean bl) {
        FighterWingSpecAPI fighterWingSpecAPI;
        if (this.knowsFighter(string)) {
            return;
        }
        if (bl) {
            this.setFighterTimestampToNow(string);
        } else {
            this.fighterTimestamps.remove(string);
        }
        this.knownFighters.add(string);
        if (this.autoEnableKnownFighters) {
            this.addPriorityFighter(string);
        }
        if (!this.updatingDoctrineInReadResolve && this.isPlayerFaction() && (fighterWingSpecAPI = Global.getSettings().getFighterWingSpec(string)) != null && fighterWingSpecAPI.hasTag("codex_unlockable")) {
            SharedUnlockData.get().reportPlayerAwareOfFighter(string, true);
        }
    }

    public void removeKnownFighter(String string) {
        this.fighterTimestamps.remove(string);
        this.knownFighters.remove(string);
        this.removePriorityFighter(string);
    }

    public boolean knowsFighter(String string) {
        return this.knownFighters.contains(string);
    }

    public Set<String> getKnownIndustries() {
        return this.knownIndustries;
    }

    public void addKnownHullMod(String string) {
        HullModSpecAPI hullModSpecAPI;
        if (this.isPlayerFaction()) {
            CampaignEngine.getInstance().getCharacterData().addHullMod(string);
        } else {
            this.knownHullMods.add(string);
        }
        if (this.autoEnableKnownHullmods) {
            this.addPriorityHullMod(string);
        }
        if (!this.updatingDoctrineInReadResolve && this.isPlayerFaction() && (hullModSpecAPI = Global.getSettings().getHullModSpec(string)) != null && hullModSpecAPI.hasTag("codex_unlockable")) {
            SharedUnlockData.get().reportPlayerAwareOfHullmod(string, true);
        }
    }

    public void removeKnownHullMod(String string) {
        if (this.isPlayerFaction()) {
            CampaignEngine.getInstance().getCharacterData().removeHullMod(string);
        } else {
            this.knownHullMods.remove(string);
        }
        this.removePriorityHullMod(string);
    }

    public boolean knowsHullMod(String string) {
        if (this.isPlayerFaction()) {
            return CampaignEngine.getInstance().getCharacterData().knowsHullMod(string);
        }
        return this.knownHullMods.contains(string);
    }

    public Set<String> getKnownHullMods() {
        if (this.isPlayerFaction()) {
            return new HashSet<String>(CampaignEngine.getInstance().getCampaignUI().getAvailableHullModIds());
        }
        return this.knownHullMods;
    }

    public void addPriorityHullMod(String string) {
        this.priorityHullMods.add(string);
    }

    public void removePriorityHullMod(String string) {
        this.priorityHullMods.remove(string);
    }

    public boolean isHullModPriority(String string) {
        return this.priorityHullMods.contains(string);
    }

    public Set<String> getPriorityHullMods() {
        return this.priorityHullMods;
    }

    public void addKnownIndustry(String string) {
        IndustrySpecAPI industrySpecAPI;
        this.knownIndustries.add(string);
        if (!this.updatingDoctrineInReadResolve && this.isPlayerFaction() && (industrySpecAPI = Global.getSettings().getIndustrySpec(string)) != null && industrySpecAPI.hasTag("codex_unlockable")) {
            SharedUnlockData.get().reportPlayerAwareOfIndustry(string, true);
        }
    }

    public void removeKnownIndustry(String string) {
        this.knownIndustries.remove(string);
    }

    public boolean knowsIndustry(String string) {
        return this.knownIndustries.contains(string);
    }

    public Set<String> getPriorityShips() {
        return this.priorityShips;
    }

    public void addPriorityShip(String string) {
        this.priorityShips.add(string);
        this.clearShipRoleCache();
    }

    public void removePriorityShip(String string) {
        this.priorityShips.remove(string);
        this.clearShipRoleCache();
    }

    public boolean isShipPriority(String string) {
        return this.priorityShips.contains(string);
    }

    public Set<String> getPriorityWeapons() {
        return this.priorityWeapons;
    }

    public void addPriorityWeapon(String string) {
        this.priorityWeapons.add(string);
    }

    public void removePriorityWeapon(String string) {
        this.priorityWeapons.remove(string);
    }

    public boolean isWeaponPriority(String string) {
        return this.priorityWeapons.contains(string);
    }

    public Set<String> getPriorityFighters() {
        return this.priorityFighters;
    }

    public void addPriorityFighter(String string) {
        this.priorityFighters.add(string);
    }

    public void removePriorityFighter(String string) {
        this.priorityFighters.remove(string);
    }

    public boolean isFighterPriority(String string) {
        return this.priorityFighters.contains(string);
    }

    public boolean isIllegal(CargoStackAPI cargoStackAPI) {
        if (cargoStackAPI.isCommodityStack()) {
            return this.isIllegal((String)cargoStackAPI.getData());
        }
        return false;
    }

    public boolean isIllegalAssumePrimary(String string) {
        return this.getIllegalCommodities().contains(string);
    }

    public boolean isIllegal(String string) {
        if (this.getIllegalCommodities().contains(string)) {
            return true;
        }
        CommoditySpecAPI commoditySpecAPI = Global.getSettings().getCommoditySpec(string);
        if (commoditySpecAPI != null) {
            return this.getIllegalCommodities().contains(commoditySpecAPI.getDemandClass());
        }
        return false;
    }

    public List<String> getStockFleetIds() {
        return new ArrayList<String>(this.spec.getStockFleets().keySet());
    }

    public String getDisplayNameOverride() {
        return this.displayNameOverride;
    }

    public void setDisplayNameOverride(String string) {
        this.displayNameOverride = string;
    }

    public String getDisplayNameWithArticleOverride() {
        return this.displayNameWithArticleOverride;
    }

    public void setDisplayNameWithArticleOverride(String string) {
        this.displayNameWithArticleOverride = string;
    }

    public String getDisplayIsOrAreOverride() {
        return this.displayIsOrAreOverride;
    }

    public void setDisplayIsOrAreOverride(String string) {
        this.displayIsOrAreOverride = string;
    }

    public String getShipNamePrefixOverride() {
        return this.shipNamePrefixOverride;
    }

    public void setShipNamePrefixOverride(String string) {
        this.shipNamePrefixOverride = string;
    }

    public String getPersonNamePrefixAOrAnOverride() {
        return this.personNamePrefixAOrAnOverride;
    }

    public void setPersonNamePrefixAOrAnOverride(String string) {
        this.personNamePrefixAOrAnOverride = string;
    }

    public String getFactionLogoOverride() {
        return this.factionLogoOverride;
    }

    public void setFactionLogoOverride(String string) {
        this.factionLogoOverride = string;
    }

    public String getFactionCrestOverride() {
        return this.factionCrestOverride;
    }

    public void setFactionCrestOverride(String string) {
        this.factionCrestOverride = string;
    }

    public String getDisplayName() {
        if (this.displayNameOverride != null) {
            return this.displayNameOverride;
        }
        return this.spec.getDisplayName();
    }

    public String getDisplayNameWithArticle() {
        if (this.displayNameWithArticleOverride != null) {
            return this.displayNameWithArticleOverride;
        }
        return this.spec.getDisplayNameWithArticle();
    }

    public String getDisplayNameWithArticleWithoutArticle() {
        return this.getDisplayNameWithArticle().replaceFirst("the ", "");
    }

    public String getDisplayNameLong() {
        if (this.displayNameOverride != null) {
            return this.displayNameOverride;
        }
        return this.spec.getDisplayNameLong();
    }

    public String getDisplayNameLongWithArticle() {
        if (this.displayNameWithArticleOverride != null) {
            return this.displayNameWithArticleOverride;
        }
        return this.spec.getDisplayNameLongWithArticle();
    }

    public String getEntityNamePrefix() {
        if (this.displayNameOverride != null) {
            return this.displayNameOverride;
        }
        return this.spec.getEntityNamePrefix();
    }

    public String getPersonNamePrefix() {
        if (this.displayNameOverride != null) {
            return this.displayNameOverride;
        }
        return this.spec.getPersonNamePrefix();
    }

    public String getPersonNamePrefixAOrAn() {
        if (this.personNamePrefixAOrAnOverride != null) {
            return this.personNamePrefixAOrAnOverride;
        }
        return this.spec.getPersonNamePrefixAOrAn();
    }

    public String getDisplayNameIsOrAre() {
        if (this.displayIsOrAreOverride != null) {
            return this.displayIsOrAreOverride;
        }
        return this.spec.getDisplayNameIsOrAre();
    }

    public String getDisplayNameHasOrHave() {
        if (this.getDisplayNameIsOrAre().equals("are")) {
            return "have";
        }
        return "has";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getShipNamePrefix() {
        if (this.shipNamePrefixOverride != null) {
            return this.shipNamePrefixOverride;
        }
        return this.spec.getShipNamePrefix();
    }

    public Person createRandomPerson() {
        return this.createRandomPerson((Random)null);
    }

    public Person createRandomPerson(Random random) {
        if (random == null) {
            random = new Random();
        }
        FullName.Gender gender = FullName.Gender.MALE;
        if (random.nextFloat() > 0.5f) {
            gender = FullName.Gender.FEMALE;
        }
        return this.createRandomPerson(gender, random);
    }

    public Person createRandomPerson(FullName.Gender gender) {
        return this.createRandomPerson(gender, null);
    }

    public Person createRandomPerson(FullName.Gender gender, Random random) {
        if (random == null) {
            random = new Random();
        }
        if (gender == null || gender == FullName.Gender.ANY) {
            gender = FullName.Gender.MALE;
            if (random.nextFloat() > 0.5f) {
                gender = FullName.Gender.FEMALE;
            }
        }
        Person person = new Person("steady");
        HashSet<String> hashSet = new HashSet<String>();
        if (!Global.getSector().isInSectorGen()) {
            hashSet.add(Global.getSector().getPlayerPerson().getPortraitSprite());
        }
        String string = null;
        int n2 = 0;
        while (n2 < 5) {
            string = (String)this.spec.getPortraits(J.o.\u00d200000, gender).pick(random);
            if (!hashSet.contains(string)) break;
            ++n2;
        }
        person.setPortraitSprite(string);
        FullName fullName = PersonNameStore.super(this, gender, random);
        person.setName(fullName);
        person.setFaction(this.getId());
        String string2 = this.pickVoice(person.getImportance(), random);
        if (string2 != null) {
            person.getMemoryWithoutUpdate().set("$voice", (Object)string2);
        }
        return person;
    }

    public WeightedRandomPicker<String> getPortraits(FullName.Gender gender) {
        return this.spec.getPortraits(J.o.\u00d200000, gender);
    }

    public FactionSpecAPI getFactionSpec() {
        return this.getSpec();
    }

    public void initSpecIfNeeded() {
        if (this.spec == null) {
            this.spec = SpecStore.super(J.class, this.id);
        }
    }

    public J getSpec() {
        if (this.spec == null) {
            this.spec = SpecStore.super(J.class, this.id);
        }
        return this.spec;
    }

    public Color getColor() {
        return this.spec.getColor();
    }

    public Color getBrightUIColor() {
        return this.spec.getBrightUIColor();
    }

    public Color getBaseUIColor() {
        return this.spec.getBaseUIColor();
    }

    public Color getSecondaryUIColor() {
        if (this.secondaryOverride != null) {
            return this.secondaryOverride;
        }
        return this.spec.getSecondaryUIColor();
    }

    public Color getSecondaryColorOverride() {
        return this.secondaryOverride;
    }

    public void setSecondaryColorOverride(Color color) {
        this.secondaryOverride = color;
    }

    public int getSecondaryColorSegmentsOverride() {
        return this.secondaryColorSegmentsOverride;
    }

    public void setSecondaryColorSegmentsOverride(int n2) {
        this.secondaryColorSegmentsOverride = n2;
    }

    public int getSecondarySegments() {
        if (this.secondaryColorSegmentsOverride != 0) {
            return this.secondaryColorSegmentsOverride;
        }
        return this.spec.getSecondarySegments();
    }

    public Color getGridUIColor() {
        return this.spec.getGridUIColor();
    }

    public Color getDarkUIColor() {
        return this.spec.getDarkUIColor();
    }

    public boolean isNeutralFaction() {
        return this.spec.getId().equals("neutral");
    }

    public boolean isPlayerFaction() {
        return this.spec.getId().equals("player");
    }

    public void advance(float f2) {
        if (this.memory != null) {
            this.memory.advance(f2);
        }
        if (this.production != null) {
            this.production.advance(f2);
        }
    }

    public Memory getMemory() {
        if (this.memory == null) {
            this.memory = new Memory();
        }
        for (CampaignPlugin campaignPlugin : CampaignEngine.getInstance().getModAndPluginData().getPlugins()) {
            campaignPlugin.updateFactionFacts((FactionAPI)this, (MemoryAPI)this.memory);
        }
        return this.memory;
    }

    public MemoryAPI getMemoryWithoutUpdate() {
        if (this.memory == null) {
            this.memory = new Memory();
        }
        return this.memory;
    }

    public float pickShipAndAddToFleet(String string, FactionAPI.ShipPickParams shipPickParams, CampaignFleetAPI campaignFleetAPI) {
        return this.pickShipAndAddToFleet(string, shipPickParams, campaignFleetAPI, null);
    }

    public float pickShipAndAddToFleet(String string, FactionAPI.ShipPickParams shipPickParams, CampaignFleetAPI campaignFleetAPI, Random random) {
        List<ShipRolePick> list = this.pickShip(string, shipPickParams, null, random);
        float f2 = 0.0f;
        for (ShipRolePick shipRolePick : list) {
            FleetMemberType fleetMemberType = FleetMemberType.SHIP;
            if (shipRolePick.isFighterWing()) {
                fleetMemberType = FleetMemberType.FIGHTER_WING;
            }
            FleetMember fleetMember = new FleetMember(1, shipRolePick.variantId, fleetMemberType);
            String string2 = campaignFleetAPI.getFleetData().pickShipName((FleetMemberAPI)fleetMember, random);
            fleetMember.setShipName(string2);
            campaignFleetAPI.getFleetData().addFleetMember((FleetMemberAPI)fleetMember);
            fleetMember.getRepairTracker().setCR(Math.max(fleetMember.getRepairTracker().getMaxCR(), 0.5f));
            f2 += shipRolePick.weight;
        }
        return f2;
    }

    public List<ShipRolePick> pickShip(String string, FactionAPI.ShipPickParams shipPickParams) {
        return this.pickShip(string, shipPickParams, null, null);
    }

    public List<ShipRolePick> pickShip(String string, FactionAPI.ShipPickParams shipPickParams, ShipFilter shipFilter, Random random) {
        return this.pickShip(string, shipPickParams, shipFilter, new HashSet<String>(), random);
    }

    public String getFleetTypeName(String string) {
        String string2 = this.spec.getFleetNames().super(string);
        if (string2 == null) {
            string2 = J.getDefaultFleetNames().super(string);
        }
        if (string2 == null) {
            string2 = "no name for type [" + string + "]";
        }
        return string2;
    }

    public String getRank(String string) {
        String string2 = this.spec.getRanksAndPosts().o00000(string);
        if (string2 == null) {
            string2 = J.getDefaultRanks().o00000(string);
        }
        if (string2 == null) {
            string2 = "no rank for id [" + string + "]";
        }
        return string2;
    }

    public String getPost(String string) {
        String string2 = this.spec.getRanksAndPosts().new(string);
        if (string2 == null) {
            string2 = J.getDefaultRanks().new(string);
        }
        if (string2 == null) {
            string2 = "no post for id [" + string + "]";
        }
        return string2;
    }

    public int getNumAvailableForRole(String string, FactionAPI.ShipPickMode shipPickMode) {
        O0Oo.oo oo2 = this.spec.getShipRoles().o00000(string);
        if (oo2 == null || oo2.o00000().isEmpty() && oo2.Object() == null) {
            oo2 = J.getDefaultShipRoles().o00000(string);
        }
        if (shipPickMode == FactionAPI.ShipPickMode.ALL) {
            return this.getAllValidEntries(oo2, null).getItems().size();
        }
        if (shipPickMode == FactionAPI.ShipPickMode.PRIORITY_ONLY || shipPickMode == FactionAPI.ShipPickMode.PRIORITY_THEN_ALL) {
            return this.getPriorityValidEntries(oo2, null).getItems().size();
        }
        if (shipPickMode == FactionAPI.ShipPickMode.IMPORTED) {
            return this.getBaseValidEntries(oo2, null).getItems().size();
        }
        return 0;
    }

    public float getVariantWeightForRole(String string, FactionAPI.ShipPickMode shipPickMode) {
        O0Oo.oo oo2 = this.spec.getShipRoles().o00000(string);
        if (oo2 == null || oo2.o00000().isEmpty() && oo2.Object() == null) {
            oo2 = J.getDefaultShipRoles().o00000(string);
        }
        if (shipPickMode == FactionAPI.ShipPickMode.ALL) {
            return this.getAllValidEntries(oo2, null).getTotal();
        }
        if (shipPickMode == FactionAPI.ShipPickMode.PRIORITY_ONLY || shipPickMode == FactionAPI.ShipPickMode.PRIORITY_THEN_ALL) {
            return this.getPriorityValidEntries(oo2, null).getTotal();
        }
        if (shipPickMode == FactionAPI.ShipPickMode.IMPORTED) {
            return this.getBaseValidEntries(oo2, null).getTotal();
        }
        return 0.0f;
    }

    public List<ShipRolePick> pickShip(String string, FactionAPI.ShipPickParams shipPickParams, ShipFilter shipFilter, Set<String> set, Random random) {
        ArrayList<ShipRolePick> arrayList = new ArrayList<ShipRolePick>();
        if (string == null) {
            return arrayList;
        }
        set.add(string);
        WeightedRandomPicker<O0Oo.Oo> weightedRandomPicker = null;
        boolean bl = shipPickParams.mode == FactionAPI.ShipPickMode.IMPORTED;
        boolean bl2 = shipPickParams.mode == FactionAPI.ShipPickMode.ALL;
        boolean bl3 = shipPickParams.mode == FactionAPI.ShipPickMode.PRIORITY_THEN_ALL;
        boolean bl4 = shipPickParams.mode == FactionAPI.ShipPickMode.PRIORITY_ONLY;
        O0Oo.oo oo2 = this.spec.getShipRoles().o00000(string);
        if (!(oo2 == null || oo2.o00000().isEmpty() && oo2.Object() == null)) {
            weightedRandomPicker = bl ? this.getBaseValidEntries(oo2, shipFilter) : (bl2 ? this.getAllValidEntries(oo2, shipFilter) : this.getPriorityValidEntries(oo2, shipFilter));
        } else {
            oo2 = J.getDefaultShipRoles().o00000(string);
            if (oo2 != null) {
                weightedRandomPicker = bl ? this.getBaseValidEntries(oo2, shipFilter) : (bl2 ? this.getAllValidEntries(oo2, shipFilter) : this.getPriorityValidEntries(oo2, shipFilter));
            }
        }
        if (weightedRandomPicker != null) {
            boolean bl5;
            weightedRandomPicker = this.pruneBasedOnTimestamp(weightedRandomPicker, shipPickParams.timestamp);
            boolean bl6 = weightedRandomPicker.isEmpty();
            weightedRandomPicker = this.keepUpToFP(weightedRandomPicker, shipPickParams.maxFP);
            boolean bl7 = weightedRandomPicker.isEmpty();
            boolean bl8 = bl5 = !bl6 && bl7 && bl3;
            if (!bl5 && bl3 && weightedRandomPicker.isEmpty() && (weightedRandomPicker = this.getAllValidEntries(oo2, shipFilter)) != null) {
                weightedRandomPicker = this.pruneBasedOnTimestamp(weightedRandomPicker, shipPickParams.timestamp);
                weightedRandomPicker = this.keepUpToFP(weightedRandomPicker, shipPickParams.maxFP);
            }
        }
        if (weightedRandomPicker != null && !weightedRandomPicker.isEmpty()) {
            weightedRandomPicker.setRandom(random);
            O0Oo.Oo oo3 = (O0Oo.Oo)weightedRandomPicker.pick();
            arrayList.add(new ShipRolePick(oo3.getVariantId()));
        } else if (!(oo2 == null || shipPickParams.blockFallback != null && shipPickParams.blockFallback.booleanValue())) {
            float f2;
            O0Oo.o o2 = oo2.Object();
            String string2 = o2 != null ? o2.new() : null;
            float f3 = f2 = o2 != null ? o2.o00000() : 0.0f;
            if (o2 == null || set.contains(string2)) {
                o2 = oo2.\u00d400000();
                float f4 = f2 = o2 != null ? o2.o00000() : 0.0f;
            }
            if (random == null) {
                random = new Random();
            }
            if (o2 != null && random.nextFloat() > f2) {
                set.add(string2);
            } else if (o2 != null && !set.contains(string2)) {
                float f5 = o2.o00000();
                int n2 = shipPickParams.maxFP;
                int n3 = 0;
                while ((float)n3 < f5) {
                    FactionAPI.ShipPickParams shipPickParams2 = shipPickParams.clone();
                    shipPickParams2.maxFP = n2;
                    List<ShipRolePick> list = this.pickShip(string2, shipPickParams2, shipFilter, set, random);
                    for (ShipRolePick shipRolePick : list) {
                        int n4 = Misc.getFPForVariantId((String)shipRolePick.variantId);
                        if (n4 > n2) continue;
                        n2 -= n4;
                        arrayList.add(shipRolePick);
                    }
                    ++n3;
                }
                if (f5 > 0.0f) {
                    for (ShipRolePick shipRolePick : arrayList) {
                        shipRolePick.weight /= f5;
                    }
                }
            }
        }
        return arrayList;
    }

    private WeightedRandomPicker<O0Oo.Oo> pruneBasedOnTimestamp(WeightedRandomPicker<O0Oo.Oo> weightedRandomPicker, Long l2) {
        if (l2 == null || this.shipTimestamps.isEmpty()) {
            return weightedRandomPicker;
        }
        WeightedRandomPicker weightedRandomPicker2 = new WeightedRandomPicker();
        List list = weightedRandomPicker.getItems();
        int n2 = 0;
        while (n2 < list.size()) {
            O0Oo.Oo oo2 = (O0Oo.Oo)list.get(n2);
            String string = Misc.getHullIdForVariantId((String)oo2.getVariantId());
            Long l3 = this.shipTimestamps.get(string);
            if (l3 == null || l3 <= l2) {
                float f2 = weightedRandomPicker.getWeight(n2);
                weightedRandomPicker2.add((Object)oo2, f2);
            }
            ++n2;
        }
        return weightedRandomPicker2;
    }

    private WeightedRandomPicker<O0Oo.Oo> keepUpToFP(WeightedRandomPicker<O0Oo.Oo> weightedRandomPicker, int n2) {
        WeightedRandomPicker weightedRandomPicker2 = new WeightedRandomPicker();
        List list = weightedRandomPicker.getItems();
        int n3 = 0;
        while (n3 < list.size()) {
            O0Oo.Oo oo2 = (O0Oo.Oo)list.get(n3);
            int n4 = Misc.getFPForVariantId((String)oo2.getVariantId());
            if (n4 <= n2) {
                float f2 = weightedRandomPicker.getWeight(n3);
                weightedRandomPicker2.add((Object)oo2, f2);
            }
            ++n3;
        }
        return weightedRandomPicker2;
    }

    public void clearShipRoleCache() {
        this.priorityRoleCache = null;
        this.normalRoleCache = null;
        this.importedRoleCache = null;
        this.approximateMaxFPPerFleet = null;
    }

    public float getApproximateMaxFPPerFleet(FactionAPI.ShipPickMode shipPickMode) {
        if (this.approximateMaxFPPerFleet == null) {
            this.approximateMaxFPPerFleet = new HashMap<FactionAPI.ShipPickMode, Float>();
        }
        if (!this.approximateMaxFPPerFleet.containsKey(shipPickMode)) {
            float f2 = Global.getSettings().getInt("maxShipsInAIFleet");
            HashMap<ShipAPI.HullSize, o> hashMap = new HashMap<ShipAPI.HullSize, o>();
            hashMap.put(ShipAPI.HullSize.FRIGATE, new o(ShipAPI.HullSize.FRIGATE));
            hashMap.put(ShipAPI.HullSize.DESTROYER, new o(ShipAPI.HullSize.DESTROYER));
            hashMap.put(ShipAPI.HullSize.CRUISER, new o(ShipAPI.HullSize.CRUISER));
            hashMap.put(ShipAPI.HullSize.CAPITAL_SHIP, new o(ShipAPI.HullSize.CAPITAL_SHIP));
            for (String string : this.getKnownShips()) {
                o o2;
                ShipHullSpecAPI shipHullSpecAPI = Global.getSettings().getHullSpec(string);
                if (shipHullSpecAPI.isCivilianNonCarrier() || shipHullSpecAPI.getHints().contains(ShipHullSpecAPI.ShipTypeHints.STATION) || shipPickMode == FactionAPI.ShipPickMode.IMPORTED && !this.useWhenImportingShip(string) || shipPickMode == FactionAPI.ShipPickMode.PRIORITY_ONLY && !this.isShipPriority(string) || (o2 = (o)hashMap.get(shipHullSpecAPI.getHullSize())) == null) continue;
                Float f3 = this.getHullFrequency().get(string);
                if (f3 == null) {
                    f3 = Float.valueOf(1.0f);
                }
                if (f3.floatValue() <= 0.0f) continue;
                f3 = shipHullSpecAPI.getDefenseType() == ShieldAPI.ShieldType.PHASE ? Float.valueOf(f3.floatValue() * ((float)this.getDoctrine().getPhaseShips() / (float)(this.getDoctrine().getPhaseShips() + this.getDoctrine().getWarships()))) : Float.valueOf(f3.floatValue() * ((float)this.getDoctrine().getWarships() / (float)(this.getDoctrine().getPhaseShips() + this.getDoctrine().getWarships())));
                o2.\u00d300000 += (float)shipHullSpecAPI.getFleetPoints() * f3.floatValue();
                o2.new += f3.floatValue();
            }
            float f4 = ((o)hashMap.get(ShipAPI.HullSize.FRIGATE)).o00000();
            float f5 = ((o)hashMap.get(ShipAPI.HullSize.DESTROYER)).o00000();
            float f6 = ((o)hashMap.get(ShipAPI.HullSize.CRUISER)).o00000();
            float f7 = ((o)hashMap.get(ShipAPI.HullSize.CAPITAL_SHIP)).o00000();
            f4 = Math.max(f4, 4.0f);
            f5 = Math.max(f5, f4);
            f6 = Math.max(f6, f5);
            f7 = Math.max(f7, f6);
            int n2 = this.getDoctrine().getShipSize();
            float f8 = 0.0f;
            switch (n2) {
                case 5: {
                    f8 = 0.1f;
                    break;
                }
                case 4: {
                    f8 = 0.1f;
                    break;
                }
                case 3: {
                    f8 = 0.05f;
                    break;
                }
                case 2: {
                    f8 = 0.0f;
                    break;
                }
                default: {
                    f8 = 0.0f;
                }
            }
            float f9 = f2 * (f7 * (0.2f + f8) + f6 * (0.2f - f8 * 0.33f) + f5 * (0.2f - f8 * 0.33f) + f4 * (0.2f - f8 * 0.33f));
            this.approximateMaxFPPerFleet.put(shipPickMode, Float.valueOf(f9 *= 0.8f));
        }
        return this.approximateMaxFPPerFleet.get(shipPickMode).floatValue();
    }

    public Map<O0Oo.oo, WeightedRandomPicker<O0Oo.Oo>> getPriorityRoleCache() {
        if (this.priorityRoleCache == null) {
            this.priorityRoleCache = new HashMap<O0Oo.oo, WeightedRandomPicker<O0Oo.Oo>>();
        }
        return this.priorityRoleCache;
    }

    public Map<O0Oo.oo, WeightedRandomPicker<O0Oo.Oo>> getNormalRoleCache() {
        if (this.normalRoleCache == null) {
            this.normalRoleCache = new HashMap<O0Oo.oo, WeightedRandomPicker<O0Oo.Oo>>();
        }
        return this.normalRoleCache;
    }

    public Map<O0Oo.oo, WeightedRandomPicker<O0Oo.Oo>> getImportedRoleCache() {
        if (this.importedRoleCache == null) {
            this.importedRoleCache = new HashMap<O0Oo.oo, WeightedRandomPicker<O0Oo.Oo>>();
        }
        return this.importedRoleCache;
    }

    private void mergeInCombatFreighters(WeightedRandomPicker<O0Oo.Oo> weightedRandomPicker, O0Oo.oo oo2, ShipFilter shipFilter, FactionAPI.ShipPickMode shipPickMode) {
        Object object2;
        float f2 = this.doctrine.getCombatFreighterCombatUseFraction();
        if (shipPickMode == FactionAPI.ShipPickMode.PRIORITY_THEN_ALL) {
            f2 = this.doctrine.getCombatFreighterCombatUseFractionWhenPriority();
        }
        if (f2 <= 0.0f) {
            return;
        }
        String string = oo2.\u00d200000();
        if (string == null) {
            return;
        }
        String string2 = roleToCFRole.get(string);
        if (string2 == null) {
            return;
        }
        O0Oo.oo oo3 = this.spec.getShipRoles().o00000(string2);
        if (oo3 == null || oo3.o00000().isEmpty() && oo3.Object() == null) {
            oo3 = J.getDefaultShipRoles().o00000(string2);
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object2 : weightedRandomPicker.getItems()) {
            hashSet.add(((O0Oo.Oo)object2).getVariantId());
        }
        object2 = this.getRestrictToVariants();
        for (O0Oo.Oo oo4 : oo3.o00000()) {
            Float f3;
            if (!((HashSet)object2).isEmpty() && !((HashSet)object2).contains(oo4.getVariantId()) || hashSet.contains(oo4.getVariantId())) continue;
            String string3 = Misc.getHullIdForVariantId((String)oo4.getVariantId());
            if (shipPickMode == FactionAPI.ShipPickMode.IMPORTED && (!this.knowsShip(string3) || !this.useWhenImportingShip(string3)) || shipPickMode == FactionAPI.ShipPickMode.PRIORITY_THEN_ALL && (!this.knowsShip(string3) || !this.isShipPriority(string3)) || shipPickMode == FactionAPI.ShipPickMode.ALL && !this.knowsShip(string3)) continue;
            float f4 = oo4.getWeight() * f2;
            if (this.getOverriddenHulls().contains(string3)) {
                f3 = this.getVariantOverrides().get(oo4.getVariantId());
                if (f3 == null) continue;
                f4 = f3.floatValue() * f2;
            }
            if ((f3 = this.getHullFrequency().get(string3)) != null) {
                f4 *= f3.floatValue();
            }
            if (shipFilter != null && !shipFilter.isAvailable(oo4.getVariantId())) continue;
            weightedRandomPicker.add((Object)oo4, f4);
        }
    }

    private WeightedRandomPicker<O0Oo.Oo> getBaseValidEntries(O0Oo.oo oo2, ShipFilter shipFilter) {
        WeightedRandomPicker weightedRandomPicker = this.getImportedRoleCache().get(oo2);
        if (weightedRandomPicker != null && shipFilter == null) {
            return weightedRandomPicker;
        }
        LinkedHashSet<String> linkedHashSet = this.getRestrictToVariants();
        weightedRandomPicker = new WeightedRandomPicker();
        for (O0Oo.Oo oo3 : oo2.o00000()) {
            Float f2;
            String string;
            if (!linkedHashSet.isEmpty() && !linkedHashSet.contains(oo3.getVariantId()) || !this.knowsShip(string = Misc.getHullIdForVariantId((String)oo3.getVariantId())) || !this.useWhenImportingShip(string)) continue;
            float f3 = oo3.getWeight();
            if (this.getOverriddenHulls().contains(string)) {
                f2 = this.getVariantOverrides().get(oo3.getVariantId());
                if (f2 == null) continue;
                f3 = f2.floatValue();
            }
            if ((f2 = this.getHullFrequency().get(string)) != null) {
                f3 *= f2.floatValue();
            }
            if (shipFilter != null && !shipFilter.isAvailable(oo3.getVariantId())) continue;
            weightedRandomPicker.add((Object)oo3, f3);
        }
        this.mergeInCombatFreighters((WeightedRandomPicker<O0Oo.Oo>)weightedRandomPicker, oo2, shipFilter, FactionAPI.ShipPickMode.IMPORTED);
        if (shipFilter == null) {
            this.getImportedRoleCache().put(oo2, (WeightedRandomPicker<O0Oo.Oo>)weightedRandomPicker);
        }
        return weightedRandomPicker;
    }

    private WeightedRandomPicker<O0Oo.Oo> getPriorityValidEntries(O0Oo.oo oo2, ShipFilter shipFilter) {
        WeightedRandomPicker weightedRandomPicker = this.getPriorityRoleCache().get(oo2);
        if (weightedRandomPicker != null && shipFilter == null) {
            return weightedRandomPicker;
        }
        LinkedHashSet<String> linkedHashSet = this.getRestrictToVariants();
        weightedRandomPicker = new WeightedRandomPicker();
        for (O0Oo.Oo oo3 : oo2.o00000()) {
            Float f2;
            String string;
            if (!linkedHashSet.isEmpty() && !linkedHashSet.contains(oo3.getVariantId()) || !this.knowsShip(string = Misc.getHullIdForVariantId((String)oo3.getVariantId())) || !this.isShipPriority(string)) continue;
            float f3 = oo3.getWeight();
            if (this.getOverriddenHulls().contains(string)) {
                f2 = this.getVariantOverrides().get(oo3.getVariantId());
                if (f2 == null) continue;
                f3 = f2.floatValue();
            }
            if ((f2 = this.getHullFrequency().get(string)) != null) {
                f3 *= f2.floatValue();
            }
            if (shipFilter != null && !shipFilter.isAvailable(oo3.getVariantId())) continue;
            weightedRandomPicker.add((Object)oo3, f3);
        }
        this.mergeInCombatFreighters((WeightedRandomPicker<O0Oo.Oo>)weightedRandomPicker, oo2, shipFilter, FactionAPI.ShipPickMode.PRIORITY_THEN_ALL);
        if (shipFilter == null) {
            this.getPriorityRoleCache().put(oo2, (WeightedRandomPicker<O0Oo.Oo>)weightedRandomPicker);
        }
        return weightedRandomPicker;
    }

    private WeightedRandomPicker<O0Oo.Oo> getAllValidEntries(O0Oo.oo oo2, ShipFilter shipFilter) {
        WeightedRandomPicker weightedRandomPicker = this.getNormalRoleCache().get(oo2);
        if (weightedRandomPicker != null && shipFilter == null) {
            return weightedRandomPicker;
        }
        weightedRandomPicker = new WeightedRandomPicker();
        LinkedHashSet<String> linkedHashSet = this.getRestrictToVariants();
        for (O0Oo.Oo oo3 : oo2.o00000()) {
            Float f2;
            String string;
            if (!linkedHashSet.isEmpty() && !linkedHashSet.contains(oo3.getVariantId()) || !this.knowsShip(string = Misc.getHullIdForVariantId((String)oo3.getVariantId()))) continue;
            float f3 = oo3.getWeight();
            if (this.getOverriddenHulls().contains(string)) {
                f2 = this.getVariantOverrides().get(oo3.getVariantId());
                if (f2 == null) continue;
                f3 = f2.floatValue();
            }
            if ((f2 = this.getHullFrequency().get(string)) != null) {
                f3 *= f2.floatValue();
            }
            if (shipFilter != null && !shipFilter.isAvailable(oo3.getVariantId())) continue;
            weightedRandomPicker.add((Object)oo3, f3);
        }
        this.mergeInCombatFreighters((WeightedRandomPicker<O0Oo.Oo>)weightedRandomPicker, oo2, shipFilter, FactionAPI.ShipPickMode.ALL);
        if (shipFilter == null) {
            this.getNormalRoleCache().put(oo2, (WeightedRandomPicker<O0Oo.Oo>)weightedRandomPicker);
        }
        return weightedRandomPicker;
    }

    public Set<String> getVariantsForRole(String string) {
        return this.getVariantsForRole(string, new HashSet<String>());
    }

    public Set<String> getVariantsForRole(String string, Set<String> set) {
        HashSet<String> hashSet = new HashSet<String>();
        set.add(string);
        WeightedRandomPicker<O0Oo.Oo> weightedRandomPicker = null;
        O0Oo.oo oo2 = this.spec.getShipRoles().o00000(string);
        if (!(oo2 == null || oo2.o00000().isEmpty() && oo2.Object() == null)) {
            weightedRandomPicker = this.getAllValidEntries(oo2, null);
        } else {
            oo2 = J.getDefaultShipRoles().o00000(string);
            if (oo2 != null) {
                weightedRandomPicker = this.getAllValidEntries(oo2, null);
            }
        }
        if (weightedRandomPicker != null && !weightedRandomPicker.isEmpty()) {
            for (O0Oo.Oo oo3 : weightedRandomPicker.getItems()) {
                hashSet.add(oo3.getVariantId());
            }
        } else if (oo2 != null) {
            String string2;
            O0Oo.o o2 = oo2.Object();
            String string3 = string2 = o2 != null ? o2.new() : null;
            if (o2 != null && !set.contains(string2)) {
                hashSet.addAll(this.getVariantsForRole(string2, set));
            }
        }
        return hashSet;
    }

    public RepLevel getRelationshipLevel(FactionAPI factionAPI) {
        return this.getRelationshipLevel(factionAPI.getId());
    }

    public RepLevel getRelationshipLevel(String string) {
        return RepLevel.getLevelFor((float)this.getRelation(string).getValue());
    }

    public boolean isAtWorst(FactionAPI factionAPI, RepLevel repLevel) {
        return this.isAtWorst(factionAPI.getId(), repLevel);
    }

    public boolean isAtBest(FactionAPI factionAPI, RepLevel repLevel) {
        return this.isAtBest(factionAPI.getId(), repLevel);
    }

    public boolean isAtWorst(String string, RepLevel repLevel) {
        return this.getRelationshipLevel(string).isAtWorst(repLevel);
    }

    public boolean isAtBest(String string, RepLevel repLevel) {
        return this.getRelationshipLevel(string).isAtBest(repLevel);
    }

    public void setRelationship(String string, RepLevel repLevel) {
        FactionManager.Relation relation = this.getRelation(string);
        if (repLevel == RepLevel.NEUTRAL) {
            relation.setValue(0.0f);
        } else if (repLevel.isPositive()) {
            relation.setValue(repLevel.getMin() + 0.01f);
        } else {
            relation.setValue(-repLevel.getMin() - 0.01f);
        }
    }

    public boolean adjustRelationship(String string, float f2, RepLevel repLevel) {
        if (f2 == 0.0f) {
            return false;
        }
        FactionManager.Relation relation = this.getRelation(string);
        float f3 = relation.getValue();
        float f4 = f3 + f2;
        if (f2 > 0.0f) {
            if (repLevel == null) {
                repLevel = RepLevel.COOPERATIVE;
            }
            float f5 = repLevel.getMax();
            if (repLevel.isNegative()) {
                f5 = -repLevel.getMin() - 0.01f;
            }
            if ((f4 = Math.min(f4, f5)) > f3) {
                relation.setValue(f4);
                return true;
            }
        } else if (f2 < 0.0f) {
            if (repLevel == null) {
                repLevel = RepLevel.VENGEFUL;
            }
            float f6 = -repLevel.getMax();
            if (repLevel.isPositive()) {
                f6 = repLevel.getMin() + 0.01f;
            }
            if ((f4 = Math.max(f4, f6)) < f3) {
                relation.setValue(f4);
                return true;
            }
        }
        return false;
    }

    public boolean ensureAtBest(String string, RepLevel repLevel) {
        FactionManager.Relation relation = this.getRelation(string);
        RepLevel repLevel2 = RepLevel.getLevelFor((float)relation.getValue());
        if (!repLevel2.isAtBest(repLevel)) {
            if (repLevel.isNegative()) {
                this.setRelationship(string, -repLevel.getMin() - 0.01f);
            } else {
                this.setRelationship(string, repLevel.getMax());
            }
            return true;
        }
        return false;
    }

    public boolean ensureAtWorst(String string, RepLevel repLevel) {
        FactionManager.Relation relation = this.getRelation(string);
        RepLevel repLevel2 = RepLevel.getLevelFor((float)relation.getValue());
        if (!repLevel2.isAtWorst(repLevel)) {
            if (repLevel.isNegative()) {
                this.setRelationship(string, -repLevel.getMax());
            } else {
                this.setRelationship(string, repLevel.getMin() + 0.01f);
            }
            return true;
        }
        return false;
    }

    public float getTariffFraction() {
        return this.spec.getTariffFraction();
    }

    public float getTollFraction() {
        return this.spec.getTollFraction();
    }

    public float getFineFraction() {
        return this.spec.getFineFraction();
    }

    public FactionManager.Relation getRelation(String string) {
        return FactionManager.getInstance().getRelation(this.id, string);
    }

    public float getRelationship(String string) {
        return this.getRelation(string).getValue();
    }

    public int getRepInt(String string) {
        return RepLevel.getRepInt((float)this.getRelation(string).getValue());
    }

    public void setRelationship(String string, float f2) {
        this.getRelation(string).setValue(f2);
    }

    public void adjustRelationship(String string, float f2) {
        FactionManager.Relation relation = this.getRelation(string);
        relation.setValue(relation.getValue() + f2);
    }

    public boolean isHostileTo(FactionAPI factionAPI) {
        return this.isHostileTo(factionAPI.getId());
    }

    public boolean isHostileTo(String string) {
        return this.isAtBest(string, RepLevel.HOSTILE);
    }

    public boolean isHostileToFast(String string) {
        return -this.getRelation(string).getValue() > RepLevel.getT3();
    }

    public Color getRelColor(String string) {
        Color color = new Color(125, 125, 125, 255);
        float f2 = this.getRelationship(string);
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (f2 < -1.0f) {
            f2 = -1.0f;
        }
        if (f2 > 0.0f) {
            color = B.o00000((Color)color, (Color)D.\u00f5o0000, (float)Math.max(0.15f, f2));
        } else if (f2 < 0.0f) {
            color = B.o00000((Color)color, (Color)D.\u00d2\u00d30000, (float)Math.max(0.15f, -f2));
        }
        return color;
    }

    public Color getRelColor(RepLevel repLevel) {
        Color color = new Color(125, 125, 125, 255);
        float f2 = repLevel.getMax();
        if (repLevel.isNegative()) {
            f2 = -f2;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (f2 < -1.0f) {
            f2 = -1.0f;
        }
        if (f2 > 0.0f) {
            color = B.o00000((Color)color, (Color)D.\u00f5o0000, (float)Math.max(0.15f, f2));
        } else if (f2 < 0.0f) {
            color = B.o00000((Color)color, (Color)D.\u00d2\u00d30000, (float)Math.max(0.15f, -f2));
        }
        return color;
    }

    public String getLogo() {
        if (this.factionLogoOverride != null) {
            return this.factionLogoOverride;
        }
        return this.getSpec().getLogo();
    }

    public String getCrest() {
        if (this.factionCrestOverride != null) {
            return this.factionCrestOverride;
        }
        if (this.getSpec().getCrest() == null) {
            return this.getLogo();
        }
        return this.getSpec().getCrest();
    }

    public JSONObject getCustom() {
        JSONObject jSONObject = this.getSpec().getCustom();
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        return jSONObject;
    }

    public String getCustomString(String string) {
        if (this.customCache.containsKey(string)) {
            return (String)this.customCache.get(string);
        }
        String string2 = this.getCustom().optString(string, "");
        this.customCache.put(string, string2);
        return string2;
    }

    public float getCustomFloat(String string) {
        if (this.customCache.containsKey(string)) {
            return ((Float)this.customCache.get(string)).floatValue();
        }
        float f2 = (float)this.getCustom().optDouble(string, 1.0);
        this.customCache.put(string, Float.valueOf(f2));
        return f2;
    }

    public boolean getCustomBoolean(String string) {
        if (this.customCache.containsKey(string)) {
            return (Boolean)this.customCache.get(string);
        }
        boolean bl = this.getCustom().optBoolean(string, false);
        this.customCache.put(string, bl);
        return bl;
    }

    public JSONObject getCustomJSONObject(String string) {
        if (this.customCache.containsKey(string)) {
            return (JSONObject)this.customCache.get(string);
        }
        JSONObject jSONObject = this.getCustom().optJSONObject(string);
        if (jSONObject == null) {
            return null;
        }
        this.customCache.put(string, jSONObject);
        return jSONObject;
    }

    public String pickRandomShipName(String string) {
        WeightedRandomPicker<String> weightedRandomPicker = CampaignEngine.getInstance().getFaction(this.getId()).getSpec().getShipNameSources();
        return ShipNameStore.o00000(null, string, weightedRandomPicker == null ? "Unknown" : (String)weightedRandomPicker.pick());
    }

    public String pickRandomShipName() {
        WeightedRandomPicker<String> weightedRandomPicker = CampaignEngine.getInstance().getFaction(this.getId()).getSpec().getShipNameSources();
        return ShipNameStore.o00000(null, this.getShipNamePrefix(), weightedRandomPicker == null ? "Unknown" : (String)weightedRandomPicker.pick());
    }

    public String pickRandomShipName(Random random) {
        WeightedRandomPicker<String> weightedRandomPicker = CampaignEngine.getInstance().getFaction(this.getId()).getSpec().getShipNameSources();
        return ShipNameStore.o00000(null, random, this.getShipNamePrefix(), weightedRandomPicker == null ? "Unknown" : (String)weightedRandomPicker.pick(random));
    }

    public RelationshipAPI getRelToPlayer() {
        final FactionAPI factionAPI = Global.getSector().getFaction("player");
        return new RelationshipAPI(){
            private RelationshipAPI.RelationshipTarget new;
            {
                this.new = new RelationshipAPI.RelationshipTarget(RelationshipAPI.RelationshipTargetType.FACTION, (FactionAPI)Faction.this);
            }

            public boolean adjustRelationship(float f2, RepLevel repLevel) {
                return factionAPI.adjustRelationship(Faction.this.getId(), f2, repLevel);
            }

            public boolean ensureAtBest(RepLevel repLevel) {
                return factionAPI.ensureAtBest(Faction.this.getId(), repLevel);
            }

            public boolean ensureAtWorst(RepLevel repLevel) {
                return factionAPI.ensureAtWorst(Faction.this.getId(), repLevel);
            }

            public RepLevel getLevel() {
                return factionAPI.getRelationshipLevel(Faction.this.getId());
            }

            public float getRel() {
                return factionAPI.getRelationship(Faction.this.getId());
            }

            public int getRepInt() {
                return RepLevel.getRepInt((float)this.getRel());
            }

            public Color getRelColor() {
                return factionAPI.getRelColor(Faction.this.getId());
            }

            public Color getRelColor(RepLevel repLevel) {
                return factionAPI.getRelColor(repLevel);
            }

            public RelationshipAPI.RelationshipTarget getTarget() {
                return this.new;
            }

            public boolean isAtBest(RepLevel repLevel) {
                return factionAPI.isAtBest(Faction.this.getId(), repLevel);
            }

            public boolean isAtWorst(RepLevel repLevel) {
                return factionAPI.isAtWorst(Faction.this.getId(), repLevel);
            }

            public boolean isHostile() {
                return factionAPI.isHostileTo(Faction.this.getId());
            }

            public void setLevel(RepLevel repLevel) {
                factionAPI.setRelationship(Faction.this.getId(), repLevel);
            }

            public void setRel(float f2) {
                factionAPI.setRelationship(Faction.this.getId(), f2);
            }

            public void setTarget(RelationshipAPI.RelationshipTarget relationshipTarget) {
                this.new = relationshipTarget;
            }
        };
    }

    public FactionDoctrine getDoctrine() {
        return this.doctrine;
    }

    public void setDoctrine(FactionDoctrine factionDoctrine) {
        this.doctrine = factionDoctrine;
    }

    public Map<String, Long> getWeaponTimestamps() {
        return this.weaponTimestamps;
    }

    public Map<String, Long> getFighterTimestamps() {
        return this.fighterTimestamps;
    }

    public Map<String, Long> getShipTimestamps() {
        return this.shipTimestamps;
    }

    public void setShipTimestampToNow(String string) {
        this.shipTimestamps.put(string, Global.getSector().getClock().getTimestamp());
    }

    public void setWeaponTimestampToNow(String string) {
        this.weaponTimestamps.put(string, Global.getSector().getClock().getTimestamp());
    }

    public void setFighterTimestampToNow(String string) {
        this.fighterTimestamps.put(string, Global.getSector().getClock().getTimestamp());
    }

    public boolean isShipKnownAt(String string, Long l2) {
        if (l2 == null) {
            return this.knowsShip(string);
        }
        Long l3 = this.shipTimestamps.get(string);
        if (l3 != null && l3 > l2) {
            return false;
        }
        return this.knowsShip(string);
    }

    public boolean isWeaponKnownAt(String string, Long l2) {
        if (l2 == null) {
            return this.knowsWeapon(string);
        }
        Long l3 = this.weaponTimestamps.get(string);
        if (l3 != null && l3 > l2) {
            return false;
        }
        return this.knowsWeapon(string);
    }

    public boolean isFighterKnownAt(String string, Long l2) {
        if (l2 == null) {
            return this.knowsFighter(string);
        }
        Long l3 = this.fighterTimestamps.get(string);
        if (l3 != null && l3 > l2) {
            return false;
        }
        return this.knowsFighter(string);
    }

    public Map<String, String> getMusicMap() {
        return this.spec.getMusicMap();
    }

    public String getBarSound() {
        return this.spec.getBarSound();
    }

    public String toString() {
        return this.getId();
    }

    public String pickVoice(PersonImportance personImportance, Random random) {
        if (personImportance == PersonImportance.VERY_LOW || personImportance == PersonImportance.LOW) {
            return (String)this.spec.getVoicePickerLow().pick(random);
        }
        if (personImportance == PersonImportance.VERY_HIGH || personImportance == PersonImportance.HIGH) {
            return (String)this.spec.getVoicePickerHigh().pick(random);
        }
        return (String)this.spec.getVoicePickerMedium().pick(random);
    }

    public Map<String, Float> getWeaponSellFrequency() {
        return this.spec.getWeaponSellFrequency();
    }

    public Map<String, Float> getFighterSellFrequency() {
        return this.spec.getFighterSellFrequency();
    }

    public Map<String, Float> getHullmodSellFrequency() {
        return this.spec.getHullmodSellFrequency();
    }

    public Map<String, Float> getShipSellFrequency() {
        return this.spec.getShipSellFrequency();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class o {
        ShipAPI.HullSize o00000;
        float new;
        float \u00d300000;

        public o(ShipAPI.HullSize hullSize) {
            this.o00000 = hullSize;
        }

        float o00000() {
            return this.\u00d300000 / Math.max(0.001f, this.new);
        }
    }
}

