/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.econ;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.MutableStatWithTempMods;
import com.fs.starfarer.api.combat.StatBonus;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.campaign.econ.Economy;
import com.fs.starfarer.campaign.econ.Market;
import com.fs.starfarer.campaign.econ.MarketDemand;
import com.fs.starfarer.campaign.econ.PriceCalculator;
import com.fs.starfarer.campaign.econ.oOOO;
import com.fs.starfarer.campaign.econ.reach.CommodityMarketData;
import com.fs.starfarer.loading.F;
import com.fs.starfarer.prototype.Utils;
import com.fs.util.DoNotObfuscate;

public class CommodityOnMarket
implements DoNotObfuscate,
CommodityOnMarketAPI {
    private Market market;
    private String commodityId;
    private float stockpile = 0.0f;
    private transient F commodity;
    private transient PriceCalculator supplyPrice = new PriceCalculator();
    private transient PriceCalculator demandPrice = new PriceCalculator();
    private MutableStat greed = new MutableStat(0.0f);
    private MarketDemand demand;
    private StatBonus playerDemandMod = new StatBonus();
    private StatBonus playerSupplyMod = new StatBonus();
    private MutableStatWithTempMods available = new MutableStatWithTempMods(0.0f);
    private MutableStatWithTempMods tradeMod = new MutableStatWithTempMods(0.0f);
    private MutableStatWithTempMods tradeModPlus = new MutableStatWithTempMods(0.0f);
    private MutableStatWithTempMods tradeModMinus = new MutableStatWithTempMods(0.0f);
    private int maxSupply = 0;
    private boolean isSupplyLegal = true;
    private int maxDemand = 0;
    private boolean isDemandLegal = true;
    private transient CommodityMarketData commodityMarketData = null;
    private float exoticUtility;

    Object readResolve() {
        if (this.available == null) {
            this.available = new MutableStatWithTempMods(0.0f);
        }
        if (this.tradeMod == null) {
            this.tradeMod = new MutableStatWithTempMods(0.0f);
        }
        if (this.tradeModPlus == null) {
            this.tradeModPlus = new MutableStatWithTempMods(0.0f);
        }
        if (this.tradeModMinus == null) {
            this.tradeModMinus = new MutableStatWithTempMods(0.0f);
        }
        this.commodity = oOOO.super(this.commodityId);
        if (this.playerDemandMod == null) {
            this.playerDemandMod = new StatBonus();
        }
        if (this.playerSupplyMod == null) {
            this.playerSupplyMod = new StatBonus();
        }
        this.supplyPrice = new PriceCalculator();
        this.demandPrice = new PriceCalculator();
        this.updateCalc();
        return this;
    }

    public CommodityMarketData getCommodityMarketData() {
        if (this.commodityMarketData == null) {
            return new CommodityMarketData(this.getId(), this.market.getEconGroup());
        }
        return this.commodityMarketData;
    }

    public void setCommodityMarketData(CommodityMarketData commodityMarketData) {
        this.commodityMarketData = commodityMarketData;
    }

    public boolean isSupplyLegal() {
        return this.isSupplyLegal;
    }

    public void setSupplyLegal(boolean bl) {
        this.isSupplyLegal = bl;
    }

    public boolean isDemandLegal() {
        return this.isDemandLegal;
    }

    public void setDemandLegal(boolean bl) {
        this.isDemandLegal = bl;
    }

    public int getExportIncome() {
        if (this.commodityMarketData != null) {
            return this.commodityMarketData.getExportIncome(this);
        }
        return 0;
    }

    public int getDemandValue() {
        if (this.commodityMarketData != null) {
            return this.commodityMarketData.getDemandValue(this);
        }
        return 0;
    }

    public boolean isNonEcon() {
        return this.getCommodity().hasTag("nonecon");
    }

    public StatBonus getPlayerDemandPriceMod() {
        return this.playerDemandMod;
    }

    public StatBonus getPlayerSupplyPriceMod() {
        return this.playerSupplyMod;
    }

    public String getId() {
        return this.commodityId;
    }

    public String toString() {
        String string = "";
        string = String.valueOf(string) + this.commodity.getName() + "\n";
        string = String.valueOf(string) + "\tStockpile: " + (int)this.stockpile + "\n";
        string = String.valueOf(string) + "\tBuying at: " + (int)this.market.getDemandPrice(this.commodity.getId(), 1.0, false) + " credits per unit\n";
        string = String.valueOf(string) + "\tSelling for: " + (int)this.market.getSupplyPrice(this.commodity.getId(), 1.0, false) + " credits per unit\n";
        return string;
    }

    public CommodityOnMarket(Market market, String string) {
        this.commodity = oOOO.super(string);
        this.commodityId = string;
        this.market = market;
        this.demand = market.getDemandData().getDemand(this.commodity.getDemandClass());
    }

    public void updateCalc() {
        F f2 = this.demand.getBaseCommodity();
        this.demandPrice.setBasePrice(f2.getBasePrice() / f2.getUtility());
        this.demandPrice.setVariability(f2.getPriceVariability());
        this.demandPrice.setDemand(this.demand.getDemandValue());
        this.supplyPrice.setBasePrice(f2.getBasePrice() / f2.getUtility());
        this.supplyPrice.setVariability(f2.getPriceVariability());
        this.supplyPrice.setDemand(this.demand.getDemandValue() + this.greed.getModifiedValue());
    }

    public PriceCalculator getDemandPrice() {
        return this.demandPrice;
    }

    public PriceCalculator getSupplyPrice() {
        return this.supplyPrice;
    }

    public F getCommodity() {
        return this.commodity;
    }

    public void setCommodity(F f2) {
        this.commodity = f2;
    }

    public MutableStat getGreed() {
        return this.greed;
    }

    public float getGreedValue() {
        return this.greed.getModifiedValue();
    }

    public MarketDemand getDemand() {
        return this.demand;
    }

    public String getDemandClass() {
        return this.demand.getDemandClass();
    }

    public float getStockpile() {
        if (this.stockpile * 0.0f != this.stockpile * 0.0f) {
            this.stockpile = 0.0f;
        }
        return this.stockpile;
    }

    public void setStockpile(float f2) {
        if (f2 * 0.0f != f2 * 0.0f) {
            return;
        }
        this.stockpile = f2;
    }

    public void addToStockpile(float f2) {
        if (f2 * 0.0f != f2 * 0.0f) {
            return;
        }
        this.stockpile += f2;
    }

    public void removeFromStockpile(float f2) {
        if (f2 * 0.0f != f2 * 0.0f) {
            return;
        }
        this.stockpile -= f2;
        if (this.stockpile < 0.0f) {
            this.stockpile = 0.0f;
        }
    }

    public Market getMarket() {
        return this.market;
    }

    public float getUtilityOnMarket() {
        if (!this.commodity.isExotic()) {
            return this.commodity.getUtility();
        }
        float f2 = Economy.EXOTIC_UTILITY_MULT;
        float f3 = Economy.RANGE_FOR_MAX_EXOTIC_DEMAND;
        MarketAPI marketAPI = Global.getSector().getEconomy().getMarket(this.commodity.getOrigin());
        if (marketAPI == null) {
            this.exoticUtility = this.commodity.getUtility() * f2;
            return this.exoticUtility;
        }
        float f4 = Utils.\u00d200000(marketAPI.getLocation(), this.market.getLocation());
        float f5 = 1.0f + f2 * Math.min(f4 / f3, 1.0f);
        this.exoticUtility = this.commodity.getUtility() * f5;
        return this.exoticUtility;
    }

    public boolean isPersonnel() {
        return this.commodity.isPersonnel();
    }

    public boolean isFuel() {
        String string = this.getDemandClass();
        return string.equals("fuel");
    }

    public int getAvailable() {
        return Math.max(0, Math.round(this.available.getModifiedValue()));
    }

    public MutableStatWithTempMods getAvailableStat() {
        return this.available;
    }

    public MutableStatWithTempMods getTradeMod() {
        return this.tradeMod;
    }

    public MutableStatWithTempMods getTradeModPlus() {
        return this.tradeModPlus;
    }

    public MutableStatWithTempMods getTradeModMinus() {
        return this.tradeModMinus;
    }

    public void addTradeMod(String string, float f2, float f3) {
        if (f2 == 0.0f) {
            return;
        }
        this.tradeMod.addTemporaryModFlat(f3, string, null, f2);
        this.reapplyEventMod();
    }

    public void addTradeModPlus(String string, float f2, float f3) {
        if (f2 == 0.0f) {
            return;
        }
        this.tradeModPlus.addTemporaryModFlat(f3, string, null, f2);
        this.reapplyEventMod();
    }

    public void addTradeModMinus(String string, float f2, float f3) {
        if (f2 == 0.0f) {
            return;
        }
        this.tradeModMinus.addTemporaryModFlat(f3, string, null, f2);
        this.reapplyEventMod();
    }

    public float getCombinedTradeModQuantity() {
        return this.tradeMod.getModifiedValue() + Math.max(this.tradeModPlus.getModifiedValue(), 0.0f) + Math.min(this.tradeModMinus.getModifiedValue(), 0.0f);
    }

    public void reapplyEventMod() {
        float f2 = this.getCombinedTradeModQuantity();
        if (f2 != 0.0f) {
            this.available.unmodifyFlat("eMod");
            float f3 = this.getModValueForQuantity(f2);
            if (f3 != 0.0f) {
                this.available.modifyFlat("eMod", f3, "Recent trade/events");
            }
        } else {
            this.available.unmodifyFlat("eMod");
        }
    }

    public float getModValueForQuantity(float f2) {
        float f3;
        block4: {
            float f4;
            float f5;
            block3: {
                f5 = this.available.getModifiedValue();
                float f6 = 0.0f;
                if (this.available.getFlatMods().get("eMod") != null) {
                    f6 = ((MutableStat.StatMod)this.available.getFlatMods().get((Object)"eMod")).value;
                    f5 -= f6;
                }
                f4 = this.getCommodity().getEconUnit();
                f3 = 0.0f;
                if (!(f2 > 0.0f)) break block3;
                float f7 = BaseIndustry.getCommodityEconUnitMult((float)(f5 += 1.0f)) * f4;
                while (f2 >= f7 && f5 + f3 > 0.0f) {
                    f2 -= f7;
                    f7 = BaseIndustry.getCommodityEconUnitMult((float)(f5 + (f3 += 1.0f))) * f4;
                }
                break block4;
            }
            if (!(f2 < 0.0f)) break block4;
            f2 = -f2;
            float f8 = BaseIndustry.getCommodityEconUnitMult((float)f5) * f4;
            while (f2 >= f8 && f5 + f3 > 0.0f) {
                f2 -= f8;
                f8 = BaseIndustry.getCommodityEconUnitMult((float)(f5 + (f3 -= 1.0f))) * f4;
            }
        }
        return f3;
    }

    public float getQuantityForModValue(float f2) {
        float f3 = this.available.getModifiedValue();
        float f4 = 0.0f;
        if (this.available.getFlatMods().get("eMod") != null) {
            f4 = ((MutableStat.StatMod)this.available.getFlatMods().get((Object)"eMod")).value;
            f3 -= f4;
        }
        float f5 = this.getCommodity().getEconUnit();
        float f6 = 0.0f;
        if (f2 > 0.0f) {
            while (f2 > 0.0f) {
                float f7 = BaseIndustry.getCommodityEconUnitMult((float)(f3 + 1.0f)) * f5;
                f6 += f7;
                f2 -= 1.0f;
                f3 += 1.0f;
            }
        } else {
            f2 = -f2;
            while (f2 > 0.0f && f3 > 0.0f) {
                float f8 = BaseIndustry.getCommodityEconUnitMult((float)f3) * f5;
                f6 -= f8;
                f2 -= 1.0f;
                f3 -= 1.0f;
            }
        }
        return f6;
    }

    public int getMaxSupply() {
        return this.maxSupply;
    }

    public void setMaxSupply(int n2) {
        this.maxSupply = n2;
    }

    public int getMaxDemand() {
        return this.maxDemand;
    }

    public void setMaxDemand(int n2) {
        this.maxDemand = n2;
    }

    public boolean isMeta() {
        return this.getCommodity().hasTag("meta");
    }

    public void updateMaxSupplyAndDemand() {
        this.maxSupply = 0;
        this.maxDemand = 0;
        for (Industry industry : this.market.getIndustries()) {
            int n2;
            int n3 = industry.getSupply(this.getId()).getQuantity().getModifiedInt();
            if (n3 > this.maxSupply) {
                this.maxSupply = n3;
                this.isSupplyLegal = industry.isSupplyLegal((CommodityOnMarketAPI)this);
            }
            if (!this.getCommodity().isPrimary() || (n2 = industry.getDemand(this.getId()).getQuantity().getModifiedInt()) <= this.maxDemand) continue;
            this.maxDemand = n2;
            this.isDemandLegal = industry.isDemandLegal((CommodityOnMarketAPI)this);
        }
    }

    public boolean isIllegal() {
        return this.getMarket().isIllegal(this.getId());
    }

    public boolean isIllegalAssumePrimary() {
        return this.getMarket().getFaction().isIllegalAssumePrimary(this.getId());
    }

    public static float getTestModValue(float f2, float f3, float f4) {
        float f5;
        block3: {
            block2: {
                f5 = 0.0f;
                if (!(f4 > 0.0f)) break block2;
                float f6 = BaseIndustry.getCommodityEconUnitMult((float)(f2 += 1.0f)) * f3;
                while (f4 >= f6 && f2 + f5 > 0.0f) {
                    f4 -= f6;
                    f6 = BaseIndustry.getCommodityEconUnitMult((float)(f2 + (f5 += 1.0f))) * f3;
                }
                break block3;
            }
            if (!(f4 < 0.0f)) break block3;
            f4 = -f4;
            float f7 = BaseIndustry.getCommodityEconUnitMult((float)f2) * f3;
            while (f4 >= f7 && f2 + f5 > 0.0f) {
                f4 -= f7;
                f7 = BaseIndustry.getCommodityEconUnitMult((float)(f2 + (f5 -= 1.0f))) * f3;
            }
        }
        return f5;
    }

    public static float getTestQuantity(float f2, float f3, float f4) {
        float f5 = 0.0f;
        if (f4 > 0.0f) {
            while (f4 > 0.0f) {
                float f6 = BaseIndustry.getCommodityEconUnitMult((float)(f2 + 1.0f)) * f3;
                f5 += f6;
                f4 -= 1.0f;
                f2 += 1.0f;
            }
        } else {
            f4 = -f4;
            while (f4 > 0.0f && f2 > 0.0f) {
                float f7 = BaseIndustry.getCommodityEconUnitMult((float)f2) * f3;
                f5 -= f7;
                f4 -= 1.0f;
                f2 -= 1.0f;
            }
        }
        return f5;
    }

    public int getPlayerTradeNetQuantity() {
        int n2 = this.getDemand().getEModExtra(this);
        return n2;
    }

    public int getDeficitQuantity() {
        if (this.getDemandPrice().getHighPriceThreshold() < 0.0f) {
            return 0;
        }
        int n2 = this.getDemand().getEModExtra(this);
        int n3 = Math.round(this.getDemandPrice().getHighPriceThreshold() - this.getStockpile());
        if ((n3 -= n2) < 0) {
            n3 = 0;
        }
        return n3;
    }

    public int getExcessQuantity() {
        if (this.getDemandPrice().getLowPriceThreshold() < 0.0f) {
            return 0;
        }
        int n2 = this.getDemand().getEModExtra(this);
        int n3 = Math.round(this.getStockpile() - this.getDemandPrice().getLowPriceThreshold());
        if ((n3 += n2) < 0) {
            n3 = 0;
        }
        return n3;
    }

    public static void main(String[] stringArray) {
        System.out.println(CommodityOnMarket.getTestQuantity(0.0f, 500.0f, 3.0f));
        System.out.println(CommodityOnMarket.getTestModValue(0.0f, 500.0f, 875.0f));
    }
}

