/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.fleet;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.characters.OfficerDataAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.HullModItemManager;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.fleet.CampaignFleet;
import com.fs.starfarer.campaign.fleet.CargoData;
import com.fs.starfarer.campaign.fleet.CrewComposition;
import com.fs.starfarer.campaign.fleet.FleetMember;
import com.fs.starfarer.campaign.fleet.LogisticsModule;
import com.fs.starfarer.loading.ShipNameStore;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.specs.BaseWeaponSpec;
import com.fs.starfarer.loading.specs.HullVariantSpec;
import com.fs.starfarer.loading.specs.O;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.rpg.OfficerData;
import com.fs.starfarer.rpg.Person;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FleetData
implements DoNotObfuscate,
FleetDataAPI,
Cloneable {
    private static final FleetMember NULL_MEMBER = new FleetMember(-1, null, FleetMemberType.NULL);
    private ArrayList<FleetMember> members = new ArrayList();
    private transient ArrayList<FleetMemberAPI> snapshot = new ArrayList();
    private transient List<FleetMember> membersWithoutNull = new ArrayList<FleetMember>();
    private transient List<FleetMember> sortedMembersWithoutNull = new ArrayList<FleetMember>();
    private transient List<FleetMember> sortedMembersWithoutNullWithFighters = new ArrayList<FleetMember>();
    private transient float fleetPointsUsed = 0.0f;
    private transient float effectiveStrength = 0.0f;
    private String namePrefix;
    private CargoData cargo = new CargoData(false);
    private transient float fuelPerLightYear = 1.0f;
    private transient float minCrew = 0.0f;
    private transient float travelSpeed = 100.0f;
    private String nameSourceFactionId = null;
    private transient WeightedRandomPicker<String> nameSources;
    private Person commander = null;
    private CampaignFleet fleet = null;
    private static final Person defaultCommander = new Person("steady");
    private List<OfficerData> officers = new ArrayList<OfficerData>();
    private transient Boolean postLoadReset = null;
    public static boolean COMPRESS_MEMBERS = false;
    private String j = null;
    private Map<Integer, PersonAPI> iTO = null;
    protected Random shipNameRandom = null;
    private boolean needsSync = true;
    private transient boolean forceNoSync = false;
    private boolean onlySyncMemberLists = false;
    private transient Map<String, Object> cacheClearedOnSync = new HashMap<String, Object>();

    protected FleetData clone() {
        try {
            return (FleetData)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Boolean getPostLoadReset() {
        return this.postLoadReset;
    }

    public void setPostLoadReset(Boolean bl) {
        this.postLoadReset = bl;
    }

    public CampaignFleet getFleet() {
        return this.fleet;
    }

    public void setFleet(CampaignFleet campaignFleet) {
        this.fleet = campaignFleet;
    }

    public List<OfficerData> getOfficers() {
        if (this.officers == null) {
            this.officers = new ArrayList<OfficerData>();
        }
        return this.officers;
    }

    public List<OfficerDataAPI> getOfficersCopy() {
        return new ArrayList<OfficerDataAPI>(this.getOfficers());
    }

    public void addOfficer(OfficerDataAPI officerDataAPI) {
        this.officers.add((OfficerData)officerDataAPI);
        officerDataAPI.getPerson().setFleet((CampaignFleetAPI)this.fleet);
    }

    public void addOfficer(PersonAPI personAPI) {
        if (this.fleet != null) {
            personAPI.setFaction(this.fleet.getFaction().getId());
        }
        this.officers.add(new OfficerData((Person)personAPI));
        personAPI.setFleet((CampaignFleetAPI)this.fleet);
    }

    public void removeOfficer(PersonAPI personAPI) {
        OfficerData officerData = this.getOfficerData((Person)personAPI);
        if (officerData != null) {
            this.officers.remove(officerData);
            officerData.getPerson().setFleet(null);
        }
    }

    public FleetMemberAPI getMemberWithCaptain(PersonAPI personAPI) {
        for (FleetMemberAPI fleetMemberAPI : this.getMembers()) {
            if (fleetMemberAPI.getCaptain() != personAPI) continue;
            return fleetMemberAPI;
        }
        return null;
    }

    public OfficerData getOfficerData(PersonAPI personAPI) {
        if (this.officers == null) {
            return null;
        }
        for (OfficerData officerData : this.officers) {
            if (officerData.getPerson() != personAPI) continue;
            return officerData;
        }
        return null;
    }

    private Object readResolve() throws JSONException {
        this.setSyncNeeded();
        this.cacheClearedOnSync = new HashMap<String, Object>();
        if (this.nameSourceFactionId == null && this.fleet != null && this.fleet.getFaction() != null) {
            this.nameSourceFactionId = this.fleet.getFaction().getId();
        }
        this.updateNameSources();
        if (this.officers == null) {
            this.officers = new ArrayList<OfficerData>();
        }
        if (COMPRESS_MEMBERS && this.j != null && this.iTO != null) {
            JSONObject jSONObject = new JSONObject(this.j);
            JSONArray jSONArray = jSONObject.getJSONArray("m");
            this.members = new ArrayList();
            int n2 = 0;
            while (n2 < jSONArray.length()) {
                String string = jSONArray.getString(n2);
                String string2 = jSONArray.getString(n2 + 1);
                FleetMember fleetMember = new FleetMember(1, string, FleetMemberType.SHIP, string2);
                this.addFleetMember(fleetMember);
                int n3 = n2 / 2;
                PersonAPI personAPI = this.iTO.get(n3);
                if (personAPI != null) {
                    fleetMember.setCaptain(personAPI, false);
                }
                fleetMember.setFlagship(fleetMember.getCaptain() == this.commander, false);
                this.postLoadReset = true;
                n2 += 2;
            }
        } else {
            this.postLoadReset = null;
        }
        this.j = null;
        this.iTO = null;
        return this;
    }

    Object writeReplace() throws JSONException {
        if (this.cargo != null && this.cargo.isEmpty() && (this.getFleet() == null || !this.getFleet().isPlayerFleet())) {
            this.cargo = null;
        }
        if (this.officers != null && this.officers.isEmpty()) {
            this.officers = null;
        }
        this.j = null;
        this.iTO = null;
        if (COMPRESS_MEMBERS && this.fleet != null && this.fleet.isAIMode()) {
            boolean bl = this.fleet.getFaction().getId().equals("remnant");
            boolean bl2 = true;
            for (FleetMember object : this.members) {
                bl2 &= !object.getStatus().needsRepairs();
                bl2 &= object.getVariant().isStockVariant();
                bl2 &= object.getRepairTracker().getBaseCR() >= object.getRepairTracker().getMaxCR();
            }
            if (bl2) {
                FleetData fleetData = this.clone();
                JSONObject jSONObject = new JSONObject();
                JSONArray jSONArray = new JSONArray();
                jSONObject.put("m", (Object)jSONArray);
                fleetData.iTO = new HashMap<Integer, PersonAPI>();
                int n2 = 0;
                for (FleetMember fleetMember : this.members) {
                    if (!fleetMember.getCaptain().isDefault()) {
                        fleetData.iTO.put(n2, fleetMember.getCaptain());
                    }
                    String string = fleetMember.getVariant().getHullVariantId();
                    String string2 = fleetMember.getShipName();
                    jSONArray.put((Object)string);
                    jSONArray.put((Object)string2);
                    ++n2;
                }
                fleetData.j = jSONObject.toString();
                fleetData.members = null;
                return fleetData;
            }
        }
        return this;
    }

    public void takeSnapshot() {
        this.snapshot = new ArrayList();
        for (FleetMember fleetMember : this.members) {
            if (fleetMember.isNull()) continue;
            this.snapshot.add(fleetMember);
        }
    }

    public ArrayList<FleetMemberAPI> getSnapshot() {
        if (this.snapshot == null) {
            this.takeSnapshot();
        }
        return this.snapshot;
    }

    public Person getCommander() {
        if (this.commander == null) {
            return defaultCommander;
        }
        return this.commander;
    }

    public void setCommander(Person person) {
        boolean bl;
        boolean bl2 = bl = this.commander != person;
        if (this.commander != null) {
            this.commander.getStats().setFleet(null);
        }
        this.commander = person;
        if (this.commander != null) {
            this.commander.getStats().setFleet(this.fleet);
            if (bl) {
                this.commander.getStats().refreshCharacterStatsEffects(false);
            }
        }
    }

    public FleetData(String string, String string2) {
        this.namePrefix = string;
        this.nameSourceFactionId = string2;
        this.updateNameSources();
        this.getCargoNoSync().setFleetData(this);
        this.setSyncNeeded();
    }

    protected void updateNameSources() {
        if (this.nameSourceFactionId != null) {
            WeightedRandomPicker<String> weightedRandomPicker = CampaignEngine.getInstance().getFaction(this.nameSourceFactionId).getSpec().getShipNameSources();
            this.nameSources = new WeightedRandomPicker();
            int n2 = 0;
            for (String string : weightedRandomPicker.getItems()) {
                float f2 = weightedRandomPicker.getWeight(n2);
                this.nameSources.add((Object)string, f2);
                ++n2;
            }
        }
    }

    public boolean isFlagshipOnlyShip() {
        this.syncIfNeeded();
        int n2 = 0;
        for (FleetMember fleetMember : this.getMembers()) {
            if (fleetMember.isFighterWing()) continue;
            ++n2;
        }
        return n2 > 1;
    }

    public CargoData getCargo() {
        if (this.cargo == null) {
            this.cargo = new CargoData(false);
        }
        this.syncIfNeeded();
        return this.cargo;
    }

    public CargoData getCargoNoSync() {
        if (this.cargo == null) {
            this.cargo = new CargoData(false);
        }
        return this.cargo;
    }

    public void setCargo(CargoData cargoData) {
        this.cargo = cargoData;
        this.cargo.setFleetData(this);
        this.setSyncNeeded();
        this.syncIfNeeded();
    }

    public void setMaxFleetPoints(float f2) {
    }

    public float getFleetPointsUsed() {
        this.syncIfNeeded();
        return this.fleetPointsUsed;
    }

    public float getEffectiveStrength() {
        this.syncIfNeeded();
        return this.effectiveStrength;
    }

    private void updateFleetPointsUsed() {
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (FleetMember fleetMember : this.members) {
            if (fleetMember.isNull()) continue;
            f2 += (float)fleetMember.getFleetPointCost();
            f3 += Misc.getMemberStrength((FleetMemberAPI)fleetMember, (boolean)true, (boolean)true, (boolean)true);
        }
        this.fleetPointsUsed = f2;
        this.effectiveStrength = f3;
    }

    public void clear() {
        this.clear(true);
    }

    public void clear(boolean bl) {
        if (bl) {
            for (FleetMember fleetMember : this.members) {
                fleetMember.setFleetData(null);
            }
        }
        this.members.clear();
        this.needsSync = true;
    }

    public FleetMember getFleetMemberAtIndex(int n2) {
        if (n2 < 0 || n2 >= this.members.size()) {
            return null;
        }
        FleetMember fleetMember = this.members.get(n2);
        if (fleetMember.isNull()) {
            return null;
        }
        return fleetMember;
    }

    public void insertFleetMemberAtIndex(FleetMember fleetMember, int n2) {
        if (n2 < 0) {
            if (!this.members.contains(fleetMember)) {
                this.addFleetMember(fleetMember);
            }
            return;
        }
        int n3 = 0;
        while (n3 < n2 + 1) {
            if (n3 >= this.members.size()) {
                this.members.add(NULL_MEMBER);
            }
            ++n3;
        }
        fleetMember.setFleetData(this);
        this.members.add(n2, fleetMember);
        this.setSyncNeeded();
    }

    public void setFleetMemberAtIndex(FleetMember fleetMember, int n2) {
        if (n2 < 0) {
            if (!this.members.contains(fleetMember)) {
                this.addFleetMember(fleetMember);
            }
            return;
        }
        int n3 = 0;
        while (n3 < n2 + 1) {
            if (n3 >= this.members.size()) {
                this.members.add(NULL_MEMBER);
            }
            ++n3;
        }
        fleetMember.setFleetData(this);
        this.members.set(n2, fleetMember);
        this.setSyncNeeded();
    }

    public void removeFleetMemberAtIndex(int n2) {
        if (n2 >= this.members.size() || n2 < 0) {
            return;
        }
        FleetMember fleetMember = this.members.get(n2);
        if (fleetMember != null && fleetMember != NULL_MEMBER) {
            fleetMember.setFleetData(null);
        }
        this.members.set(n2, NULL_MEMBER);
        this.setSyncNeeded();
    }

    public int getIndexOfFleetMember(FleetMember fleetMember) {
        return this.members.indexOf(fleetMember);
    }

    public String pickShipName(FleetMemberAPI fleetMemberAPI, Random random) {
        if (this.nameSources != null) {
            this.nameSources.setRandom(random);
        }
        String string = ShipNameStore.o00000((FleetMember)fleetMemberAPI, random, this.namePrefix, this.nameSources == null ? "Unknown" : (String)this.nameSources.pick());
        if (this.nameSources != null) {
            this.nameSources.setRandom(null);
        }
        return string;
    }

    public void addFleetMember(int n2, FleetMember fleetMember) {
        this.members.add(n2, fleetMember);
        this.setSyncNeeded();
    }

    public Random getShipNameRandom() {
        return this.shipNameRandom;
    }

    public void setShipNameRandom(Random random) {
        this.shipNameRandom = random;
    }

    public void addFleetMember(FleetMember fleetMember) {
        int n2 = 0;
        while (n2 < this.members.size()) {
            if (this.members.get(n2) == fleetMember) {
                return;
            }
            ++n2;
        }
        n2 = this.findFirstUnusedIndex();
        this.members.set(n2, fleetMember);
        if (fleetMember.getShipName() == null && !fleetMember.isFighterWing()) {
            fleetMember.setShipName(ShipNameStore.o00000(fleetMember, this.shipNameRandom, this.namePrefix, this.nameSources == null ? "Unknown" : (String)this.nameSources.pick(this.shipNameRandom)));
        }
        fleetMember.setFleetData(this);
        if (fleetMember.getCaptain() == null) {
            fleetMember.setCaptain(new Person("steady"));
        }
        fleetMember.setFlagship(false);
        this.setSyncNeeded();
    }

    public FleetMemberAPI addFleetMember(String string) {
        FleetMemberAPI fleetMemberAPI = Global.getFactory().createFleetMember(FleetMemberType.SHIP, string);
        this.addFleetMember(fleetMemberAPI);
        return fleetMemberAPI;
    }

    public void addFleetMember(FleetMemberAPI fleetMemberAPI) {
        if (fleetMemberAPI == null) {
            String string = "FleetData with fleet == null";
            if (this.fleet != null) {
                string = this.fleet.getNameWithFaction();
            }
            throw new RuntimeException("Attempting to add null fleet member to [" + string + "]");
        }
        this.addFleetMember((FleetMember)fleetMemberAPI);
    }

    public void removeFleetMember(FleetMemberAPI fleetMemberAPI) {
        this.removeFleetMemberAndCollapseSlot((FleetMember)fleetMemberAPI);
    }

    public List<FleetMemberAPI> getMembersListCopy() {
        if (this.getMembers() == null) {
            return new ArrayList<FleetMemberAPI>();
        }
        return new ArrayList<FleetMemberAPI>(this.getMembers());
    }

    public List<FleetMemberAPI> getCombatReadyMembersListCopy() {
        return new ArrayList<FleetMemberAPI>(this.getCombatReadyMembers());
    }

    public void removeFleetMemberAndCollapseSlot(FleetMember fleetMember) {
        this.members.remove(fleetMember);
        this.setSyncNeeded();
        fleetMember.setFleetData(null);
    }

    public void removeFleetMemberAndDoNotCollapseSlot(FleetMember fleetMember) {
        int n2 = this.members.indexOf(fleetMember);
        this.removeFleetMemberAtIndex(n2);
        fleetMember.setFleetData(null);
    }

    public int findFirstUnusedIndex() {
        int n2 = 0;
        while (n2 < this.members.size()) {
            if (this.members.get(n2).isNull()) {
                return n2;
            }
            ++n2;
        }
        this.members.add(NULL_MEMBER);
        return this.members.size() - 1;
    }

    public void swapMembers(FleetMember fleetMember, FleetMember fleetMember2) {
        int n2 = this.members.indexOf(fleetMember);
        int n3 = this.members.indexOf(fleetMember2);
        if (n2 >= 0 && n3 >= 0) {
            this.members.set(n2, fleetMember2);
            this.members.set(n3, fleetMember);
        }
        this.syncMemberLists();
    }

    public List<FleetMember> getMembersListWithFighters() {
        this.syncIfNeeded();
        if (this.sortedMembersWithoutNullWithFighters.isEmpty()) {
            for (FleetMember fleetMember : this.membersWithoutNull) {
                this.sortedMembersWithoutNullWithFighters.add(fleetMember);
            }
            Utils.\u00d200000(this.sortedMembersWithoutNullWithFighters);
        }
        return this.sortedMembersWithoutNullWithFighters;
    }

    public List<FleetMemberAPI> getMembersListWithFightersCopy() {
        return new ArrayList<FleetMemberAPI>(this.getMembersListWithFighters());
    }

    public void syncMemberLists() {
        this.cacheClearedOnSync = new HashMap<String, Object>();
        this.membersWithoutNull = new ArrayList<FleetMember>();
        if (this.members == null) {
            this.members = new ArrayList();
        }
        for (FleetMember fleetMember : this.members) {
            if (fleetMember.isNull()) continue;
            fleetMember.setFleetData(this);
            this.membersWithoutNull.add(fleetMember);
        }
        this.membersWithoutNull = Collections.unmodifiableList(this.membersWithoutNull);
        this.sortedMembersWithoutNull = new ArrayList<FleetMember>(this.membersWithoutNull);
        Collections.sort(this.sortedMembersWithoutNull, new Comparator<FleetMember>(){

            public int super(FleetMember fleetMember, FleetMember fleetMember2) {
                int n2;
                int n3 = fleetMember.getHullSpec().getHullSize().ordinal();
                if (n3 != (n2 = fleetMember.getHullSpec().getHullSize().ordinal())) {
                    return n2 - n3;
                }
                return fleetMember2.getFleetPointCost() - fleetMember.getFleetPointCost();
            }
        });
        this.sortedMembersWithoutNull = Collections.unmodifiableList(this.sortedMembersWithoutNull);
        this.sortedMembersWithoutNullWithFighters = new ArrayList<FleetMember>();
    }

    public List<FleetMember> getSortedMembers() {
        this.onlySyncMemberLists = true;
        this.syncIfNeeded();
        this.onlySyncMemberLists = false;
        return this.sortedMembersWithoutNull;
    }

    public boolean isOnlySyncMemberLists() {
        return this.onlySyncMemberLists;
    }

    public void setOnlySyncMemberLists(boolean bl) {
        this.onlySyncMemberLists = bl;
    }

    public Map<String, Object> getCacheClearedOnSync() {
        if (this.cacheClearedOnSync == null) {
            this.cacheClearedOnSync = new HashMap<String, Object>();
        }
        return this.cacheClearedOnSync;
    }

    public boolean isForceNoSync() {
        return this.forceNoSync;
    }

    public void setForceNoSync(boolean bl) {
        this.forceNoSync = bl;
    }

    public void syncIfNeeded() {
        if (this.fleet != null && this.fleet.getStats() == null) {
            return;
        }
        if (this.needsSync && !this.forceNoSync && this.isInInvalidStateDueToGameLoadOrder()) {
            this.membersWithoutNull = new ArrayList<FleetMember>();
            return;
        }
        if (this.needsSync && !this.forceNoSync && this.onlySyncMemberLists) {
            this.needsSync = false;
            this.forceNoSync = true;
            this.syncMemberLists();
            this.forceNoSync = false;
            return;
        }
        if (this.needsSync && !this.forceNoSync && !this.onlySyncMemberLists) {
            Object object;
            this.needsSync = false;
            this.forceNoSync = true;
            if (this.commander != null) {
                this.commander.getStats().setFleet(this.fleet);
            }
            this.syncMemberLists();
            for (FleetMember object2 : this.members) {
                if (object2.isNull()) continue;
                object2.updateStats();
            }
            this.cacheClearedOnSync = new HashMap<String, Object>();
            for (FleetMember fleetMember : this.members) {
                if (fleetMember.isNull()) continue;
                object = (Person)fleetMember.getFleetCommanderForStats();
                if (object == null) {
                    object = fleetMember.getFleetCommander();
                }
                if (object == null) {
                    object = this.commander;
                }
                if (object == null) continue;
                ((Person)object).getStats().applyFleetwideToStats(fleetMember.getStats(), fleetMember.getHullSpec().getHullSize());
            }
            this.recrewFleetMembers();
            if (this.fleet != null) {
                for (O o2 : SpecStore.String()) {
                    o2.getFleetEffect().onFleetSync((CampaignFleetAPI)this.fleet);
                }
            }
            this.updateFleetPointsUsed();
            this.updateCargoCapacities();
            this.updateTravelSpeed();
            if (this.getFleet() != null && this.getFleet().getLogistics() != null) {
                this.getFleet().getLogistics().advance(0.0f);
            }
            if (this.membersWithoutNull != null) {
                for (FleetMember fleetMember : this.membersWithoutNull) {
                    if (fleetMember.getBuffManager() != null) {
                        fleetMember.getBuffManager().advance(0.0f);
                    }
                    if ((object = fleetMember.getVariant()) == null) continue;
                    for (O o3 : ((HullVariantSpec)object).getAllMods()) {
                        if (o3.getEffect() == null) continue;
                        o3.getEffect().advanceInCampaign((FleetMemberAPI)fleetMember, 0.0f);
                    }
                }
            }
            for (FleetMember fleetMember : this.members) {
                if (fleetMember.isNull() || fleetMember.getVariant() == null) continue;
                fleetMember.updateOnlyStatsThatCanRelyOnCROrCrew();
                if (fleetMember.getBuffManager() != null) {
                    fleetMember.getBuffManager().applyBuffs(fleetMember);
                }
                fleetMember.getRepairTracker().updateRates();
            }
            if (this.fleet != null) {
                this.fleet.updateCounts();
                this.fleet.updateFleetSizeCount();
                String string = "burn_bonus_from_ships";
                float f2 = Misc.getFleetwideTotalMod((CampaignFleetAPI)this.fleet, (String)"fleet_burn_bonus", (float)0.0f);
                if (f2 > 0.0f) {
                    this.fleet.getStats().getFleetwideMaxBurnMod().modifyFlat(string, f2, "Drive field stabilization");
                } else {
                    this.fleet.getStats().getFleetwideMaxBurnMod().unmodifyFlat(string);
                }
            }
            this.forceNoSync = false;
            this.needsSync = false;
        }
    }

    public float getTravelSpeed() {
        this.syncIfNeeded();
        float f2 = this.membersWithoutNull.size();
        if (f2 <= 0.0f) {
            this.travelSpeed = 200.0f;
            return this.travelSpeed;
        }
        float f3 = this.getBurnLevel();
        this.travelSpeed = Math.max(1.0f, f3) * StarfarerSettings.\u00d2\u00d20000() + StarfarerSettings.O\u00f40000();
        this.travelSpeed = this.getCommander().getStats().getTravelSpeedBonus().computeEffective(this.travelSpeed);
        if (this.travelSpeed < 0.0f) {
            this.travelSpeed = 0.0f;
        }
        if (f3 <= 0.0f) {
            this.travelSpeed = StarfarerSettings.if("minTravelSpeed");
        }
        return this.travelSpeed;
    }

    public boolean isNeedsSync() {
        return this.needsSync;
    }

    public void updateCargoCapacities() {
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        for (FleetMember fleetMember : this.membersWithoutNull) {
            float f7 = 1.0f;
            if (fleetMember.isFighterWing()) {
                f7 = fleetMember.getWingSpec().getNumFighters();
            }
            f2 += fleetMember.getFuelCapacity() * f7;
            f3 += fleetMember.getCargoCapacity() * f7;
            f4 += fleetMember.getMinCrew();
            f5 += fleetMember.getMaxCrew();
            f6 += fleetMember.getFuelUse() * f7;
        }
        if (f6 == 0.0f) {
            f6 = 1.0f;
        }
        this.getCargoNoSync().setMaxFuel(f2);
        this.getCargoNoSync().setMaxCapacity(f3);
        this.getCargoNoSync().setMaxPersonnel(f5);
        this.getCargoNoSync().updateSpaceUsed();
        this.minCrew = f4;
        this.fuelPerLightYear = f6;
    }

    public void setSyncNeeded() {
        this.needsSync = true;
    }

    public float getBurnLevel() {
        float f2 = this.getMinBurnLevel();
        if (this.fleet != null) {
            float f3 = f2;
            boolean bl = f3 > (f2 = this.fleet.getStats().getFleetwideMaxBurnMod().computeEffective(f2));
            f2 = Math.round(f2);
            if (bl && f2 == f3) {
                f2 -= 1.0f;
            }
        }
        if (f2 < 1.0f && f2 > 0.0f) {
            f2 = 1.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 20.0f) {
            f2 = 20.0f;
        }
        return f2;
    }

    private void updateTravelSpeed() {
        this.travelSpeed = this.getTravelSpeed();
    }

    public void ensureHasFlagship() {
        this.ensureHasFlagship(true);
    }

    public void ensureHasFlagship(boolean bl) {
        boolean bl2 = false;
        for (FleetMember fleetMember : this.membersWithoutNull) {
            if (!bl2) {
                if (!fleetMember.isFlagship()) continue;
                bl2 = true;
                continue;
            }
            if (!bl) continue;
            if (fleetMember.isFlagship()) {
                fleetMember.setCaptain(new Person("steady"));
            }
            fleetMember.setFlagship(false);
        }
        if (!bl2) {
            for (FleetMember fleetMember : this.membersWithoutNull) {
                boolean bl3;
                boolean bl4 = bl3 = this.fleet != null && this.fleet.isPlayerFleet() && Misc.isAutomated((FleetMemberAPI)fleetMember);
                if (bl3 || fleetMember.isFighterWing() || Misc.isUnremovable((PersonAPI)fleetMember.getCaptain())) continue;
                fleetMember.setFlagship(true);
                break;
            }
        }
    }

    public void recrewFleetMembers() {
        this.recrewFleetMembersV2();
    }

    private void recrewFleetMembersV2() {
        float f2;
        float fleetMember;
        boolean bl = false;
        if (this.getFleet() != null && this.getFleet().isAIMode()) {
            for (FleetMember object2 : this.membersWithoutNull) {
                if (object2.getFleetCommanderForStats() != null && object2.getFleetCommanderForStats().isPlayer()) {
                    bl = true;
                    continue;
                }
                CrewComposition f5 = new CrewComposition();
                fleetMember = object2.getMinCrew();
                f5.setCrew(fleetMember);
                object2.setCrewComposition(f5);
            }
            if (!bl) {
                return;
            }
        }
        ArrayList<FleetMember> arrayList = new ArrayList<FleetMember>();
        float f4 = 0.0f;
        float f3 = 0.0f;
        for (FleetMember fleetMember2 : this.membersWithoutNull) {
            if (fleetMember2.getRepairTracker() == null || bl && (fleetMember2.getFleetCommanderForStats() == null || !fleetMember2.getFleetCommanderForStats().isPlayer())) continue;
            if (fleetMember2.isMothballed()) {
                fleetMember2.setCrewComposition(new CrewComposition());
                continue;
            }
            arrayList.add(fleetMember2);
            f3 += fleetMember2.getMinCrew();
        }
        fleetMember = this.getCargoNoSync().getCrew();
        if (bl) {
            fleetMember = ((CampaignFleet)Global.getSector().getPlayerFleet()).getFleetData().getCargoNoSync().getCrew();
        }
        float f5 = fleetMember;
        if (f3 == 0.0f) {
            f2 = 0.0f;
        } else {
            f2 = f5 / f3;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
        }
        for (FleetMember fleetMember3 : arrayList) {
            if (bl && (fleetMember3.getFleetCommanderForStats() == null || !fleetMember3.getFleetCommanderForStats().isPlayer())) continue;
            float f6 = fleetMember3.getMinCrew();
            float f7 = Math.round(f6 * f2);
            float f8 = Math.min(fleetMember, f7);
            fleetMember -= f8;
            CrewComposition crewComposition = new CrewComposition();
            crewComposition.setCrew(f8);
            fleetMember3.setCrewComposition(crewComposition);
            fleetMember3.updateStats();
        }
    }

    public List<FleetMember> getMembersNoSync() {
        return this.members;
    }

    public boolean isInInvalidStateDueToGameLoadOrder() {
        if (this.members == null) {
            return true;
        }
        for (FleetMember fleetMember : this.members) {
            if (fleetMember.isNull() || fleetMember.getRepairTracker() != null) continue;
            return true;
        }
        return false;
    }

    public List<FleetMember> getMembers() {
        this.syncIfNeeded();
        return this.membersWithoutNull;
    }

    public int getNumMembers() {
        this.syncIfNeeded();
        return this.membersWithoutNull.size();
    }

    public List<FleetMemberAPI> getMembersInPriorityOrder() {
        ArrayList<FleetMemberAPI> arrayList = new ArrayList<FleetMemberAPI>();
        for (FleetMemberAPI fleetMemberAPI : this.getMembers()) {
            if (fleetMemberAPI.getRepairTracker().isMothballed()) continue;
            arrayList.add(fleetMemberAPI);
        }
        for (FleetMemberAPI fleetMemberAPI : this.getMembers()) {
            if (!fleetMemberAPI.getRepairTracker().isMothballed()) continue;
            arrayList.add(fleetMemberAPI);
        }
        return arrayList;
    }

    public List<FleetMember> getMembersWithNulls() {
        this.syncIfNeeded();
        return this.members;
    }

    public List<FleetMember> getMembersWithNullsWithoutSync() {
        return this.members;
    }

    public void collapseEmptySlots() {
        Iterator<FleetMember> iterator = this.members.iterator();
        while (iterator.hasNext()) {
            FleetMember fleetMember = iterator.next();
            if (!fleetMember.isNull()) continue;
            iterator.remove();
        }
    }

    public float getFuelPerLightYear() {
        this.syncIfNeeded();
        return this.fuelPerLightYear;
    }

    public float getMinCrew() {
        this.syncIfNeeded();
        return this.minCrew;
    }

    public List<FleetMember> getCombatReadyMembers() {
        this.syncIfNeeded();
        ArrayList<FleetMember> arrayList = new ArrayList<FleetMember>();
        for (FleetMember fleetMember : this.membersWithoutNull) {
            if (fleetMember.isMothballed() || !fleetMember.canBeDeployedForCombat()) continue;
            arrayList.add(fleetMember);
        }
        return arrayList;
    }

    public void sort() {
        this.sort(null);
    }

    public void sortToMatchOrder(List<FleetMemberAPI> list) {
        this.setSyncNeeded();
        this.syncIfNeeded();
        if (this.membersWithoutNull == null || this.members == null) {
            return;
        }
        ArrayList<FleetMember> arrayList = new ArrayList<FleetMember>(this.membersWithoutNull);
        this.members.clear();
        block0: for (FleetMemberAPI fleetMemberAPI : list) {
            String string = fleetMemberAPI.getId();
            for (FleetMember fleetMember : arrayList) {
                if (!fleetMember.getId().equals(string)) continue;
                this.addFleetMember(fleetMember);
                arrayList.remove(fleetMember);
                continue block0;
            }
        }
        for (FleetMemberAPI fleetMemberAPI : arrayList) {
            this.addFleetMember(fleetMemberAPI);
        }
    }

    public void sort(final ShipAPI.HullSize hullSize) {
        this.setSyncNeeded();
        this.syncIfNeeded();
        if (this.membersWithoutNull == null || this.members == null) {
            return;
        }
        ArrayList<FleetMember> arrayList = new ArrayList<FleetMember>(this.membersWithoutNull);
        Collections.sort(arrayList, new Comparator<FleetMember>(){

            public int super(FleetMember fleetMember, FleetMember fleetMember2) {
                if (fleetMember.isMothballed() && !fleetMember2.isMothballed()) {
                    return 1;
                }
                if (fleetMember2.isMothballed() && !fleetMember.isMothballed()) {
                    return -1;
                }
                if (fleetMember.getHullSpec().getHullSize() == hullSize && fleetMember2.getHullSpec().getHullSize() != hullSize) {
                    return -1;
                }
                if (fleetMember.getHullSpec().getHullSize() != hullSize && fleetMember2.getHullSpec().getHullSize() == hullSize) {
                    return 1;
                }
                int n2 = fleetMember2.getHullSpec().getHullSize().ordinal() - fleetMember.getHullSpec().getHullSize().ordinal();
                if (n2 != 0) {
                    return n2;
                }
                return fleetMember2.getFleetPointCost() - fleetMember.getFleetPointCost();
            }
        });
        this.members.clear();
        for (FleetMember fleetMember : arrayList) {
            this.addFleetMember(fleetMember);
        }
        this.syncIfNeeded();
    }

    public float getTotalRepairAndRecoverySupplyCostIgnoringLR() {
        float f2 = 0.0f;
        for (FleetMember fleetMember : this.getMembers()) {
            if (!fleetMember.canBeRepaired() && (!fleetMember.isFighterWing() || fleetMember.isSuspendRepairs())) continue;
            f2 += LogisticsModule.getRecoverySupplyUsePerDay(fleetMember) * fleetMember.getRepairTracker().getRemainingRepairAndRecoveryTimeIgnoringLR();
        }
        return f2;
    }

    public boolean areAnyShipsPerformingRepairs() {
        if (this.getCargo().getSupplies() <= 0.0f) {
            return false;
        }
        if (this.getFleet() != null) {
            return this.getFleet().getLogistics().repairsNeeded();
        }
        return false;
    }

    public float computeTotalStrength(boolean bl) {
        this.syncIfNeeded();
        float f2 = 0.0f;
        for (FleetMember fleetMember : this.membersWithoutNull) {
            if (!fleetMember.canBeDeployedForCombat() && !bl) continue;
            float f3 = fleetMember.getFleetPointCost();
            f2 += f3;
        }
        return f2;
    }

    public float getMaxBurnLevel() {
        float f2 = 0.0f;
        for (FleetMember fleetMember : this.getMembers()) {
            float f3;
            if (fleetMember.isMothballed() || !((f3 = fleetMember.getStats().getMaxBurnLevel().getModifiedValue()) > f2)) continue;
            f2 = f3;
        }
        return f2;
    }

    public float getMinBurnLevel() {
        float f2 = Float.MAX_VALUE;
        for (FleetMember fleetMember : this.getMembers()) {
            float f3 = fleetMember.getStats().getMaxBurnLevel().getModifiedValue();
            if (!(f3 < f2)) continue;
            f2 = f3;
        }
        return f2;
    }

    public float getMinBurnLevelUnmodified() {
        float f2 = Float.MAX_VALUE;
        for (FleetMember fleetMember : this.getMembers()) {
            float f3 = fleetMember.getStats().getMaxBurnLevel().getBaseValue();
            if (!(f3 < f2)) continue;
            f2 = f3;
        }
        return f2;
    }

    public void scuttle(FleetMemberAPI fleetMemberAPI) {
        FleetMember fleetMember = (FleetMember)fleetMemberAPI;
        float f2 = fleetMember.getRepairTracker().getSuppliesFromScuttling();
        float f3 = fleetMember.getRepairTracker().getFuelFromScuttling();
        float f4 = fleetMember.getRepairTracker().getHeavyMachineryFromScuttling();
        this.getCargo().addSupplies(f2);
        this.getCargo().addFuel(f3);
        this.getCargo().addCommodity("heavy_machinery", f4);
        if (!fleetMember.isFighterWing()) {
            for (String string : fleetMember.getVariant().getNonBuiltInWeaponSlots()) {
                BaseWeaponSpec baseWeaponSpec = fleetMember.getVariant().getWeaponSpec(string);
                if (baseWeaponSpec.getAIHints().contains(WeaponAPI.AIHints.SYSTEM)) continue;
                this.getCargo().addWeapons(baseWeaponSpec.getWeaponId(), 1);
            }
            for (String string : fleetMember.getVariant().getNonBuiltInWings()) {
                this.getCargo().addFighters(string, 1);
            }
        }
        if (fleetMember.getCaptain() != null && fleetMember.getCaptain().isAICore()) {
            this.getCargo().addCommodity(fleetMember.getCaptain().getAICoreId(), 1.0f);
        }
        if (this.fleet != null && this.fleet.isPlayerFleet()) {
            HullModItemManager.getInstance().giveBackAllItems((FleetMemberAPI)fleetMember);
        }
        this.removeFleetMemberAndCollapseSlot(fleetMember);
    }

    public void setFlagship(FleetMemberAPI fleetMemberAPI) {
        for (FleetMember fleetMember : this.getMembers()) {
            fleetMember.setFlagship(false);
            if (fleetMember.getCaptain() != CampaignEngine.getInstance().getCharacterData().getPerson() && !fleetMember.isFlagship() || fleetMemberAPI == null) continue;
            fleetMember.setCaptain(new Person("steady"));
        }
        if (fleetMemberAPI != null) {
            fleetMemberAPI.setFlagship(true);
            fleetMemberAPI.setCaptain((PersonAPI)this.getCommander());
        }
    }
}

