/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.util;

import com.fs.graphics.util.Fader;
import com.fs.graphics.util.GLListManager;
import com.fs.profiler.Profiler;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import org.lwjgl.opengl.GL11;

public class UIIndicator
implements DoNotObfuscate {
    private Fader fader = new Fader(0.0f, 0.25f, 0.25f);
    private Color color;
    private IndicatorType type;
    private IndicatorType next = null;
    private Color nextColor;
    private float radius;
    private float lw;
    private GLListManager.GLListToken token;

    public UIIndicator(IndicatorType indicatorType, Color color, float f2, float f3) {
        this.radius = f2;
        this.lw = f3;
        this.type = indicatorType;
        this.color = color;
        this.fader.fadeIn();
    }

    public void setRadius(float f2) {
        if (this.radius == f2) {
            return;
        }
        this.radius = f2;
        GLListManager.invalidateList((GLListManager.GLListToken)this.token);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (!color.equals(this.color)) {
            GLListManager.invalidateList((GLListManager.GLListToken)this.token);
            this.color = color;
        }
    }

    public Fader getFader() {
        return this.fader;
    }

    public void setWidth(float f2) {
        if (this.lw == f2) {
            return;
        }
        this.lw = f2;
        GLListManager.invalidateList((GLListManager.GLListToken)this.token);
    }

    public void advance(float f2) {
        if (this.next != null && this.fader.isFadedOut()) {
            GLListManager.invalidateList((GLListManager.GLListToken)this.token);
            this.type = this.next;
            this.color = this.nextColor;
            this.next = null;
            this.fader.fadeIn();
        } else if (this.next != null) {
            this.fader.fadeOut();
        }
        this.fader.advance(f2);
    }

    public void setNext(IndicatorType indicatorType, Color color) {
        this.next = indicatorType;
        this.nextColor = color;
    }

    public void reFanOut() {
        this.fader.forceOut();
        this.fader.fadeIn();
    }

    public void render(float f2, float f3, float f4) {
        f4 *= this.fader.getBrightness();
        f4 *= 0.3f;
        Profiler.new((String)"Rendering UI indicators");
        switch (this.type) {
            case DIAMOND: {
                this.renderDiamond(f2, f3, f4 * 0.37f);
                break;
            }
            case SQUARE: {
                this.renderSquare(f2, f3, f4 * 0.37f);
                break;
            }
            case CIRCLE: {
                this.renderCircle(f2, f3, f4 * 0.37f);
            }
        }
        Profiler.o00000();
    }

    private void renderDiamond(float f2, float f3, float f4) {
        boolean bl = this.begin(f2, f3, f4, 0.0f, false);
        if (!bl) {
            GL11.glBegin((int)8);
            this.diamondHelper(this.radius, this.lw);
            this.diamondHelper(this.radius - 0.25f, this.lw - 0.5f);
            this.diamondHelper(this.radius - 0.5f, this.lw - 1.0f);
            GL11.glEnd();
        }
        this.end(bl);
    }

    private void renderSquare(float f2, float f3, float f4) {
        boolean bl = this.begin(f2, f3, f4, 0.0f, false);
        if (!bl) {
            GL11.glBegin((int)8);
            this.squareHelper(this.radius, this.lw);
            this.squareHelper(this.radius - 0.25f, this.lw - 0.5f);
            this.squareHelper(this.radius - 0.5f, this.lw - 1.0f);
            GL11.glEnd();
        }
        this.end(bl);
    }

    private void renderCircle(float f2, float f3, float f4) {
        boolean bl = this.begin(f2, f3, f4, 0.0f, false);
        if (!bl) {
            GL11.glBegin((int)8);
            this.circleHelper(this.radius, this.lw);
            this.circleHelper(this.radius - 0.25f, this.lw - 0.5f);
            this.circleHelper(this.radius - 0.5f, this.lw - 1.0f);
            GL11.glEnd();
        }
        this.end(bl);
    }

    private void circleHelper(float f2, float f3) {
        float f4 = (float)Math.PI * f2 * 2.0f;
        int n2 = (int)Math.max((float)((int)(f4 / 15.0f)), 36.0f);
        float f5 = (float)Math.PI * 2 / (float)n2;
        float f6 = 0.0f;
        while (f6 < (float)(n2 + 1)) {
            float f7 = f5 * f6;
            float f8 = (float)Math.cos(f7);
            float f9 = (float)Math.sin(f7);
            float f10 = f8 * f2;
            float f11 = f9 * f2;
            float f12 = f8 * (f2 - f3);
            float f13 = f9 * (f2 - f3);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex2f((float)f10, (float)f11);
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex2f((float)f12, (float)f13);
            f6 += 1.0f;
        }
    }

    private void diamondHelper(float f2, float f3) {
        float f4;
        float f5 = f4 = f2 * 1.3f;
        GL11.glVertex2f((float)(-f4), (float)0.0f);
        GL11.glVertex2f((float)(-f4 + (f3 *= 1.414f)), (float)0.0f);
        GL11.glVertex2f((float)0.0f, (float)f5);
        GL11.glVertex2f((float)0.0f, (float)(f5 - f3));
        GL11.glVertex2f((float)f4, (float)0.0f);
        GL11.glVertex2f((float)(f4 - f3), (float)0.0f);
        GL11.glVertex2f((float)0.0f, (float)(-f5));
        GL11.glVertex2f((float)0.0f, (float)(-f5 + f3));
        GL11.glVertex2f((float)(-f4), (float)0.0f);
        GL11.glVertex2f((float)(-f4 + f3), (float)0.0f);
    }

    private void squareHelper(float f2, float f3) {
        float f4 = -f2;
        float f5 = -f2;
        float f6 = f2 * 2.0f;
        GL11.glVertex2f((float)f4, (float)f5);
        GL11.glVertex2f((float)(f4 + f3), (float)(f5 + f3));
        GL11.glVertex2f((float)f4, (float)(f5 + f6));
        GL11.glVertex2f((float)(f4 + f3), (float)(f5 + f6 - f3));
        GL11.glVertex2f((float)(f4 + f6), (float)(f5 + f6));
        GL11.glVertex2f((float)(f4 + f6 - f3), (float)(f5 + f6 - f3));
        GL11.glVertex2f((float)(f4 + f6), (float)f5);
        GL11.glVertex2f((float)(f4 + f6 - f3), (float)(f5 + f3));
        GL11.glVertex2f((float)f4, (float)f5);
        GL11.glVertex2f((float)(f4 + f3), (float)(f5 + f3));
    }

    private void end(boolean bl) {
        if (!bl) {
            GLListManager.endList();
        }
        GL11.glPopMatrix();
    }

    private boolean begin(float f2, float f3, float f4, float f5, boolean bl) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)f2, (float)f3, (float)0.0f);
        float f6 = this.fader.getBrightness();
        GL11.glScalef((float)f6, (float)f6, (float)1.0f);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4ub((byte)((byte)this.color.getRed()), (byte)((byte)this.color.getGreen()), (byte)((byte)this.color.getBlue()), (byte)((byte)((float)this.color.getAlpha() * f4)));
        boolean bl2 = GLListManager.callList((GLListManager.GLListToken)this.token);
        if (bl2) {
            return true;
        }
        this.token = GLListManager.beginList();
        return false;
    }

    public static enum IndicatorType implements DoNotObfuscate
    {
        SQUARE,
        DIAMOND,
        CIRCLE;

    }
}

