/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.combat.entities;

import com.fs.graphics.LayeredRenderable;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.OnHitEffectPlugin;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.ApplyDamageResultAPI;
import com.fs.starfarer.api.loading.ProjectileSpawnType;
import com.fs.starfarer.api.loading.ProjectileSpecAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.combat.CombatEngine;
import com.fs.starfarer.combat.CombatViewport;
import com.fs.starfarer.combat.E.F;
import com.fs.starfarer.combat.E.new;
import com.fs.starfarer.combat.ai.ProximityFuseAI;
import com.fs.starfarer.combat.entities.Missile;
import com.fs.starfarer.combat.entities.Ship;
import com.fs.starfarer.combat.entities.for;
import com.fs.starfarer.combat.entities.o0oO;
import com.fs.starfarer.combat.entities.ship.A.o0OO;
import com.fs.starfarer.combat.entities.ship.E;
import com.fs.starfarer.combat.entities.ship.G;
import com.fs.starfarer.combat.systems.Q;
import com.fs.starfarer.loading.specs.OOoO;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.renderers.M;
import com.fs.starfarer.renderers.N;
import com.fs.starfarer.renderers.O0oO;
import com.fs.starfarer.settings.StarfarerSettings;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class MovingRay
extends o0oO
implements ProximityFuseAI.o,
DamagingProjectileAPI,
LayeredRenderable<CombatEngineLayers, CombatViewport> {
    private OOoO spec;
    private M.o textureAnimator;
    private N.o projAnimator;
    private float maxBrightness = 0.0f;
    private boolean didDamage = false;
    private for rayExtender;
    private float launchPower;
    private float maxPulseLength;
    private O0oO shine;
    private OnHitEffectPlugin effect = null;
    private final Q weapon;
    private int owner;
    private List<new> damagedAlready;
    private Vector2f spawnLocation = new Vector2f();
    private EnumSet<CombatEngineLayers> layers = EnumSet.of(CombatEngineLayers.ABOVE_SHIPS_LAYER);
    private float elapsed = 0.0f;
    private new damageTarget;
    private boolean fromMissile = false;

    public MovingRay(Ship ship, Q q, OOoO oOoO2, float f2, Vector2f vector2f) {
        this.weapon = q;
        this.spec = oOoO2;
        if (oOoO2.isPassThroughMissiles() || oOoO2.isPassThroughFighters()) {
            this.damagedAlready = new ArrayList<new>();
        }
        this.setSource(ship);
        this.effect = oOoO2.getOnHitEffect();
        this.projAnimator = new N.o(oOoO2.getBulletSpriteName());
        this.maxBrightness = 1.0f;
        this.launchPower = f2;
        if (oOoO2.getTextureType() != null) {
            this.textureAnimator = new M.o(oOoO2.getTextureType());
            this.projAnimator.o00000 = this.textureAnimator.\u00d300000();
            this.projAnimator.\u00d300000 = this.textureAnimator.\u00d500000();
        } else {
            this.textureAnimator = new M.o(oOoO2.getFringeTex(), oOoO2.getCoreTex());
            this.projAnimator.o00000 = this.textureAnimator.\u00d300000();
            this.projAnimator.\u00d300000 = this.textureAnimator.\u00d500000();
        }
        if (oOoO2.getGlowRadius() > 0.0f) {
            this.shine = new O0oO(oOoO2.getGlowRadius(), oOoO2.getWidth() * 1.5f, oOoO2.getGlowColor());
        }
        float f3 = E.getAdjustedBaseRange(oOoO2.getMaxRange(), ship, q);
        float f4 = E.getThresholdAdjustedRange(ship, q, f3 * E.computeExtraRangeMult(ship, q) + E.computeExtraRangeFlat(ship, q));
        if (oOoO2.getBehaviorSpec() != null && oOoO2.getBehaviorSpec().getParams() != null) {
            float f5 = (float)oOoO2.getBehaviorSpec().getParams().optDouble("shotRangeVariance", 0.0);
            float f6 = (float)oOoO2.getBehaviorSpec().getParams().optDouble("probOfVariance", 1.0);
            if ((float)Math.random() < f6) {
                f4 *= 1.0f - f5 * (float)Math.random();
            }
        }
        this.maxPulseLength = Math.max(f2 * oOoO2.getLength(), 1.0f / StarfarerSettings.\u00f8\u00d30000() * oOoO2.getMoveSpeed(ship.getStats(), q) * 1.5f);
        this.rayExtender = new for(this.getFrom(), this.getTo(), this.maxPulseLength, oOoO2.getMoveSpeed(ship.getStats(), q), f4, oOoO2.getFadeTime(), vector2f);
        this.setImpactMass(oOoO2.getImpactMass());
        this.setDamage(oOoO2.getDamage().clone());
        this.getDamage().setStats(ship.getStats());
        float[] fArray = E.computeExtraDamageComponents(ship, q);
        if (fArray != null) {
            this.getDamage().getModifier().modifyPercent("core_edc_0", fArray[0]);
            this.getDamage().getModifier().modifyFlat("core_edc_1", fArray[1]);
            this.getDamage().getModifier().modifyMult("core_edc_2", fArray[2]);
        }
        this.owner = ship.getOwner();
    }

    public Vector2f getSpawnLocation() {
        return this.spawnLocation;
    }

    @Override
    public int getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(int n2) {
        this.owner = n2;
    }

    @Override
    public WeaponAPI getWeapon() {
        return this.weapon;
    }

    public Vector2f getImpactDirecion() {
        Vector2f vector2f = Utils.\u00d300000(Utils.\u00d300000(this.rayExtender.String(), this.rayExtender.\u00d600000()));
        return vector2f;
    }

    public float getImpact() {
        return this.spec.getImpactMass();
    }

    public EnumSet<CombatEngineLayers> getActiveLayers() {
        return this.layers;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public boolean isExpired() {
        return this.rayExtender.if();
    }

    public float getBrightness() {
        return this.rayExtender.super() * this.maxBrightness;
    }

    public void render(CombatEngineLayers combatEngineLayers, CombatViewport combatViewport) {
        Vector2f vector2f = this.getFrom();
        Vector2f vector2f2 = this.getTo();
        if (!combatViewport.isNearViewport(vector2f, 100.0f)) {
            return;
        }
        if (!combatViewport.isNearViewport(vector2f2, 100.0f)) {
            return;
        }
        if (this.spec.getFringeColor().getAlpha() <= 0 && this.spec.getCoreColor().getAlpha() <= 0) {
            return;
        }
        float f2 = this.rayExtender.super() * this.maxBrightness;
        float f3 = Utils.void(this.getFrom(), this.getTo());
        if (f3 < this.maxPulseLength) {
            f2 *= f3 / this.maxPulseLength;
        }
        if (this.shine != null) {
            this.shine.o00000(vector2f2.x, vector2f2.y, f2, false);
        }
        if (this.spec.getSpawnType() == ProjectileSpawnType.BEAM) {
            M.o00000(this.textureAnimator, this.spec.getFringeColor(), this.spec.getCoreColor(), this.spec.isDarkCore(), this.spec.getDarkFringeIter(), this.spec.getDarkCoreIter(), vector2f, vector2f2, this.spec.getWidth() * f2, this.spec.getCoreWidthMult(), this.spec.getPixelsPerTexel(), f2, false);
        } else if (this.spec.getSpawnType() == ProjectileSpawnType.BALLISTIC_AS_BEAM) {
            N.super(this.projAnimator, this.getVelocity(), this.spec.getFringeColor(), this.spec.getCoreColor(), vector2f2, vector2f, this.spec.getWidth(), this.spec.getCoreWidthMult(), f2);
        }
    }

    @Override
    public boolean canCauseInsideBoundsCollision() {
        if (this.didDamage) {
            return false;
        }
        float f2 = this.spec.getMoveSpeed(this.getSource() == null ? null : this.getSource().getStats(), this.weapon);
        if (f2 <= 50.0f) {
            return this.elapsed > 0.5f;
        }
        return this.elapsed > 50.0f / f2;
    }

    @Override
    public void advance(float f2) {
        this.elapsed += f2;
        float f3 = this.launchPower * (1.0f - this.rayExtender.void()) * (1.0f - this.rayExtender.void());
        if (this.rayExtender.\u00d200000()) {
            f3 = this.launchPower;
        }
        if (this.isFading()) {
            this.getDamage().setSoftFlux(true);
        }
        if (this.didDamage) {
            f3 = 0.0f;
        }
        this.getDamage().setMultiplier(f3);
        this.textureAnimator.super(f2, this.spec.getTextureScrollSpeed());
        this.projAnimator.o00000(f2, this.spec.getTextureScrollSpeed());
        this.rayExtender.super(f2, this.didDamage);
    }

    @Override
    public void setFacing(float f2) {
        super.setFacing(f2);
    }

    @Override
    public boolean pierces(new new_) {
        if (this.damagedAlready == null) {
            return super.pierces(new_);
        }
        return super.pierces(new_) || !this.didDamage && this.damagedAlready.contains(new_);
    }

    @Override
    public void notifyDealtDamage(Vector2f vector2f, G g2, new new_) {
        if (!(this.didDamage || this.damagedAlready != null && this.damagedAlready.contains(new_))) {
            this.damageTarget = new_;
            float f2 = this.spec.getHitGlowRadius();
            if (f2 == 0.0f) {
                f2 = this.spec.getLength() * 0.5f;
            }
            float f3 = f2 / 1.0f;
            float f4 = f2 / 2.0f;
            boolean bl = false;
            if (this.damagedAlready != null) {
                if (this.spec.isPassThroughMissiles() && new_ instanceof Missile) {
                    bl = true;
                } else if (this.spec.isPassThroughFighters() && new_ instanceof Ship && ((Ship)new_).isFighter() && (!this.spec.isPassThroughFightersOnlyWhenDestroyed() || new_.getHitpoints() <= 0.0f)) {
                    bl = true;
                }
            }
            if (!bl) {
                this.didDamage = true;
            }
            float f5 = f3 + (float)Math.random() * f4;
            f5 = Misc.getHitGlowSize((float)f5, (float)this.getDamage().getBaseDamage(), (ApplyDamageResultAPI)g2);
            if (!this.didDamage) {
                f5 *= 0.5f;
            }
            o0OO.o00000(vector2f, g2, f5, new_, this.spec.getFringeColor(), this.getDamage().getMultiplier() * 0.4f, this.getDamage().getMultiplier());
            if (this.damagedAlready != null) {
                this.damagedAlready.add(new_);
            }
            if ((this.didDamage || this.spec.isApplyOnHitEffectWhenPassThrough()) && this.effect != null) {
                this.effect.onHit((DamagingProjectileAPI)this, (CombatEntityAPI)new_, vector2f, g2.getDamageToShields() > 0.0f, (ApplyDamageResultAPI)g2, (CombatEngineAPI)CombatEngine.getInstance());
            }
        }
    }

    public CombatEntityAPI getDamageTarget() {
        return this.damageTarget instanceof CombatEntityAPI ? this.damageTarget : null;
    }

    @Override
    public boolean didDamage() {
        return this.didDamage;
    }

    @Override
    public Vector2f getVelocity() {
        return this.rayExtender.\u00f500000();
    }

    public float getMoveSpeed() {
        return this.spec.getMoveSpeed(this.getSource() == null ? null : this.getSource().getStats(), this.weapon);
    }

    @Override
    public F getDamage(Vector2f vector2f, new new_) {
        if (this.damagedAlready != null && this.damagedAlready.contains(new_)) {
            return new F(0.0f, false, this.getDamage().getType(), this.getSource().getStats());
        }
        return this.getDamage();
    }

    @Override
    public boolean isFading() {
        return this.rayExtender.\u00f400000();
    }

    public float getDamageAmount() {
        return this.getDamage().getDamage();
    }

    public float getBaseDamageAmount() {
        return this.getDamage().getBaseDamage();
    }

    public void setDamageAmount(float f2) {
        this.getDamage().setDamage(f2);
    }

    public DamageType getDamageType() {
        return this.getDamage().getType();
    }

    public String getProjectileSpecId() {
        return this.spec.getId();
    }

    public float getEmpAmount() {
        return this.getDamage().getFluxComponent();
    }

    public ProjectileSpawnType getSpawnType() {
        return this.spec.getSpawnType();
    }

    public float getElapsed() {
        return this.elapsed;
    }

    public boolean isFromMissile() {
        return this.fromMissile;
    }

    public void setFromMissile(boolean bl) {
        this.fromMissile = bl;
    }

    public void addDamagedAlready(CombatEntityAPI combatEntityAPI) {
    }

    public void removeDamagedAlready(CombatEntityAPI combatEntityAPI) {
    }

    public ProjectileSpecAPI getProjectileSpec() {
        return this.spec;
    }

    public Vector2f getTailEnd() {
        return this.rayExtender.String();
    }

    public List<CombatEntityAPI> getDamagedAlready() {
        return null;
    }
}

