/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.loading.specs;

import com.fs.starfarer.api.campaign.FactionDoctrineAPI;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FactionDoctrine
implements FactionDoctrineAPI,
DoNotObfuscate,
Cloneable {
    private int warships = 4;
    private int carriers = 2;
    private int phaseShips = 1;
    private int officerQuality = 2;
    private int shipQuality = 3;
    private int numShips = 2;
    private int shipSize = 3;
    private int aggression = 3;
    private int fleets = 3;
    private float autofitRandomizeProbability = 0.0f;
    private float combatFreighterProbability = 0.0f;
    private float combatFreighterCombatUseFraction = 0.0f;
    private float combatFreighterCombatUseFractionWhenPriority = 0.0f;
    private float commanderSkillsShuffleProbability = 0.0f;
    private boolean strictComposition = false;
    private List<String> commanderSkills = new ArrayList<String>();
    private float officerSkillsShuffleProbability = 0.0f;
    private List<String> officerSkills = new ArrayList<String>();

    public FactionDoctrine clone() {
        try {
            return (FactionDoctrine)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void copyToDoctrine(FactionDoctrineAPI factionDoctrineAPI) {
        this.copyTo((FactionDoctrine)factionDoctrineAPI);
    }

    public void copyTo(FactionDoctrine factionDoctrine) {
        factionDoctrine.warships = this.warships;
        factionDoctrine.carriers = this.carriers;
        factionDoctrine.phaseShips = this.phaseShips;
        factionDoctrine.officerQuality = this.officerQuality;
        factionDoctrine.numShips = this.numShips;
        factionDoctrine.shipSize = this.shipSize;
        factionDoctrine.shipQuality = this.shipQuality;
        factionDoctrine.aggression = this.aggression;
        factionDoctrine.fleets = this.fleets;
        factionDoctrine.autofitRandomizeProbability = this.autofitRandomizeProbability;
        factionDoctrine.combatFreighterProbability = this.combatFreighterProbability;
        factionDoctrine.combatFreighterCombatUseFraction = this.combatFreighterCombatUseFraction;
        factionDoctrine.combatFreighterCombatUseFractionWhenPriority = this.combatFreighterCombatUseFractionWhenPriority;
        factionDoctrine.commanderSkillsShuffleProbability = this.commanderSkillsShuffleProbability;
        factionDoctrine.officerSkillsShuffleProbability = this.officerSkillsShuffleProbability;
        factionDoctrine.commanderSkills = new ArrayList<String>(this.commanderSkills);
        factionDoctrine.officerSkills = new ArrayList<String>(this.officerSkills);
    }

    public FactionDoctrine() {
    }

    public FactionDoctrine(JSONObject jSONObject) throws JSONException {
        String string;
        int n2;
        JSONArray jSONArray;
        this.warships = jSONObject.getInt("warships");
        this.carriers = jSONObject.getInt("carriers");
        this.phaseShips = jSONObject.getInt("phaseShips");
        this.officerQuality = jSONObject.getInt("officerQuality");
        this.shipQuality = jSONObject.getInt("shipQuality");
        this.numShips = jSONObject.getInt("numShips");
        this.shipSize = jSONObject.optInt("shipSize", 3);
        this.aggression = jSONObject.optInt("aggression", 3);
        this.fleets = jSONObject.optInt("fleets", 3);
        this.strictComposition = jSONObject.optBoolean("strictComposition", false);
        this.autofitRandomizeProbability = (float)jSONObject.optDouble("autofitRandomizeProbability", 0.25);
        this.combatFreighterProbability = (float)jSONObject.optDouble("combatFreighterProbability", 0.0);
        this.commanderSkillsShuffleProbability = (float)jSONObject.optDouble("commanderSkillsShuffleProbability", 0.0);
        this.combatFreighterCombatUseFraction = (float)jSONObject.optDouble("combatFreighterCombatUseFraction", 0.0);
        this.combatFreighterCombatUseFractionWhenPriority = (float)jSONObject.optDouble("combatFreighterCombatUseFractionWhenPriority", 0.0);
        if (jSONObject.has("commanderSkills")) {
            jSONArray = jSONObject.getJSONArray("commanderSkills");
            this.commanderSkills.clear();
            n2 = 0;
            while (n2 < jSONArray.length()) {
                string = jSONArray.getString(n2);
                this.commanderSkills.add(string);
                ++n2;
            }
        }
        this.officerSkillsShuffleProbability = (float)jSONObject.optDouble("officerSkillsShuffleProbability", 0.0);
        if (jSONObject.has("officerSkills")) {
            jSONArray = jSONObject.getJSONArray("officerSkills");
            this.officerSkills.clear();
            n2 = 0;
            while (n2 < jSONArray.length()) {
                string = jSONArray.getString(n2);
                this.officerSkills.add(string);
                ++n2;
            }
        }
    }

    protected Object readResolve() {
        if (this.commanderSkills == null) {
            this.commanderSkills = new ArrayList<String>();
        }
        if (this.officerSkills == null) {
            this.officerSkills = new ArrayList<String>();
        }
        return this;
    }

    public int getTotalStrengthPoints() {
        return this.numShips + this.officerQuality + this.shipQuality;
    }

    public int getWarships() {
        return this.warships;
    }

    public void setWarships(int n2) {
        this.warships = n2;
    }

    public int getCarriers() {
        return this.carriers;
    }

    public void setCarriers(int n2) {
        this.carriers = n2;
    }

    public int getPhaseShips() {
        return this.phaseShips;
    }

    public void setPhaseShips(int n2) {
        this.phaseShips = n2;
    }

    public int getOfficerQuality() {
        return this.officerQuality;
    }

    public void setOfficerQuality(int n2) {
        this.officerQuality = n2;
    }

    public int getShipQuality() {
        return this.shipQuality;
    }

    public float getShipQualityContribution() {
        return ((float)this.shipQuality - 1.0f) * StarfarerSettings.if("doctrineFleetQualityPerPoint");
    }

    public void setShipQuality(int n2) {
        this.shipQuality = n2;
    }

    public int getNumShips() {
        return this.numShips;
    }

    public void setNumShips(int n2) {
        this.numShips = n2;
    }

    public int getShipSize() {
        return this.shipSize;
    }

    public void setShipSize(int n2) {
        this.shipSize = n2;
    }

    public int getAggression() {
        return this.aggression;
    }

    public void setAggression(int n2) {
        this.aggression = n2;
    }

    public int getFleets() {
        return this.fleets;
    }

    public void setFleets(int n2) {
        this.fleets = n2;
    }

    public float getCombatFreighterProbability() {
        return this.combatFreighterProbability;
    }

    public void setCombatFreighterProbability(float f2) {
        this.combatFreighterProbability = f2;
    }

    public float getCommanderSkillsShuffleProbability() {
        return this.commanderSkillsShuffleProbability;
    }

    public void setCommanderSkillsShuffleProbability(float f2) {
        this.commanderSkillsShuffleProbability = f2;
    }

    public List<String> getCommanderSkills() {
        return this.commanderSkills;
    }

    public float getCombatFreighterCombatUseFraction() {
        return this.combatFreighterCombatUseFraction;
    }

    public float getOfficerSkillsShuffleProbability() {
        return this.officerSkillsShuffleProbability;
    }

    public List<String> getOfficerSkills() {
        return this.officerSkills;
    }

    public void setCombatFreighterCombatUseFraction(float f2) {
        this.combatFreighterCombatUseFraction = f2;
    }

    public float getCombatFreighterCombatUseFractionWhenPriority() {
        return this.combatFreighterCombatUseFractionWhenPriority;
    }

    public void setCombatFreighterCombatUseFractionWhenPriority(float f2) {
        this.combatFreighterCombatUseFractionWhenPriority = f2;
    }

    public float getAutofitRandomizeProbability() {
        return this.autofitRandomizeProbability;
    }

    public void setAutofitRandomizeProbability(float f2) {
        this.autofitRandomizeProbability = f2;
    }

    public boolean isStrictComposition() {
        return this.strictComposition;
    }

    public void setStrictComposition(boolean bl) {
        this.strictComposition = bl;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + this.aggression;
        n3 = 31 * n3 + Float.floatToIntBits(this.autofitRandomizeProbability);
        n3 = 31 * n3 + this.carriers;
        n3 = 31 * n3 + Float.floatToIntBits(this.combatFreighterCombatUseFraction);
        n3 = 31 * n3 + Float.floatToIntBits(this.combatFreighterCombatUseFractionWhenPriority);
        n3 = 31 * n3 + Float.floatToIntBits(this.combatFreighterProbability);
        n3 = 31 * n3 + (this.commanderSkills == null ? 0 : this.commanderSkills.hashCode());
        n3 = 31 * n3 + Float.floatToIntBits(this.commanderSkillsShuffleProbability);
        n3 = 31 * n3 + (this.officerSkills == null ? 0 : this.officerSkills.hashCode());
        n3 = 31 * n3 + Float.floatToIntBits(this.officerSkillsShuffleProbability);
        n3 = 31 * n3 + this.fleets;
        n3 = 31 * n3 + this.numShips;
        n3 = 31 * n3 + this.officerQuality;
        n3 = 31 * n3 + this.phaseShips;
        n3 = 31 * n3 + this.shipQuality;
        n3 = 31 * n3 + this.shipSize;
        n3 = 31 * n3 + (this.strictComposition ? 1231 : 1237);
        n3 = 31 * n3 + this.warships;
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FactionDoctrine factionDoctrine = (FactionDoctrine)object;
        if (this.aggression != factionDoctrine.aggression) {
            return false;
        }
        if (Float.floatToIntBits(this.autofitRandomizeProbability) != Float.floatToIntBits(factionDoctrine.autofitRandomizeProbability)) {
            return false;
        }
        if (this.carriers != factionDoctrine.carriers) {
            return false;
        }
        if (Float.floatToIntBits(this.combatFreighterCombatUseFraction) != Float.floatToIntBits(factionDoctrine.combatFreighterCombatUseFraction)) {
            return false;
        }
        if (Float.floatToIntBits(this.combatFreighterCombatUseFractionWhenPriority) != Float.floatToIntBits(factionDoctrine.combatFreighterCombatUseFractionWhenPriority)) {
            return false;
        }
        if (Float.floatToIntBits(this.combatFreighterProbability) != Float.floatToIntBits(factionDoctrine.combatFreighterProbability)) {
            return false;
        }
        if (this.commanderSkills == null ? factionDoctrine.commanderSkills != null : !this.commanderSkills.equals(factionDoctrine.commanderSkills)) {
            return false;
        }
        if (Float.floatToIntBits(this.commanderSkillsShuffleProbability) != Float.floatToIntBits(factionDoctrine.commanderSkillsShuffleProbability)) {
            return false;
        }
        if (this.officerSkills == null ? factionDoctrine.officerSkills != null : !this.officerSkills.equals(factionDoctrine.officerSkills)) {
            return false;
        }
        if (Float.floatToIntBits(this.officerSkillsShuffleProbability) != Float.floatToIntBits(factionDoctrine.officerSkillsShuffleProbability)) {
            return false;
        }
        if (this.fleets != factionDoctrine.fleets) {
            return false;
        }
        if (this.numShips != factionDoctrine.numShips) {
            return false;
        }
        if (this.officerQuality != factionDoctrine.officerQuality) {
            return false;
        }
        if (this.phaseShips != factionDoctrine.phaseShips) {
            return false;
        }
        if (this.shipQuality != factionDoctrine.shipQuality) {
            return false;
        }
        if (this.shipSize != factionDoctrine.shipSize) {
            return false;
        }
        if (this.strictComposition != factionDoctrine.strictComposition) {
            return false;
        }
        return this.warships == factionDoctrine.warships;
    }
}

