/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.util;

import com.fs.graphics.util.Fader;
import com.fs.starfarer.api.util.ColorShifterAPI;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ColorShifter
implements DoNotObfuscate,
ColorShifterAPI {
    private Color base;
    private Color curr;
    private Map<Object, ShiftData> data = new LinkedHashMap<Object, ShiftData>();

    public ColorShifter(Color color) {
        this.base = color;
        this.curr = color;
    }

    public Color getBase() {
        return this.base;
    }

    public void setBase(Color color) {
        this.base = color;
    }

    public Color getCurr() {
        return this.curr;
    }

    public void shift(Object object, Color color, float f2, float f3, float f4) {
        if (color == null) {
            this.data.remove(object);
            return;
        }
        ShiftData shiftData = this.data.get(object);
        if (shiftData == null) {
            shiftData = new ShiftData();
            shiftData.fader = new Fader(0.0f, f2, f3);
            shiftData.fader.setBounceDown(true);
            this.data.put(object, shiftData);
        }
        shiftData.to = color;
        shiftData.shift = f4;
        shiftData.fader.setDuration(f2, f3);
        shiftData.fader.fadeIn();
    }

    public void advance(float f2) {
        Iterator<ShiftData> iterator = this.data.values().iterator();
        while (iterator.hasNext()) {
            ShiftData shiftData = iterator.next();
            shiftData.fader.advance(f2);
            if (!shiftData.fader.isFadedOut()) continue;
            iterator.remove();
        }
        this.updateCurr();
    }

    public boolean isShifted() {
        return !this.data.isEmpty();
    }

    private void updateCurr() {
        if (this.data.isEmpty()) {
            this.curr = this.base;
            return;
        }
        this.curr = this.getCurrForBase(this.base);
    }

    public Color getCurrForBase(Color color) {
        float f2;
        if (this.data == null || this.data.isEmpty()) {
            return color;
        }
        float f3 = 0.0f;
        for (ShiftData shiftData : this.data.values()) {
            f2 = shiftData.fader.getBrightness();
            f3 += f2;
        }
        if (f3 <= 0.0f) {
            return color;
        }
        float f4 = color.getRed();
        float f5 = color.getGreen();
        f2 = color.getBlue();
        float f6 = color.getAlpha();
        for (ShiftData shiftData : this.data.values()) {
            float f7 = shiftData.fader.getBrightness();
            float f8 = f3 - f7 + 1.0f;
            f4 += ((float)shiftData.to.getRed() - (float)color.getRed()) * shiftData.shift * f7 / f8;
            f5 += ((float)shiftData.to.getGreen() - (float)color.getGreen()) * shiftData.shift * f7 / f8;
            f2 += ((float)shiftData.to.getBlue() - (float)color.getBlue()) * shiftData.shift * f7 / f8;
            f6 += ((float)shiftData.to.getAlpha() - (float)color.getAlpha()) * shiftData.shift * f7 / f8;
        }
        if (f4 > 255.0f) {
            f4 = 255.0f;
        }
        if (f5 > 255.0f) {
            f5 = 255.0f;
        }
        if (f2 > 255.0f) {
            f2 = 255.0f;
        }
        if (f6 > 255.0f) {
            f6 = 255.0f;
        }
        if (f4 < 0.0f) {
            f4 = 0.0f;
        }
        if (f5 < 0.0f) {
            f5 = 0.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        return new Color((int)f4, (int)f5, (int)f2, (int)f6);
    }

    public static void main(String[] stringArray) {
        ColorShifter colorShifter = new ColorShifter(Color.red);
        int n2 = 0;
        while (n2 < 10) {
            colorShifter.shift("c1", Color.green, 1.0f, 1.0f, 1.0f);
            colorShifter.shift("c2", Color.blue, 1.0f, 1.0f, 0.5f);
            colorShifter.advance(0.1f);
            ++n2;
        }
        System.out.println(colorShifter.getCurr());
    }

    public static class ShiftData
    implements DoNotObfuscate {
        public Color to;
        public Fader fader;
        public float shift;
    }
}

