/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.graphics.util.Fader;
import com.fs.starfarer.D;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignProgressIndicatorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.campaign.BaseCampaignEntity;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.ui.N;
import com.fs.starfarer.combat.CombatViewport;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.starfarer.ui.dosuper;
import java.awt.Color;
import java.util.EnumSet;

public class CampaignProgressIndicator
extends BaseCampaignEntity
implements CampaignProgressIndicatorAPI {
    private SectorEntityToken target;
    private final float durationDays;
    private float elapsedDays;
    private final String text;
    private transient N bar;
    private transient dosuper label;
    private Fader fader = new Fader(0.0f, 0.25f, 0.25f);
    private boolean interrupted = false;
    private boolean finished = false;
    private EnumSet<CampaignEngineLayers> layers = EnumSet.of(CampaignEngineLayers.ABOVE);

    public CampaignProgressIndicator(String string, SectorEntityToken sectorEntityToken, float f2) {
        super(null);
        this.text = string;
        this.target = sectorEntityToken;
        this.durationDays = f2;
        this.readResolve();
        this.fader.fadeIn();
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        if (this.fader == null) {
            this.fader = new Fader(0.0f, 0.25f, 0.25f);
            this.fader.fadeIn();
        }
        if (this.layers == null) {
            this.layers = EnumSet.of(CampaignEngineLayers.ABOVE);
        }
        this.bar = new N("", 0.0f, 1.0f);
        this.bar.setSize(100.0f, 12.0f);
        this.bar.setShowLabelOnly(true);
        this.setBarColor(D.\u00f4\u00d40000);
        this.label = new dosuper(this.text, "graphics/fonts/orbitron12condensed.fnt", D.void.super, true, Alignment.MID);
        this.label.autoSize();
        this.label.getRenderer().int(true);
        return this;
    }

    public void interrupt() {
        this.bar.setBarColor(D.\u00f4o0000);
        this.interrupted = true;
        this.fader.fadeOut();
    }

    public void finish() {
        this.finished = true;
        this.fader.fadeOut();
    }

    @Override
    public void advance(float f2) {
        super.advance(f2);
        this.fader.advance(f2);
        if (this.interrupted && this.fader.isFadedOut()) {
            this.setExpired(true);
        }
        if (this.finished && this.fader.isFadedOut()) {
            this.setExpired(true);
        }
        if (!CampaignEngine.getInstance().isPaused() && !this.interrupted) {
            float f3 = CampaignEngine.getInstance().getClock().convertToDays(f2);
            this.elapsedDays += f3;
            this.bar.setProgress(Math.min(1.0f, this.elapsedDays / this.durationDays));
        }
        this.bar.advance(f2);
        this.label.advance(f2);
    }

    @Override
    public boolean isExpired() {
        return super.isExpired();
    }

    public void setProgress(float f2) {
        this.bar.setProgress(f2);
    }

    public float getProgress() {
        return this.bar.getProgress();
    }

    public void setBarColor(Color color) {
        this.bar.setBarColor(color);
    }

    @Override
    public void render(CampaignEngineLayers campaignEngineLayers, CombatViewport combatViewport) {
        super.render(campaignEngineLayers, combatViewport);
    }

    public void renderOverlay(float f2) {
        if (f2 <= 0.0f) {
            return;
        }
        f2 *= this.fader.getBrightness();
        CombatViewport combatViewport = CampaignEngine.getInstance().getViewport();
        float f3 = Math.round(combatViewport.convertWorldXtoScreenX(this.target.getLocation().x));
        float f4 = Math.round(combatViewport.convertWorldYtoScreenY(this.target.getLocation().y));
        float f5 = 100.0f;
        float f6 = 10.0f;
        float f7 = StarfarerSettings.\u00d2\u00d30000();
        float f8 = StarfarerSettings.if.new();
        f3 -= f5 / 2.0f;
        f4 -= f6 / 2.0f;
        if (f3 < -f5) {
            return;
        }
        if (f4 < -f6) {
            return;
        }
        if (f3 > f5 + f7) {
            return;
        }
        if (f4 > f6 + f8) {
            return;
        }
        this.bar.getPosition().setRoundCoordinates(true);
        this.bar.getPosition().setLocation(f3, f4 - f6 / 2.0f - 2.0f);
        this.bar.render(f2);
        this.label.getPosition().setRoundCoordinates(true);
        this.label.getPosition().setLocation(Math.round(f3 + f5 / 2.0f - this.label.getWidth() / 2.0f), Math.round(f4 + f6 / 2.0f + 2.0f));
        this.label.render(f2);
    }

    @Override
    public EnumSet<CampaignEngineLayers> getActiveLayers() {
        return this.layers;
    }

    public float getDurationDays() {
        return this.durationDays;
    }

    @Override
    public float getRadius() {
        return this.target.getRadius();
    }

    public SectorEntityToken getTarget() {
        return this.target;
    }

    public void setTarget(SectorEntityToken sectorEntityToken) {
        this.target = sectorEntityToken;
    }

    public boolean isStar() {
        return false;
    }
}

