/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.ai;

import com.fs.profiler.Profiler;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetActionTextProvider;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.FleetEncounterContextPlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.AbilityAIPlugin;
import com.fs.starfarer.api.campaign.ai.AssignmentModulePlugin;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.campaign.ai.NavigationModulePlugin;
import com.fs.starfarer.api.campaign.ai.StrategicModulePlugin;
import com.fs.starfarer.api.campaign.ai.TacticalModulePlugin;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.fleet.CrewCompositionAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.util.TimeoutTracker;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.ai.AssignmentModule;
import com.fs.starfarer.campaign.ai.NavigationModule;
import com.fs.starfarer.campaign.ai.StrategicModule;
import com.fs.starfarer.campaign.ai.TacticalModule;
import com.fs.starfarer.campaign.fleet.CampaignFleet;
import com.fs.starfarer.combat.ai.AI;
import com.fs.starfarer.loading.FleetCreationSpec;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModularFleetAI
implements AI,
DoNotObfuscate,
ModularFleetAIAPI,
CampaignFleetAIAPI {
    private NavigationModulePlugin navModule;
    private AssignmentModulePlugin assignmentModule;
    private StrategicModulePlugin strategicModule;
    private TacticalModulePlugin tacticalModule;
    private final CampaignFleet fleet;
    private Map<String, AbilityAIPlugin> abilityAI = new LinkedHashMap<String, AbilityAIPlugin>();
    private transient Set<String> noAIAbilities = new HashSet<String>();
    private FleetActionTextProvider actionTextProvider = null;
    private String actionTextOverride = null;

    public ModularFleetAI(CampaignFleet campaignFleet) {
        this.fleet = campaignFleet;
        this.navModule = CampaignEngine.getInstance().getModAndPluginData().pickNavigationAIModule(campaignFleet, this);
        if (this.navModule == null) {
            this.navModule = new NavigationModule(campaignFleet, this);
        }
        this.assignmentModule = CampaignEngine.getInstance().getModAndPluginData().pickAssignmentAIModule(campaignFleet, this);
        if (this.assignmentModule == null) {
            this.assignmentModule = new AssignmentModule(campaignFleet, this);
        }
        this.strategicModule = CampaignEngine.getInstance().getModAndPluginData().pickStrategicAIModule(campaignFleet, this);
        if (this.strategicModule == null) {
            this.strategicModule = new StrategicModule(campaignFleet, this);
        }
        this.tacticalModule = CampaignEngine.getInstance().getModAndPluginData().pickTacticalAIModule(campaignFleet, this);
        if (this.tacticalModule == null) {
            this.tacticalModule = new TacticalModule(campaignFleet, this);
        }
    }

    Object readResolve() {
        this.noAIAbilities = new HashSet<String>();
        return this;
    }

    @Override
    public void advance(float f2) {
        if (this.fleet.getBattle() != null) {
            return;
        }
        float f3 = Global.getSector().getClock().convertToDays(f2);
        Profiler.new((String)"Modular fleet AI");
        Profiler.new((String)"Assignment module");
        this.assignmentModule.advance(f3);
        Profiler.o00000();
        Profiler.new((String)"Strategic module");
        this.strategicModule.advance(f3);
        Profiler.o00000();
        Profiler.new((String)"Tactical module");
        this.tacticalModule.advance(f3);
        Profiler.o00000();
        Profiler.new((String)"Navigation module");
        this.navModule.advance(f3);
        Profiler.o00000();
        Profiler.new((String)"Abilities");
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        ArrayList<AbilityPlugin> arrayList = new ArrayList<AbilityPlugin>(this.fleet.getAbilities().values());
        for (AbilityPlugin abilityPlugin : arrayList) {
            if (this.noAIAbilities.contains(abilityPlugin.getId())) continue;
            linkedHashSet.add(abilityPlugin.getId());
            AbilityAIPlugin abilityAIPlugin = this.abilityAI.get(abilityPlugin.getId());
            if (abilityAIPlugin == null) {
                abilityAIPlugin = CampaignEngine.getInstance().getModAndPluginData().pickAbilityAI(abilityPlugin, this);
                if (abilityAIPlugin != null) {
                    this.abilityAI.put(abilityPlugin.getId(), abilityAIPlugin);
                } else {
                    this.noAIAbilities.add(abilityPlugin.getId());
                }
            }
            if (abilityAIPlugin == null || !this.fleet.hasAbility(abilityPlugin.getId())) continue;
            Profiler.new((String)("Ability [" + abilityPlugin.getId() + "]"));
            abilityAIPlugin.advance(f3);
            Profiler.o00000();
        }
        for (AbilityPlugin abilityPlugin : arrayList) {
            if (linkedHashSet.contains(abilityPlugin.getId())) continue;
            this.abilityAI.remove(abilityPlugin.getId());
        }
        Profiler.o00000();
        Profiler.o00000();
    }

    @Override
    public void render() {
    }

    public NavigationModulePlugin getNavModule() {
        return this.navModule;
    }

    public void setNavModule(NavigationModulePlugin navigationModulePlugin) {
        this.navModule = navigationModulePlugin;
    }

    public AssignmentModulePlugin getAssignmentModule() {
        return this.assignmentModule;
    }

    public void setAssignmentModule(AssignmentModulePlugin assignmentModulePlugin) {
        this.assignmentModule = assignmentModulePlugin;
    }

    public StrategicModulePlugin getStrategicModule() {
        return this.strategicModule;
    }

    public void setStrategicModule(StrategicModulePlugin strategicModulePlugin) {
        this.strategicModule = strategicModulePlugin;
    }

    public TacticalModulePlugin getTacticalModule() {
        return this.tacticalModule;
    }

    public void setTacticalModule(TacticalModulePlugin tacticalModulePlugin) {
        this.tacticalModule = tacticalModulePlugin;
    }

    public CampaignFleet getFleet() {
        return this.fleet;
    }

    public FleetActionTextProvider getActionTextProvider() {
        return this.actionTextProvider;
    }

    public void setActionTextProvider(FleetActionTextProvider fleetActionTextProvider) {
        this.actionTextProvider = fleetActionTextProvider;
    }

    public String getActionTextOverride() {
        if (this.actionTextOverride != null) {
            return this.actionTextOverride;
        }
        return null;
    }

    public void setActionTextOverride(String string) {
        this.actionTextOverride = string;
    }

    public void addAssignment(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2, Script script) {
        this.assignmentModule.addAssignment(fleetAssignment, sectorEntityToken, f2, script);
    }

    public void addAssignment(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2, String string, Script script) {
        this.assignmentModule.addAssignment(fleetAssignment, sectorEntityToken, f2, string, script);
    }

    public void addAssignment(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2, String string, boolean bl, Script script, Script script2) {
        this.assignmentModule.addAssignment(fleetAssignment, sectorEntityToken, f2, string, bl, script, script2);
    }

    public void addAssignmentAtStart(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2, Script script) {
        this.assignmentModule.addAssignmentAtStart(fleetAssignment, sectorEntityToken, f2, script);
    }

    public void addAssignmentAtStart(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2, String string, Script script) {
        this.assignmentModule.addAssignmentAtStart(fleetAssignment, sectorEntityToken, f2, string, script);
    }

    public FleetAssignmentDataAPI getCurrentAssignment() {
        return this.assignmentModule.getCurrentAssignment();
    }

    public List<FleetAssignmentDataAPI> getAssignmentsCopy() {
        return this.assignmentModule.getAssignmentsCopy();
    }

    public void removeAssignment(FleetAssignmentDataAPI fleetAssignmentDataAPI) {
        this.assignmentModule.removeAssignment(fleetAssignmentDataAPI);
    }

    public FleetAssignment getCurrentAssignmentType() {
        FleetAssignmentDataAPI fleetAssignmentDataAPI = this.assignmentModule.getCurrentAssignment();
        if (fleetAssignmentDataAPI == null) {
            return null;
        }
        return fleetAssignmentDataAPI.getAssignment();
    }

    public boolean isCurrentAssignment(FleetAssignment fleetAssignment) {
        return this.assignmentModule.isCurrentAssignment(fleetAssignment);
    }

    public boolean isFleeing() {
        return this.tacticalModule.isFleeing();
    }

    public boolean isMaintainingContact() {
        return this.tacticalModule.isMaintainingContact();
    }

    public boolean isHostileTo(CampaignFleetAPI campaignFleetAPI) {
        return this.tacticalModule.isHostileTo(campaignFleetAPI);
    }

    public CampaignFleetAIAPI.BoardingActionDecision makeBoardingDecision(FleetEncounterContextPlugin fleetEncounterContextPlugin, FleetMemberAPI fleetMemberAPI, CrewCompositionAPI crewCompositionAPI) {
        return this.tacticalModule.makeBoardingDecision(fleetEncounterContextPlugin, fleetMemberAPI, crewCompositionAPI);
    }

    public void performCrashMothballingPriorToEscape(FleetEncounterContextPlugin fleetEncounterContextPlugin, CampaignFleetAPI campaignFleetAPI) {
        this.tacticalModule.performCrashMothballingPriorToEscape(fleetEncounterContextPlugin, campaignFleetAPI);
    }

    public CampaignFleetAIAPI.InitialBoardingResponse pickBoardingResponse(FleetEncounterContextPlugin fleetEncounterContextPlugin, FleetMemberAPI fleetMemberAPI, CampaignFleetAPI campaignFleetAPI) {
        return this.tacticalModule.pickBoardingResponse(fleetEncounterContextPlugin, fleetMemberAPI, campaignFleetAPI);
    }

    public List<FleetMemberAPI> pickBoardingTaskForce(FleetEncounterContextPlugin fleetEncounterContextPlugin, FleetMemberAPI fleetMemberAPI, CampaignFleetAPI campaignFleetAPI) {
        return this.tacticalModule.pickBoardingTaskForce(fleetEncounterContextPlugin, fleetMemberAPI, campaignFleetAPI);
    }

    public CampaignFleetAIAPI.EncounterOption pickEncounterOption(FleetEncounterContextPlugin fleetEncounterContextPlugin, CampaignFleetAPI campaignFleetAPI) {
        return this.tacticalModule.pickEncounterOption(fleetEncounterContextPlugin, campaignFleetAPI);
    }

    public CampaignFleetAIAPI.EncounterOption pickEncounterOption(FleetEncounterContextPlugin fleetEncounterContextPlugin, CampaignFleetAPI campaignFleetAPI, boolean bl) {
        return this.tacticalModule.pickEncounterOption(fleetEncounterContextPlugin, campaignFleetAPI, bl);
    }

    public CampaignFleetAIAPI.PursuitOption pickPursuitOption(FleetEncounterContextPlugin fleetEncounterContextPlugin, CampaignFleetAPI campaignFleetAPI) {
        return this.tacticalModule.pickPursuitOption(fleetEncounterContextPlugin, campaignFleetAPI);
    }

    public void removeFirstAssignment() {
        this.assignmentModule.removeFirstAssignment();
    }

    public void removeFirstAssignmentIfItIs(FleetAssignment fleetAssignment) {
        this.assignmentModule.removeFirstAssignmentIfItIs(fleetAssignment);
    }

    public void reportNearbyAction(CampaignFleetAIAPI.ActionType actionType, SectorEntityToken sectorEntityToken, SectorEntityToken sectorEntityToken2, String string) {
        this.tacticalModule.reportNearbyAction(actionType, sectorEntityToken, sectorEntityToken2, string);
    }

    public void clearAssignments() {
        this.assignmentModule.clearAssignments();
    }

    public void dumpResourcesIfNeeded() {
        this.strategicModule.dumpExcessCargoIfNeeded();
    }

    public void notifyInteractedWith(CampaignFleetAPI campaignFleetAPI) {
        this.tacticalModule.notifyInteractedWith(campaignFleetAPI);
    }

    public void setCreationSpec(FleetCreationSpec fleetCreationSpec) {
    }

    public boolean wantsToJoin(BattleAPI battleAPI, boolean bl) {
        return this.tacticalModule.wantsToJoin(battleAPI, bl);
    }

    public void doNotAttack(SectorEntityToken sectorEntityToken, float f2) {
        TimeoutTracker timeoutTracker = this.strategicModule.getDoNotAttack();
        float f3 = timeoutTracker.getRemaining((Object)sectorEntityToken);
        timeoutTracker.set((Object)sectorEntityToken, Math.max(f3, f2));
    }
}

