/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.ai;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.campaign.ai.NavigationModulePlugin;
import com.fs.starfarer.api.campaign.ai.StrategicModulePlugin;
import com.fs.starfarer.api.campaign.ai.TacticalModulePlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.impl.campaign.shared.WormholeManager;
import com.fs.starfarer.api.impl.campaign.terrain.StarCoronaTerrainPlugin;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.TimeoutTracker;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.CircularFleetOrbit;
import com.fs.starfarer.campaign.Hyperspace;
import com.fs.starfarer.campaign.JumpPoint;
import com.fs.starfarer.campaign.ai.CampaignFleetAI;
import com.fs.starfarer.campaign.ai.TacticalModule;
import com.fs.starfarer.campaign.fleet.CampaignFleet;
import com.fs.starfarer.campaign.fleet.CargoData;
import com.fs.starfarer.campaign.ui.trade.CargoItemStack;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class StrategicModule
implements DoNotObfuscate,
StrategicModulePlugin {
    public static final float HOSTILE_MARKET_AVOID_RANGE = 4000.0f;
    private CampaignFleet fleet;
    private final ModularFleetAIAPI ai;
    private CampaignFleetAI.JumpPlan currJumpPlan;
    private IntervalUtil avoidTracker = new IntervalUtil(0.5f, 1.5f);
    private TimeoutTracker<SectorEntityToken> doNotAttack = new TimeoutTracker();
    private TimeoutTracker<SectorEntityToken> recentlyStoppedPursuing = new TimeoutTracker();

    public StrategicModule(CampaignFleet campaignFleet, ModularFleetAIAPI modularFleetAIAPI) {
        this.fleet = campaignFleet;
        this.ai = modularFleetAIAPI;
    }

    public TimeoutTracker<SectorEntityToken> getDoNotAttack() {
        return this.doNotAttack;
    }

    protected Object readResolve() {
        if (this.doNotAttack == null) {
            this.doNotAttack = new TimeoutTracker();
        }
        if (this.recentlyStoppedPursuing == null) {
            this.recentlyStoppedPursuing = new TimeoutTracker();
        }
        return this;
    }

    public void advance(float f2) {
        float f3;
        this.doNotAttack.advance(f2);
        this.recentlyStoppedPursuing.advance(f2);
        CampaignFleetAI.FleetAssignmentData fleetAssignmentData = (CampaignFleetAI.FleetAssignmentData)this.ai.getAssignmentModule().getCurrentAssignment();
        if (fleetAssignmentData == null) {
            fleetAssignmentData = new CampaignFleetAI.FleetAssignmentData(FleetAssignment.PATROL_SYSTEM, null, 1.0f, null, null);
        }
        this.avoidTracker.advance(f2);
        if (this.avoidTracker.intervalElapsed()) {
            this.updateAvoidLocations();
            this.dumpExcessCargoIfNeeded();
        }
        TacticalModulePlugin tacticalModulePlugin = this.ai.getTacticalModule();
        Vector2f vector2f = new Vector2f((ReadableVector2f)this.fleet.getLocation());
        float f4 = 0.0f;
        if (!(fleetAssignmentData.target == null || tacticalModulePlugin.isBusy() && !tacticalModulePlugin.isFleeing() || !TacticalModule.knowsIfTargetJumped(this.fleet, fleetAssignmentData.target) && this.fleet.getContainingLocation() != fleetAssignmentData.target.getContainingLocation())) {
            vector2f = fleetAssignmentData.target.getLocation();
            boolean bl = this.currJumpPlan != null || this.fleet.getInteractionTarget() instanceof JumpPointAPI;
            this.updateJumpPlanTo(fleetAssignmentData.target.getContainingLocation(), f2);
            f3 = fleetAssignmentData.target.getRadius();
            if (this.currJumpPlan != null) {
                this.fleet.setInteractionTarget(this.currJumpPlan.point);
                vector2f = this.currJumpPlan.point.getLocation();
                f3 = this.currJumpPlan.point.getRadius();
            } else if (bl) {
                this.fleet.setInteractionTarget(null);
            }
            f4 = Utils.void(vector2f, this.fleet.getLocation());
            f4 -= f3;
            f4 += 45.0f;
            if (this.currJumpPlan != null && (f4 < 100.0f || f4 < 500.0f && !this.fleet.isInCurrentLocation() || f4 < 1000.0f && CampaignEngine.getInstance().isInFastAdvance())) {
                CampaignEngine.getInstance().doHyperspaceTransition(this.fleet, this.currJumpPlan.point, this.currJumpPlan.dest);
                this.currJumpPlan = null;
            } else if (this.currJumpPlan != null) {
                this.ai.getTacticalModule().setTravelDestination(vector2f, 0.5f);
                return;
            }
        }
        if (fleetAssignmentData.target == null || fleetAssignmentData.target != null && this.fleet.getContainingLocation() != fleetAssignmentData.target.getContainingLocation()) {
            tacticalModulePlugin.setPriorityTarget(null, 0.0f, false);
            if (fleetAssignmentData.assignment == FleetAssignment.HOLD) {
                tacticalModulePlugin.setTravelDestination(this.fleet.getLocation(), 0.1f);
            } else {
                tacticalModulePlugin.setTravelDestination(null, 0.0f);
            }
            return;
        }
        float f5 = 50.0f;
        if (Global.getSector().isInFastAdvance()) {
            f5 = 500.0f;
        }
        switch (fleetAssignmentData.assignment) {
            case DELIVER_RESOURCES: 
            case DELIVER_SUPPLIES: 
            case DELIVER_FUEL: 
            case DELIVER_PERSONNEL: 
            case DELIVER_CREW: 
            case DELIVER_MARINES: 
            case RESUPPLY: 
            case GO_TO_LOCATION: 
            case GO_TO_LOCATION_AND_DESPAWN: 
            case HOLD: 
            case STANDING_DOWN: {
                tacticalModulePlugin.setPriorityTarget(null, 0.0f, false);
                tacticalModulePlugin.setTravelDestination(vector2f, 0.5f);
                break;
            }
            case INTERCEPT: {
                tacticalModulePlugin.setPriorityTarget(fleetAssignmentData.target, 0.5f, false);
                tacticalModulePlugin.setTravelDestination(null, 0.0f);
                break;
            }
            case FOLLOW: {
                tacticalModulePlugin.setPriorityTarget(fleetAssignmentData.target, 0.5f, true);
                tacticalModulePlugin.setTravelDestination(null, 0.0f);
                break;
            }
            case ORBIT_PASSIVE: 
            case ORBIT_AGGRESSIVE: {
                if (this.fleet.getOrbit() != null && this.fleet.getOrbitFocus() == fleetAssignmentData.target) break;
                f3 = this.fleet.getRadius() + 100.0f + (float)Math.random() * 100.0f + fleetAssignmentData.target.getRadius();
                if (f4 <= f3 + f5) {
                    float f6 = f3 / 50.0f * (1.0f + (float)Math.random());
                    float f7 = Utils.\u00d300000(fleetAssignmentData.target.getLocation(), this.fleet.getLocation()) + (float)Math.random() * 120.0f - 60.0f;
                    if (f4 < 100.0f) {
                        f7 = (float)Math.random() * 360.0f;
                    }
                    this.fleet.setOrbit(new CircularFleetOrbit(this.fleet, fleetAssignmentData.target, f3, f7).setPeriod(f6));
                    tacticalModulePlugin.setTravelDestination(null, 0.0f);
                    tacticalModulePlugin.setPriorityTarget(null, 0.0f, false);
                    break;
                }
                tacticalModulePlugin.setPriorityTarget(null, 0.0f, false);
                tacticalModulePlugin.setTravelDestination(vector2f, 0.5f);
                break;
            }
            case ATTACK_LOCATION: {
                tacticalModulePlugin.setPriorityTarget(null, 0.0f, false);
                this.attackLocation(fleetAssignmentData.target);
                break;
            }
            case DEFEND_LOCATION: {
                tacticalModulePlugin.setPriorityTarget(null, 0.0f, false);
                this.defendLocation(fleetAssignmentData.target);
                break;
            }
            case PATROL_SYSTEM: {
                tacticalModulePlugin.setPriorityTarget(null, 0.0f, false);
                this.patrolSystem(fleetAssignmentData.target);
                break;
            }
            case RAID_SYSTEM: {
                tacticalModulePlugin.setPriorityTarget(null, 0.0f, false);
                this.raidSystem(fleetAssignmentData.target);
            }
        }
    }

    private void raidSystem(SectorEntityToken sectorEntityToken) {
        Object object;
        Object object22;
        Object object3;
        String string = "raid_entity";
        String string2 = "raid_route";
        String string3 = "$ai_raidType";
        String string4 = "$ai_raidFrom";
        String string5 = "$ai_raidTo";
        MemoryAPI memoryAPI = this.fleet.getMemoryWithoutUpdate();
        if (!memoryAPI.contains(string3)) {
            object3 = new WeightedRandomPicker();
            if (sectorEntityToken.isInHyperspace()) {
                for (Object object22 : sectorEntityToken.getContainingLocation().getEntitiesWithTag("jump_point")) {
                    float f2 = Misc.getDistance((Vector2f)sectorEntityToken.getLocation(), (Vector2f)object22.getLocation());
                    if (!(f2 < 1500.0f)) continue;
                    object3.add((Object)new oo((SectorEntityToken)object22), 1.0f);
                }
            } else {
                object22 = sectorEntityToken.getContainingLocation().getEntitiesWithTag("jump_point");
                MarketAPI marketAPI = object22.iterator();
                while (marketAPI.hasNext()) {
                    object = (SectorEntityToken)marketAPI.next();
                    int n2 = Misc.getNumHostileMarkets((FactionAPI)this.fleet.getFaction(), (SectorEntityToken)object, (float)4000.0f);
                    if (n2 > 0) continue;
                    object3.add((Object)new oo((SectorEntityToken)object), 5.0f);
                }
                object = Misc.getMarketsInLocation((LocationAPI)sectorEntityToken.getContainingLocation());
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    MarketAPI marketAPI2;
                    marketAPI = (MarketAPI)iterator.next();
                    if (marketAPI.getFaction() == this.fleet.getFaction() && marketAPI.getPrimaryEntity() != null) {
                        object3.add((Object)new oo(marketAPI.getPrimaryEntity()), (float)marketAPI.getSize() * 2.0f);
                    }
                    Iterator iterator2 = object.iterator();
                    while (iterator2.hasNext()) {
                        float f3;
                        marketAPI2 = (MarketAPI)iterator2.next();
                        if (marketAPI2 == marketAPI || (f3 = Utils.void(marketAPI.getPrimaryEntity().getLocation(), marketAPI2.getPrimaryEntity().getLocation())) < 5000.0f || (marketAPI2.getFaction() == null || !marketAPI2.getFaction().isHostileTo((FactionAPI)this.fleet.getFaction())) && (marketAPI.getFaction() == null || !marketAPI.getFaction().isHostileTo((FactionAPI)this.fleet.getFaction())) || marketAPI.getFaction().isHostileTo(marketAPI2.getFaction())) continue;
                        object3.add((Object)new oo(marketAPI.getPrimaryEntity(), marketAPI2.getPrimaryEntity()), (float)(marketAPI.getSize() + marketAPI2.getSize()) / 2.0f * 1.0f);
                    }
                    if (marketAPI.getFaction() == null || !marketAPI.getFaction().isHostileTo((FactionAPI)this.fleet.getFaction())) continue;
                    iterator2 = object22.iterator();
                    while (iterator2.hasNext()) {
                        marketAPI2 = (SectorEntityToken)iterator2.next();
                        object3.add((Object)new oo(marketAPI.getPrimaryEntity(), (SectorEntityToken)marketAPI2), (float)marketAPI.getSize() * 0.25f);
                    }
                }
            }
            object22 = (oo)object3.pick();
            if (object22 != null) {
                if (((oo)object22).super == null) {
                    memoryAPI.set(string3, (Object)string, 30.0f);
                    memoryAPI.set(string4, (Object)((oo)object22).\u00d200000, 30.0f);
                } else {
                    memoryAPI.set(string3, (Object)string2, 30.0f);
                    memoryAPI.set(string4, (Object)((oo)object22).\u00d200000, 30.0f);
                    memoryAPI.set(string5, (Object)((oo)object22).super, 30.0f);
                }
            }
        }
        if (memoryAPI.contains(string3)) {
            object3 = memoryAPI.getString(string3);
            if (((String)object3).equals(string) && memoryAPI.contains(string4)) {
                this.doCircularPatrol((SectorEntityToken)memoryAPI.get(string4), "$ai_raidEntityCircleDir", "$ai_raidEntityDist", 3.0f, 3.0f, 200.0f, 500.0f);
            } else if (((String)object3).equals(string2) && memoryAPI.contains(string4) && memoryAPI.contains(string5)) {
                object22 = (SectorEntityToken)memoryAPI.get(string4);
                object = (SectorEntityToken)memoryAPI.get(string5);
                Vector2f vector2f = Vector2f.add((Vector2f)object22.getLocation(), (Vector2f)object.getLocation(), (Vector2f)new Vector2f());
                vector2f.scale(0.5f);
                StrategicModule.doCircularPatrol(this.fleet, this.ai, vector2f, "$ai_raidEntityCircleDir", "$ai_raidEntityDist", 3.0f, 3.0f, 200.0f, 500.0f);
            }
        }
    }

    private void patrolSystem(SectorEntityToken sectorEntityToken) {
        boolean bl = sectorEntityToken instanceof PlanetAPI && ((PlanetAPI)sectorEntityToken).isStar();
        bl |= sectorEntityToken != null && sectorEntityToken.isSystemCenter();
        if (sectorEntityToken.isInHyperspace()) {
            String string = "$ai_hyperPatrolCircleDir";
            String string2 = "$ai_hyperPatrolDist";
            this.doCircularPatrol(sectorEntityToken, string, string2, 3.0f, 3.0f, 500.0f, 750.0f);
        } else if (!bl) {
            String string = "$ai_hyperPatrolCircleDir";
            String string3 = "$ai_hyperPatrolDist";
            this.doCircularPatrol(sectorEntityToken, string, string3, 3.0f, 3.0f, 200.0f, 500.0f);
        } else {
            Object object3;
            List list;
            Object object2;
            String string = "patrol_entity";
            String string4 = "patrol_route";
            String string5 = "$ai_patrolType";
            String string6 = "$ai_patrolFrom";
            String string7 = "$ai_patrolTo";
            MemoryAPI memoryAPI = this.fleet.getMemoryWithoutUpdate();
            if (!memoryAPI.contains(string5)) {
                object2 = new WeightedRandomPicker();
                list = Misc.getMarketsInLocation((LocationAPI)sectorEntityToken.getContainingLocation());
                for (Object object3 : list) {
                    if (object3.getFaction() != this.fleet.getFaction()) continue;
                    object2.add((Object)new o(object3.getPrimaryEntity()), (float)object3.getSize());
                    for (JumpPointAPI jumpPointAPI : list) {
                        if (jumpPointAPI == object3 || jumpPointAPI.getFaction() == null || jumpPointAPI.getFaction().isHostileTo(object3.getFaction())) continue;
                        object2.add((Object)new o(object3.getPrimaryEntity(), jumpPointAPI.getPrimaryEntity()), (float)(object3.getSize() + jumpPointAPI.getSize()) / 2.0f * 1.0f);
                    }
                }
                for (Object object3 : sectorEntityToken.getContainingLocation().getEntitiesWithTag("jump_point")) {
                    JumpPointAPI jumpPointAPI;
                    if (!(object3 instanceof JumpPointAPI)) continue;
                    jumpPointAPI = (JumpPointAPI)object3;
                    object2.add((Object)new o((SectorEntityToken)jumpPointAPI), 2.0f);
                }
                for (Object object3 : sectorEntityToken.getContainingLocation().getEntitiesWithTag("comm_relay")) {
                    float f2 = Math.max(1.0f, this.fleet.getFleetData().getBurnLevel() - 8.0f);
                    if (!((f2 *= 2.0f) > 0.0f)) continue;
                    object2.add((Object)new o((SectorEntityToken)object3), f2);
                }
                for (Object object3 : sectorEntityToken.getContainingLocation().getEntitiesWithTag("planet")) {
                    if (object3.getFaction() == null || object3.getFaction().isHostileTo((FactionAPI)this.fleet.getFaction())) continue;
                    object2.add((Object)new o((SectorEntityToken)object3), 0.25f);
                }
                object3 = (o)object2.pick();
                if (object3 != null) {
                    if (object3.super == null) {
                        memoryAPI.set(string5, (Object)string, 30.0f);
                        memoryAPI.set(string6, (Object)object3.\u00d200000, 30.0f);
                    } else {
                        memoryAPI.set(string5, (Object)string4, 30.0f);
                        memoryAPI.set(string6, (Object)object3.\u00d200000, 30.0f);
                        memoryAPI.set(string7, (Object)object3.super, 30.0f);
                    }
                }
            }
            if (memoryAPI.contains(string5)) {
                object2 = memoryAPI.getString(string5);
                if (((String)object2).equals(string) && memoryAPI.contains(string6)) {
                    this.doCircularPatrol((SectorEntityToken)memoryAPI.get(string6), "$ai_patrolEntityCircleDir", "$ai_patrolEntityDist", 3.0f, 3.0f, 200.0f, 500.0f);
                } else if (((String)object2).equals(string4) && memoryAPI.contains(string6) && memoryAPI.contains(string7)) {
                    list = (SectorEntityToken)memoryAPI.get(string6);
                    object3 = (SectorEntityToken)memoryAPI.get(string7);
                    this.doPatrolRoute((SectorEntityToken)list, (SectorEntityToken)object3, "$ai_patrolRouteStage", "$ai_patrolCustom1", "$ai_patrolCustom2", string5);
                }
            }
        }
    }

    private void defendLocation(SectorEntityToken sectorEntityToken) {
        this.doCircularPatrol(sectorEntityToken, "$ai_defLocCircleDir", "$ai_defLocDist", 3.0f, 3.0f, 200.0f, 500.0f);
    }

    private void attackLocation(SectorEntityToken sectorEntityToken) {
        this.doCircularPatrol(sectorEntityToken, "$ai_attackLocCircleDir", "$ai_attackLocDist", 3.0f, 3.0f, 200.0f, 500.0f);
    }

    private void doPatrolRoute(SectorEntityToken sectorEntityToken, SectorEntityToken sectorEntityToken2, String string, String string2, String string3, String string4) {
        MemoryAPI memoryAPI = this.fleet.getMemoryWithoutUpdate();
        String string5 = memoryAPI.getString(string);
        if (string5 == null) {
            string5 = "approach";
        }
        memoryAPI.set(string, (Object)string5, 5.0f);
        TacticalModulePlugin tacticalModulePlugin = this.ai.getTacticalModule();
        if (string5.equals("approach")) {
            float f2 = Utils.void(this.fleet.getLocation(), sectorEntityToken.getLocation()) - this.fleet.getRadius() - sectorEntityToken.getRadius();
            if (f2 > 300.0f) {
                tacticalModulePlugin.setTravelDestination(sectorEntityToken.getLocation(), 0.5f);
            } else {
                float f3 = (float)Math.random();
                string5 = f3 > 0.25f ? "weave" : "straight";
                memoryAPI.set(string, (Object)string5, 5.0f);
                memoryAPI.unset(string2);
                memoryAPI.unset(string3);
            }
        } else {
            memoryAPI.set(string, (Object)string5, 5.0f);
            float f4 = Utils.void(this.fleet.getLocation(), sectorEntityToken2.getLocation()) - this.fleet.getRadius() - sectorEntityToken2.getRadius();
            if (f4 < 300.0f) {
                memoryAPI.unset(string4);
                memoryAPI.unset(string);
                memoryAPI.unset(string2);
                memoryAPI.unset(string3);
            } else if (string5.equals("straight")) {
                tacticalModulePlugin.setTravelDestination(sectorEntityToken2.getLocation(), 0.5f);
            } else if (string5.equals("weave")) {
                float f5;
                float f6;
                float f7 = 0.0f;
                if (memoryAPI.contains(string2)) {
                    f7 = memoryAPI.getFloat(string2);
                }
                long l2 = CampaignEngine.getInstance().getClock().getTimestamp();
                if (memoryAPI.contains(string3)) {
                    l2 = memoryAPI.getLong(string3);
                }
                float f8 = CampaignEngine.getInstance().getClock().getElapsedDaysSince(l2);
                f7 += f8;
                l2 = CampaignEngine.getInstance().getClock().getTimestamp();
                if (!this.ai.getTacticalModule().isBusy()) {
                    memoryAPI.set(string2, (Object)Float.valueOf(f7), 5.0f);
                } else {
                    memoryAPI.set(string2, (Object)Float.valueOf(f7 - f8), 5.0f);
                }
                memoryAPI.set(string3, (Object)l2, 5.0f);
                float f9 = this.fleet.getTravelSpeed() * CampaignEngine.getInstance().getClock().getSecondsPerDay();
                float f10 = this.fleet.getRadius() + sectorEntityToken.getRadius() + f9 * 0.5f * f7;
                float f11 = Utils.void(sectorEntityToken.getLocation(), sectorEntityToken2.getLocation()) - this.fleet.getRadius();
                if (f10 > f11) {
                    f10 = f11;
                }
                if (f10 < 0.0f) {
                    f10 = 0.0f;
                }
                if ((f6 = (float)Math.sin((f5 = f10) * 6.28f / 1000.0f) * 3000.0f) > f4 * 0.5f) {
                    f6 = f4 * 0.5f;
                }
                Vector2f vector2f = Utils.\u00d300000(Utils.\u00d300000(sectorEntityToken.getLocation(), sectorEntityToken2.getLocation()));
                Vector2f vector2f2 = Utils.String(vector2f);
                Vector2f vector2f3 = new Vector2f();
                vector2f.scale(f5);
                vector2f2.scale(f6);
                Vector2f.add((Vector2f)vector2f3, (Vector2f)vector2f, (Vector2f)vector2f3);
                Vector2f.add((Vector2f)vector2f3, (Vector2f)vector2f2, (Vector2f)vector2f3);
                Vector2f.add((Vector2f)vector2f3, (Vector2f)sectorEntityToken.getLocation(), (Vector2f)vector2f3);
                tacticalModulePlugin.setTravelDestination(vector2f3, 0.5f);
            }
        }
    }

    private void doCircularPatrol(SectorEntityToken sectorEntityToken, String string, String string2, float f2, float f3, float f4, float f5) {
        StrategicModule.doCircularPatrol(this.fleet, this.ai, sectorEntityToken.getLocation(), string, string2, f2, f3, f4 + sectorEntityToken.getRadius(), f5);
    }

    public static void doCircularPatrol(CampaignFleetAPI campaignFleetAPI, ModularFleetAIAPI modularFleetAIAPI, Vector2f vector2f, String string, String string2, float f2, float f3, float f4, float f5) {
        float f6;
        float f7;
        MemoryAPI memoryAPI;
        if (campaignFleetAPI.getMemoryWithoutUpdate().contains("$cfai_patrolDist")) {
            f4 = campaignFleetAPI.getMemoryWithoutUpdate().getFloat("$cfai_patrolDist");
            f5 = Math.min(f4 * 0.5f, 200.0f);
        }
        if (!(memoryAPI = campaignFleetAPI.getMemoryWithoutUpdate()).contains(string) || !memoryAPI.contains(string2)) {
            float f8 = Math.signum((float)Math.random() - 0.5f);
            if (f8 == 0.0f) {
                f8 = 1.0f;
            }
            f7 = campaignFleetAPI.getRadius() + f4 + (float)Math.random() * f5;
            f6 = f2 + (float)Math.random() * f3;
            memoryAPI.set(string, (Object)Float.valueOf(f8), f6);
            memoryAPI.set(string2, (Object)Float.valueOf(f7), f6);
        }
        TacticalModulePlugin tacticalModulePlugin = modularFleetAIAPI.getTacticalModule();
        f7 = memoryAPI.getFloat(string);
        f6 = memoryAPI.getFloat(string2);
        float f9 = Utils.void(campaignFleetAPI.getLocation(), vector2f);
        if (f9 > f6 + 50.0f) {
            tacticalModulePlugin.setTravelDestination(vector2f, 0.5f);
        } else {
            float f10 = Utils.\u00d300000(vector2f, campaignFleetAPI.getLocation());
            Vector2f vector2f2 = Utils.\u00d300000(f10 += 5.0f * f7);
            vector2f2.scale(f6);
            Vector2f.add((Vector2f)vector2f2, (Vector2f)vector2f, (Vector2f)vector2f2);
            tacticalModulePlugin.setTravelDestination(vector2f2, 0.5f);
        }
    }

    private void updateAvoidLocations() {
    }

    public boolean isAllowedToEngage(SectorEntityToken sectorEntityToken) {
        boolean bl;
        boolean bl2;
        SectorEntityToken sectorEntityToken2;
        if (this.doNotAttack.contains((Object)sectorEntityToken)) {
            return false;
        }
        CampaignFleetAI.FleetAssignmentData fleetAssignmentData = (CampaignFleetAI.FleetAssignmentData)this.ai.getAssignmentModule().getCurrentAssignment();
        boolean bl3 = !this.fleet.getMemoryWithoutUpdate().getBoolean("$cfai_doNotIgnorePlayer");
        boolean bl4 = sectorEntityToken.getMemoryWithoutUpdate() != null && sectorEntityToken.getMemoryWithoutUpdate().getBoolean("$cfai_ignoredByOtherFleets");
        bl4 |= this.fleet.getMemoryWithoutUpdate() != null && this.fleet.getMemoryWithoutUpdate().getBoolean("$cfai_ignoreOtherFleets") && (!sectorEntityToken.isPlayerFleet() || bl3);
        if (sectorEntityToken.getMemoryWithoutUpdate() != null && sectorEntityToken.getMemoryWithoutUpdate().getString("$cfai_ignoredByFaction") != null && sectorEntityToken.getMemoryWithoutUpdate().getString("$cfai_ignoredByFaction").equals(this.fleet.getFaction().getId())) {
            bl4 = true;
        }
        if (fleetAssignmentData != null && fleetAssignmentData.getTarget() == sectorEntityToken) {
            bl4 = false;
        }
        if (bl4) {
            return false;
        }
        if (fleetAssignmentData == null) {
            return true;
        }
        FleetAssignment fleetAssignment = fleetAssignmentData.assignment;
        float f2 = Float.MAX_VALUE;
        float f3 = sectorEntityToken.getRadius() + this.fleet.getRadius();
        if (sectorEntityToken.getContainingLocation() == this.fleet.getContainingLocation()) {
            f2 = Misc.getDistance((Vector2f)this.fleet.getLocation(), (Vector2f)sectorEntityToken.getLocation());
        }
        float f4 = this.fleet.getTravelSpeed();
        float f5 = 0.0f;
        boolean bl5 = false;
        if (sectorEntityToken instanceof CampaignFleet) {
            f5 = ((CampaignFleet)sectorEntityToken).getTravelSpeed();
            bl5 = ((CampaignFleet)sectorEntityToken).getBattle() != null;
        }
        boolean bl6 = false;
        AbilityPlugin abilityPlugin = this.fleet.getAbility("emergency_burn");
        if (abilityPlugin != null && abilityPlugin.isActiveOrInProgress()) {
            bl6 = true;
        }
        boolean bl7 = f2 <= f3;
        bl7 |= bl6;
        if ((fleetAssignment == FleetAssignment.DEFEND_LOCATION || fleetAssignment == FleetAssignment.PATROL_SYSTEM) && (sectorEntityToken2 = fleetAssignmentData.getTarget()) != null) {
            boolean bl8 = bl2 = sectorEntityToken2.getContainingLocation() instanceof StarSystemAPI && ((StarSystemAPI)sectorEntityToken2.getContainingLocation()).getCenter() == sectorEntityToken2;
            if (!bl2 && Misc.getDistance((Vector2f)sectorEntityToken2.getLocation(), (Vector2f)sectorEntityToken.getLocation()) < 600.0f + f4 * 5.0f + sectorEntityToken2.getRadius()) {
                bl7 = true;
            }
        }
        if (this.fleet.getMemoryWithoutUpdate().getBoolean("$cfai_longPursuit")) {
            bl7 = true;
        }
        if (bl5) {
            bl7 = true;
        }
        if (fleetAssignment == FleetAssignment.INTERCEPT && fleetAssignmentData != null && sectorEntityToken == fleetAssignmentData.target) {
            bl7 = true;
        }
        if (!bl7) {
            SectorEntityToken sectorEntityToken3;
            Vector2f vector2f;
            float f6;
            sectorEntityToken2 = sectorEntityToken.getVisibilityLevelTo((SectorEntityToken)this.fleet);
            if (sectorEntityToken2 != SectorEntityToken.VisibilityLevel.NONE && (f6 = Vector2f.dot((Vector2f)(vector2f = Utils.\u00d300000(Utils.\u00d300000(sectorEntityToken.getLocation(), this.fleet.getLocation()))), (Vector2f)sectorEntityToken.getVelocity())) >= 100.0f) {
                this.recentlyStoppedPursuing.remove((Object)sectorEntityToken);
            }
            float f7 = f6 = (sectorEntityToken3 = this.ai.getTacticalModule().getTarget()) == sectorEntityToken ? this.ai.getTacticalModule().getPursuitDays() : 0.0f;
            if (this.recentlyStoppedPursuing.contains((Object)sectorEntityToken) || this.recentlyStoppedPursuing.getItems().size() > 1) {
                f6 = 1000.0f;
            }
            bl = this.fleet.getMemoryWithoutUpdate().getBoolean("$isPatrol");
            float f8 = 1.5f;
            if (bl) {
                f8 = 3.0f;
            }
            float f9 = f8 + this.fleet.getFleetData().getBurnLevel() * 0.1f;
            f9 -= 1.5f * (float)this.recentlyStoppedPursuing.getItems().size();
            float f10 = 1000.0f;
            float f11 = f4 - f5;
            if (f11 > 0.0f) {
                f10 = (f2 - f3) / f11;
            }
            if (this.fleet.getContainingLocation() != sectorEntityToken.getContainingLocation() && TacticalModule.knowsIfTargetJumped(this.fleet, sectorEntityToken)) {
                f10 = 0.0f;
            }
            f5 += (float)this.recentlyStoppedPursuing.getItems().size() * StarfarerSettings.\u00d2\u00d20000();
            if (f10 > 3.0f && f5 >= f4 && f2 > f3 + 50.0f && f6 > f9) {
                if (!this.recentlyStoppedPursuing.contains((Object)sectorEntityToken)) {
                    this.recentlyStoppedPursuing.add((Object)sectorEntityToken, 2.0f + (float)Math.random() * 2.0f);
                }
                return false;
            }
        }
        sectorEntityToken2 = this.fleet.getMemoryWithoutUpdate();
        switch (fleetAssignment) {
            case DELIVER_RESOURCES: 
            case DELIVER_SUPPLIES: 
            case DELIVER_FUEL: 
            case DELIVER_PERSONNEL: 
            case DELIVER_CREW: 
            case DELIVER_MARINES: {
                return f2 < f3;
            }
            case RESUPPLY: 
            case GO_TO_LOCATION: 
            case GO_TO_LOCATION_AND_DESPAWN: {
                String string;
                bl2 = sectorEntityToken2.getBoolean("$isTradeFleet");
                if (bl2) {
                    return false;
                }
                boolean bl9 = sectorEntityToken2.getBoolean("$doNotGetSidetracked");
                if (bl9) {
                    return false;
                }
                bl = sectorEntityToken2.getBoolean("$isScavenger");
                if (bl && this.fleet.isInHyperspace() && !"pirates".equals(this.fleet.getFaction().getId())) {
                    return false;
                }
                return !this.fleet.isInHyperspace() || "pirates".equals(this.fleet.getFaction().getId()) || !"scavengerSmall".equals(string = sectorEntityToken2.getString("$fleetType")) && !"scavengerMedium".equals(string) && !"scavengerLarge".equals(string);
            }
            case ORBIT_PASSIVE: 
            case FOLLOW: {
                boolean bl10 = sectorEntityToken2.getBoolean("$doNotGetSidetracked");
                if (bl10) {
                    return false;
                }
                boolean bl11 = sectorEntityToken2.getBoolean("$isPatrol");
                return sectorEntityToken.isPlayerFleet() && (!sectorEntityToken.isTransponderOn() || sectorEntityToken2.contains("$sawPlayerTransponderOff") || sectorEntityToken2.contains("$pursuePlayer")) && bl11;
            }
            case HOLD: 
            case STANDING_DOWN: {
                return false;
            }
            case PATROL_SYSTEM: 
            case DEFEND_LOCATION: 
            case ORBIT_AGGRESSIVE: 
            case ATTACK_LOCATION: 
            case RAID_SYSTEM: {
                boolean bl12 = sectorEntityToken2.getBoolean("$doNotGetSidetracked");
                return !bl12 || !(sectorEntityToken instanceof CampaignFleetAPI) || ((CampaignFleetAPI)sectorEntityToken).getAI() == null || !((CampaignFleetAPI)sectorEntityToken).getAI().isFleeing();
            }
            case INTERCEPT: {
                return sectorEntityToken == fleetAssignmentData.target;
            }
        }
        return true;
    }

    public boolean isAllowedToEvade(SectorEntityToken sectorEntityToken) {
        CampaignFleetAI.FleetAssignmentData fleetAssignmentData = (CampaignFleetAI.FleetAssignmentData)this.ai.getAssignmentModule().getCurrentAssignment();
        if (fleetAssignmentData == null) {
            return true;
        }
        FleetAssignment fleetAssignment = fleetAssignmentData.assignment;
        return fleetAssignmentData.target != sectorEntityToken;
    }

    public void updateJumpPlanTo(LocationAPI locationAPI, float f2) {
        if (locationAPI == this.fleet.getContainingLocation()) {
            this.currJumpPlan = null;
            return;
        }
        if (this.fleet.getCargo().getFuel() <= 0.0f && !this.fleet.isAIMode()) {
            this.currJumpPlan = null;
            return;
        }
        if (this.fleet.getMemoryWithoutUpdate().getBoolean("$cfai_noJump")) {
            this.currJumpPlan = null;
            return;
        }
        if (this.fleet.isInHyperspaceTransition()) {
            this.currJumpPlan = null;
            return;
        }
        if (this.currJumpPlan != null) {
            this.currJumpPlan.timeLeft -= f2;
            if (this.currJumpPlan.timeLeft <= 0.0f) {
                this.currJumpPlan = null;
            }
        }
        if (this.currJumpPlan != null) {
            return;
        }
        Oo oo2 = StrategicModule.findNearestSafeJumpPoint(this.fleet, locationAPI);
        if (oo2 != null) {
            float f3;
            this.currJumpPlan = new CampaignFleetAI.JumpPlan(oo2.o00000, oo2.new);
            ArrayList<StarCoronaTerrainPlugin> arrayList = new ArrayList<StarCoronaTerrainPlugin>();
            if (this.fleet.getContainingLocation() instanceof StarSystemAPI) {
                StarSystemAPI starSystemAPI = (StarSystemAPI)this.fleet.getContainingLocation();
                for (CampaignTerrainAPI campaignTerrainAPI : starSystemAPI.getTerrainCopy()) {
                    if (!(campaignTerrainAPI.getPlugin() instanceof StarCoronaTerrainPlugin)) continue;
                    StarCoronaTerrainPlugin starCoronaTerrainPlugin = (StarCoronaTerrainPlugin)campaignTerrainAPI.getPlugin();
                    arrayList.add(starCoronaTerrainPlugin);
                }
            }
            if ((f3 = Misc.getDistance((SectorEntityToken)this.fleet, (SectorEntityToken)oo2.o00000)) < 2000.0f && f3 > 500.0f) {
                float f4 = this.currJumpPlan.timeLeft;
                for (StarCoronaTerrainPlugin starCoronaTerrainPlugin : arrayList) {
                    if (!starCoronaTerrainPlugin.containsPoint(oo2.o00000.getLocation(), 100.0f)) continue;
                    this.fleet.getMemoryWithoutUpdate().set("$ai_useEBForTravel", (Object)true, f4);
                    NavigationModulePlugin navigationModulePlugin = this.ai.getNavModule();
                    navigationModulePlugin.doNotAvoid(starCoronaTerrainPlugin.getEntity(), f4);
                    break;
                }
            }
        }
    }

    public static Oo findNearestSafeJumpPoint(CampaignFleetAPI campaignFleetAPI, LocationAPI locationAPI) {
        boolean bl;
        List list = campaignFleetAPI.getContainingLocation().getEntities(JumpPoint.class);
        Hyperspace hyperspace = CampaignEngine.getInstance().getHyperspace();
        boolean bl2 = bl = locationAPI == null;
        if (hyperspace != locationAPI && hyperspace != campaignFleetAPI.getContainingLocation()) {
            bl = true;
        }
        ArrayList<Oo> arrayList = new ArrayList<Oo>();
        for (JumpPoint jumpPoint : list) {
            if (jumpPoint.isStarAnchor() || jumpPoint.getMemoryWithoutUpdate().getBoolean("$unstable") || jumpPoint.getMemoryWithoutUpdate().getBoolean(WormholeManager.WORMHOLE)) continue;
            int n2 = Misc.getNumHostileMarkets((FactionAPI)campaignFleetAPI.getFaction(), (SectorEntityToken)jumpPoint, (float)4000.0f);
            n2 *= 2;
            for (JumpPointAPI.JumpDestination jumpDestination : jumpPoint.getDestinations()) {
                if (jumpDestination.getDestination() == null || jumpDestination.getDestination().getContainingLocation() != locationAPI && (!bl || hyperspace != jumpDestination.getDestination().getContainingLocation())) continue;
                float f2 = Utils.void(jumpPoint.getLocation(), campaignFleetAPI.getLocation());
                Oo oo2 = new Oo();
                oo2.o00000 = jumpPoint;
                oo2.new = jumpDestination;
                oo2.\u00d400000 = f2;
                oo2.\u00d300000 = StrategicModule.getNumUnsafeFleetsAround(campaignFleetAPI, jumpPoint, 750.0f) + n2;
                arrayList.add(oo2);
                if (!(f2 < 2000.0f) || campaignFleetAPI.isInHyperspace()) continue;
                return oo2;
            }
        }
        Collections.sort(arrayList, new Comparator<Oo>(){

            public int super(Oo oo2, Oo oo3) {
                if (oo2.\u00d300000 == oo3.\u00d300000) {
                    return (int)oo2.\u00d400000 - (int)oo3.\u00d400000;
                }
                return oo2.\u00d300000 - oo3.\u00d300000;
            }
        });
        if (arrayList.isEmpty()) {
            return null;
        }
        return (Oo)arrayList.get(0);
    }

    public static int getNumUnsafeFleetsAround(final CampaignFleetAPI campaignFleetAPI, SectorEntityToken sectorEntityToken, float f2) {
        List list = Misc.findNearbyFleets((SectorEntityToken)sectorEntityToken, (float)f2, (Misc.FleetFilter)new Misc.FleetFilter(){

            public boolean accept(CampaignFleetAPI campaignFleetAPI2) {
                if (campaignFleetAPI2.isPlayerFleet()) {
                    return false;
                }
                if (!campaignFleetAPI2.isHostileTo((SectorEntityToken)campaignFleetAPI)) {
                    return false;
                }
                float f2 = campaignFleetAPI.getFleetPoints();
                float f3 = campaignFleetAPI2.getFleetPoints();
                return f3 * 1.5f >= f2;
            }
        });
        return list.size();
    }

    public void dumpExcessCargoIfNeeded() {
        CargoData cargoData = this.fleet.getCargo();
        if (cargoData.getFuel() > cargoData.getMaxFuel()) {
            cargoData.removeFuel(cargoData.getFuel() - cargoData.getMaxFuel());
        }
        float f2 = cargoData.getTotalCrew() + cargoData.getMarines();
        float f3 = cargoData.getMaxPersonnel();
        float f4 = f2 - f3;
        boolean bl = false;
        for (CargoItemStack cargoItemStack : cargoData.getStacks()) {
            if (f4 <= 0.0f) break;
            if (!cargoItemStack.isPersonnelStack()) continue;
            float f5 = Math.min(f4, cargoItemStack.getSize());
            cargoItemStack.add(-f5);
            f4 -= f5;
            bl = true;
        }
        float f6 = cargoData.getSpaceUsed();
        float f7 = cargoData.getMaxCapacity();
        f4 = f6 - f7;
        for (CargoItemStack cargoItemStack : cargoData.getStacks()) {
            if (f4 <= 0.0f) break;
            if (cargoItemStack.isPersonnelStack() || cargoItemStack.isFuelStack()) continue;
            float f8 = Math.min(f4, cargoItemStack.getSize());
            cargoItemStack.add(-f8);
            f4 -= f8;
            bl = true;
        }
        if (bl) {
            cargoData.sort();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Oo {
        public JumpPoint o00000;
        public JumpPointAPI.JumpDestination new;
        public int \u00d300000;
        public float \u00d400000;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class o {
        public SectorEntityToken \u00d200000 = null;
        public SectorEntityToken super = null;

        public o(SectorEntityToken sectorEntityToken, SectorEntityToken sectorEntityToken2) {
            this.\u00d200000 = sectorEntityToken;
            this.super = sectorEntityToken2;
        }

        public o(SectorEntityToken sectorEntityToken) {
            this.\u00d200000 = sectorEntityToken;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class oo {
        public SectorEntityToken \u00d200000 = null;
        public SectorEntityToken super = null;

        public oo(SectorEntityToken sectorEntityToken, SectorEntityToken sectorEntityToken2) {
            this.\u00d200000 = sectorEntityToken;
            this.super = sectorEntityToken2;
        }

        public oo(SectorEntityToken sectorEntityToken) {
            this.\u00d200000 = sectorEntityToken;
        }
    }
}

