/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.econ.contract;

import com.fs.profiler.Profiler;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.campaign.econ.CommodityOnMarket;
import com.fs.starfarer.campaign.econ.Economy;
import com.fs.starfarer.campaign.econ.Market;
import com.fs.starfarer.campaign.econ.MarketConnection;
import com.fs.starfarer.campaign.econ.contract.Bid;
import com.fs.starfarer.campaign.econ.contract.Contract;
import com.fs.starfarer.campaign.econ.contract.ExistingMarketContracts;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ContractEconomy
implements DoNotObfuscate {
    public static final float INITIAL_CONTRACT_SIZE_MULT = 0.5f;
    public static final float PROGRESSIVE_CONTRACT_SIZE_MULT = 0.5f;
    public static final float SELF_SALE_PROFIT_MULT = 1.0f;
    public static final float MIN_UNIT_SIZE_MULT = 0.25f;
    public static final float MIN_BID_DUR = 5.0f;
    public static final float MAX_BID_DUR = 15.0f;
    public static boolean DEBUG = true;
    private List<Contract> contracts = new ArrayList<Contract>();
    private Map<String, TempCommodityData> tempData = new HashMap<String, TempCommodityData>();
    private Economy economy;
    private Map<String, ExistingMarketContracts> existingContracts = new HashMap<String, ExistingMarketContracts>();
    private static final String GREED_MOD_KEY = "econ_greed_factor";

    public ExistingMarketContracts getExistingContracts(Market market) {
        ExistingMarketContracts existingMarketContracts = this.existingContracts.get(market.getId());
        if (existingMarketContracts == null) {
            existingMarketContracts = new ExistingMarketContracts();
            existingMarketContracts.market = market;
            this.existingContracts.put(market.getId(), existingMarketContracts);
        }
        return existingMarketContracts;
    }

    public Map<String, ExistingMarketContracts> getAcceptedContracts() {
        return this.existingContracts;
    }

    public ContractEconomy(Economy economy) {
        this.economy = economy;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public void nextStep() {
        this.redistributeSupply("ore");
    }

    public void redistributeSupply(String string) {
        this.tempData.clear();
        DEBUG = false;
        if (DEBUG) {
            System.out.println("");
            System.out.println("-----------------------------------------------------");
            System.out.println("--COMMODITY: " + string + "----------------------");
            System.out.println("-----------------------------------------------------");
        }
        Profiler.new((String)"Pre-iteration setup");
        boolean bl = true;
        for (MarketAPI marketAPI : this.economy.getMarkets()) {
            Profiler.new((String)"Reapplying market conditions");
            marketAPI.reapplyConditions();
            Profiler.o00000();
        }
        Profiler.o00000();
        Profiler.new((String)"Main iteration");
        this.prepStockpiles(string);
        this.updateGreed(string);
        Profiler.new((String)"Updating all prices");
        this.economy.updateAllPrices();
        Profiler.o00000();
        this.processExistingContracts(string, 1.0f);
        int n2 = 200;
        int n3 = 0;
        while (n3 < n2) {
            if (DEBUG) {
                System.out.println("");
                System.out.println("-----------------------------------");
                System.out.println("---NEW ROUND OF BIDS & CONTRACTS---");
                System.out.println("-----------------------------------");
            }
            this.generateContracts(string);
            this.doRoundOfBids(string);
            bl = this.processBidResults(this.contracts, false);
            if (!bl) {
                boolean bl2 = true;
                float f2 = this.getMinContractSize(string);
                for (Contract contract : this.contracts) {
                    if (!((float)contract.quantity > f2)) continue;
                    bl2 = false;
                    break;
                }
                if (bl2) {
                    if (!DEBUG) break;
                    System.out.println("ENDING ON ITERATION " + (n3 + 1) + " OUT OF " + n2);
                    break;
                }
            }
            ++n3;
        }
        this.moveComputedIncomingToCOM(string);
        Profiler.new((String)"Adding to stockpiles");
        n3 = 0;
        while (n3 < 1) {
            this.addToStockpilesFromProjectedIncoming(string, 0.2f);
            ++n3;
        }
        Profiler.o00000();
        for (MarketAPI marketAPI : this.economy.getMarkets()) {
        }
        Profiler.o00000();
        for (MarketAPI marketAPI : this.economy.getMarkets()) {
            Profiler.new((String)"Reapplying conditions and updating met demand");
            marketAPI.reapplyConditions();
            Profiler.o00000();
        }
    }

    public float getMinContractSize(String string) {
        return this.economy.getCommoditySpec(string).getEconUnit() * 0.25f;
    }

    public Map<String, TempCommodityData> getTempData() {
        return this.tempData;
    }

    public void processExistingContracts(String string, float f2) {
        Profiler.new((String)"Processing accepted contracts");
        List<MarketAPI> list = this.economy.getMarkets();
        ArrayList<Contract> arrayList = new ArrayList<Contract>();
        HashSet hashSet = new HashSet();
        for (MarketAPI object : list) {
        }
        this.processBidResults(arrayList, true);
        for (String string2 : new ArrayList<String>(this.existingContracts.keySet())) {
            if (hashSet.contains(string2)) continue;
            this.existingContracts.remove(string2);
        }
        Profiler.o00000();
    }

    public TempCommodityData getData(Market market, String string) {
        String string2 = String.valueOf(market.getId()) + "_" + string;
        TempCommodityData tempCommodityData = this.tempData.get(string2);
        if (tempCommodityData == null) {
            tempCommodityData = new TempCommodityData();
            this.tempData.put(string2, tempCommodityData);
        }
        return tempCommodityData;
    }

    public void moveComputedIncomingToCOM(String string) {
    }

    public void addToStockpilesFromProjectedIncoming(String string, float f2) {
    }

    public void prepStockpiles(String string) {
    }

    public void updateGreed(String string) {
    }

    public float getSupplyMult(CommodityOnMarket commodityOnMarket) {
        return 1.0f;
    }

    public void generateContracts(String string) {
        int n2 = this.economy.getMarkets().size();
        int n3 = 0;
        while (n3 < n2) {
            this.generateContracts(string, n3);
            ++n3;
        }
    }

    public void generateContracts(String string, int n2) {
    }

    public List<Contract> getContracts() {
        return this.contracts;
    }

    public void addOutpostRelatedDemand(Market market) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (CommodityOnMarketAPI object : market.getAllCommodities()) {
            if (object.isNonEcon()) continue;
            linkedHashSet.add(object.getDemandClass());
        }
        for (String string : linkedHashSet) {
            this.addOutpostRelatedDemand(market, string);
        }
    }

    public void addOutpostRelatedDemand(Market market, String string) {
    }

    public void doRoundOfBids(String string) {
    }

    public void doRoundOfBids(String string, Market market) {
        Profiler.new((String)"Making bids");
        Contract object = null;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        String string2 = null;
        boolean bl = false;
        ArrayList<CommodityOnMarket> arrayList = new ArrayList<CommodityOnMarket>();
        for (CommodityOnMarket commodityOnMarket : market.getCommoditiesWithClass(string)) {
            Iterator<Contract> iterator = this.getData(market, commodityOnMarket.getId());
            if (((TempCommodityData)((Object)iterator)).availableForSale <= 0.0f) continue;
            arrayList.add(commodityOnMarket);
        }
        if (arrayList.isEmpty()) {
            Profiler.o00000();
            return;
        }
        float f5 = 0.0f;
        for (CommodityOnMarket commodityOnMarket : arrayList) {
            TempCommodityData tempCommodityData = this.getData(market, commodityOnMarket.getId());
            f5 += (tempCommodityData.availableForSale + tempCommodityData.projectedIncoming) * commodityOnMarket.getUtilityOnMarket();
        }
        block2: for (Contract contract : this.contracts) {
            float f6 = -1.0f;
            for (CommodityOnMarket commodityOnMarket : arrayList) {
                float f7;
                float f8;
                boolean bl2;
                MarketConnection marketConnection;
                CommodityOnMarket commodityOnMarket2 = contract.market.getCommodityData(commodityOnMarket.getId());
                float f9 = (float)contract.quantity / commodityOnMarket2.getUtilityOnMarket();
                TempCommodityData tempCommodityData = this.getData(market, commodityOnMarket.getId());
                if (tempCommodityData.availableForSale < f9 || tempCommodityData.boughtFrom.contains(contract.market.getId()) || !(marketConnection = null).isEnabled()) continue;
                boolean bl3 = bl2 = marketConnection.isAllTradeIsSmuggling() || market.isIllegal(commodityOnMarket) || contract.market.isIllegal(commodityOnMarket2);
                if (bl2 && (float)contract.quantity > commodityOnMarket.getCommodity().getEconUnit()) continue;
                if (f6 < 0.0f) {
                    f6 = 0.0f;
                    for (CommodityOnMarket commodityOnMarket3 : contract.market.getCommoditiesWithClass(string)) {
                        TempCommodityData tempCommodityData2 = this.getData(contract.market, commodityOnMarket3.getId());
                        f6 += (tempCommodityData2.availableForSale + tempCommodityData2.projectedIncoming) * commodityOnMarket3.getUtilityOnMarket();
                    }
                }
                if ((f8 = marketConnection.getModifiedPrice(market.getSupplyPriceMod().computeEffective((float)commodityOnMarket.getSupplyPrice().getD() / Math.max(1.0f, f5) * commodityOnMarket.getCommodity().getBasePrice() * commodityOnMarket.getUtilityOnMarket()))) * 1.1f >= (f7 = contract.market.getDemandPriceMod().computeEffective((float)commodityOnMarket2.getDemandPrice().getD() / Math.max(1.0f, f6) * commodityOnMarket2.getCommodity().getBasePrice() * commodityOnMarket2.getUtilityOnMarket()))) continue block2;
                float f10 = market.getSupplyPriceAssumingStockpileUtility(commodityOnMarket, f5, f9, false);
                if (contract.bestBid != null && (float)contract.bestBid.totalPrice < f10) continue;
                float f11 = contract.market.getDemandPriceAssumingStockpileUtility(commodityOnMarket2, f6, f9, false);
                if (market != contract.market) {
                    f10 = bl2 ? marketConnection.getSmugglePrice(f10) : marketConnection.getModifiedPrice(f10);
                }
                if (f11 < f10 || contract.bestBid != null && (float)contract.bestBid.totalPrice < f10) continue;
                float f12 = (f11 - f10) / f9;
                if (market == contract.market) {
                    f12 *= 1.0f;
                }
                if (!(f12 > f2)) continue;
                f2 = f12;
                object = contract;
                f3 = f10;
                string2 = commodityOnMarket.getId();
                f4 = f9;
                bl = bl2;
            }
        }
        if (object != null) {
            Bid bid = new Bid();
            bid.contract = object;
            bid.market = market;
            bid.commodityId = string2;
            bid.totalPrice = (int)f3;
            bid.quantity = (int)f4;
            bid.smuggling = bl;
            object.bestBid = bid;
        }
        Profiler.o00000();
    }

    public boolean processBidResults(List<Contract> list, boolean bl) {
        Profiler.new((String)"Processing bid results");
        boolean bl2 = false;
        for (Contract contract : list) {
            TempCommodityData tempCommodityData = this.getData(contract.market, contract.demandClass);
            boolean bl3 = tempCommodityData.lastContractFulfilled;
            tempCommodityData.lastContractFulfilled = false;
            if (contract.bestBid == null) continue;
            Bid bid = contract.bestBid;
            if (!bl) {
                bid.remainingDuration = (int)(5.0f + (float)Math.round(10.0f * (float)Math.random()));
            }
            TempCommodityData tempCommodityData2 = this.getData(bid.market, bid.commodityId);
            if (tempCommodityData2.availableForSale < (float)contract.bestBid.quantity) {
                if (!bl) continue;
                this.getExistingContracts(bid.market).removeBid(contract.demandClass, bid);
                this.getExistingContracts(contract.market).removeContract(contract.demandClass, contract);
                continue;
            }
            tempCommodityData2.availableForSale -= (float)bid.quantity;
            if (tempCommodityData2.availableForSale < 0.0f) {
                tempCommodityData2.availableForSale = 0.0f;
            }
            TempCommodityData tempCommodityData3 = this.getData(contract.market, bid.commodityId);
            tempCommodityData3.availableForSale += (float)bid.quantity;
            tempCommodityData3.boughtFrom.add(bid.market.getId());
            boolean bl4 = false;
            if (contract.market != bid.market) {
                bl2 = true;
            } else {
                bl4 = true;
            }
            if (!bl) {
                this.getExistingContracts(bid.market).addBid(contract.demandClass, bid);
                this.getExistingContracts(contract.market).addContract(contract.demandClass, contract);
            }
            if (bl3) {
                tempCommodityData.lastContractSize /= 0.5f;
                if (tempCommodityData.lastContractSize > tempCommodityData.maxContractSize) {
                    tempCommodityData.lastContractSize = tempCommodityData.maxContractSize;
                }
            }
            tempCommodityData.lastContractFulfilled = true;
            if (!DEBUG) continue;
            System.out.println(String.format("Bid accepted: %s -> %s, %s units of %s for %s credits", bid.market.getId(), contract.market.getId(), "" + bid.quantity, bid.market.getCommodityData(bid.commodityId).getCommodity().getName(), "" + bid.totalPrice));
        }
        Profiler.o00000();
        return bl2;
    }

    public static class TempCommodityData
    implements DoNotObfuscate {
        public float maxContractSize;
        public float lastContractSize;
        public float availableForSale;
        public float extraForSaleFromStockpile;
        public float projectedIncoming;
        public boolean lastContractFulfilled = true;
        public Set<String> boughtFrom = new HashSet<String>();
    }
}

