/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.econ.reach;

import com.fs.profiler.Profiler;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.econ.CommodityMarketDataAPI;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySourceType;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketShareDataAPI;
import com.fs.starfarer.api.combat.MutableStatWithTempMods;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.ids.Stats;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.campaign.econ.CommodityOnMarket;
import com.fs.starfarer.campaign.econ.Market;
import com.fs.starfarer.campaign.econ.reach.MarketShareData;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.vector.Vector2f;

public class CommodityMarketData
implements CommodityMarketDataAPI,
DoNotObfuscate {
    public static float COM_FACTOR = Global.getSettings().getFloat("accessibilityDistFromCOM");
    public static float BASE_ACCESSIBILITY = Global.getSettings().getFloat("accessibilityBaseValue");
    public static float SAME_FACTION_BONUS = Global.getSettings().getFloat("accessibilitySameFactionBonus");
    public static float PER_UNIT_SHIPPING = Global.getSettings().getFloat("accessibilityPerUnitShipping");
    public static String KEY_LOCAL = "core_local";
    public static String KEY_IMPORTS = "core_base";
    public static String KEY_SHORTAGE = "core_shortage";
    public static String KEY_LOWACCESS = "core_lowaccess";
    private String commodityId;
    private String econGroup;
    private int maxExportGlobal = 0;
    private LinkedHashMap<String, Integer> maxExportPerFaction = new LinkedHashMap();
    private LinkedHashMap<String, Float> marketValuePerFaction = new LinkedHashMap();
    private LinkedHashMap<MarketAPI, MarketShareData> marketShareData = new LinkedHashMap();
    private List<MarketShareDataAPI> sortedProducers = new ArrayList<MarketShareDataAPI>();
    private List<MarketShareDataAPI> sortedConsumers = new ArrayList<MarketShareDataAPI>();
    private float marketValue = 0.0f;

    public static Vector2f computeCenterOfMass(MarketAPI marketAPI, String string) {
        Vector2f vector2f = new Vector2f();
        float f2 = 0.0f;
        List list = Global.getSector().getEconomy().getMarketsInGroup(string);
        if (marketAPI != null && !list.contains(marketAPI)) {
            list.add(marketAPI);
        }
        for (MarketAPI marketAPI2 : list) {
            float f3 = Math.max(1.0f, (float)marketAPI2.getSize() - 1.0f);
            vector2f.x += marketAPI2.getLocationInHyperspace().x * f3;
            vector2f.y += marketAPI2.getLocationInHyperspace().y * f3;
            f2 += f3;
        }
        if (f2 > 0.0f) {
            vector2f.scale(1.0f / f2);
        }
        return vector2f;
    }

    public static float computeBaseAccessibility(MarketAPI marketAPI) {
        Vector2f vector2f = CommodityMarketData.computeCenterOfMass(marketAPI, marketAPI.getEconGroup());
        return CommodityMarketData.computeBaseAccessibility(marketAPI, vector2f);
    }

    public static float computeBaseAccessibility(MarketAPI marketAPI, Vector2f vector2f) {
        float f2 = Misc.getDistanceLY((Vector2f)vector2f, (Vector2f)marketAPI.getLocationInHyperspace());
        return (float)Math.round((BASE_ACCESSIBILITY - f2 / COM_FACTOR) * 100.0f) / 100.0f;
    }

    public static int getShippingCapacity(MarketAPI marketAPI, boolean bl) {
        float f2 = (float)Math.round(marketAPI.getAccessibilityMod().computeEffective(0.0f) * 100.0f) / 100.0f;
        if (bl) {
            f2 += SAME_FACTION_BONUS;
        }
        return (int)Math.max(0.0f, f2 / PER_UNIT_SHIPPING);
    }

    public int getMaxShipping(MarketAPI marketAPI, boolean bl) {
        return CommodityMarketData.getShippingCapacity(marketAPI, bl);
    }

    public static String getDescForAccessibility(float f2) {
        String string = "Proximity to other colonies";
        if (f2 < 0.0f) {
            string = "Isolation from other colonies";
        }
        return string;
    }

    public static String getFactionHostilityDesc() {
        return "Hostilities with other factions";
    }

    public static float getHostilityPenalty(MarketAPI marketAPI) {
        float f2 = Global.getSettings().getFloat("accessibilityLossWhenAllHostile");
        List list = Global.getSector().getEconomy().getMarketsInGroup(marketAPI.getEconGroup());
        if (!list.contains(marketAPI)) {
            list.add(marketAPI);
        }
        o o2 = new o(list);
        float f3 = o2.\u00d200000;
        Map<FactionAPI, Integer> map = o2.\u00d300000;
        Integer n2 = map.get(marketAPI.getFaction());
        if (n2 == null) {
            n2 = 0;
        }
        float f4 = (float)Math.round(f2 * (float)n2.intValue() / f3 * 100.0f) / 100.0f;
        return f4;
    }

    public CommodityMarketData(String string, String string2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Object object;
        CommodityOnMarketAPI commodityOnMarketAPI;
        String string3;
        this.commodityId = string;
        this.econGroup = string2;
        Vector2f vector2f = CommodityMarketData.computeCenterOfMass(null, string2);
        HashMap<String, Float> hashMap = new HashMap<String, Float>();
        HashMap<String, Float> hashMap2 = new HashMap<String, Float>();
        float f2 = 0.0f;
        List list = Global.getSector().getEconomy().getMarketsInGroup(string2);
        o o2 = new o(list);
        float f3 = o2.\u00d200000;
        Map<FactionAPI, Integer> map = o2.\u00d300000;
        float f4 = Global.getSettings().getFloat("accessibilityLossWhenAllHostile");
        for (MarketAPI marketAPI : list) {
            float f5;
            string3 = marketAPI.getFactionId();
            commodityOnMarketAPI = marketAPI.getCommodityData(string);
            object = ((Market)marketAPI).getCommoditiesWithClass(commodityOnMarketAPI.getDemandClass());
            commodityOnMarketAPI.updateMaxSupplyAndDemand();
            if (commodityOnMarketAPI.getCommodity().isPrimary()) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    CommodityOnMarketAPI commodityOnMarketAPI2 = (CommodityOnMarketAPI)iterator.next();
                    if (commodityOnMarketAPI2 == commodityOnMarketAPI) continue;
                    commodityOnMarketAPI2.setMaxDemand(commodityOnMarketAPI.getMaxDemand());
                    commodityOnMarketAPI2.setDemandLegal(commodityOnMarketAPI.isDemandLegal());
                }
            }
            ((CommodityOnMarket)commodityOnMarketAPI).setCommodityMarketData(this);
            n7 = commodityOnMarketAPI.getMaxSupply();
            n7 = Math.min(n7, commodityOnMarketAPI.getAvailable());
            n6 = CommodityMarketData.getShippingCapacity(marketAPI, false);
            n5 = CommodityMarketData.getShippingCapacity(marketAPI, true);
            n4 = Math.min(n7, n6);
            if (n4 > this.maxExportGlobal) {
                this.maxExportGlobal = n4;
            }
            n3 = this.getMaxExport(string3);
            n2 = Math.min(n7, n5);
            if (n2 > n3) {
                this.maxExportPerFaction.put(string3, n2);
            }
            float f6 = CommodityMarketData.computeBaseAccessibility(marketAPI, vector2f);
            String string4 = CommodityMarketData.getDescForAccessibility(f6);
            marketAPI.getAccessibilityMod().modifyFlatAlways("core_base", f6, string4);
            if (f3 > 0.0f) {
                Profiler.new((String)"Computing hostile accessibility mods");
                Integer n8 = map.get(marketAPI.getFaction());
                if (n8 == null) {
                    n8 = 0;
                }
                if ((f5 = (float)Math.round(f4 * (float)n8.intValue() / f3 * 100.0f) / 100.0f) > 0.0f) {
                    marketAPI.getAccessibilityMod().modifyFlatAlways("core_hostile", -f5, CommodityMarketData.getFactionHostilityDesc());
                } else {
                    marketAPI.getAccessibilityMod().unmodifyFlat("core_hostile");
                }
                Profiler.o00000();
            }
            float f7 = marketAPI.getAccessibilityMod().computeEffective(0.0f);
            f5 = BaseIndustry.getSizeMult((float)n4) * Math.max(0.0f, f7);
            f2 += f5;
            hashMap.put(marketAPI.getId(), Float.valueOf(f5));
            float f8 = this.getDemandValue(commodityOnMarketAPI);
            hashMap2.put(marketAPI.getId(), Float.valueOf(f8));
            this.marketValue += f8;
            this.marketValuePerFaction.put(string3, Float.valueOf(this.getMarketValue(string3) + f8));
        }
        for (MarketAPI marketAPI : list) {
            boolean bl;
            string3 = marketAPI.getFactionId();
            commodityOnMarketAPI = marketAPI.getCommodityData(string);
            object = this.getMarketShareData(marketAPI);
            ((MarketShareData)object).setSourceIsIllegal(!(commodityOnMarketAPI.isDemandLegal() && commodityOnMarketAPI.getMaxDemand() > 0 || commodityOnMarketAPI.isSupplyLegal() && commodityOnMarketAPI.getMaxSupply() > 0));
            if (f2 > 0.0f) {
                float f9 = ((Float)hashMap.get(marketAPI.getId())).floatValue();
                ((MarketShareData)object).setExportMarketShare(f9 / f2);
            }
            if (this.marketValue > 0.0f) {
                float f10 = ((Float)hashMap2.get(marketAPI.getId())).floatValue();
                ((MarketShareData)object).setMarketValueFraction(f10 / this.marketValue);
            }
            n7 = CommodityMarketData.getShippingCapacity(marketAPI, false);
            n6 = CommodityMarketData.getShippingCapacity(marketAPI, true);
            n5 = commodityOnMarketAPI.getMaxSupply();
            n4 = commodityOnMarketAPI.getMaxDemand();
            n3 = n4 - n5;
            if (n3 < 0) {
                n3 = 0;
            }
            n2 = this.getMaxExport(string3);
            int n9 = Math.min(n6, n2);
            if (((MarketShareData)object).isSourceIsIllegal()) {
                n9 = 0;
            }
            int n10 = Math.min(n7, this.maxExportGlobal);
            ((MarketShareData)object).setSource(CommoditySourceType.NONE);
            MutableStatWithTempMods mutableStatWithTempMods = commodityOnMarketAPI.getAvailableStat();
            mutableStatWithTempMods.unmodifyFlat(KEY_LOCAL);
            mutableStatWithTempMods.unmodifyFlat(KEY_IMPORTS);
            mutableStatWithTempMods.unmodifyFlat(KEY_SHORTAGE);
            mutableStatWithTempMods.unmodifyFlat(KEY_LOWACCESS);
            if (n5 + n9 + n10 <= 0 && n4 <= 0) continue;
            String string5 = "import";
            if (((MarketShareData)object).isSourceIsIllegal()) {
                string5 = "smuggling";
            }
            if (n5 > 0) {
                ((MarketShareData)object).setSource(CommoditySourceType.LOCAL);
                mutableStatWithTempMods.modifyFlat(KEY_LOCAL, (float)n5, "Local production");
            }
            boolean bl2 = bl = n9 > n5 || n10 > n5;
            if (n3 > 0 && !marketAPI.isHidden()) {
                int n11;
                int n12 = n3 - Math.max(0, n4 - n2) - Math.max(0, n3 - n6);
                if (n12 >= (n11 = n3 - Math.max(0, n4 - this.maxExportGlobal) - Math.max(0, n3 - n7))) {
                    if (bl) {
                        ((MarketShareData)object).setSource(CommoditySourceType.IN_FACTION);
                    }
                    var30_41 = n3;
                    mutableStatWithTempMods.modifyFlat(KEY_IMPORTS, (float)var30_41, "Desired " + string5 + " volume (in-faction)");
                    var31_42 = n4 - n2;
                    var31_42 = Math.min(var31_42, n3);
                    if (var31_42 > 0) {
                        mutableStatWithTempMods.modifyFlat(KEY_SHORTAGE, (float)(-var31_42), "In-faction shortage (max in-faction production source has " + n2 + ")");
                    }
                    var32_43 = var30_41 - n6;
                    var32_43 = Math.min(var32_43, n3);
                    if ((var32_43 -= Math.max(0, var31_42)) > 0) {
                        mutableStatWithTempMods.modifyFlat(KEY_LOWACCESS, (float)(-var32_43), "Insufficient accessibility");
                    }
                } else if (n10 > 0) {
                    if (bl) {
                        ((MarketShareData)object).setSource(CommoditySourceType.GLOBAL);
                    }
                    var30_41 = n3;
                    mutableStatWithTempMods.modifyFlat(KEY_IMPORTS, (float)var30_41, "Desired " + string5 + " volume");
                    var31_42 = n4 - this.maxExportGlobal;
                    var31_42 = Math.min(var31_42, n3);
                    if (var31_42 > 0) {
                        mutableStatWithTempMods.modifyFlat(KEY_SHORTAGE, (float)(-var31_42), "Global shortage (max production source has " + this.maxExportGlobal + ")");
                    }
                    var32_43 = var30_41 - n7;
                    var32_43 = Math.min(var32_43, n3);
                    if ((var32_43 -= Math.max(0, var31_42)) > 0) {
                        mutableStatWithTempMods.modifyFlat(KEY_LOWACCESS, (float)(-var32_43), "Insufficient accessibility");
                    }
                }
            }
            commodityOnMarketAPI.reapplyEventMod();
        }
        this.adjustMarketShare(list);
    }

    public void adjustMarketShare(List<MarketAPI> list) {
        float f2;
        Profiler.new((String)"Adjusting market share");
        int n2 = 0;
        for (MarketAPI marketAPI : list) {
            Iterator<MarketAPI> iterator = this.getMarketShareData(marketAPI);
            f2 = ((MarketShareData)((Object)iterator)).getExportMarketShare();
            n2 += (int)(f2 * 100.0f);
        }
        this.sortedProducers = new ArrayList<MarketShareData>(this.marketShareData.values());
        Collections.sort(this.sortedProducers, new Comparator<MarketShareDataAPI>(){

            public int o00000(MarketShareDataAPI marketShareDataAPI, MarketShareDataAPI marketShareDataAPI2) {
                float f2 = marketShareDataAPI.getExportMarketShare() * 100.0f - (float)((int)(marketShareDataAPI.getExportMarketShare() * 100.0f));
                float f3 = marketShareDataAPI2.getExportMarketShare() * 100.0f - (float)((int)(marketShareDataAPI2.getExportMarketShare() * 100.0f));
                return (int)Math.signum(f3 - f2);
            }
        });
        int n3 = 100 - n2;
        for (MarketShareDataAPI marketShareDataAPI : this.sortedProducers) {
            f2 = marketShareDataAPI.getExportMarketShare();
            if (!(f2 > 0.0f)) continue;
            if (n3 > 0) {
                marketShareDataAPI.setExportMarketShare((float)((int)(f2 * 100.0f) + 1) / 100.0f);
                --n3;
                continue;
            }
            marketShareDataAPI.setExportMarketShare((float)((int)(f2 * 100.0f)) / 100.0f);
        }
        n2 = 0;
        for (MarketAPI marketAPI : list) {
            MarketShareData marketShareData = this.getMarketShareData(marketAPI);
            float f3 = marketShareData.getMarketValueFraction();
            n2 += (int)(f3 * 100.0f);
        }
        this.sortedConsumers = new ArrayList<MarketShareData>(this.marketShareData.values());
        Collections.sort(this.sortedConsumers, new Comparator<MarketShareDataAPI>(){

            public int super(MarketShareDataAPI marketShareDataAPI, MarketShareDataAPI marketShareDataAPI2) {
                float f2 = marketShareDataAPI.getMarketValueFraction() * 100.0f - (float)((int)(marketShareDataAPI.getMarketValueFraction() * 100.0f));
                float f3 = marketShareDataAPI2.getMarketValueFraction() * 100.0f - (float)((int)(marketShareDataAPI2.getMarketValueFraction() * 100.0f));
                return (int)Math.signum(f3 - f2);
            }
        });
        n3 = 100 - n2;
        for (MarketShareDataAPI marketShareDataAPI : this.sortedConsumers) {
            float f4 = marketShareDataAPI.getMarketValueFraction();
            if (!(f4 > 0.0f)) continue;
            if (n3 > 0) {
                marketShareDataAPI.setMarketValueFraction((float)((int)(f4 * 100.0f) + 1) / 100.0f);
                --n3;
                continue;
            }
            marketShareDataAPI.setMarketValueFraction((float)((int)(f4 * 100.0f)) / 100.0f);
        }
        Profiler.o00000();
    }

    public List<MarketAPI> getMarkets() {
        List list = Global.getSector().getEconomy().getMarketsInGroup(this.econGroup);
        return list;
    }

    public List<MarketShareDataAPI> getSortedProducers() {
        return this.sortedProducers;
    }

    public List<MarketShareDataAPI> getSortedConsumers() {
        return this.sortedConsumers;
    }

    public int getExportMarketSharePercent(MarketAPI marketAPI) {
        return Math.round(this.getMarketShareData(marketAPI).getExportMarketShare() * 100.0f);
    }

    public int getMarketValuePercent(MarketAPI marketAPI) {
        return Math.round(this.getMarketShareData(marketAPI).getMarketValueFraction() * 100.0f);
    }

    public MarketShareData getMarketShareData(MarketAPI marketAPI) {
        MarketShareData marketShareData = this.marketShareData.get(marketAPI);
        if (marketShareData == null) {
            marketShareData = new MarketShareData();
        }
        this.marketShareData.put(marketAPI, marketShareData);
        return marketShareData;
    }

    public int getMaxExport(String string) {
        Integer n2 = this.maxExportPerFaction.get(string);
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    public float getMarketValue(String string) {
        Float f2 = this.marketValuePerFaction.get(string);
        if (f2 == null) {
            return 0.0f;
        }
        return f2.floatValue();
    }

    public String getCommodityId() {
        return this.commodityId;
    }

    public String getEconGroup() {
        return this.econGroup;
    }

    public int getMaxExportGlobal() {
        return this.maxExportGlobal;
    }

    public float getMarketValue() {
        float f2 = this.getMarketValue("player");
        return this.marketValue - f2;
    }

    public float getMarketValueOutsideFaction(String string) {
        float f2 = this.getMarketValue(string);
        return this.getMarketValue() - f2;
    }

    public int getExportIncome(CommodityOnMarketAPI commodityOnMarketAPI) {
        MarketShareData marketShareData = this.getMarketShareData(commodityOnMarketAPI.getMarket());
        if (marketShareData.isSourceIsIllegal()) {
            return 0;
        }
        float f2 = commodityOnMarketAPI.getMarket().getIncomeMult().getModifiedValue();
        float f3 = 1.0f;
        if (commodityOnMarketAPI.getMarket().isPlayerOwned()) {
            f3 = Global.getSector().getPlayerStats().getDynamic().getValue(Stats.getCommodityExportCreditsMultId((String)commodityOnMarketAPI.getId()));
        }
        return (int)(marketShareData.getExportMarketShare() * this.getMarketValue() * (f2 *= f3));
    }

    public int getDemandValue(CommodityOnMarketAPI commodityOnMarketAPI) {
        float f2 = CommodityMarketData.getShippingCapacity(commodityOnMarketAPI.getMarket(), false);
        float f3 = commodityOnMarketAPI.getMaxDemand();
        float f4 = commodityOnMarketAPI.getCommodity().getExportValue();
        float f5 = Global.getSettings().getFloat("exportIncomeMult");
        float f6 = BaseIndustry.getSizeMult((float)Math.min(f2, f3)) * f4 * f5;
        return (int)f6;
    }

    public int getMarketSharePercent(FactionAPI factionAPI) {
        int n2 = 0;
        for (MarketAPI marketAPI : this.getMarkets()) {
            int n3 = this.getExportMarketSharePercent(marketAPI);
            if (marketAPI.getFaction() != factionAPI && (!factionAPI.isPlayerFaction() || !marketAPI.isPlayerOwned())) continue;
            n2 += n3;
        }
        return n2;
    }

    public Map<FactionAPI, Integer> getMarketSharePercentPerFaction() {
        LinkedHashMap<FactionAPI, Integer> linkedHashMap = new LinkedHashMap<FactionAPI, Integer>();
        for (MarketAPI marketAPI : this.getMarkets()) {
            FactionAPI factionAPI = marketAPI.getFaction();
            if (linkedHashMap.containsKey(factionAPI)) continue;
            Integer n2 = this.getMarketSharePercent(factionAPI);
            linkedHashMap.put(factionAPI, n2);
        }
        return linkedHashMap;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class o {
        public float \u00d200000 = 0.0f;
        public Map<FactionAPI, Integer> super = new LinkedHashMap<FactionAPI, Integer>();
        public Map<FactionAPI, Integer> \u00d300000;

        public o(List<MarketAPI> list) {
            for (MarketAPI marketAPI : list) {
                FactionAPI factionAPI2 = marketAPI.getFaction();
                Object object = this.super.get(factionAPI2);
                if (object == null) {
                    object = 0;
                }
                int n2 = Math.max(1, marketAPI.getSize() - 2);
                this.super.put(factionAPI2, (Integer)object + n2);
                this.\u00d200000 += (float)n2;
            }
            this.\u00d300000 = new HashMap<FactionAPI, Integer>();
            for (FactionAPI factionAPI : this.super.keySet()) {
                this.\u00d300000.put(factionAPI, 0);
            }
            for (FactionAPI factionAPI : this.super.keySet()) {
                for (FactionAPI factionAPI2 : this.super.keySet()) {
                    if (factionAPI == factionAPI2 || !factionAPI.isHostileTo(factionAPI2)) continue;
                    Integer n3 = this.\u00d300000.get(factionAPI);
                    if (n3 == null) {
                        n3 = 0;
                    }
                    this.\u00d300000.put(factionAPI, n3 + this.super.get(factionAPI2));
                }
            }
        }
    }
}

