/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.fleet;

import com.fs.graphics.Sprite;
import com.fs.graphics.util.Fader;
import com.fs.profiler.Profiler;
import com.fs.starfarer.D;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.FleetInflater;
import com.fs.starfarer.api.campaign.FleetOrStubAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.StatBonus;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberViewAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.campaign.BaseCampaignEntity;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.CharacterStats;
import com.fs.starfarer.campaign.Faction;
import com.fs.starfarer.campaign.accidents.AccidentManager;
import com.fs.starfarer.campaign.ai.ModularFleetAI;
import com.fs.starfarer.campaign.class;
import com.fs.starfarer.campaign.fleet.Battle;
import com.fs.starfarer.campaign.fleet.CampaignFleetMemberView;
import com.fs.starfarer.campaign.fleet.CampaignFleetView;
import com.fs.starfarer.campaign.fleet.CargoData;
import com.fs.starfarer.campaign.fleet.FleetAbilityRenderer;
import com.fs.starfarer.campaign.fleet.FleetData;
import com.fs.starfarer.campaign.fleet.FleetMember;
import com.fs.starfarer.campaign.fleet.LogisticsModule;
import com.fs.starfarer.campaign.fleet.MutableFleetStats;
import com.fs.starfarer.campaign.fleet.SmoothFacingModule;
import com.fs.starfarer.campaign.fleet.SmoothMovementModule;
import com.fs.starfarer.campaign.ui.trade.CargoItemStack;
import com.fs.starfarer.campaign.util.super;
import com.fs.starfarer.combat.CombatViewport;
import com.fs.starfarer.coreui.A.V;
import com.fs.starfarer.coreui.C;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.specs.HullVariantSpec;
import com.fs.starfarer.loading.specs.O;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.rpg.OfficerData;
import com.fs.starfarer.rpg.Person;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class CampaignFleet
extends BaseCampaignEntity
implements CampaignFleetAPI,
DoNotObfuscate,
SmoothMovementModule.MovementModuleDelegate,
FleetOrStubAPI,
Cloneable {
    private Boolean reportedSpawned = false;
    private Boolean noAutoDespawn = null;
    private FleetData fleetData;
    private Vector2f moveDestination = null;
    private boolean moveOverride = false;
    private Fader noCombat = null;
    private CampaignFleetView fleetView;
    private float facing = 90.0f;
    private SmoothMovementModule movementModule;
    private SmoothFacingModule facingModule;
    private transient ShipAPI.HullSize largestShipSize;
    private CampaignFleetAIAPI ai;
    private Boolean doNotAdvanceAI = null;
    private transient Boolean wasMousedOverByPlayer = null;
    private String name = "Patrol";
    private transient Sprite arrow;
    private MutableFleetStats stats = new MutableFleetStats();
    private SectorEntityToken interactionTarget = null;
    private AccidentManager accidentManager;
    private LogisticsModule logistics;
    private Boolean isInJumpTransition = null;
    private Boolean inHyperspaceTransitionWarpOutStage = null;
    private boolean aiMode = false;
    private transient class sensorRangeIndicator;
    private Boolean noFactionInName = null;
    private Boolean stationMode = null;
    private Battle battle = null;
    private float desiredFacing;
    private Boolean wasOutOfSupplies = null;
    private Boolean wasOutOfCrew = null;
    private Fader noCombatPulse = new Fader(0.0f, 0.1f, 0.1f, true, true);
    private List<FleetEventListener> despawnListeners = null;
    private Boolean fadeAndExpire = null;
    private transient FleetAbilityRenderer abilityRenderer = null;
    private String nullAIActionText = null;
    private FleetInflater inflater;
    private Boolean hidden = null;
    private Boolean inflated = null;
    private transient EnumSet<CampaignEngineLayers> layers = EnumSet.of(CampaignEngineLayers.FLEETS);
    private static Vector2f zero = new Vector2f();
    private JumpPointAPI.JumpDestination jumpDestination;
    public static final String OVERCAPCAITY_SPEED_PENALTY_ID = "overcap_speed_penalty";
    private transient boolean hasUniqueSig = false;
    private transient int numCapitals;
    private transient int numCruisers;
    private transient int numDestroyers;
    private transient int numFrigates;
    private transient int numFighters;
    private transient int fleetSizeNum;
    private transient boolean isOnlyOneLargestShip = false;
    private transient FleetMember mostExpensiveShip = null;
    private Boolean forceNoSensorProfileUpdate = null;
    private transient Boolean abortDespawn = null;
    private Boolean goSlowOneFrame = null;
    private Boolean wasSlowMoving = null;
    private Boolean goSlowStop = null;

    protected CampaignFleet clone() {
        try {
            return (CampaignFleet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public CampaignFleet() {
        this(Faction.NO_FACTION);
    }

    @Override
    public boolean isHidden() {
        return this.hidden != null;
    }

    public void setHidden(Boolean bl) {
        if (bl != null && !bl.booleanValue()) {
            bl = null;
        }
        this.hidden = bl;
    }

    public FleetInflater getInflater() {
        return this.inflater;
    }

    public void setInflater(FleetInflater fleetInflater) {
        this.inflater = fleetInflater;
    }

    public boolean isInflated() {
        return this.inflated != null && this.inflated != false;
    }

    public void setInflated(Boolean bl) {
        this.inflated = bl;
    }

    public void inflateIfNeeded() {
        if (this.inflater != null && this.inflated == null && !this.getFaction().isNeutralFaction()) {
            this.inflater.inflate((CampaignFleetAPI)this);
            ListenerUtil.reportFleetInflated((CampaignFleetAPI)this, (FleetInflater)this.inflater);
            if (this.inflater.removeAfterInflating()) {
                this.inflater = null;
            }
            this.inflated = true;
        }
    }

    public void deflate() {
        if (!this.isPlayerFleet()) {
            boolean bl = this.getMemoryWithoutUpdate().getBoolean("$overrideNoAutofit");
            for (FleetMember fleetMember : this.getMembers()) {
                HullVariantSpec hullVariantSpec = fleetMember.getVariant();
                if (!bl && fleetMember.getHullSpec().hasTag("no_autofit") || !bl && fleetMember.getVariant() != null && fleetMember.getVariant().hasTag("no_autofit") || hullVariantSpec.getOriginalVariant() == null) continue;
                fleetMember.setVariant(SpecStore.super(HullVariantSpec.class, hullVariantSpec.getOriginalVariant()), false, false);
            }
            this.inflated = null;
            this.getFleetData().syncIfNeeded();
        }
    }

    public Boolean wasMousedOverByPlayer() {
        if (this.wasMousedOverByPlayer != null) {
            return true;
        }
        return false;
    }

    public void setWasMousedOverByPlayer(Boolean bl) {
        if (bl != null && !bl.booleanValue()) {
            bl = null;
        }
        this.wasMousedOverByPlayer = bl;
    }

    public void setStationMode(Boolean bl) {
        this.stationMode = bl;
        if (this.stationMode != null && !this.stationMode.booleanValue()) {
            this.stationMode = null;
        }
    }

    public boolean isStationMode() {
        return this.stationMode != null;
    }

    public String getNullAIActionText() {
        return this.nullAIActionText;
    }

    public void setNullAIActionText(String string) {
        this.nullAIActionText = string;
    }

    public FleetAbilityRenderer getAbilityRenderer() {
        if (this.abilityRenderer == null) {
            this.abilityRenderer = new FleetAbilityRenderer(this);
        }
        return this.abilityRenderer;
    }

    @Override
    public void addAbility(String string) {
        super.addAbility(string);
    }

    @Override
    public void removeAbility(String string) {
        super.removeAbility(string);
    }

    public void setFaction(String string, boolean bl) {
        super.setFaction(string);
        if (bl) {
            for (FleetMember fleetMember : this.getMembers()) {
                if (fleetMember.getCaptain() == null) continue;
                fleetMember.getCaptain().setFaction(string);
            }
        }
    }

    public Boolean isDoNotAdvanceAI() {
        if (this.doNotAdvanceAI != null && this.doNotAdvanceAI.booleanValue()) {
            return true;
        }
        return false;
    }

    public void setDoNotAdvanceAI(Boolean bl) {
        this.doNotAdvanceAI = bl;
    }

    public Boolean isNoAutoDespawn() {
        if (this.noAutoDespawn != null) {
            return true;
        }
        return false;
    }

    public void setNoAutoDespawn(Boolean bl) {
        this.noAutoDespawn = bl;
        if (bl != null && !bl.booleanValue()) {
            this.noAutoDespawn = null;
        }
    }

    public boolean isReportedSpawned() {
        return this.reportedSpawned == null;
    }

    public void setReportedSpawned(boolean bl) {
        this.reportedSpawned = bl ? null : Boolean.valueOf(bl);
    }

    public CampaignFleet(Faction faction) {
        super(null);
        this.setFaction(faction);
        this.arrow = new Sprite("graphics/warroom/ship_arrow.png");
        this.fleetData = new FleetData(faction.getShipNamePrefix(), faction.getId());
        this.fleetData.setFleet(this);
        this.fleetView = new CampaignFleetView(this);
        this.movementModule = new SmoothMovementModule(1.0f, 2.0f, this);
        this.facingModule = new SmoothFacingModule(150.0f, 100.0f);
        this.facingModule.setFacing(this.facing);
        this.desiredFacing = this.facing;
        super.o o2 = super.o.\u00d200000;
        this.updateIndicatorColor();
        Person person = faction.createRandomPerson();
        person.getStats().getCommandPoints().modifyFlat("default_commander", 10.0f);
        this.setCommander(person);
        this.accidentManager = new AccidentManager(this);
        this.logistics = new LogisticsModule(this);
        this.sensorRangeIndicator = new class(this);
    }

    public void setDesiredFacing(float f2) {
        this.desiredFacing = f2;
    }

    public float getDesiredFacing() {
        return this.desiredFacing;
    }

    public class getSensorRangeIndicator() {
        return this.sensorRangeIndicator;
    }

    public boolean isAIMode() {
        return this.aiMode;
    }

    public void setAIModeNoSync(boolean bl) {
        this.aiMode = bl;
    }

    public void setAIMode(boolean bl) {
        boolean bl2 = false;
        if (bl != this.aiMode) {
            bl2 = true;
        }
        this.aiMode = bl;
        if (bl2) {
            this.fleetData.setSyncNeeded();
            this.fleetData.syncIfNeeded();
            this.fleetData.setSyncNeeded();
            this.fleetData.syncIfNeeded();
        }
    }

    public void forceSync() {
        this.fleetData.setSyncNeeded();
        this.fleetData.syncIfNeeded();
        this.fleetData.setSyncNeeded();
        this.fleetData.syncIfNeeded();
    }

    public boolean isInHyperspaceTransition() {
        return this.isInJumpTransition != null;
    }

    public void setInJumpTransition(boolean bl) {
        this.isInJumpTransition = bl ? Boolean.valueOf(true) : null;
    }

    public boolean isInJumpTransitionWarpOutStage() {
        return this.inHyperspaceTransitionWarpOutStage != null;
    }

    public void setInJumpTransitionWarpOutStage(boolean bl) {
        if (bl) {
            bl = true;
        } else {
            this.inHyperspaceTransitionWarpOutStage = null;
        }
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        if (this.fleetView == null) {
            this.fleetView = new CampaignFleetView(this);
        }
        this.layers = EnumSet.of(CampaignEngineLayers.FLEETS);
        this.fleetData.setFleet(this);
        if (this.logistics == null) {
            this.logistics = new LogisticsModule(this);
        }
        if (this.noCombatPulse == null) {
            this.noCombatPulse = new Fader(0.0f, 0.1f, 0.1f, true, true);
        }
        if (this.arrow == null) {
            this.arrow = new Sprite("graphics/warroom/ship_arrow.png");
        }
        this.sensorRangeIndicator = new class(this);
        this.fleetData.setSyncNeeded();
        return this;
    }

    @Override
    protected Object writeReplace() {
        Object object;
        super.writeReplace();
        if (this.isAIMode()) {
            this.accidentManager = null;
        }
        if (this.getContainingLocation() != null && !this.getContainingLocation().getFleets().contains(this)) {
            object = new ModularFleetAI(this);
            this.setAI((CampaignFleetAIAPI)object);
            this.getMemoryWithoutUpdate().unset("$ai_nearestEnemy");
            this.getMemoryWithoutUpdate().unset("$ai_fleeingFrom");
            this.getMemoryWithoutUpdate().unset("$ai_pursuitTarget");
        }
        this.deflate();
        if (!this.isVisible(500.0f) && !this.willBeVisible()) {
            object = this.clone();
            ((CampaignFleet)object).fleetView = null;
            return object;
        }
        return this;
    }

    private void updateIndicatorColor() {
        this.getIndicator().o00000(this.getFaction().getSpec().getColor(), this.getFaction().getSecondaryUIColor(), this.getFaction().getSpec().getSecondarySegments());
    }

    @Override
    public void setLocation(float f2, float f3) {
        super.setLocation(f2, f3);
        this.movementModule.getLocation().set(f2, f3);
    }

    public Vector2f getVelocityFromMovementModule() {
        return this.movementModule.getVelocity();
    }

    public void setVelocity(float f2, float f3) {
        this.movementModule.getVelocity().set(f2, f3);
    }

    public float getAcceleration() {
        return this.movementModule.getAcceleration();
    }

    public SmoothMovementModule getMovementModule() {
        return this.movementModule;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isNoFactionInName() {
        return this.noFactionInName != null;
    }

    public void setNoFactionInName(boolean bl) {
        this.noFactionInName = bl ? Boolean.valueOf(true) : null;
    }

    public String getNameWithFaction() {
        if (this.isStationMode()) {
            return this.getNameWithFactionKeepCase();
        }
        if (this.getFaction().getEntityNamePrefix().isEmpty() || this.noFactionInName != null) {
            String[] stringArray;
            if (this.name != null && (stringArray = this.name.split(" ")).length > 1 && (stringArray[0].endsWith("'s") || this.name.startsWith("Tactistar"))) {
                String string = stringArray[0];
                int n2 = 1;
                while (n2 < stringArray.length) {
                    string = String.valueOf(string) + " " + stringArray[n2].toLowerCase();
                    ++n2;
                }
                return string;
            }
            return this.name.toLowerCase();
        }
        return String.valueOf(this.getFaction().getEntityNamePrefix()) + " " + this.name.toLowerCase();
    }

    public String getNameWithFactionKeepCase() {
        if (this.getFaction().getEntityNamePrefix().isEmpty() || this.noFactionInName != null) {
            return this.name;
        }
        return String.valueOf(this.getFaction().getEntityNamePrefix()) + " " + this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public Person getCommander() {
        return this.fleetData.getCommander();
    }

    public CharacterStats getCommanderStats() {
        if (this.fleetData.getCommander() == null) {
            return null;
        }
        return this.fleetData.getCommander().getStats();
    }

    public void setCommander(PersonAPI personAPI) {
        this.fleetData.setCommander((Person)personAPI);
    }

    public boolean canBeEngaged() {
        if (this.getMemoryWithoutUpdate().getBoolean("$canOnlyBeEngagedWhenVisibleToPlayer") && this.getVisibilityLevelToPlayerFleet() == SectorEntityToken.VisibilityLevel.NONE) {
            return false;
        }
        return this.noCombat == null && this.fadeAndExpire == null;
    }

    public void setNoEngaging(float f2) {
        this.noCombat = new Fader(0.0f, f2);
        this.noCombat.fadeIn();
        this.noCombatPulse.setBounce(true, true);
        this.noCombatPulse.fadeIn();
    }

    public boolean isNoEngagingSet() {
        return this.noCombat != null;
    }

    @Override
    public EnumSet<CampaignEngineLayers> getActiveLayers() {
        return this.layers;
    }

    public void renderSensorRange(float f2) {
        if (this.isHidden()) {
            return;
        }
        this.sensorRangeIndicator.super(f2);
    }

    @Override
    public void render(CampaignEngineLayers campaignEngineLayers, CombatViewport combatViewport) {
        if (!combatViewport.isNearViewport(this.getLocation(), 450.0f)) {
            return;
        }
        if (this.isHidden()) {
            return;
        }
        float f2 = combatViewport.getAlphaMult();
        if ((f2 *= this.getSensorFader().getBrightness()) <= 0.0f) {
            return;
        }
        Profiler.new((String)"Campaign fleet rendering");
        SectorEntityToken.VisibilityLevel visibilityLevel = this.getVisibilityLevelToPlayerFleet();
        if (this.getSensorContactFader().getBrightness() > 0.0f) {
            this.fleetView.renderContrails(f2 * this.getSensorContactFader().getBrightness());
        }
        GL11.glPushMatrix();
        Vector2f vector2f = this.getLocation();
        GL11.glTranslatef((float)vector2f.x, (float)vector2f.y, (float)0.0f);
        f2 *= this.getSensorContactFader().getBrightness();
        if (f2 <= 0.0f) {
            GL11.glPopMatrix();
            Profiler.o00000();
            return;
        }
        this.fleetView.render(f2);
        if (this.fadeAndExpire == null && visibilityLevel != SectorEntityToken.VisibilityLevel.SENSOR_CONTACT && !this.isStationMode()) {
            float f3 = 10.0f;
            this.arrow.setSize(f3, f3);
            this.arrow.setColor(this.getIndicator().\u00d200000());
            this.arrow.setAlphaMult(f2 * 0.5f);
            float f4 = this.facingModule.getFacing();
            this.arrow.setAngle(f4 - 90.0f);
            float f5 = (float)Math.cos(Math.toRadians(f4));
            float f6 = (float)Math.sin(Math.toRadians(f4));
            float f7 = this.getSelectionSize() + 5.0f;
            float f8 = f7 * f5;
            float f9 = f7 * f6;
            this.arrow.renderAtCenter(f8, f9);
            this.renderCourseArrow(f2);
        }
        GL11.glPopMatrix();
        Profiler.o00000();
    }

    private void renderCourseArrow(float f2) {
        float f3;
        if (!this.isPlayerFleet()) {
            return;
        }
        CampaignEngine.o o2 = CampaignEngine.getInstance().getCampaignUI();
        if (o2 == null) {
            return;
        }
        if (o2.getCourseWidget() == null) {
            return;
        }
        V v2 = o2.getCourseWidget();
        SectorEntityToken sectorEntityToken = v2.getCurrentTarget();
        if (sectorEntityToken == null) {
            return;
        }
        float f4 = 10.0f;
        float f5 = o2.getZoomFactor();
        this.arrow.setSize(f4 *= f5, f4);
        this.arrow.setColor(this.getIndicator().\u00d200000());
        this.arrow.setAlphaMult(f2 *= v2.getInner().getBrightness());
        float f6 = Utils.\u00d300000(this.getLocation(), sectorEntityToken.getLocation());
        this.arrow.setAngle(f6 - 90.0f);
        float f7 = (float)Math.cos(Math.toRadians(f6));
        float f8 = (float)Math.sin(Math.toRadians(f6));
        float f9 = 3.0f;
        float f10 = 15.0f;
        float f11 = (f4 + f9) * f10;
        float f12 = Math.max(0.0f, Utils.void(this.getLocation(), sectorEntityToken.getLocation()) - f11 - 50.0f);
        if (f11 > f12) {
            f3 = f12 / f11;
            f2 *= f3;
        }
        f3 = 0.1f;
        float f13 = 0.25f;
        float f14 = 0.0f;
        while (f14 < f10) {
            float f15 = v2.getPhase() + f14 * (1.0f / f10);
            while (f15 > 1.0f) {
                f15 -= 1.0f;
            }
            float f16 = 1.0f;
            if (f15 < f3) {
                f16 = f15 / f3;
            } else if (f15 > 1.0f - f13) {
                f16 = (1.0f - f15) / f13;
            }
            float f17 = this.getSelectionSize() + 5.0f + f4 + f15 * f11;
            float f18 = f17 * f7;
            float f19 = f17 * f8;
            this.arrow.setAlphaMult(f2 * f16);
            this.arrow.renderAtCenter(f18, f19);
            f14 += 1.0f;
        }
    }

    public Fader getNoCombatPulse() {
        return this.noCombatPulse;
    }

    @Override
    public void advance(float f2) {
        if (f2 > 0.0f && this.isPlayerFleet()) {
            for (CargoItemStack cargoItemStack : this.getCargo().getStacks()) {
                if (cargoItemStack.getCargo() == this.getCargo()) continue;
                cargoItemStack.setCargo(this.getCargo());
            }
        }
        if (this.fleetData.getPostLoadReset() != null) {
            this.fleetData.setSyncNeeded();
            this.fleetData.syncIfNeeded();
            for (FleetMember fleetMember : this.fleetData.getMembers()) {
                fleetMember.getRepairTracker().setCR(fleetMember.getRepairTracker().getMaxCR());
            }
            this.fleetData.setPostLoadReset(null);
        }
        Profiler.new((String)"Fleet advance");
        this.sensorRangeIndicator.\u00d200000(f2);
        if (this.isInCurrentLocation()) {
            this.getAbilityRenderer().updateLayers();
        }
        if (this == CampaignEngine.getInstance().getPlayerFleet()) {
            this.getCargo().initPartialsIfNeeded();
        }
        if (this.ai != null && this.fadeAndExpire == null && !this.isDoNotAdvanceAI().booleanValue()) {
            Profiler.new((String)"Fleet AI");
            this.ai.advance(f2);
            Profiler.o00000();
        }
        Profiler.new((String)"Commander and officer advance");
        if (this.fleetData != null && this.fleetData.getCommander() != null) {
            this.fleetData.getCommander().advance(f2);
        }
        if (this.fleetData != null && this.fleetData.getOfficers() != null) {
            for (OfficerData officerData : this.fleetData.getOfficers()) {
                officerData.getPerson().advance(f2);
            }
        }
        Profiler.o00000();
        Profiler.new((String)"super.advance");
        super.advance(f2);
        Profiler.o00000();
        Profiler.new((String)"Nulling interaction target if needed");
        if (this.getInteractionTarget() != null && this.getInteractionTarget().getContainingLocation() != this.getContainingLocation()) {
            this.setInteractionTarget(null);
        }
        if (this.getInteractionTarget() != null && !this.getInteractionTarget().isAlive()) {
            this.setInteractionTarget(null);
        }
        Profiler.o00000();
        if (this.noCombat != null) {
            this.noCombat.advance(f2);
            if (this.noCombat.isIdle()) {
                this.noCombat = null;
                this.noCombatPulse.setBounce(false, true);
            }
        }
        this.noCombatPulse.advance(f2);
        this.updateSpeedBonus();
        float f3 = CampaignEngine.getInstance().getClock().convertToDays(f2);
        Profiler.new((String)"HullModSpec fleet effect advance");
        for (O o2 : SpecStore.\u00f400000()) {
            o2.getFleetEffect().advanceInCampaign((CampaignFleetAPI)this);
        }
        Profiler.o00000();
        Profiler.new((String)"Fleet stats advance");
        this.stats.advance(f3);
        Profiler.o00000();
        if (!this.aiMode) {
            Profiler.new((String)"Accident manager");
            this.getAccidentManager().advance(f2);
            Profiler.o00000();
        }
        Profiler.new((String)"Logistics advance");
        this.logistics.advance(f3);
        Profiler.o00000();
        Profiler.new((String)"Repairs");
        float f4 = this.getCargo().getSupplies();
        ArrayList arrayList = new ArrayList();
        for (FleetMember fleetMember : this.getMembers()) {
            if (!(fleetMember.getStatus().getHullFraction() <= 0.0f)) continue;
            arrayList.add(fleetMember);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            FleetMember fleetMember;
            fleetMember = (FleetMember)iterator.next();
            this.fleetData.removeFleetMember(fleetMember);
        }
        boolean bl = false;
        for (FleetMember fleetMember : this.getMembers()) {
            bl |= fleetMember.needsRepairs();
        }
        if (this == CampaignEngine.getInstance().getPlayerFleet() && this.wasOutOfSupplies == null && f4 <= 0.0f) {
            this.wasOutOfSupplies = true;
            CampaignEngine.getInstance().addMessage("Out of supplies", D.\u00d2\u00d30000);
            if (bl) {
                CampaignEngine.getInstance().addMessage("Unable to continue ongoing repairs", D.\u00d2\u00d30000);
            }
        } else if (f4 > 1.0f) {
            this.wasOutOfSupplies = null;
        }
        Profiler.o00000();
        if (this == CampaignEngine.getInstance().getPlayerFleet()) {
            Profiler.new((String)"Player out of crew message");
            if (this.wasOutOfCrew == null && this.fleetData.getMinCrew() > (float)this.fleetData.getCargo().getTotalCrew()) {
                this.wasOutOfCrew = true;
                CampaignEngine.getInstance().addMessage("Not enough crew to keep all ships combat-ready", D.\u00d2\u00d30000);
            } else if (this.fleetData.getMinCrew() <= (float)this.fleetData.getCargo().getTotalCrew()) {
                this.wasOutOfCrew = null;
            }
            Profiler.o00000();
        }
        Profiler.new((String)"Update counts");
        this.updateCounts();
        Profiler.o00000();
        this.doGoSlow(f2);
        if (this.moveDestination != null || this.fadeAndExpire != null) {
            Profiler.new((String)"Movement");
            if (this.fadeAndExpire != null) {
                this.moveDestination = new Vector2f((ReadableVector2f)this.getLocation());
            }
            float f5 = this.fleetData.getTravelSpeed();
            this.movementModule.setAcceleration(Math.max(10.0f, f5 * this.getStats().getAccelerationMult().getModifiedValue()));
            this.movementModule.setMaxSpeed(f5);
            this.movementModule.advance(this, this.moveDestination, zero, f2);
            this.moveOverride = false;
            this.getLocation().set((ReadableVector2f)this.movementModule.getLocation());
            this.getVelocity().set((ReadableVector2f)this.movementModule.getVelocity());
            if (this.getBattle() == null) {
                float f6 = this.getVelocity().length();
                float f7 = Utils.void(this.movementModule.getLocation(), this.moveDestination);
                if (f6 > 3.0f && f7 > 10.0f) {
                    this.desiredFacing = Utils.\u00d300000(this.getVelocity());
                }
            }
            this.facingModule.setTurnAcceleration(1040.0f);
            this.facingModule.setMaxTurnRate(720.0f);
            this.facingModule.advance(this.desiredFacing, f2);
            this.facing = this.facingModule.getFacing();
            Profiler.o00000();
        }
        Profiler.new((String)"Hull mod ship effects and buff manager advance");
        for (FleetMember fleetMember : this.getMembers()) {
            HullVariantSpec hullVariantSpec = fleetMember.getVariant();
            if (hullVariantSpec != null) {
                for (O o3 : hullVariantSpec.getAllMods()) {
                    if (o3.getEffect() == null) continue;
                    o3.getEffect().advanceInCampaign((FleetMemberAPI)fleetMember, f2);
                }
            }
            if (fleetMember.getBuffManager() == null) continue;
            fleetMember.getBuffManager().advance(f3);
        }
        Profiler.o00000();
        Profiler.new((String)"Fleet view advance outer");
        if (this.isVisible(500.0f) || this.willBeVisible()) {
            Profiler.new((String)"Fleet view advance inner");
            this.fleetView.advance(f2);
            Profiler.o00000();
        } else {
            this.fleetView.clear();
        }
        if (this.fadeAndExpire != null && this.getSensorFader().isFadedOut()) {
            this.setExpired(true);
        }
        Profiler.o00000();
        if (this.fleetData.getMembers().isEmpty() && this.fadeAndExpire == null) {
            this.despawn(CampaignEventListener.FleetDespawnReason.NO_MEMBERS, null);
        }
        Profiler.o00000();
    }

    public void updateFleetView() {
        if (this.fleetView != null) {
            this.fleetView.advance(0.0f);
        }
    }

    @Override
    public void setExpired(boolean bl) {
        if (!bl) {
            this.fadeAndExpire = null;
        }
        super.setExpired(bl);
    }

    public JumpPointAPI.JumpDestination getJumpDestination() {
        return this.jumpDestination;
    }

    public void setJumpDestination(JumpPointAPI.JumpDestination jumpDestination) {
        this.jumpDestination = jumpDestination;
    }

    public boolean willBeVisible() {
        float f2 = 500.0f;
        boolean bl = this.isInHyperspaceTransition() && this.getJumpDestination() != null && this.getJumpDestination().getDestination().getContainingLocation() == CampaignEngine.getInstance().getCurrentLocation() && CampaignEngine.getInstance().getViewport().isNearViewport(this.getJumpDestination().getDestination().getLocation(), this.getRadius() + f2);
        boolean bl2 = false;
        CampaignFleet campaignFleet = CampaignEngine.getInstance().getPlayerFleet();
        if (campaignFleet != null) {
            boolean bl3 = bl2 = campaignFleet.isInHyperspaceTransition() && campaignFleet.getJumpDestination() != null && campaignFleet.getJumpDestination().getDestination().getContainingLocation() == this.getContainingLocation() && Utils.void(this.getLocation(), campaignFleet.getJumpDestination().getDestination().getLocation()) < 1000.0f + f2;
        }
        return bl || bl2;
    }

    public float getTotalSupplyCostPerDay() {
        return this.logistics.getTotalSuppliesPerDay();
    }

    public float getCrewSupplyCostPerDay() {
        return this.logistics.getCrewSuppliesPerDay();
    }

    public void updateSpeedBonus() {
        Profiler.new((String)"Updating open space speed bonus");
        if (this.isPlayerFleet()) {
            float f2;
            CargoData cargoData = this.getCargo();
            float f3 = cargoData.getFuel() / Math.max(1.0f, cargoData.getMaxFuel());
            f3 = Math.max(f3, (float)(cargoData.getMarines() + cargoData.getTotalCrew()) / Math.max(1.0f, cargoData.getMaxPersonnel()));
            f3 = Math.max(f3, cargoData.getSpaceUsed() / Math.max(1.0f, cargoData.getMaxCapacity()));
            float f4 = this.getNumShips();
            if ((f3 = Math.max(f3, (f4 - (f2 = (float)Global.getSettings().getMaxShipsInFleet()) + f4) / f2)) <= 1.0f) {
                this.stats.getFleetwideMaxBurnMod().unmodify(OVERCAPCAITY_SPEED_PENALTY_ID);
            } else {
                float f5;
                this.stats.getFleetwideMaxBurnMod().unmodify(OVERCAPCAITY_SPEED_PENALTY_ID);
                float f6 = this.fleetData.getBurnLevel();
                if (f3 > 2.0f) {
                    f3 = 2.0f;
                }
                if ((f5 = 2.0f - f3) > 1.0f) {
                    f5 = 1.0f;
                }
                if (f5 < 1.0f) {
                    this.stats.getFleetwideMaxBurnMod().modifyMult(OVERCAPCAITY_SPEED_PENALTY_ID, f5, "Over carrying capacity or max number of ships");
                } else {
                    this.stats.getFleetwideMaxBurnMod().unmodifyMult(OVERCAPCAITY_SPEED_PENALTY_ID);
                }
            }
        }
        Profiler.o00000();
    }

    public Boolean getForceNoSensorProfileUpdate() {
        return this.forceNoSensorProfileUpdate;
    }

    public void setForceNoSensorProfileUpdate(Boolean bl) {
        this.forceNoSensorProfileUpdate = bl;
    }

    public boolean hasShipsWithUniqueSig() {
        this.fleetData.syncIfNeeded();
        return this.hasUniqueSig;
    }

    public void updateCounts() {
        this.numCapitals = 0;
        this.numCruisers = 0;
        this.numDestroyers = 0;
        this.numFrigates = 0;
        this.numFighters = 0;
        this.hasUniqueSig = false;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.isPlayerFleet()) {
            for (FleetMember fleetMember : this.fleetData.getMembers()) {
                this.hasUniqueSig |= fleetMember.getVariant() != null && fleetMember.getVariant().hasTag("ship_unique_signature");
            }
        }
        int n2 = 0;
        Object object = new float[this.fleetData.getMembers().size()];
        float[] fArray = new float[((Object)object).length];
        int n3 = 0;
        for (FleetMember fleetMember : this.fleetData.getMembers()) {
            switch (fleetMember.getHullSpec().getHullSize()) {
                case CAPITAL_SHIP: {
                    ++this.numCapitals;
                    break;
                }
                case CRUISER: {
                    ++this.numCruisers;
                    break;
                }
                case DESTROYER: {
                    ++this.numDestroyers;
                    break;
                }
                case FRIGATE: {
                    ++this.numFrigates;
                    break;
                }
                case FIGHTER: {
                    ++this.numFighters;
                }
            }
            float f4 = 0.0f;
            float f5 = Math.round(fleetMember.getStats().getSensorProfile().getModifiedValue());
            if (!fleetMember.isMothballed()) {
                f3 += (f4 += (float)Math.round(fleetMember.getStats().getSensorStrength().getModifiedValue()));
            }
            f2 += f5;
            fArray[n3] = f4;
            object[n3] = f5;
            ++n3;
            if (fleetMember.getFleetPointCost() <= n2 || this.largestShipSize != fleetMember.getHullSpec().getHullSize()) continue;
            n2 = fleetMember.getFleetPointCost();
            this.mostExpensiveShip = fleetMember;
        }
        int n4 = (int)StarfarerSettings.super.class();
        n4 = Math.min(n4, ((Object)object).length);
        float f6 = Utils.super((float[])object, ((Object)object).length - n4);
        f2 = 0.0f;
        int n5 = 0;
        int n6 = 0;
        while (n6 < ((Object)object).length) {
            if (object[n6] > f6) {
                ++n5;
                f2 += object[n6];
            }
            ++n6;
        }
        if (n4 > n5) {
            f2 += (float)(n4 - n5) * f6;
        }
        float f7 = Utils.super(fArray, ((Object)object).length - n4);
        f3 = 0.0f;
        n5 = 0;
        int n7 = 0;
        while (n7 < fArray.length) {
            if (fArray[n7] > f7) {
                ++n5;
                f3 += fArray[n7];
            }
            ++n7;
        }
        if (n4 > n5) {
            f3 += (float)(n4 - n5) * f7;
        }
        float f8 = StarfarerSettings.\u00d6\u00d30000();
        f2 += f8;
        f3 += f8;
        f2 = this.stats.getSensorProfileMod().computeEffective(f2);
        f3 = this.stats.getSensorStrengthMod().computeEffective(f3);
        if (this.forceNoSensorProfileUpdate == null || !this.forceNoSensorProfileUpdate.booleanValue()) {
            this.setSensorProfile(Float.valueOf(f2));
        }
        this.setSensorStrength(Float.valueOf(f3));
        this.isOnlyOneLargestShip = false;
        if (this.numCapitals > 0) {
            if (this.numCapitals == 1) {
                this.isOnlyOneLargestShip = true;
            }
            this.largestShipSize = ShipAPI.HullSize.CAPITAL_SHIP;
        } else if (this.numCruisers > 0) {
            if (this.numCruisers == 1) {
                this.isOnlyOneLargestShip = true;
            }
            this.largestShipSize = ShipAPI.HullSize.CRUISER;
        } else if (this.numDestroyers > 0) {
            if (this.numDestroyers == 1) {
                this.isOnlyOneLargestShip = true;
            }
            this.largestShipSize = ShipAPI.HullSize.DESTROYER;
        } else if (this.numFrigates > 0) {
            if (this.numFrigates == 1) {
                this.isOnlyOneLargestShip = true;
            }
            this.largestShipSize = ShipAPI.HullSize.FRIGATE;
        } else if (this.numFighters > 0) {
            if (this.numFighters == 1) {
                this.isOnlyOneLargestShip = true;
            }
            this.largestShipSize = ShipAPI.HullSize.FIGHTER;
        }
        if (this.largestShipSize == null) {
            this.largestShipSize = ShipAPI.HullSize.FRIGATE;
        }
    }

    public FleetMember getMostExpensiveShip() {
        this.fleetData.syncIfNeeded();
        return this.mostExpensiveShip;
    }

    public boolean isOnlyOneLargestShip() {
        this.fleetData.syncIfNeeded();
        return this.isOnlyOneLargestShip;
    }

    public ShipAPI.HullSize getLargestShipSize() {
        this.fleetData.syncIfNeeded();
        return this.largestShipSize;
    }

    public int getNumCapitals() {
        this.fleetData.syncIfNeeded();
        return this.numCapitals;
    }

    public int getNumCruisers() {
        this.fleetData.syncIfNeeded();
        return this.numCruisers;
    }

    public int getNumDestroyers() {
        this.fleetData.syncIfNeeded();
        return this.numDestroyers;
    }

    public int getNumFrigates() {
        this.fleetData.syncIfNeeded();
        return this.numFrigates;
    }

    public int getNumFighters() {
        this.fleetData.syncIfNeeded();
        return this.numFighters;
    }

    public void setMoveDestination(float f2, float f3) {
        if (this.moveOverride) {
            return;
        }
        this.moveDestination = new Vector2f(f2, f3);
    }

    public void setMoveDestinationOverride(float f2, float f3) {
        this.moveDestination = new Vector2f(f2, f3);
        this.moveOverride = true;
    }

    public Vector2f getMoveDestination() {
        if (this.moveDestination == null) {
            return new Vector2f((ReadableVector2f)this.getLocation());
        }
        return this.moveDestination;
    }

    @Override
    public float getTravelSpeed() {
        return this.fleetData.getTravelSpeed();
    }

    public void addFleetMember(FleetMemberAPI fleetMemberAPI) {
        this.fleetData.addFleetMember((FleetMember)fleetMemberAPI);
    }

    public void removeFleetMember(FleetMemberAPI fleetMemberAPI) {
        this.fleetData.removeFleetMemberAndCollapseSlot((FleetMember)fleetMemberAPI);
    }

    public List<FleetMember> getMembers() {
        return this.fleetData.getMembers();
    }

    public List<FleetMember> getMembersWithFighters() {
        return this.fleetData.getMembersListWithFighters();
    }

    public List<FleetMemberAPI> getMembersWithFightersCopy() {
        return this.fleetData.getMembersListWithFightersCopy();
    }

    public List<FleetMember> getCombatReadyMembers() {
        return this.fleetData.getCombatReadyMembers();
    }

    public List<FleetMemberAPI> getMembersListCopy() {
        return new ArrayList<FleetMemberAPI>(this.fleetData.getMembers());
    }

    public List<FleetMemberAPI> getCombatReadyMembersListCopy() {
        return new ArrayList<FleetMemberAPI>(this.fleetData.getCombatReadyMembers());
    }

    public FleetData getFleetData() {
        return this.fleetData;
    }

    public void removeAll(List<FleetMemberAPI> list) {
        boolean bl = CampaignEngine.getInstance().getCurrentLocation() == this.getContainingLocation();
        for (FleetMemberAPI fleetMemberAPI : list) {
            CampaignFleetMemberView campaignFleetMemberView;
            this.fleetData.removeFleetMemberAndCollapseSlot((FleetMember)fleetMemberAPI);
            if (!bl || (campaignFleetMemberView = this.fleetView.getViewForMember((FleetMember)fleetMemberAPI)) == null) continue;
            campaignFleetMemberView.showExplosionFlash();
        }
    }

    public void removeFleetMemberWithDestructionFlash(FleetMemberAPI fleetMemberAPI) {
        boolean bl = CampaignEngine.getInstance().getCurrentLocation() == this.getContainingLocation();
        this.fleetData.removeFleetMemberAndCollapseSlot((FleetMember)fleetMemberAPI);
        CampaignFleetMemberView campaignFleetMemberView = this.fleetView.getViewForMember((FleetMember)fleetMemberAPI);
        if (campaignFleetMemberView != null && bl) {
            campaignFleetMemberView.showExplosionFlash();
        }
    }

    @Override
    public boolean isPlayerFleet() {
        return this == CampaignEngine.getInstance().getPlayerFleet();
    }

    @Override
    public float getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(float f2) {
        this.facing = f2;
        this.facingModule.setFacing(f2);
    }

    @Override
    public void setLightSource(SectorEntityToken sectorEntityToken, Color color) {
        super.setLightSource(sectorEntityToken, color);
        this.fleetView.setLightSource(sectorEntityToken, color);
    }

    public float getSelectionSize() {
        float f2 = StarfarerSettings.\u00f5O0000() + (float)this.fleetSizeNum * StarfarerSettings.private();
        if (f2 > StarfarerSettings.\u00d5\u00d50000()) {
            f2 = StarfarerSettings.\u00d5\u00d50000();
        }
        return f2;
    }

    @Override
    public float getRadius() {
        return this.getSelectionSize();
    }

    @Override
    public CargoData getCargo() {
        return this.fleetData.getCargo();
    }

    public void setAI(CampaignFleetAIAPI campaignFleetAIAPI) {
        this.ai = campaignFleetAIAPI;
    }

    public CampaignFleetAIAPI getAI() {
        return this.ai;
    }

    public void addAssignment(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2) {
        if (this.ai != null) {
            this.ai.addAssignment(fleetAssignment, sectorEntityToken, f2, null);
        }
    }

    public void addAssignment(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2, Script script) {
        if (this.ai != null) {
            this.ai.addAssignment(fleetAssignment, sectorEntityToken, f2, script);
        }
    }

    public void addAssignment(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2, String string, Script script) {
        if (this.ai != null) {
            this.ai.addAssignment(fleetAssignment, sectorEntityToken, f2, string, script);
        }
    }

    public void addAssignment(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2, String string) {
        if (this.ai != null) {
            this.ai.addAssignment(fleetAssignment, sectorEntityToken, f2, string, null);
        }
    }

    public void addAssignment(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2, String string, boolean bl, Script script, Script script2) {
        if (this.ai != null) {
            this.ai.addAssignment(fleetAssignment, sectorEntityToken, f2, string, bl, script, script2);
        }
    }

    public void clearAssignments() {
        if (this.ai != null) {
            this.ai.clearAssignments();
        }
    }

    public boolean isEmpty() {
        return this.getMembers().isEmpty();
    }

    public boolean isValidPlayerFleet() {
        for (FleetMember fleetMember : this.getMembers()) {
            if (Misc.isAutomated((FleetMemberAPI)fleetMember) || fleetMember.isFighterWing() || Misc.isUnremovable((PersonAPI)fleetMember.getCaptain())) continue;
            return true;
        }
        return false;
    }

    public FleetMember getFlagship() {
        boolean bl = this.fleetData.isOnlySyncMemberLists();
        this.fleetData.setOnlySyncMemberLists(true);
        FleetMember fleetMember = null;
        List<FleetMember> list = this.getMembers();
        for (FleetMember fleetMember2 : list) {
            if (fleetMember2.isNull() || fleetMember2.isFighterWing()) continue;
            if (fleetMember2.isFlagship()) {
                this.fleetData.setOnlySyncMemberLists(bl);
                return fleetMember2;
            }
            if (fleetMember != null) continue;
            fleetMember = fleetMember2;
        }
        this.fleetData.setOnlySyncMemberLists(bl);
        if (fleetMember != null) {
            return fleetMember;
        }
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public MutableFleetStats getStats() {
        return this.stats;
    }

    public StatBonus getMovementSpeedMod() {
        return this.stats.getMovementSpeedMod();
    }

    public SectorEntityToken getInteractionTarget() {
        return this.interactionTarget;
    }

    public void setInteractionTarget(SectorEntityToken sectorEntityToken) {
        this.interactionTarget = sectorEntityToken;
    }

    public AccidentManager getAccidentManager() {
        if (this.accidentManager == null) {
            this.accidentManager = new AccidentManager(this);
        }
        return this.accidentManager;
    }

    public void setPreferredResupplyLocation(SectorEntityToken sectorEntityToken) {
    }

    public CampaignFleetView getFleetView() {
        return this.fleetView;
    }

    public List<FleetMember> getSortedMembers() {
        return this.fleetData.getSortedMembers();
    }

    public int getFleetPoints() {
        return (int)this.fleetData.getFleetPointsUsed();
    }

    public float getEffectiveStrength() {
        return this.fleetData.getEffectiveStrength();
    }

    public String toString() {
        return String.valueOf(super.toString()) + this.getNameWithFaction();
    }

    public LogisticsModule getLogistics() {
        return this.logistics;
    }

    public int getNumMembersFast() {
        return this.getFleetData().getMembersNoSync().size();
    }

    public int getFleetSizeCount() {
        if (this.getFleetData() != null) {
            this.getFleetData().syncIfNeeded();
        }
        return this.fleetSizeNum;
    }

    public void updateFleetSizeCount() {
        if (this.isDespawning()) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        for (FleetMemberAPI fleetMemberAPI : this.getFleetData().getMembers()) {
            ShipAPI.HullSize hullSize = fleetMemberAPI.getHullSpec().getHullSize();
            int n4 = 1;
            switch (hullSize) {
                case CAPITAL_SHIP: {
                    n4 = 4;
                    if (!fleetMemberAPI.isStation()) break;
                    n4 = 25;
                    break;
                }
                case CRUISER: {
                    n4 = 3;
                    break;
                }
                case DESTROYER: {
                    n4 = 2;
                    break;
                }
                case FRIGATE: {
                    n4 = 1;
                    break;
                }
                case DEFAULT: 
                case FIGHTER: {
                    n4 = 0;
                }
            }
            n2 += n4;
            if (n4 <= n3) continue;
            n3 = n4;
        }
        this.fleetSizeNum = n2;
    }

    public boolean knowsWhoPlayerIs() {
        if (this.getFaction().isPlayerFaction()) {
            return true;
        }
        boolean bl = Global.getSector().getPlayerFleet().isTransponderOn() || this.getMemoryWithoutUpdate().getBoolean("$sawPlayerTransponderOn") || Global.getSector().getPlayerFleet().hasShipsWithUniqueSig();
        return bl;
    }

    public boolean isHostileTo(SectorEntityToken sectorEntityToken) {
        if (sectorEntityToken instanceof CampaignFleetAPI) {
            if (this.getAI() == null) {
                if (Misc.isPlayerOrCombinedPlayerPrimary((CampaignFleetAPI)((CampaignFleetAPI)sectorEntityToken))) {
                    if (this.getMemoryWithoutUpdate().is("$cfai_makeHostile", true)) {
                        return true;
                    }
                    if (this.getMemoryWithoutUpdate().is("$cfai_makeNonHostile", true)) {
                        return false;
                    }
                    if (this.getMemoryWithoutUpdate().is("$cfai_makeHostileWhileTOff", true) && !Global.getSector().getPlayerFleet().isTransponderOn()) {
                        return true;
                    }
                }
                if (sectorEntityToken.getFaction().isPlayerFaction()) {
                    if (this.getMemoryWithoutUpdate().is("$cfai_makeHostile", true)) {
                        return true;
                    }
                    if (this.getMemoryWithoutUpdate().is("$cfai_makeNonHostile", true)) {
                        return false;
                    }
                }
                if (this.getFaction().isPlayerFaction() && sectorEntityToken.getMemoryWithoutUpdate().is("$cfai_makeHostile", true)) {
                    return true;
                }
            }
            boolean bl = this.getAI() != null && this.getAI().isHostileTo((CampaignFleetAPI)sectorEntityToken);
            bl |= ((CampaignFleetAPI)sectorEntityToken).getAI() != null && ((CampaignFleetAPI)sectorEntityToken).getAI().isHostileTo((CampaignFleetAPI)this);
            if (this.getAI() == null) {
                bl |= this.getFaction().isHostileTo(sectorEntityToken.getFaction());
            }
            return bl;
        }
        return this.getFaction().isHostileTo(sectorEntityToken.getFaction());
    }

    public boolean isFriendlyTo(SectorEntityToken sectorEntityToken) {
        if (sectorEntityToken instanceof CampaignFleetAPI && Misc.isPlayerOrCombinedPlayerPrimary((CampaignFleetAPI)((CampaignFleetAPI)sectorEntityToken)) && !sectorEntityToken.isTransponderOn() && !this.knowsWhoPlayerIs()) {
            return false;
        }
        return this.getFaction().isAtWorst(sectorEntityToken.getFaction(), RepLevel.FRIENDLY);
    }

    public List<FleetMemberViewAPI> getViews() {
        return new ArrayList<FleetMemberViewAPI>(this.fleetView.getViews());
    }

    public FleetMemberViewAPI getViewForMember(FleetMemberAPI fleetMemberAPI) {
        return this.fleetView.getViewForMember((FleetMember)fleetMemberAPI);
    }

    public float getCurrBurnLevel() {
        float f2 = this.getVelocity().length();
        float f3 = C.getBurnLevelForSpeed(f2);
        return Math.round(f3);
    }

    public BattleAPI getBattle() {
        return this.battle;
    }

    public void setBattle(BattleAPI battleAPI) {
        this.battle = (Battle)battleAPI;
    }

    @Override
    public StatBonus getDetectedRangeMod() {
        return this.getStats().getDetectedRangeMod();
    }

    @Override
    public StatBonus getSensorRangeMod() {
        return this.getStats().getSensorRangeMod();
    }

    public void addAssignmentAtStart(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2, String string, Script script) {
        if (this.ai != null) {
            this.ai.addAssignmentAtStart(fleetAssignment, sectorEntityToken, f2, string, script);
        }
    }

    public void addAssignmentAtStart(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2, Script script) {
        if (this.ai != null) {
            this.ai.addAssignmentAtStart(fleetAssignment, sectorEntityToken, f2, script);
        }
    }

    public List<FleetAssignmentDataAPI> getAssignmentsCopy() {
        if (this.ai != null && this.ai instanceof ModularFleetAIAPI) {
            ModularFleetAIAPI modularFleetAIAPI = (ModularFleetAIAPI)this.ai;
            return modularFleetAIAPI.getAssignmentModule().getAssignmentsCopy();
        }
        return new ArrayList<FleetAssignmentDataAPI>();
    }

    public FleetAssignmentDataAPI getCurrentAssignment() {
        if (this.ai != null && this.ai instanceof ModularFleetAIAPI) {
            ModularFleetAIAPI modularFleetAIAPI = (ModularFleetAIAPI)this.ai;
            return modularFleetAIAPI.getAssignmentModule().getCurrentAssignment();
        }
        return null;
    }

    public boolean isCurrentAssignment(FleetAssignment fleetAssignment) {
        if (this.ai != null && this.ai instanceof ModularFleetAIAPI) {
            ModularFleetAIAPI modularFleetAIAPI = (ModularFleetAIAPI)this.ai;
            return modularFleetAIAPI.isCurrentAssignment(fleetAssignment);
        }
        return false;
    }

    public void removeFirstAssignment() {
        if (this.ai != null && this.ai instanceof ModularFleetAIAPI) {
            ModularFleetAIAPI modularFleetAIAPI = (ModularFleetAIAPI)this.ai;
            modularFleetAIAPI.removeFirstAssignment();
        }
    }

    public void removeFirstAssignmentIfItIs(FleetAssignment fleetAssignment) {
        if (this.ai != null && this.ai instanceof ModularFleetAIAPI) {
            ModularFleetAIAPI modularFleetAIAPI = (ModularFleetAIAPI)this.ai;
            modularFleetAIAPI.removeFirstAssignmentIfItIs(fleetAssignment);
        }
    }

    public void addEventListener(FleetEventListener fleetEventListener) {
        if (this.despawnListeners == null) {
            this.despawnListeners = new ArrayList<FleetEventListener>();
        }
        this.despawnListeners.add(fleetEventListener);
    }

    public void removeEventListener(FleetEventListener fleetEventListener) {
        if (this.despawnListeners == null) {
            return;
        }
        this.despawnListeners.remove(fleetEventListener);
    }

    public void despawn() {
        this.despawn(CampaignEventListener.FleetDespawnReason.NO_REASON_PROVIDED, null);
    }

    public Boolean getAbortDespawn() {
        return this.abortDespawn;
    }

    public void setAbortDespawn(Boolean bl) {
        this.abortDespawn = bl;
    }

    public void despawn(CampaignEventListener.FleetDespawnReason fleetDespawnReason, Object object) {
        this.fadeAndExpire = true;
        CampaignEngine.getInstance().reportFleetDespawned(this, fleetDespawnReason, object);
        if (this.despawnListeners != null) {
            for (FleetEventListener fleetEventListener : new ArrayList<FleetEventListener>(this.despawnListeners)) {
                fleetEventListener.reportFleetDespawnedToListener((CampaignFleetAPI)this, fleetDespawnReason, object);
            }
        }
        ListenerUtil.reportFleetDespawnedToListener((CampaignFleetAPI)this, (CampaignEventListener.FleetDespawnReason)fleetDespawnReason, (Object)object);
        if (this.getAbortDespawn() != null && this.getAbortDespawn().booleanValue()) {
            this.fadeAndExpire = null;
            this.setAbortDespawn(null);
        } else {
            this.fleetData.clear();
            this.getSensorFader().setDurationOut(1.0f);
            this.getSensorFader().fadeOut();
        }
    }

    public boolean isDespawning() {
        return this.fadeAndExpire != null && this.fadeAndExpire != false;
    }

    public boolean isFleet() {
        return true;
    }

    public boolean isStub() {
        return false;
    }

    public List<FleetEventListener> getEventListeners() {
        if (this.despawnListeners == null) {
            return new ArrayList<FleetEventListener>();
        }
        return this.despawnListeners;
    }

    public boolean isStar() {
        return false;
    }

    public boolean wasSlowMoving() {
        return this.wasSlowMoving != null && this.wasSlowMoving != false;
    }

    public void goSlowOneFrame() {
        this.goSlowOneFrame = true;
    }

    public void goSlowOneFrame(boolean bl) {
        this.goSlowOneFrame = true;
        this.goSlowStop = bl ? Boolean.valueOf(true) : null;
    }

    public boolean getGoSlowOneFrame() {
        return this.goSlowOneFrame != null;
    }

    public boolean getGoSlowStop() {
        return this.goSlowStop != null;
    }

    protected void doGoSlow(float f2) {
        if (f2 <= 0.0f) {
            return;
        }
        if (!CampaignEngine.getInstance().isFastForwardIteration()) {
            this.resetAfterGoingSlowIfNeeded();
        }
        this.goSlowOneFrameIfNeeded(f2);
    }

    protected void resetAfterGoingSlowIfNeeded() {
        if (this.wasSlowMoving != null && this.wasSlowMoving.booleanValue() && (this.goSlowOneFrame == null || !this.goSlowOneFrame.booleanValue())) {
            this.setMoveDestination(this.getLocation().x, this.getLocation().y);
            this.wasSlowMoving = null;
            this.getMovementModule().setHardSpeedLimit(-1.0f);
        }
    }

    protected void goSlowOneFrameIfNeeded(float f2) {
        if (this.goSlowOneFrame == null || !this.goSlowOneFrame.booleanValue()) {
            return;
        }
        this.goSlowOneFrame = null;
        this.wasSlowMoving = true;
        boolean bl = this.goSlowStop != null && this.goSlowStop != false;
        this.goSlowStop = null;
        float f3 = Misc.getSpeedForBurnLevel((float)Misc.getGoSlowBurnLevel((CampaignFleetAPI)this));
        if (bl) {
            f3 = 0.0f;
        }
        Vector2f vector2f = this.getMovementModule().getVelocity();
        float f4 = vector2f.length();
        Vector2f vector2f2 = new Vector2f((ReadableVector2f)vector2f);
        vector2f2.negate();
        Utils.super(vector2f2);
        float f5 = this.getMovementModule().getAcceleration() * 1.0f;
        float f6 = f4 - f3;
        if (f6 > f5 * 0.1f) {
            vector2f2.scale(10000.0f);
            Vector2f.add((Vector2f)vector2f2, (Vector2f)this.getLocation(), (Vector2f)vector2f2);
            this.setMoveDestination(vector2f2.x, vector2f2.y);
        } else if (f6 > 0.0f) {
            if (bl) {
                this.setMoveDestination(this.getLocation().x, this.getLocation().y);
            }
            Vector2f vector2f3 = new Vector2f((ReadableVector2f)vector2f);
            vector2f3.negate();
            Utils.super(vector2f3);
            float f7 = f5 * 1.0f;
            if (f7 * f2 > f4 - f3 && f2 > 0.0f) {
                f7 = (f4 - f3) / f2;
            }
            if (f7 < 0.0f) {
                f7 = 0.0f;
            }
            vector2f3.scale(f7);
            vector2f.x += vector2f3.x * f2;
            vector2f.y += vector2f3.y * f2;
            this.getMovementModule().setHardSpeedLimit(Math.max(f3, vector2f.length()));
        }
    }

    public int getNumShips() {
        if (this.getFleetData() == null) {
            return 0;
        }
        List<FleetMember> list = this.getFleetData().getMembers();
        if (list == null) {
            return 0;
        }
        return list.size();
    }
}

