/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.fleet;

import com.fs.starfarer.campaign.fleet.CampaignFleet;
import com.fs.starfarer.prototype.Utils;
import com.fs.util.DoNotObfuscate;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SmoothMovementModule
implements DoNotObfuscate {
    private Vector2f vel = new Vector2f();
    private Vector2f loc = new Vector2f();
    private Vector2f accel = new Vector2f();
    private float acceleration;
    private float maxSpeed;
    private MovementModuleDelegate delegate = null;
    private boolean smoothCap = false;
    private float hardSpeedLimit = -1.0f;

    public float getHardSpeedLimit() {
        return this.hardSpeedLimit;
    }

    public void setHardSpeedLimit(float f2) {
        this.hardSpeedLimit = f2;
    }

    public SmoothMovementModule(float f2, float f3, MovementModuleDelegate movementModuleDelegate) {
        this(f2, f3);
        this.delegate = movementModuleDelegate;
        this.smoothCap = true;
    }

    public SmoothMovementModule(float f2, float f3) {
        this.acceleration = f2;
        this.maxSpeed = f3;
    }

    public void advance(CampaignFleet campaignFleet, Vector2f vector2f, Vector2f vector2f2, float f2) {
        if (f2 * f2 == 0.0f || f2 <= 0.0f) {
            return;
        }
        float f3 = this.maxSpeed;
        float f4 = 1.0f;
        float f5 = this.vel.length();
        float f6 = this.acceleration;
        float f7 = f6 * f4;
        if (this.delegate != null) {
            f3 = this.getEffectiveMaxSpeed();
        }
        if (f7 <= 0.0f) {
            this.accel.set(0.0f, 0.0f);
            return;
        }
        Vector2f vector2f3 = Vector2f.sub((Vector2f)vector2f, (Vector2f)this.loc, (Vector2f)new Vector2f());
        Vector2f vector2f4 = Vector2f.sub((Vector2f)vector2f2, (Vector2f)this.vel, (Vector2f)new Vector2f());
        vector2f3.scale(3.0f);
        float f8 = vector2f4.length() / f7;
        vector2f4.scale(f8 + 0.75f);
        Vector2f vector2f5 = (Vector2f)Vector2f.add((Vector2f)vector2f3, (Vector2f)vector2f4, (Vector2f)new Vector2f()).negate();
        float f9 = vector2f5.length() / (f2 * f2);
        if (f9 > f7) {
            f9 = f7;
        }
        this.accel = f9 > 0.0f ? (Vector2f)Utils.super(vector2f5).scale(-f9) : (Vector2f)vector2f5.negate();
        this.vel.x += this.accel.x * f2;
        this.vel.y += this.accel.y * f2;
        f5 = this.vel.length();
        if (f5 >= f3 && f5 > 0.0f) {
            if (this.smoothCap) {
                Vector2f vector2f6 = new Vector2f((ReadableVector2f)this.vel);
                vector2f6.negate();
                Utils.super(vector2f6);
                float f10 = f5 - f3;
                if (f10 < 50.0f) {
                    f10 = 50.0f;
                }
                float f11 = f9 * 2.0f;
                if (campaignFleet != null) {
                    float f12 = campaignFleet.getFleetData().getTravelSpeed();
                    f11 = f9 + f12;
                }
                if (f10 < f11) {
                    f10 = f11;
                }
                if (f10 * f2 > f5 - f3 && f2 > 0.0f) {
                    f10 = (f5 - f3) / f2;
                }
                vector2f6.scale(f10);
                this.vel.x += vector2f6.x * f2;
                this.vel.y += vector2f6.y * f2;
            } else {
                this.vel.scale(f3 / f5);
            }
        }
        if (this.hardSpeedLimit >= 0.0f && f5 > 0.0f) {
            this.vel.scale(this.hardSpeedLimit / f5);
        }
        boolean bl = false;
        if (campaignFleet != null) {
            vector2f2.length();
        }
        if (!bl) {
            this.loc.x += this.vel.x * f2;
            this.loc.y += this.vel.y * f2;
        }
    }

    public ReadableVector2f getAccelVector() {
        return this.accel;
    }

    public float getAcceleration() {
        return this.acceleration;
    }

    public void setAcceleration(float f2) {
        this.acceleration = f2;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public float getEffectiveMaxSpeed() {
        if (this.delegate == null) {
            return this.maxSpeed;
        }
        return this.delegate.getTravelSpeed();
    }

    public void setMaxSpeed(float f2) {
        this.maxSpeed = f2;
    }

    public Vector2f getVelocity() {
        return this.vel;
    }

    public Vector2f getLocation() {
        return this.loc;
    }

    public static interface MovementModuleDelegate
    extends DoNotObfuscate {
        public float getTravelSpeed();
    }
}

