/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.rules;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.econ.Market;
import com.fs.util.DoNotObfuscate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.lwjgl.util.vector.Vector2f;

public class Memory
implements DoNotObfuscate,
MemoryAPI {
    private LinkedHashMap<String, Object> data = new LinkedHashMap();
    private List<Expire> expire = new ArrayList<Expire>();
    private LinkedHashMap<String, Require> require = new LinkedHashMap();
    private LinkedHashMap<String, String> reqFor = new LinkedHashMap();
    transient boolean restored = false;
    public static final String EN_REF = "enRef_";
    public static final String M_REF = "mRef_";

    public void clear() {
        this.data.clear();
        this.expire.clear();
        this.require.clear();
        this.reqFor.clear();
    }

    Object readResolve() {
        if (this.data == null) {
            this.data = new LinkedHashMap();
        }
        if (this.expire == null) {
            this.expire = new ArrayList<Expire>();
        }
        if (this.require == null) {
            this.require = new LinkedHashMap();
        }
        if (this.reqFor == null) {
            this.reqFor = new LinkedHashMap();
        }
        this.restored = false;
        return this;
    }

    Object writeReplace() {
        Memory memory = new Memory();
        memory.data = new LinkedHashMap();
        memory.data.putAll(this.data);
        memory.expire = this.expire;
        memory.require = this.require;
        memory.reqFor = this.reqFor;
        if (this.expire.isEmpty() || this.require.isEmpty() || this.reqFor.isEmpty()) {
            if (this.expire.isEmpty()) {
                memory.expire = null;
            }
            if (this.require.isEmpty()) {
                memory.require = null;
            }
            if (this.reqFor.isEmpty()) {
                memory.reqFor = null;
            }
        }
        this.replaceEntitiesWithIds(memory.data);
        return memory;
    }

    public void replaceEntitiesWithIds(LinkedHashMap<String, Object> linkedHashMap) {
        for (String string : new ArrayList<String>(linkedHashMap.keySet())) {
            Object object;
            Object object2 = linkedHashMap.get(string);
            if (object2 instanceof SectorEntityToken) {
                object = (SectorEntityToken)object2;
                if (!object.isAlive()) continue;
                linkedHashMap.put(string, EN_REF + object.getId());
                continue;
            }
            if (!(object2 instanceof Market)) continue;
            object = (Market)object2;
            if (Global.getSector().getEconomy().getMarket(((Market)object).getId()) != object) continue;
            linkedHashMap.put(string, M_REF + ((Market)object).getId());
        }
    }

    public void replaceIdsWithEntities(LinkedHashMap<String, Object> linkedHashMap) {
        for (String string : new ArrayList<String>(linkedHashMap.keySet())) {
            SectorEntityToken sectorEntityToken;
            Object object = linkedHashMap.get(string);
            if (!(object instanceof String)) continue;
            String string2 = (String)object;
            if (string2.startsWith(EN_REF)) {
                string2 = string2.replaceFirst(EN_REF, "");
                sectorEntityToken = Global.getSector().getEntityById(string2);
                if (sectorEntityToken != null) {
                    linkedHashMap.put(string, sectorEntityToken);
                    continue;
                }
                linkedHashMap.remove(string);
                continue;
            }
            if (!string2.startsWith(M_REF)) continue;
            string2 = string2.replaceFirst(M_REF, "");
            sectorEntityToken = Global.getSector().getEconomy().getMarket(string2);
            if (sectorEntityToken != null) {
                linkedHashMap.put(string, sectorEntityToken);
                continue;
            }
            linkedHashMap.remove(string);
        }
    }

    public void advance(float f2) {
        if (!this.restored) {
            this.replaceIdsWithEntities(this.data);
            this.restored = true;
        }
        if (CampaignEngine.getInstance().isPaused()) {
            return;
        }
        float f3 = CampaignEngine.getInstance().getClock().convertToDays(f2);
        Iterator<Expire> iterator = this.expire.iterator();
        while (iterator.hasNext()) {
            Expire expire = iterator.next();
            expire.timeLeft -= f3;
            if (!(expire.timeLeft < 0.0f)) continue;
            this.unset(expire.key);
            iterator.remove();
        }
        for (Require require : this.require.values()) {
            boolean bl = false;
            for (String string : require.req) {
                if (!this.contains(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.require.remove(require.key);
            this.unset(require.key);
        }
    }

    public float getExpire(String string) {
        for (Expire expire : this.expire) {
            if (!expire.key.equals(string)) continue;
            return expire.timeLeft;
        }
        return -1.0f;
    }

    public Collection<String> getKeys() {
        return this.data.keySet();
    }

    public void expire(String string, float f2) {
        Expire expire2;
        for (Expire expire2 : this.expire) {
            if (!expire2.key.equals(string)) continue;
            expire2.timeLeft = f2;
            if (f2 < 0.0f) {
                this.expire.remove(expire2);
            }
            return;
        }
        if (f2 < 0.0f) {
            return;
        }
        expire2 = new Expire();
        expire2.key = string;
        expire2.timeLeft = f2;
        this.expire.add(expire2);
    }

    public void addRequired(String string, String string2) {
        Require require = this.require.get(string);
        if (require == null) {
            require = new Require();
            require.key = string;
            this.require.put(string, require);
        }
        require.req.add(string2);
        this.reqFor.put(string2, string);
    }

    public void removeRequired(String string, String string2) {
        Require require = this.require.get(string);
        if (require == null) {
            return;
        }
        require.req.remove(string2);
        if (require.req.isEmpty()) {
            this.require.remove(string);
        }
        this.reqFor.remove(string2);
    }

    public Set<String> getRequired(String string) {
        Require require = this.require.get(string);
        if (require == null || require.req == null) {
            return new LinkedHashSet<String>();
        }
        return require.req;
    }

    public void removeAllRequired(String string) {
        for (String string2 : new ArrayList<String>(this.getRequired(string))) {
            this.unset(string2);
        }
    }

    public void unset(String string) {
        Require require;
        String string2 = (String)this.reqFor.remove(string);
        this.data.remove(string);
        if (string2 != null && (require = this.require.get(string2)) != null) {
            boolean bl = false;
            for (String string3 : require.req) {
                if (!this.contains(string3)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.require.remove(require.key);
                this.unset(require.key);
            }
        }
    }

    public boolean contains(String string) {
        if (!this.restored) {
            this.replaceIdsWithEntities(this.data);
            this.restored = true;
        }
        return this.data.containsKey(string);
    }

    public boolean is(String string, Object object) {
        return this.contains(string) && this.data.get(string).equals(object);
    }

    public boolean is(String string, float f2) {
        return this.contains(string) && this.getFloat(string) == f2;
    }

    public boolean is(String string, boolean bl) {
        return this.contains(string) && this.getBoolean(string) == bl;
    }

    public void set(String string, Object object) {
        if (!string.startsWith("$")) {
            throw new RuntimeException("Key " + string + " should start with $");
        }
        this.data.put(string, object);
        Iterator<Expire> iterator = this.expire.iterator();
        while (iterator.hasNext()) {
            Expire expire = iterator.next();
            if (!expire.key.equals(string)) continue;
            iterator.remove();
            break;
        }
    }

    public void set(String string, Object object, float f2) {
        if (!string.startsWith("$")) {
            throw new RuntimeException("Key " + string + " should start with $");
        }
        this.data.put(string, object);
        this.expire(string, f2);
    }

    public Object get(String string) {
        if (!this.restored) {
            this.replaceIdsWithEntities(this.data);
            this.restored = true;
        }
        return this.data.get(string);
    }

    public SectorEntityToken getEntity(String string) {
        if (!this.restored) {
            this.replaceIdsWithEntities(this.data);
            this.restored = true;
        }
        if (this.data.get(string) instanceof SectorEntityToken) {
            return (SectorEntityToken)this.data.get(string);
        }
        return null;
    }

    public String getString(String string) {
        if (this.data.containsKey(string)) {
            return this.data.get(string).toString();
        }
        return null;
    }

    public float getFloat(String string) {
        if (this.data.containsKey(string)) {
            Object object = this.data.get(string);
            if (object instanceof Float) {
                return ((Float)object).floatValue();
            }
            return Memory.parseFloat(object);
        }
        return 0.0f;
    }

    public static float parseFloat(Object object) {
        try {
            return Float.parseFloat(object.toString());
        }
        catch (Exception exception) {
            try {
                if (((String)object).endsWith("\u00a2")) {
                    object = ((String)object).substring(0, ((String)object).length() - 1);
                }
                return Misc.getFormat().parse(object.toString()).floatValue();
            }
            catch (ParseException parseException) {
                throw new RuntimeException(parseException);
            }
        }
    }

    public long getLong(String string) {
        if (this.data.containsKey(string)) {
            Object object = this.data.get(string);
            if (object instanceof Long) {
                return (Long)object;
            }
            try {
                return Long.parseLong(object.toString());
            }
            catch (Throwable throwable) {
                return (long)Float.parseFloat(object.toString());
            }
        }
        return 0L;
    }

    public int getInt(String string) {
        if (this.data.containsKey(string)) {
            Object object = this.data.get(string);
            if (object instanceof Integer) {
                return (Integer)object;
            }
            try {
                return Integer.parseInt(object.toString());
            }
            catch (Throwable throwable) {
                return (int)Float.parseFloat(object.toString());
            }
        }
        return 0;
    }

    public boolean getBoolean(String string) {
        String string2 = this.getString(string);
        if (string2 != null) {
            return string2.toLowerCase().trim().equals("true");
        }
        return false;
    }

    public Vector2f getVector2f(String string) {
        if (this.data.get(string) instanceof Vector2f) {
            return (Vector2f)this.data.get(string);
        }
        return null;
    }

    public CampaignFleetAPI getFleet(String string) {
        if (this.data.get(string) instanceof CampaignFleetAPI) {
            return (CampaignFleetAPI)this.data.get(string);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public boolean between(String string, float f2, float f3) {
        if (!this.contains(string)) {
            return false;
        }
        float f4 = this.getFloat(string);
        return f4 >= f2 && f4 <= f3;
    }

    public static void main(String[] stringArray) {
        Memory memory = new Memory();
        memory.set("key", true);
        System.out.println(memory.is("key", true));
        System.out.println(memory.is("key", "true"));
        System.out.println(new Float(1.2342343f).toString());
        System.out.println(new Memory().toString());
        System.out.println(new Boolean(true).toString());
    }

    public static class Expire
    implements DoNotObfuscate {
        String key;
        float timeLeft;
    }

    public static class Require
    implements DoNotObfuscate {
        String key;
        LinkedHashSet<String> req = new LinkedHashSet();
    }
}

