/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.combat.entities;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.OnHitEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.ApplyDamageResultAPI;
import com.fs.starfarer.api.loading.ProjectileSpawnType;
import com.fs.starfarer.api.loading.ProjectileSpecAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.combat.CombatEngine;
import com.fs.starfarer.combat.CombatViewport;
import com.fs.starfarer.combat.E.D;
import com.fs.starfarer.combat.E.new;
import com.fs.starfarer.combat.ai.ProximityFuseAI;
import com.fs.starfarer.combat.entities.B;
import com.fs.starfarer.combat.entities.BaseEntity;
import com.fs.starfarer.combat.entities.F;
import com.fs.starfarer.combat.entities.Missile;
import com.fs.starfarer.combat.entities.Ship;
import com.fs.starfarer.combat.entities.ship.A.o0OO;
import com.fs.starfarer.combat.entities.ship.E;
import com.fs.starfarer.combat.entities.ship.G;
import com.fs.starfarer.combat.systems.Q;
import com.fs.starfarer.loading.specs.OOoO;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.renderers.N;
import com.fs.starfarer.renderers.O0oO;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class BallisticProjectile
extends BaseEntity
implements F,
DamagingProjectileAPI,
ProximityFuseAI.o {
    private Ship source;
    private com.fs.starfarer.combat.E.F damage;
    private OOoO spec;
    private N.o projAnimator;
    private boolean didDamage = false;
    private B trailExtender;
    private float health;
    private CombatEngine engine;
    private O0oO shine;
    private OnHitEffectPlugin effect = null;
    private final Q weapon;
    private List<new> damagedAlready;
    private Vector2f spawnLocation = new Vector2f();
    private float elapsed = 0.0f;
    private new damageTarget;
    private EnumSet<CombatEngineLayers> layers = EnumSet.of(CombatEngineLayers.ABOVE_SHIPS_LAYER);
    private boolean fromMissile = false;

    public BallisticProjectile(Ship ship, Q q, OOoO oOoO2, Vector2f vector2f, Vector2f vector2f2, float f2) {
        float f3;
        float f4;
        this.source = ship;
        this.weapon = q;
        this.spec = oOoO2;
        this.damage = oOoO2.getDamage().clone();
        this.damage.setStats(ship.getStats());
        if (oOoO2.isPassThroughMissiles() || oOoO2.isPassThroughFighters()) {
            this.damagedAlready = new ArrayList<new>();
        }
        this.spawnLocation.set((ReadableVector2f)vector2f);
        float[] fArray = E.computeExtraDamageComponents(ship, q);
        if (fArray != null) {
            this.damage.getModifier().modifyPercent("core_edc_0", fArray[0]);
            this.damage.getModifier().modifyFlat("core_edc_1", fArray[1]);
            this.damage.getModifier().modifyMult("core_edc_2", fArray[2]);
        }
        this.engine = CombatEngine.getInstance();
        this.projAnimator = new N.o(oOoO2.getBulletSpriteName());
        this.effect = oOoO2.getOnHitEffect();
        this.setOwner(ship.getOwner());
        this.getVelocity().set((ReadableVector2f)vector2f2);
        this.getLocation().set((ReadableVector2f)vector2f);
        this.setFacing(f2);
        if (oOoO2.getGlowRadius() > 0.0f) {
            this.shine = new O0oO(oOoO2.getGlowRadius(), oOoO2.getWidth() * 1.5f, oOoO2.getGlowColor());
        }
        Vector2f vector2f3 = Utils.\u00d300000(f2);
        this.setCollisionRadius(oOoO2.getWidth() / 2.0f);
        float f5 = 0.0f;
        if (oOoO2.getBehaviorSpec() != null && oOoO2.getBehaviorSpec().getParams() != null) {
            f5 = (float)oOoO2.getBehaviorSpec().getParams().optDouble("shotRangeVariance", 0.0);
            f4 = (float)oOoO2.getBehaviorSpec().getParams().optDouble("probOfVariance", 1.0);
            if ((float)Math.random() >= f4) {
                f5 = 0.0f;
            }
        }
        f4 = E.getAdjustedBaseRange(oOoO2.getMaxRange(), ship, q);
        float f6 = E.getThresholdAdjustedRange(ship, q, f4 * (1.0f - f5 * (float)Math.random()) * E.computeExtraRangeMult(ship, q) + E.computeExtraRangeFlat(ship, q)) / oOoO2.getMoveSpeed(ship.getStats(), q);
        this.trailExtender = new B(vector2f, vector2f3, oOoO2.getLength(), oOoO2.getMoveSpeed(ship.getStats(), q), f6, oOoO2.getFadeTime());
        D d2 = new D();
        float f7 = oOoO2.getWidth() * 0.5f;
        float f8 = Math.min(oOoO2.getLength() * 0.75f, f7 * 5.0f);
        if (f8 < (f3 = oOoO2.getMoveSpeed(ship.getStats(), q) * 1.0f / 30.0f * 3.0f)) {
            f8 = f3;
        }
        d2.addSegment(f7 / 2.0f, 0.0f, -f8, 0.0f);
        d2.addSegment(f7 / 2.0f, f7 / 2.0f, f7 / 2.0f, -f7 / 2.0f);
        this.setBounds(d2);
        this.health = oOoO2.getMaxHealth();
    }

    public Vector2f getSpawnLocation() {
        return this.spawnLocation;
    }

    @Override
    public void setFacing(float f2) {
        super.setFacing(f2);
        if (this.trailExtender != null) {
            this.trailExtender.super(Utils.\u00d300000(f2));
        }
    }

    @Override
    public WeaponAPI getWeapon() {
        return this.weapon;
    }

    @Override
    public boolean canCauseInsideBoundsCollision() {
        if (this.source != null && !this.source.isFighter()) {
            return true;
        }
        float f2 = this.spec.getMoveSpeed(this.source.getStats(), this.weapon);
        if (f2 <= 50.0f) {
            return this.elapsed > 0.5f;
        }
        return this.elapsed > 50.0f / f2;
    }

    @Override
    public void advance(float f2) {
        this.elapsed += f2;
        float f3 = 1.0f - this.trailExtender.String();
        if (this.trailExtender.\u00d200000()) {
            f3 = 1.0f;
        }
        f3 *= f3;
        if (this.didDamage) {
            f3 = 0.0f;
        }
        this.damage.setMultiplier(f3);
        if (this.isFading()) {
            this.damage.setSoftFlux(true);
        }
        this.projAnimator.o00000(f2, this.spec.getTextureScrollSpeed());
        this.trailExtender.super(f2, this.getLocation(), this.didDamage);
    }

    @Override
    public void render(CombatEngineLayers combatEngineLayers, CombatViewport combatViewport) {
        if (!combatViewport.isNearViewport(this.getLocation(), this.spec.getLength() * 1.5f)) {
            return;
        }
        Vector2f vector2f = this.trailExtender.\u00d600000();
        Vector2f vector2f2 = this.getLocation();
        float f2 = this.trailExtender.super();
        if (this.shine != null) {
            this.shine.o00000(vector2f2.x, vector2f2.y, f2, false);
        }
        N.super(this.projAnimator, this.getVelocity(), this.spec.getFringeColor(), this.spec.getCoreColor(), vector2f2, vector2f, this.spec.getWidth(), this.spec.getCoreWidthMult(), f2);
    }

    @Override
    public com.fs.starfarer.combat.E.F getDamage(Vector2f vector2f, new new_) {
        if (this.damagedAlready != null && this.damagedAlready.contains(new_)) {
            return new com.fs.starfarer.combat.E.F(0.0f, false, this.damage.getType(), this.source.getStats());
        }
        return this.damage;
    }

    public com.fs.starfarer.combat.E.F getDamage() {
        return this.damage;
    }

    public void setDamage(com.fs.starfarer.combat.E.F f2) {
        this.damage = f2;
    }

    @Override
    public Ship getSource() {
        return this.source;
    }

    public void setSource(ShipAPI shipAPI) {
        this.source = (Ship)shipAPI;
    }

    @Override
    public boolean isDestroyedByCollision(new new_) {
        return false;
    }

    @Override
    public F.o notifyDealtDamage(Vector2f vector2f, G g2, new new_) {
        this.setDidDamage(vector2f, new_, g2);
        if (this.damagedAlready != null) {
            this.damagedAlready.add(new_);
        }
        if (this.damagedAlready != null && !this.didDamage) {
            return F.o.new;
        }
        return F.o.\u00d400000;
    }

    @Override
    public boolean didDamage() {
        return this.didDamage;
    }

    private void setDidDamage(Vector2f vector2f, new new_, G g2) {
        if (!(this.didDamage || this.damagedAlready != null && this.damagedAlready.contains(new_))) {
            this.damageTarget = new_;
            float f2 = this.spec.getHitGlowRadius();
            if (f2 == 0.0f) {
                f2 = this.spec.getLength() * 2.0f;
            }
            float f3 = f2 / 1.0f;
            float f4 = f2 / 2.0f;
            boolean bl = false;
            if (this.damagedAlready != null) {
                if (this.spec.isPassThroughMissiles() && new_ instanceof Missile) {
                    bl = true;
                } else if (this.spec.isPassThroughFighters() && new_ instanceof Ship && ((Ship)new_).isFighter() && (!this.spec.isPassThroughFightersOnlyWhenDestroyed() || new_.getHitpoints() <= 0.0f)) {
                    bl = true;
                }
            }
            if (!bl) {
                this.didDamage = true;
            }
            float f5 = f3 + (float)Math.random() * f4;
            f5 = Misc.getHitGlowSize((float)f5, (float)this.getDamage().getBaseDamage(), (ApplyDamageResultAPI)g2);
            if (!this.didDamage) {
                f5 *= 0.5f;
            }
            o0OO.o00000(vector2f, g2, f5, new_, this.spec.getFringeColor(), this.damage.getMultiplier() * 0.4f, this.damage.getMultiplier());
            if ((this.didDamage || this.spec.isApplyOnHitEffectWhenPassThrough()) && this.effect != null) {
                this.effect.onHit((DamagingProjectileAPI)this, (CombatEntityAPI)new_, vector2f, g2.getDamageToShields() > 0.0f, (ApplyDamageResultAPI)g2, (CombatEngineAPI)CombatEngine.getInstance());
            }
        }
    }

    public CombatEntityAPI getDamageTarget() {
        return this.damageTarget instanceof CombatEntityAPI ? this.damageTarget : null;
    }

    @Override
    public G applyDamage(Vector2f vector2f, com.fs.starfarer.combat.E.F f2, boolean bl, float f3, Object object) {
        if (this.health <= 0.0f) {
            return new G();
        }
        float f4 = f2.computeDamageDealt(f3);
        if (f4 > this.health) {
            f4 = this.health;
        }
        this.health -= f4;
        if (this.health <= 0.0f) {
            this.setDidDamage(this.getLocation(), null, new G());
            boolean bl2 = this.engine.getViewport().isNearViewport(vector2f, this.getCollisionRadius() * 1.5f);
            if (bl2) {
                CombatEngine.getInstance().getExplosionSystem().spawnExplosion(this);
            }
            this.getVelocity().set(0.0f, 0.0f);
        }
        return new G(f2.getType(), f4, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public void cleanup() {
    }

    @Override
    public EnumSet<CombatEngineLayers> getActiveLayers() {
        return this.layers;
    }

    @Override
    public void init() {
    }

    @Override
    public boolean isExpired() {
        return this.trailExtender.void() || this.health < 0.0f;
    }

    @Override
    public float getMass() {
        return this.spec.getImpactMass();
    }

    public float getMoveSpeed() {
        return this.spec.getMoveSpeed(this.source.getStats(), this.weapon);
    }

    public float getBrightness() {
        return this.trailExtender.super();
    }

    @Override
    public boolean isFading() {
        return this.trailExtender.String() > 0.0f;
    }

    public void setDamageAmount(float f2) {
        this.damage.setDamage(f2);
    }

    public float getDamageAmount() {
        return this.damage.getDamage();
    }

    public float getBaseDamageAmount() {
        return this.damage.getBaseDamage();
    }

    public float getEmpAmount() {
        return this.damage.getFluxComponent();
    }

    public DamageType getDamageType() {
        return this.damage.getType();
    }

    public String getProjectileSpecId() {
        return this.spec.getId();
    }

    public ProjectileSpawnType getSpawnType() {
        return this.spec.getSpawnType();
    }

    public float getElapsed() {
        return this.elapsed;
    }

    @Override
    public boolean isFromMissile() {
        return this.fromMissile;
    }

    public void setFromMissile(boolean bl) {
        this.fromMissile = bl;
    }

    public void addDamagedAlready(CombatEntityAPI combatEntityAPI) {
    }

    public void removeDamagedAlready(CombatEntityAPI combatEntityAPI) {
    }

    public ProjectileSpecAPI getProjectileSpec() {
        return this.spec;
    }

    public Vector2f getTailEnd() {
        return this.trailExtender.\u00d600000();
    }

    public List<CombatEntityAPI> getDamagedAlready() {
        return null;
    }
}

