/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.prototype.entities;

import com.fs.graphics.LayeredRenderable;
import com.fs.graphics.Sprite;
import com.fs.starfarer.prototype.C;
import com.fs.starfarer.prototype.G;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.prototype.entities.Object;
import com.fs.starfarer.prototype.entities.OoOO;
import com.fs.starfarer.prototype.entities.String;
import com.fs.starfarer.prototype.oooO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class Ship
extends Object
implements LayeredRenderable<oooO, C> {
    private int owner = 0;
    private float maxArmor = 200.0f;
    private float maxEnergy = 500.0f;
    private float energyRegen = 40.0f;
    private float maxSpeed = 100.0f;
    private float acceleration = 300.0f;
    private float turnRate = 120.0f;
    private float energy = 500.0f;
    private float armor = 200.0f;
    private float facing = 0.0f;
    private Vector2f targetPoint = new Vector2f();
    private OoOO shield;
    private String ray;
    private float shieldCoverage = 195.0f;
    private float weaponCoverage = 120.0f;
    private Sprite sprite;
    private G engine;
    private static final java.lang.String SHIP_TEXTURE = "graphics/longbow.png";
    private static final java.lang.String FIGHTER_TEXTURE = "graphics/reaper.png";
    private List<o> commands = new ArrayList<o>();

    static {
        try {
            com.fs.graphics.G.o00000((java.lang.String)SHIP_TEXTURE, (java.lang.String)SHIP_TEXTURE);
            com.fs.graphics.G.o00000((java.lang.String)FIGHTER_TEXTURE, (java.lang.String)FIGHTER_TEXTURE);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public Ship(G g2) {
        this.engine = g2;
        this.sprite = new Sprite(com.fs.graphics.G.\u00d200000((java.lang.String)SHIP_TEXTURE));
        this.sprite.setAngle(0.0f);
        this.sprite.setSize(50.0f, 50.0f);
        this.setRadius(15.0f);
        this.setShieldRadius(30.0f);
        this.shield = new OoOO(this);
        this.ray = null;
    }

    public Ship(G g2, boolean bl) {
        this.engine = g2;
        this.sprite = new Sprite(com.fs.graphics.G.\u00d200000((java.lang.String)FIGHTER_TEXTURE));
        this.sprite.setAngle(0.0f);
        this.sprite.setSize(25.0f, 25.0f);
        this.setRadius(10.0f);
        this.setShieldRadius(20.0f);
        this.shield = new OoOO(this);
        this.ray = null;
    }

    public void giveCommand(o o2) {
        this.commands.add(o2);
    }

    public void advance(float f2) {
        boolean bl = false;
        boolean bl2 = false;
        for (o o2 : this.commands) {
            switch (o2.o00000) {
                case new: {
                    this.turnLeft(f2);
                    break;
                }
                case o00000: {
                    this.turnRight(f2);
                    break;
                }
                case class: {
                    this.accelerate(f2);
                    break;
                }
                case \u00d800000: {
                    this.decelerate(f2);
                    break;
                }
                case \u00d600000: {
                    if (!this.fire(this.engine, (Vector2f)o2.new, f2)) break;
                    bl = true;
                    break;
                }
                case \u00d400000: {
                    bl2 = true;
                    this.raiseShields((Vector2f)o2.new);
                }
            }
        }
        this.commands.clear();
        if (!bl2) {
            this.lowerShields();
        }
        if (!bl) {
            this.stopFire(this.engine);
        }
        this.energy += this.energyRegen * f2;
        if (this.energy > this.maxEnergy) {
            this.energy = this.maxEnergy;
        }
        if (this.getShield().super()) {
            this.energy -= this.getShield().\u00d200000() * f2;
            if (this.energy < 0.0f) {
                this.energy = 0.0f;
            }
        }
        if (this.energy <= 20.0f) {
            this.lowerShields();
        }
    }

    private void turnLeft(float f2) {
        float f3 = f2 * this.getTurnRate();
        float f4 = this.getFacing();
        this.setFacing(f4 += f3);
    }

    private void turnRight(float f2) {
        float f3 = f2 * this.getTurnRate();
        float f4 = this.getFacing();
        this.setFacing(f4 -= f3);
    }

    private void accelerate(float f2) {
        Vector2f vector2f = Utils.\u00d300000(this.getFacing());
        vector2f.scale(f2 * this.getAcceleration());
        Vector2f.add((Vector2f)new Vector2f((ReadableVector2f)this.getVelocity()), (Vector2f)vector2f, (Vector2f)this.getVelocity());
        float f3 = this.getVelocity().length();
        if (f3 >= this.getMaxSpeed()) {
            this.getVelocity().scale(this.getMaxSpeed() / f3);
        }
    }

    private void decelerate(float f2) {
        Vector2f vector2f = new Vector2f((ReadableVector2f)this.getVelocity());
        if (vector2f.length() != 0.0f) {
            vector2f.normalise();
            vector2f.scale(-1.0f);
            vector2f.scale(f2 * this.getAcceleration() / 3.0f);
            Vector2f.add((Vector2f)new Vector2f((ReadableVector2f)this.getVelocity()), (Vector2f)vector2f, (Vector2f)this.getVelocity());
            float f3 = this.getVelocity().length();
            if (f3 >= this.getMaxSpeed()) {
                this.getVelocity().scale(this.getMaxSpeed() / f3);
            }
            if (f3 <= 1.0f) {
                this.getVelocity().set(0.0f, 0.0f);
            }
        }
    }

    private void raiseShields(Vector2f vector2f) {
        Vector2f vector2f2 = new Vector2f();
        float f2 = Utils.\u00d300000(Vector2f.sub((Vector2f)vector2f, (Vector2f)this.getLocation(), (Vector2f)vector2f2));
        if (!Utils.super(this.getFacing(), this.shieldCoverage, this.getLocation(), vector2f)) {
            f2 = Utils.\u00d200000(this.getFacing(), this.shieldCoverage, f2);
        }
        this.getShield().super(true);
        this.getShield().\u00d200000(f2);
    }

    private void lowerShields() {
        this.getShield().super(false);
    }

    private boolean fire(G g2, Vector2f vector2f, float f2) {
        String string = null;
        string = this.ray == null ? new String(this) : this.ray;
        float f3 = string.new() * f2;
        if (this.energy < f3) {
            this.stopFire(g2);
            return false;
        }
        if (this.ray == null) {
            this.ray = string;
            g2.o00000(this.ray);
        }
        this.energy -= f3;
        this.setTargetPoint(vector2f.x, vector2f.y);
        return true;
    }

    public void stopFire(G g2) {
        if (this.ray != null) {
            g2.new(this.ray);
            this.energy -= this.ray.o00000();
            if (this.energy < 0.0f) {
                this.energy = 0.0f;
            }
        }
        this.ray = null;
    }

    public EnumSet<oooO> getActiveLayers() {
        return EnumSet.of(oooO.\u00d200000);
    }

    public void render(oooO oooO2, C c2) {
        this.sprite.setAngle(this.facing + 90.0f);
        this.sprite.renderAtCenter(this.getLocation().x, this.getLocation().y);
        if (this.shield.super()) {
            this.shield.\u00d300000();
        }
        if (this.ray != null) {
            this.ray.\u00d600000();
        }
    }

    public float getAcceleration() {
        return this.acceleration;
    }

    public void setAcceleration(float f2) {
        this.acceleration = f2;
    }

    public float getArmor() {
        return this.armor;
    }

    public void setArmor(float f2) {
        this.armor = f2;
    }

    public float getEnergy() {
        return this.energy;
    }

    public void setEnergy(float f2) {
        this.energy = f2;
    }

    public float getEnergyRegen() {
        return this.energyRegen;
    }

    public void setEnergyRegen(float f2) {
        this.energyRegen = f2;
    }

    public float getFacing() {
        return this.facing;
    }

    public void setFacing(float f2) {
        while (f2 > 360.0f) {
            f2 -= 360.0f;
        }
        if (f2 < 0.0f) {
            f2 += 360.0f;
        }
        this.facing = f2;
    }

    public float getMaxArmor() {
        return this.maxArmor;
    }

    public void setMaxArmor(float f2) {
        this.maxArmor = f2;
    }

    public float getMaxEnergy() {
        return this.maxEnergy;
    }

    public void setMaxEnergy(float f2) {
        this.maxEnergy = f2;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(float f2) {
        this.maxSpeed = f2;
    }

    public Sprite getSprite() {
        return this.sprite;
    }

    public void setSprite(Sprite sprite) {
        this.sprite = sprite;
    }

    public float getTurnRate() {
        return this.turnRate;
    }

    public void setTurnRate(float f2) {
        this.turnRate = f2;
    }

    @Override
    public OoOO getShield() {
        return this.shield;
    }

    public Vector2f getTargetPoint() {
        return this.targetPoint;
    }

    public void setTargetPoint(float f2, float f3) {
        this.targetPoint.x = f2;
        this.targetPoint.y = f3;
        if (this.ray == null) {
            return;
        }
        float f4 = this.getLocation().x;
        float f5 = this.getLocation().y;
        float f6 = Utils.\u00d300000(Vector2f.sub((Vector2f)this.targetPoint, (Vector2f)this.getLocation(), (Vector2f)new Vector2f()));
        if (!Utils.super(this.getFacing(), this.weaponCoverage, this.getLocation(), this.targetPoint)) {
            f6 = Utils.\u00d200000(this.getFacing(), this.weaponCoverage, f6);
        }
        Vector2f vector2f = Utils.\u00d300000(f6);
        float f7 = f4 + vector2f.x * this.ray.null();
        float f8 = f5 + vector2f.y * this.ray.null();
        this.ray.o00000(new Vector2f(f4, f5));
        this.ray.new(new Vector2f(f7, f8));
    }

    public float getShieldCoverage() {
        return this.shieldCoverage;
    }

    public void setShieldCoverage(float f2) {
        this.shieldCoverage = f2;
    }

    public float getWeaponCoverage() {
        return this.weaponCoverage;
    }

    public void setWeaponCoverage(float f2) {
        this.weaponCoverage = f2;
    }

    public int getOwner() {
        return this.owner;
    }

    public void setOwner(int n2) {
        this.owner = n2;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class o {
        public Oo o00000;
        public java.lang.Object new;

        public o(Oo oo2, java.lang.Object object) {
            this.o00000 = oo2;
            this.new = object;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum Oo {
        new,
        o00000,
        class,
        \u00d800000,
        \u00d600000,
        \u00d400000;

    }
}

