/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.util;

import com.fs.graphics.G;
import com.fs.graphics.Sprite;
import com.fs.util.DoNotObfuscate;
import java.io.IOException;

public class ReplaceableSprite
implements DoNotObfuscate {
    private transient Sprite sprite;
    private String originalTextureId;
    private String textureFilename;
    private String pendingTextureFilename;
    private final SpriteUpdateDelegate delegate;

    public ReplaceableSprite(String string, SpriteUpdateDelegate spriteUpdateDelegate) {
        this.delegate = spriteUpdateDelegate;
        this.sprite = new Sprite(string);
        this.originalTextureId = string;
        this.textureFilename = string;
        this.pendingTextureFilename = null;
        this.readResolve();
    }

    Object readResolve() {
        this.sprite = new Sprite(this.originalTextureId);
        if (this.pendingTextureFilename != null && this.pendingTextureFilename.equals(this.textureFilename)) {
            this.pendingTextureFilename = this.textureFilename;
            this.textureFilename = this.originalTextureId;
        }
        return this;
    }

    public void update() {
        if (this.pendingTextureFilename != null) {
            this.textureFilename = this.pendingTextureFilename;
        }
        if (!this.textureFilename.equals(this.sprite.getTexture().\u00d500000())) {
            try {
                G.\u00d400000().o00000(this.sprite.getTexture(), this.textureFilename);
                this.sprite.setSize((float)this.sprite.getTexture().Object(), (float)this.sprite.getTexture().\u00d400000());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            if (this.delegate != null) {
                this.delegate.spriteUpdated();
            }
            this.pendingTextureFilename = null;
        }
    }

    public void replaceTexture(String string) {
        if (this.textureFilename.equals(string)) {
            this.pendingTextureFilename = null;
            return;
        }
        this.pendingTextureFilename = string;
    }

    public Sprite getSprite() {
        return this.sprite;
    }

    public String getOriginalTextureId() {
        return this.originalTextureId;
    }

    public String getTextureFilename() {
        return this.textureFilename;
    }

    public static interface SpriteUpdateDelegate
    extends DoNotObfuscate {
        public void spriteUpdated();
    }
}

