/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.CharacterCreationData;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.impl.SharedSettings;
import com.fs.starfarer.api.impl.campaign.DevMenuOptions;
import com.fs.starfarer.api.impl.campaign.rulecmd.DumpMemory;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireAll;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireBest;
import java.util.HashMap;
import java.util.Map;

public class NewGameDialogPluginImpl
implements InteractionDialogPlugin {
    public static String CAMPAIGN_HELP_POPUPS_OPTION_CHECKED = "campaignHelpPopupsOptionChecked";
    private InteractionDialogAPI dialog;
    private TextPanelAPI textPanel;
    private OptionPanelAPI options;
    private VisualPanelAPI visual;
    private CharacterCreationData data;
    private SectorEntityToken entity;
    private State state = State.OPTIONS;
    private HashMap<String, MemoryAPI> memoryMap;
    private MemoryAPI memory;
    private OptionId lastOptionMousedOver = null;

    @Override
    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        this.textPanel = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        dialog.setOptionOnEscape("Leave", (Object)OptionId.LEAVE);
        this.createInitialOptions();
        this.entity = dialog.getInteractionTarget();
        this.memory = this.entity.getMemoryWithoutUpdate();
        this.data = (CharacterCreationData)this.memory.get("$characterData");
        this.memoryMap = new HashMap();
        this.memoryMap.put("local", this.memory);
        this.memoryMap.put("global", Global.getFactory().createMemory());
        if (Global.getSettings().isDevMode()) {
            this.memoryMap.get("global").set("$isDevMode", true, 0.0f);
        }
        dialog.setPromptText("-");
        this.data.setCampaignHelpEnabled(SharedSettings.optBoolean(CAMPAIGN_HELP_POPUPS_OPTION_CHECKED, true));
        dialog.hideTextPanel();
        this.visual.showNewGameOptionsPanel(this.data);
    }

    @Override
    public void advance(float amount) {
        if (this.state == State.OPTIONS) {
            String name = this.data.getCharacterData().getName();
            if (name == null || name.isEmpty()) {
                this.options.setEnabled((Object)OptionId.CONTINUE_CHOICES, false);
            } else {
                this.options.setEnabled((Object)OptionId.CONTINUE_CHOICES, true);
            }
        } else if (this.state == State.CHOICES && this.data.isDone()) {
            this.dialog.dismiss();
        }
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return this.memoryMap;
    }

    @Override
    public void backFromEngagement(EngagementResultAPI result) {
    }

    @Override
    public void optionSelected(String text, Object optionData) {
        if (optionData == null) {
            return;
        }
        if (text != null && this.state == State.CHOICES) {
            this.dialog.addOptionSelectedText(optionData);
        }
        if (optionData instanceof String) {
            if (optionData == "DumpMemory.option_dump_memory") {
                new DumpMemory().execute(null, this.dialog, null, this.memoryMap);
                return;
            }
            if (DevMenuOptions.isDevOption(optionData)) {
                DevMenuOptions.execute(this.dialog, (String)optionData);
                return;
            }
            this.memory.set("$option", optionData);
            this.memory.expire("$option", 0.0f);
            this.fireBest("NewGameOptionSelected");
        } else {
            OptionId option = (OptionId)((Object)optionData);
            switch (option) {
                case LEAVE: {
                    SharedSettings.setBoolean(CAMPAIGN_HELP_POPUPS_OPTION_CHECKED, this.data.isCampaignHelpEnabled());
                    SharedSettings.saveIfNeeded();
                    this.dialog.dismissAsCancel();
                    break;
                }
                case CONTINUE_CHOICES: {
                    SharedSettings.setBoolean(CAMPAIGN_HELP_POPUPS_OPTION_CHECKED, this.data.isCampaignHelpEnabled());
                    SharedSettings.saveIfNeeded();
                    this.dialog.showTextPanel();
                    this.visual.showPersonInfo(this.data.getPerson(), true);
                    this.options.clearOptions();
                    this.state = State.CHOICES;
                    this.fireBest("BeginNewGameCreation");
                }
            }
        }
    }

    private void createInitialOptions() {
        this.options.clearOptions();
        boolean dev = Global.getSettings().isDevMode();
        this.options.addOption("Continue", (Object)OptionId.CONTINUE_CHOICES, null);
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }

    @Override
    public Object getContext() {
        return null;
    }

    public boolean fireAll(String trigger) {
        return FireAll.fire(null, this.dialog, this.memoryMap, trigger);
    }

    public boolean fireBest(String trigger) {
        return FireBest.fire(null, this.dialog, this.memoryMap, trigger);
    }

    private static enum OptionId {
        INIT,
        CONTINUE_CHOICES,
        LEAVE;

    }

    private static enum State {
        OPTIONS,
        CHOICES;

    }
}

