/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.impl.campaign.econ.BaseMarketConditionPlugin;
import com.fs.starfarer.api.impl.campaign.procgen.ConditionGenDataSpec;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.Map;

public class BaseHazardCondition
extends BaseMarketConditionPlugin {
    @Override
    public void apply(String id) {
        ConditionGenDataSpec spec;
        float hazard;
        Object test = Global.getSettings().getSpec(ConditionGenDataSpec.class, this.condition.getId(), true);
        if (test instanceof ConditionGenDataSpec && (hazard = (spec = (ConditionGenDataSpec)test).getHazard()) != 0.0f) {
            this.market.getHazard().modifyFlat(id, hazard, this.condition.getName());
        }
    }

    @Override
    public void unapply(String id) {
        this.market.getHazard().unmodifyFlat(id);
    }

    @Override
    public Map<String, String> getTokenReplacements() {
        return super.getTokenReplacements();
    }

    @Override
    protected void createTooltipAfterDescription(TooltipMakerAPI tooltip, boolean expanded) {
        ConditionGenDataSpec spec;
        float hazard;
        super.createTooltipAfterDescription(tooltip, expanded);
        Object test = Global.getSettings().getSpec(ConditionGenDataSpec.class, this.condition.getId(), true);
        if (test instanceof ConditionGenDataSpec && (hazard = (spec = (ConditionGenDataSpec)test).getHazard()) != 0.0f) {
            String pct = (int)(hazard * 100.0f) + "%";
            if (hazard > 0.0f) {
                pct = "+" + pct;
            }
            tooltip.addPara("%s hazard rating", 10.0f, Misc.getHighlightColor(), pct);
        }
    }
}

