/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.MutableStatWithTempMods;
import com.fs.starfarer.api.impl.campaign.econ.BaseMarketConditionPlugin;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.CountingMap;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;

public class ShippingDisruption
extends BaseMarketConditionPlugin {
    public static String COMMODITY_LOSS_PREFIX = "sh_loss";
    public static float ACCESS_LOSS_DURATION = 90.0f;
    public static float ACCESS_PER_UNITS_LOST = 0.1f;
    protected MutableStatWithTempMods shippingLost = new MutableStatWithTempMods(0.0f);
    protected float disruptionTimeLeft = 0.0f;

    public static float getPenaltyForShippingLost(float marketSize, float unitsLost) {
        float result = (float)Math.round(unitsLost / marketSize * ACCESS_PER_UNITS_LOST * 100.0f) / 100.0f;
        if (result == 0.0f) {
            result = 0.01f;
        }
        return result;
    }

    public static ShippingDisruption getDisruption(MarketAPI market) {
        MarketConditionAPI mc = market.getCondition("shipping_disruption");
        if (mc == null) {
            String id = market.addCondition("shipping_disruption");
            mc = market.getSpecificCondition(id);
        }
        return (ShippingDisruption)mc.getPlugin();
    }

    public void addShippingLost(float units) {
        this.shippingLost.addTemporaryModFlat(ACCESS_LOSS_DURATION, String.valueOf(this.getModId()) + Misc.genUID(), units);
        this.updatePenaltyValue();
    }

    protected void updatePenaltyValue() {
        this.unapply(this.getModId());
        this.apply(this.getModId());
    }

    public float getDisruptionTimeLeft() {
        return this.disruptionTimeLeft;
    }

    public void setDisruptionTimeLeft(float disruptionTimeLeft) {
        this.disruptionTimeLeft = disruptionTimeLeft;
    }

    public void notifyDisrupted(float duration) {
        this.disruptionTimeLeft = Math.max(this.disruptionTimeLeft, duration);
    }

    @Override
    public void apply(String id) {
        float penalty = ShippingDisruption.getPenaltyForShippingLost(this.market.getSize(), this.shippingLost.getModifiedValue());
        String name = "Trade fleets lost";
        this.market.getAccessibilityMod().modifyFlat(id, -penalty, name);
        if (this.market.isPlayerOwned()) {
            for (CommodityOnMarketAPI com : this.market.getCommoditiesCopy()) {
                ArrayList<String> unmodify = new ArrayList<String>();
                if (com.getMaxSupply() >= com.getAvailable() + 1) {
                    for (String key : com.getAvailableStat().getFlatMods().keySet()) {
                        MutableStat.StatMod mod = com.getAvailableStat().getFlatStatMod(key);
                        int val = Math.round(Math.abs(mod.value));
                        if (!key.startsWith(COMMODITY_LOSS_PREFIX) || val == 0) continue;
                        unmodify.add(mod.source);
                    }
                }
                for (String modId : unmodify) {
                    com.getAvailableStat().unmodifyFlat(modId);
                }
            }
        }
    }

    @Override
    public void unapply(String id) {
        this.market.getAccessibilityMod().unmodifyFlat(id);
    }

    @Override
    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.shippingLost.advance(days);
        this.updatePenaltyValue();
        this.disruptionTimeLeft -= days;
        if (this.disruptionTimeLeft <= 0.0f) {
            this.disruptionTimeLeft = 0.0f;
            if (this.shippingLost.isUnmodified()) {
                this.market.removeSpecificCondition(this.condition.getIdForPluginModifications());
            }
        }
    }

    @Override
    public Map<String, String> getTokenReplacements() {
        return super.getTokenReplacements();
    }

    @Override
    public String[] getHighlights() {
        return super.getHighlights();
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        tooltip.addTitle("Shipping Disruption");
        int loss = this.shippingLost.getModifiedInt();
        int penalty = Math.round(ShippingDisruption.getPenaltyForShippingLost(this.market.getSize(), this.shippingLost.getModifiedValue()) * 100.0f);
        Color h = Misc.getHighlightColor();
        Color n = Misc.getNegativeHighlightColor();
        float pad = 3.0f;
        float small = 5.0f;
        float opad = 10.0f;
        if (penalty > 0) {
            tooltip.addPara("Trade fleets launched from " + this.market.getName() + " have suffered losses, " + "resulting in a temporary accessibility penalty of %s.", opad, h, penalty + "%");
        }
        CountingMap<CommodityOnMarketAPI> losses = new CountingMap<CommodityOnMarketAPI>();
        for (CommodityOnMarketAPI com : this.market.getCommoditiesCopy()) {
            for (String key : com.getAvailableStat().getFlatMods().keySet()) {
                MutableStat.StatMod mod = com.getAvailableStat().getFlatStatMod(key);
                int val = Math.round(Math.abs(mod.value));
                if (!key.startsWith(COMMODITY_LOSS_PREFIX) || val == 0) continue;
                losses.add(com, val);
            }
        }
        if (!losses.isEmpty()) {
            tooltip.addPara("The local availability of some commodities has been reduced by trade fleet losses. Provided no further losses occur, commodity availability should return to normal levels within at most three months.", opad);
            tooltip.beginGridFlipped(400.0f, 1, 30.0f, opad);
            int j = 0;
            for (CommodityOnMarketAPI com : losses.keySet()) {
                tooltip.addToGrid(0, j++, com.getCommodity().getName(), "-" + losses.getCount(com), h);
            }
            tooltip.addGrid(pad);
        }
    }

    @Override
    public float getTooltipWidth() {
        return super.getTooltipWidth();
    }

    @Override
    public boolean hasCustomTooltip() {
        return true;
    }

    @Override
    public boolean isTooltipExpandable() {
        return super.isTooltipExpandable();
    }
}

