/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class PlanetaryShield
extends BaseIndustry {
    public static float DEFENSE_BONUS = 2.0f;
    public static float ALPHA_CORE_BONUS = 0.5f;
    public static float IMPROVE_DEFENSE_BONUS = 0.25f;

    @Override
    public void apply() {
        super.apply(false);
        int size = 5;
        this.applyIncomeAndUpkeep(size);
        float bonus = DEFENSE_BONUS;
        this.market.getStats().getDynamic().getMod("ground_defenses_mod").modifyMult(this.getModId(), 1.0f + bonus, this.getNameForModifier());
        if (this.isFunctional()) {
            this.market.suppressCondition("meteor_impacts");
            PlanetaryShield.applyVisuals(this.market.getPlanetEntity());
        } else {
            this.unapply();
        }
    }

    public static void applyVisuals(PlanetAPI planet) {
        if (planet == null) {
            return;
        }
        planet.getSpec().setShieldTexture(Global.getSettings().getSpriteName("industry", "shield_texture"));
        planet.getSpec().setShieldThickness(0.1f);
        planet.getSpec().setShieldColor(new Color(255, 255, 255, 175));
        planet.applySpecChanges();
    }

    public static void unapplyVisuals(PlanetAPI planet) {
        if (planet == null) {
            return;
        }
        planet.getSpec().setShieldTexture(null);
        planet.getSpec().setShieldThickness(0.0f);
        planet.getSpec().setShieldColor(null);
        planet.applySpecChanges();
    }

    @Override
    public void unapply() {
        super.unapply();
        this.market.unsuppressCondition("meteor_impacts");
        PlanetaryShield.unapplyVisuals(this.market.getPlanetEntity());
        this.market.getStats().getDynamic().getMod("ground_defenses_mod").unmodifyMult(this.getModId());
    }

    @Override
    public boolean isAvailableToBuild() {
        if (!Global.getSector().getPlayerFaction().knowsIndustry(this.getId())) {
            return false;
        }
        return this.market.getPlanetEntity() != null && !this.market.getPlanetEntity().isGasGiant();
    }

    @Override
    public String getUnavailableReason() {
        if (!super.isAvailableToBuild()) {
            return super.getUnavailableReason();
        }
        return "Can not be built at a gas giant";
    }

    @Override
    public boolean showWhenUnavailable() {
        return Global.getSector().getPlayerFaction().knowsIndustry(this.getId());
    }

    @Override
    protected boolean hasPostDemandSection(boolean hasDemand, Industry.IndustryTooltipMode mode) {
        return mode != Industry.IndustryTooltipMode.NORMAL || this.isFunctional();
    }

    @Override
    protected void addPostDemandSection(TooltipMakerAPI tooltip, boolean hasDemand, Industry.IndustryTooltipMode mode) {
        if (mode != Industry.IndustryTooltipMode.NORMAL || this.isFunctional()) {
            float bonus = DEFENSE_BONUS;
            this.addGroundDefensesImpactSection(tooltip, bonus, null);
        }
    }

    @Override
    protected void applyAlphaCoreModifiers() {
        this.market.getStats().getDynamic().getMod("ground_defenses_mod").modifyMult(this.getModId(1), 1.0f + ALPHA_CORE_BONUS, "Alpha core (" + this.getNameForModifier() + ")");
    }

    @Override
    protected void applyNoAICoreModifiers() {
        this.market.getStats().getDynamic().getMod("ground_defenses_mod").unmodifyMult(this.getModId(1));
    }

    @Override
    protected void applyAlphaCoreSupplyAndDemandModifiers() {
        this.demandReduction.modifyFlat(this.getModId(0), DEMAND_REDUCTION, "Alpha core");
    }

    @Override
    protected void addAlphaCoreDescription(TooltipMakerAPI tooltip, Industry.AICoreDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        String pre = "Alpha-level AI core currently assigned. ";
        if (mode == Industry.AICoreDescriptionMode.MANAGE_CORE_DIALOG_LIST || mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            pre = "Alpha-level AI core. ";
        }
        float a = ALPHA_CORE_BONUS;
        String str = "\u00d7" + (1.0f + a);
        if (mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            CommoditySpecAPI coreSpec = Global.getSettings().getCommoditySpec(this.aiCoreId);
            TooltipMakerAPI text = tooltip.beginImageWithText(coreSpec.getIconName(), 48.0f);
            text.addPara(String.valueOf(pre) + "Reduces upkeep cost by %s. Reduces demand by %s unit. " + "Increases ground defenses by %s.", 0.0f, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION, str);
            tooltip.addImageWithText(opad);
            return;
        }
        tooltip.addPara(String.valueOf(pre) + "Reduces upkeep cost by %s. Reduces demand by %s unit. " + "Increases ground defenses by %s.", opad, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION, str);
    }

    @Override
    public boolean canImprove() {
        return true;
    }

    @Override
    protected void applyImproveModifiers() {
        if (this.isImproved()) {
            this.market.getStats().getDynamic().getMod("ground_defenses_mod").modifyMult(this.getModId(2), 1.0f + IMPROVE_DEFENSE_BONUS, String.valueOf(this.getImprovementsDescForModifiers()) + " (" + this.getNameForModifier() + ")");
        } else {
            this.market.getStats().getDynamic().getMod("ground_defenses_mod").unmodifyMult(this.getModId(2));
        }
    }

    @Override
    public void addImproveDesc(TooltipMakerAPI info, Industry.ImprovementDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        float a = IMPROVE_DEFENSE_BONUS;
        String str = "\u00d7" + (1.0f + a);
        if (mode == Industry.ImprovementDescriptionMode.INDUSTRY_TOOLTIP) {
            info.addPara("Ground defenses increased by %s.", 0.0f, highlight, str);
        } else {
            info.addPara("Increases ground defenses by %s.", 0.0f, highlight, str);
        }
        info.addSpacer(opad);
        super.addImproveDesc(info, mode);
    }
}

