/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.eventide;

import com.fs.starfarer.api.impl.campaign.eventide.AnimAction;

public class HitArea
implements Cloneable {
    public float x;
    public float y;
    public float w;
    public float h;

    protected HitArea clone() {
        try {
            HitArea copy = (HitArea)super.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public HitArea getAdjustedForAction(AnimAction action) {
        HitArea copy = new HitArea();
        float sign = action.actor.facing;
        copy.x = action.actor.loc.x + this.x * action.anim.scale * sign;
        copy.y = action.actor.loc.y + this.y * action.anim.scale;
        copy.h = this.h * action.anim.scale;
        if (sign > 0.0f) {
            copy.w = this.w * action.anim.scale;
        } else {
            copy.x = action.actor.loc.x + this.x * action.anim.scale * sign - this.w * action.anim.scale;
            copy.w = this.w * action.anim.scale;
        }
        return copy;
    }

    public boolean intersects(HitArea other) {
        if (this.x > other.x + other.w) {
            return false;
        }
        if (this.x + this.w < other.x) {
            return false;
        }
        if (this.y > other.y + other.h) {
            return false;
        }
        return !(this.y + this.h < other.y);
    }
}

