/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.intel.bar.PortsideBarData;
import com.fs.starfarer.api.impl.campaign.intel.bar.PortsideBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.SpecBarEventCreator;
import com.fs.starfarer.api.loading.BarEventSpec;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.TimeoutTracker;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;

public class BarEventManager
implements EveryFrameScript {
    public static final String KEY = "$core_genericBarEventManager";
    protected List<GenericBarEventCreator> creators = new ArrayList<GenericBarEventCreator>();
    protected LinkedHashMap<PortsideBarEvent, GenericBarEventCreator> barEventCreators = new LinkedHashMap();
    protected IntervalUtil tracker = new IntervalUtil(0.4f, 0.6f);
    protected IntervalUtil tracker2 = new IntervalUtil(20.0f, 40.0f);
    protected TimeoutTracker<PortsideBarEvent> active = new TimeoutTracker();
    protected TimeoutTracker<GenericBarEventCreator> timeout = new TimeoutTracker();
    protected long seed = Misc.genRandomSeed();

    public static BarEventManager getInstance() {
        Object test = Global.getSector().getMemoryWithoutUpdate().get(KEY);
        return (BarEventManager)test;
    }

    public BarEventManager() {
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
        this.readResolve();
    }

    public long getSeed(SectorEntityToken entity, PersonAPI person, String extra) {
        long mult = 1L;
        if (entity != null) {
            mult *= (long)entity.getName().hashCode();
        }
        if (person != null) {
            mult *= (long)person.getNameString().hashCode();
        }
        if (extra != null) {
            mult *= (long)extra.hashCode();
        }
        return this.seed + mult * 181783497276652981L;
    }

    public void updateSeed() {
        this.seed = Misc.genRandomSeed();
    }

    protected Object readResolve() {
        if (this.timeout == null) {
            this.timeout = new TimeoutTracker();
        }
        if (this.tracker2 == null) {
            this.tracker2 = new IntervalUtil(20.0f, 40.0f);
        }
        if (this.seed == 0L) {
            this.updateSeed();
        }
        this.updateBarEventCreatorsFromSpecs();
        return this;
    }

    public void updateBarEventCreatorsFromSpecs() {
        List<BarEventSpec> specs = Global.getSettings().getAllBarEventSpecs();
        HashSet<String> validEvents = new HashSet<String>();
        HashSet<String> alreadyHaveCreatorsFor = new HashSet<String>();
        for (BarEventSpec spec : specs) {
            validEvents.add(spec.getId());
        }
        for (GenericBarEventCreator curr : new ArrayList<GenericBarEventCreator>(this.creators)) {
            if (!curr.wasAutoAdded()) continue;
            if (!validEvents.contains(curr.getBarEventId())) {
                this.creators.remove(curr);
                this.timeout.remove(curr);
                continue;
            }
            alreadyHaveCreatorsFor.add(curr.getBarEventId());
        }
        for (BarEventSpec spec : specs) {
            if (alreadyHaveCreatorsFor.contains(spec.getId())) continue;
            SpecBarEventCreator curr = new SpecBarEventCreator(spec.getId());
            curr.setWasAutoAdded(true);
            this.creators.add(curr);
        }
    }

    public void addEventCreator(GenericBarEventCreator creator) {
        this.creators.add(creator);
    }

    public boolean hasEventCreator(Class<?> clazz) {
        for (GenericBarEventCreator script : this.creators) {
            if (!clazz.isInstance(script)) continue;
            return true;
        }
        return false;
    }

    public List<GenericBarEventCreator> getCreators() {
        return this.creators;
    }

    public TimeoutTracker<PortsideBarEvent> getActive() {
        return this.active;
    }

    public TimeoutTracker<GenericBarEventCreator> getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Class creatorClass, float duration) {
        for (GenericBarEventCreator curr : this.creators) {
            if (!curr.getClass().equals(creatorClass)) continue;
            this.timeout.set(curr, duration);
            break;
        }
    }

    public void notifyWasInteractedWith(PortsideBarEvent event) {
        PortsideBarData.getInstance().removeEvent(event);
        GenericBarEventCreator creator = this.getCreatorFor(event);
        if (creator != null) {
            float dur = creator.getBarEventAcceptedTimeoutDuration();
            dur = Math.max(dur, this.timeout.getRemaining(creator));
            this.timeout.set(creator, dur);
            this.active.remove(event);
        }
    }

    public GenericBarEventCreator getCreatorFor(PortsideBarEvent event) {
        return this.barEventCreators.get(event);
    }

    @Override
    public void advance(float amount) {
        float days = Misc.getDays(amount);
        this.active.advance(days);
        this.timeout.advance(days);
        if (DebugFlags.BAR_DEBUG) {
            days *= 100.0f;
            this.timeout.clear();
        }
        this.tracker.advance(days);
        this.tracker2.advance(days);
        if (this.tracker2.intervalElapsed()) {
            this.updateSeed();
        }
        if (this.tracker.intervalElapsed()) {
            int i = 0;
            while (i < 5) {
                ArrayList<PortsideBarEvent> orphaned = new ArrayList<PortsideBarEvent>(this.barEventCreators.keySet());
                for (PortsideBarEvent s : this.active.getItems()) {
                    orphaned.remove(s);
                }
                for (PortsideBarEvent event : orphaned) {
                    GenericBarEventCreator creator = (GenericBarEventCreator)this.barEventCreators.remove(event);
                    if (creator != null) {
                        float dur = creator.getBarEventTimeoutDuration();
                        dur = Math.max(dur, this.timeout.getRemaining(creator));
                        this.timeout.set(creator, dur);
                    }
                    PortsideBarData.getInstance().removeEvent(event);
                }
                float f = Global.getSettings().getFloat("maxTotalBarEventsAsFractionOfEventTypes");
                float max = Math.round((float)this.creators.size() * f);
                if (DebugFlags.BAR_DEBUG) {
                    max = 10000.0f;
                }
                if (max < 1.0f) {
                    max = 1.0f;
                }
                if ((float)this.active.getItems().size() >= max) {
                    return;
                }
                if (this.barEventCreators.size() >= this.creators.size()) {
                    return;
                }
                LinkedHashSet<String> activeCreators = new LinkedHashSet<String>();
                for (GenericBarEventCreator curr : this.barEventCreators.values()) {
                    activeCreators.add(curr.getBarEventId());
                }
                WeightedRandomPicker<GenericBarEventCreator> priority = new WeightedRandomPicker<GenericBarEventCreator>();
                WeightedRandomPicker<GenericBarEventCreator> picker = new WeightedRandomPicker<GenericBarEventCreator>();
                for (GenericBarEventCreator curr : this.creators) {
                    if (activeCreators.contains(curr.getBarEventId()) || this.timeout.contains(curr)) continue;
                    if (curr.isPriority()) {
                        priority.add(curr, curr.getBarEventFrequencyWeight());
                        continue;
                    }
                    picker.add(curr, curr.getBarEventFrequencyWeight());
                }
                GenericBarEventCreator pick = (GenericBarEventCreator)priority.pick();
                if (pick == null) {
                    pick = (GenericBarEventCreator)picker.pick();
                }
                if (pick == null) {
                    return;
                }
                PortsideBarEvent event = pick.createBarEvent();
                if (event == null) {
                    return;
                }
                this.active.add(event, pick.getBarEventActiveDuration());
                this.barEventCreators.put(event, pick);
                PortsideBarData.getInstance().addEvent(event);
                ++i;
            }
        }
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    public static interface GenericBarEventCreator {
        public PortsideBarEvent createBarEvent();

        public float getBarEventFrequencyWeight();

        public float getBarEventActiveDuration();

        public float getBarEventTimeoutDuration();

        public float getBarEventAcceptedTimeoutDuration();

        public boolean isPriority();

        public String getBarEventId();

        public boolean wasAutoAdded();
    }
}

