/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.PlanetaryShieldBarEvent;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PlanetaryShieldIntel
extends BaseIntelPlugin {
    public static int FINISHED_XP = 20000;
    public static int PAY_PILOT_XP = 5000;
    protected PlanetAPI planet;
    protected PlanetaryShieldBarEvent event;
    protected PSIStage stage;
    protected int pilotCredits;

    public PlanetaryShieldIntel(PlanetAPI planet, PlanetaryShieldBarEvent event) {
        this.planet = planet;
        this.event = event;
        PersonAPI pilot = event.getPilot();
        Misc.makeImportant(pilot, "psi");
        MarketAPI market = event.getPilotMarket();
        market.addPerson(pilot);
        market.getCommDirectory().addPerson(pilot);
        this.pilotCredits = 10000 + 1000 * Misc.random.nextInt(10);
        pilot.getMemoryWithoutUpdate().set("$psi_isPilot", true);
        pilot.getMemoryWithoutUpdate().set("$psi_eventRef", this);
        pilot.getMemoryWithoutUpdate().set("$psi_credits", Misc.getDGSCredits(this.pilotCredits));
        this.stage = PSIStage.TALK_TO_PILOT;
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
        Global.getSector().removeScript(this);
        PersonAPI pilot = this.event.getPilot();
        MarketAPI market = this.event.getPilotMarket();
        market.removePerson(pilot);
        market.getCommDirectory().removePerson(pilot);
        Misc.makeUnimportant(this.planet, "psi");
    }

    @Override
    public boolean callEvent(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        String action = params.get(0).getString(memoryMap);
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        CargoAPI cargo = playerFleet.getCargo();
        PersonAPI pilot = this.event.getPilot();
        MarketAPI market = this.event.getPilotMarket();
        if (action.equals("prepare")) {
            pilot.getMemoryWithoutUpdate().set("$psi_credits", Misc.getDGSCredits(this.pilotCredits), 0.0f);
            pilot.getMemoryWithoutUpdate().set("$psi_playerCredits", Misc.getDGSCredits(cargo.getCredits().get()), 0.0f);
        } else {
            if (action.equals("canPay")) {
                return cargo.getCredits().get() >= (float)this.pilotCredits;
            }
            if (action.equals("payPilot")) {
                market.removePerson(pilot);
                market.getCommDirectory().removePerson(pilot);
                cargo.getCredits().subtract(this.pilotCredits);
                AddRemoveCommodity.addCreditsLossText(this.pilotCredits, dialog.getTextPanel());
                Global.getSector().getPlayerPerson().getStats().addXP(PAY_PILOT_XP, dialog.getTextPanel());
                Misc.makeImportant(this.planet, "psi");
                this.stage = PSIStage.GO_TO_PLANET;
                this.sendUpdate((Object)PSIStage.GO_TO_PLANET, dialog.getTextPanel());
            }
        }
        return true;
    }

    @Override
    public void endAfterDelay() {
        this.stage = PSIStage.DONE;
        Misc.makeUnimportant(this.planet, "psi");
        super.endAfterDelay();
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean isUpdate = this.getListInfoParam() != null;
        MarketAPI market = this.event.getPilotMarket();
        if (this.stage == PSIStage.TALK_TO_PILOT) {
            info.addPara("Talk to the pilot at %s", initPad, tc, market.getFaction().getBaseUIColor(), market.getName());
        } else if (this.stage == PSIStage.GO_TO_PLANET) {
            info.addPara("Explore the planet", tc, initPad);
        }
        initPad = 0.0f;
        this.unindent(info);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.setParaSmallInsignia();
        info.addPara(this.getName(), c, 0.0f);
        info.setParaFontDefault();
        this.addBulletPoints(info, mode);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        if (this.stage == PSIStage.TALK_TO_PILOT) {
            info.addPara("An old spacer told you a tale about a mysterious red planet. The pilot - the only other survivor of the salvage expedition - may know the planet's location.", opad);
        } else if (this.stage == PSIStage.GO_TO_PLANET) {
            info.addPara("You've talked to the old spacer's pilot comrade and convinced them to divulge the location of the planet.", opad);
        } else {
            info.addPara("You've found the planet and uncovered its secret.", opad);
        }
        this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("intel", "red_planet");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Story");
        tags.add("Exploration");
        tags.add("Accepted");
        tags.add("Missions");
        return tags;
    }

    @Override
    public IntelInfoPlugin.IntelSortTier getSortTier() {
        return IntelInfoPlugin.IntelSortTier.TIER_2;
    }

    @Override
    public String getSortString() {
        return "Red Planet";
    }

    @Override
    public String getName() {
        if (this.isEnded() || this.isEnding()) {
            return "Red Planet - Completed";
        }
        return "Red Planet";
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return super.getFactionForUIColors();
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        if (this.stage == PSIStage.TALK_TO_PILOT) {
            return this.event.getPilotMarket().getPrimaryEntity();
        }
        return this.planet;
    }

    @Override
    public boolean shouldRemoveIntel() {
        return super.shouldRemoveIntel();
    }

    @Override
    public String getCommMessageSound() {
        return PlanetaryShieldIntel.getSoundMajorPosting();
    }

    public static enum PSIStage {
        TALK_TO_PILOT,
        GO_TO_PLANET,
        DONE;

    }
}

