/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.deciv;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Set;

public class DecivIntel
extends BaseIntelPlugin {
    protected SectorEntityToken primary;
    protected String name;
    protected FactionAPI faction;
    protected boolean destroyed;
    protected boolean warning;

    public DecivIntel(MarketAPI market, SectorEntityToken primary, boolean destroyed, boolean warning) {
        this.primary = primary;
        this.destroyed = destroyed;
        this.warning = warning;
        this.faction = market.getFaction();
        this.name = market.getName();
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean isUpdate = this.getListInfoParam() != null;
        this.unindent(info);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.addPara(this.getName(), c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addImage(this.getFactionForUIColors().getLogo(), width, 128.0f, opad);
        if (this.warning) {
            info.addPara("Conditions at " + this.name + ", a colony belonging to " + this.faction.getDisplayNameWithArticle() + ", have taken a turn for the worse. Unless the colony " + "is stabilized in some way, it's likely to decivilize and be lost completely in the near future.", opad, this.faction.getBaseUIColor(), this.faction.getDisplayNameWithArticleWithoutArticle());
        } else if (this.destroyed) {
            info.addPara(String.valueOf(this.name) + ", a colony formerly belonging to " + this.faction.getDisplayNameWithArticle() + ", has been destroyed.", opad, this.faction.getBaseUIColor(), this.faction.getDisplayNameWithArticleWithoutArticle());
        } else {
            info.addPara(String.valueOf(this.name) + ", a colony formerly belonging to " + this.faction.getDisplayNameWithArticle() + ", has become decivilized. " + "Central authority has collapsed completely and irreversibly, with the remaining " + "population scrambling to survive.", opad, this.faction.getBaseUIColor(), this.faction.getDisplayNameWithArticleWithoutArticle());
        }
        this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("intel", "deciv");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Decivilized");
        return tags;
    }

    @Override
    public String getSortString() {
        return "Decivilized " + this.name;
    }

    @Override
    public String getName() {
        if (this.warning) {
            return String.valueOf(this.name) + " - Deterioration";
        }
        if (this.destroyed) {
            return String.valueOf(this.name) + " - Destroyed";
        }
        return String.valueOf(this.name) + " - Decivilized";
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.faction;
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.primary;
    }

    @Override
    public boolean shouldRemoveIntel() {
        return false;
    }

    @Override
    public String getCommMessageSound() {
        return super.getCommMessageSound();
    }
}

