/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.raid;

import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.fleets.RouteLocationCalculator;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.intel.inspection.HITravelStage;
import com.fs.starfarer.api.impl.campaign.intel.punitive.PETravelStage;
import com.fs.starfarer.api.impl.campaign.intel.raid.BaseRaidStage;
import com.fs.starfarer.api.impl.campaign.intel.raid.RaidIntel;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;

public class TravelStage
extends BaseRaidStage {
    protected SectorEntityToken from;
    protected SectorEntityToken to;
    protected boolean requireNearTarget;

    public TravelStage(RaidIntel raid, SectorEntityToken from, SectorEntityToken to, boolean requireNearTarget) {
        super(raid);
        this.from = from;
        this.to = to;
        this.requireNearTarget = requireNearTarget;
    }

    @Override
    public void notifyStarted() {
        this.updateRoutes();
    }

    protected void updateRoutes() {
        this.resetRoutes();
        List<RouteManager.RouteData> routes = RouteManager.getInstance().getRoutesForSource(this.intel.getRouteSourceId());
        for (RouteManager.RouteData route : routes) {
            float travelDays = RouteLocationCalculator.getTravelDays(this.from, this.to);
            if (DebugFlags.RAID_DEBUG || DebugFlags.FAST_RAIDS || this instanceof PETravelStage && DebugFlags.PUNITIVE_EXPEDITION_DEBUG || this instanceof HITravelStage && DebugFlags.HEGEMONY_INSPECTION_DEBUG) {
                travelDays *= 0.1f;
            }
            route.addSegment(new RouteManager.RouteSegment(travelDays, this.from, this.to));
            route.addSegment(new RouteManager.RouteSegment(1000.0f, this.to, "wait_stage"));
            this.maxDays = Math.max(this.maxDays, travelDays);
        }
    }

    @Override
    protected void updateStatus() {
        this.abortIfNeededBasedOnFP(true);
        this.updateStatusBasedOnReaching(this.to, true, this.requireNearTarget);
    }

    @Override
    public void showStageInfo(TooltipMakerAPI info) {
        int curr = this.intel.getCurrentStage();
        int index = this.intel.getStageIndex(this);
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        if (this.status == RaidIntel.RaidStageStatus.FAILURE) {
            info.addPara("The raiding forces have failed to successfully reach the " + this.intel.getSystem().getNameWithLowercaseType() + ". The raid is now over.", opad);
        } else if (curr == index) {
            info.addPara("The raiding forces are currently travelling to the " + this.intel.getSystem().getNameWithLowercaseType() + ".", opad);
        }
    }
}

