/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.population;

import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;

public class PopulationComposition {
    private LinkedHashMap<String, Float> comp = new LinkedHashMap();
    private MutableStat weight = new MutableStat(0.0f);
    public static final String SET_WEIGHT_ID = "core_set";

    Object readResolve() {
        if (this.weight == null) {
            this.weight = new MutableStat(0.0f);
        }
        return this;
    }

    public LinkedHashMap<String, Float> getComp() {
        return this.comp;
    }

    public float get(String id) {
        Float val = this.comp.get(id);
        if (val == null) {
            return 0.0f;
        }
        return val.floatValue();
    }

    public void set(String id, float value) {
        this.comp.put(id, Float.valueOf(value));
    }

    public void add(String id, float value) {
        this.set(id, this.get(id) + value);
    }

    public String toString() {
        String str = "";
        if (!this.weight.getFlatMods().containsKey(SET_WEIGHT_ID)) {
            for (MutableStat.StatMod mod : this.weight.getFlatMods().values()) {
                str = mod.value > 0.0f ? String.valueOf(str) + "<b>+" + (int)mod.getValue() + "</b> " + mod.getDesc() + "\n" : String.valueOf(str) + "<b>" + (int)mod.getValue() + "</b> " + mod.getDesc() + "\n";
            }
            str = String.valueOf(str) + "\n";
        }
        ArrayList<String> keys = new ArrayList<String>(this.comp.keySet());
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return (int)Math.signum(PopulationComposition.this.get(o2) - PopulationComposition.this.get(o1));
            }
        });
        for (String key : keys) {
            float val = Misc.getRoundedValueFloat(this.get(key));
            str = String.valueOf(str) + key + ": " + val + "\n";
        }
        return str;
    }

    public float getWeightValue() {
        return this.weight.getModifiedValue();
    }

    public float getPositiveWeight() {
        float total = 0.0f;
        for (MutableStat.StatMod mod : this.weight.getFlatMods().values()) {
            if (!(mod.value > 0.0f)) continue;
            total += mod.value;
        }
        return total;
    }

    public float getNegativeWeight() {
        float total = 0.0f;
        for (MutableStat.StatMod mod : this.weight.getFlatMods().values()) {
            if (!(mod.value < 0.0f)) continue;
            total -= mod.value;
        }
        return total;
    }

    public void setWeight(float weight) {
        this.weight.modifyFlat(SET_WEIGHT_ID, weight);
    }

    public void updateWeight() {
        float total = 0.0f;
        for (Float f : this.comp.values()) {
            total += f.floatValue();
        }
        this.weight.modifyFlat(SET_WEIGHT_ID, total);
    }

    public MutableStat getWeight() {
        return this.weight;
    }

    public void normalize() {
        float w = this.weight.getModifiedValue();
        this.normalizeToWeight(w);
    }

    public void normalizeToPositive() {
        this.normalizeToWeight(this.getPositiveWeight());
    }

    public void normalizeToWeight(float w) {
        float total = 0.0f;
        for (Float f : this.comp.values()) {
            total += f.floatValue();
        }
        if (w <= 0.0f || total <= 0.0f) {
            for (String id : this.comp.keySet()) {
                this.set(id, 0.0f);
            }
            return;
        }
        for (String id : this.comp.keySet()) {
            float f = this.get(id);
            this.set(id, f * w / total);
        }
    }
}

