/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class ConditionGenDataSpec {
    public static String NO_PICK_SUFFIX = "_no_pick";
    private String id;
    private String group;
    private float rank;
    private float order;
    private float hazard;
    private float xpMult;
    private boolean requiresSurvey = false;
    private Map<String, Float> multipliers = new HashMap<String, Float>();
    private Set<String> requiresAll = new HashSet<String>();
    private Set<String> requiresAny = new HashSet<String>();
    private Set<String> requiresNotAny = new HashSet<String>();

    public ConditionGenDataSpec(JSONObject row) throws JSONException {
        String requiresNotAny;
        String requiresAnyStr;
        this.id = row.getString("id");
        this.group = row.getString("group");
        this.rank = (float)row.optDouble("rank", 0.0);
        this.order = (float)row.optDouble("order", 0.0);
        this.hazard = (float)row.optDouble("hazard", 0.0);
        this.xpMult = (float)row.optDouble("xpMult", 0.0);
        this.requiresSurvey = row.optBoolean("reqSurvey", false);
        String[] stringArray = JSONObject.getNames((JSONObject)row);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            float mult = (float)row.optDouble(key, 1.0);
            if (row.has(key) && !row.getString(key).isEmpty()) {
                this.multipliers.put(key, Float.valueOf(mult));
            }
            ++n2;
        }
        String requiresAllStr = row.optString("requiresAll", null);
        if (requiresAllStr != null) {
            String[] split;
            String[] stringArray2 = split = requiresAllStr.split(",");
            int mult = split.length;
            int n3 = 0;
            while (n3 < mult) {
                String condition = stringArray2[n3];
                if (!(condition = condition.trim()).isEmpty()) {
                    this.addRequiresAll(condition);
                }
                ++n3;
            }
        }
        if ((requiresAnyStr = row.optString("requiresAny", null)) != null) {
            String[] split;
            String[] stringArray3 = split = requiresAnyStr.split(",");
            int n4 = split.length;
            int mult = 0;
            while (mult < n4) {
                String condition = stringArray3[mult];
                if (!(condition = condition.trim()).isEmpty()) {
                    this.addRequiresAny(condition);
                }
                ++mult;
            }
        }
        if ((requiresNotAny = row.optString("requiresNotAny", null)) != null) {
            String[] split;
            String[] stringArray4 = split = requiresNotAny.split(",");
            int n5 = split.length;
            int n6 = 0;
            while (n6 < n5) {
                String condition = stringArray4[n6];
                if (!(condition = condition.trim()).isEmpty()) {
                    this.addRequiresNotAny(condition);
                }
                ++n6;
            }
        }
    }

    public float getXpMult() {
        return this.xpMult;
    }

    public void setXpMult(float xpMult) {
        this.xpMult = xpMult;
    }

    public float getMultiplier(String key) {
        if (!this.multipliers.containsKey(key)) {
            return 1.0f;
        }
        return this.multipliers.get(key).floatValue();
    }

    public boolean hasMultiplier(String key) {
        return this.multipliers.containsKey(key);
    }

    public Set<String> getRequiresAll() {
        return this.requiresAll;
    }

    public void addRequiresAll(String condition) {
        this.requiresAll.add(condition);
    }

    public boolean requiresAllContains(String condition) {
        return this.requiresAll.contains(condition);
    }

    public Set<String> getRequiresAny() {
        return this.requiresAny;
    }

    public void addRequiresAny(String condition) {
        this.requiresAny.add(condition);
    }

    public boolean requiresAnyContains(String condition) {
        return this.requiresAny.contains(condition);
    }

    public Set<String> getRequiresNotAny() {
        return this.requiresNotAny;
    }

    public void addRequiresNotAny(String condition) {
        this.requiresNotAny.add(condition);
    }

    public boolean requiresNotAnyContains(String condition) {
        return this.requiresNotAny.contains(condition);
    }

    public Map<String, Float> getMultipliers() {
        return this.multipliers;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public float getRank() {
        return this.rank;
    }

    public void setRank(float rank) {
        this.rank = rank;
    }

    public float getOrder() {
        return this.order;
    }

    public void setOrder(float order) {
        this.order = order;
    }

    public boolean isRequiresSurvey() {
        return this.requiresSurvey;
    }

    public void setRequiresSurvey(boolean requiresSurvey) {
        this.requiresSurvey = requiresSurvey;
    }

    public float getHazard() {
        return this.hazard;
    }

    public void setHazard(float hazard) {
        this.hazard = hazard;
    }
}

