/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.FleetStatsSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.MutableFleetStatsAPI;
import com.fs.starfarer.api.impl.campaign.DModManager;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.impl.campaign.skills.FieldRepairsScript;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class HullRestoration {
    public static float RECOVERY_PROB = 2.0f;
    public static float CR_PER_SMOD = 5.0f;
    public static float CR_MAX_BONUS = 15.0f;
    public static float CR_MINUS_PER_DMOD = 5.0f;
    public static float DMOD_AVOID_MAX = 0.9f;
    public static float DMOD_AVOID_MIN = 0.75f;
    public static float DMOD_AVOID_MIN_DP = 5.0f;
    public static float DP_REDUCTION = 0.1f;
    public static float DP_REDUCTION_MAX = 5.0f;
    public static float DMOD_AVOID_MAX_DP = 60.0f;

    public static class Level1
    implements FleetStatsSkillEffect {
        @Override
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("ship_recovery_mod").modifyFlat(id, RECOVERY_PROB);
        }

        @Override
        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getMod("ship_recovery_mod").unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "All of your ships are almost always recoverable if lost in combat";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            float mult;
            float dp = DMOD_AVOID_MIN_DP;
            if (stats.getFleetMember() != null) {
                dp = stats.getFleetMember().getDeploymentPointsCost();
            }
            if ((mult = 1.0f - (dp - DMOD_AVOID_MIN_DP) / (DMOD_AVOID_MAX_DP - DMOD_AVOID_MIN_DP)) > 1.0f) {
                mult = 1.0f;
            }
            if (mult < 0.0f) {
                mult = 0.0f;
            }
            float probAvoid = DMOD_AVOID_MIN + (DMOD_AVOID_MAX - DMOD_AVOID_MIN) * mult;
            stats.getDynamic().getMod("dmod_acquire_prob_mod").modifyMult(id, 1.0f - probAvoid);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("dmod_acquire_prob_mod").unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            String lowDP = "" + (int)DMOD_AVOID_MIN_DP;
            String highDP = "" + (int)DMOD_AVOID_MAX_DP;
            String lowChance = Math.round(DMOD_AVOID_MIN * 100.0f) + "%";
            String highChance = Math.round(DMOD_AVOID_MAX * 100.0f) + "%";
            return "Ships lost in combat have a " + lowChance + " (if " + highDP + " deployment points or higher) to " + highChance + " (" + lowDP + " DP or lower) chance to avoid d-mods";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            float num = 0.0f;
            if (stats.getVariant() != null) {
                num = stats.getVariant().getSMods().size();
            }
            stats.getMaxCombatReadiness().modifyFlat(id, num * CR_PER_SMOD * 0.01f, "Hull Restoration skill");
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMaxCombatReadiness().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+" + (int)CR_PER_SMOD + "% maximum combat readiness per s-mod built into the hull";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3B
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            FleetMemberAPI member = stats.getFleetMember();
            float dmods = 0.0f;
            if (member != null) {
                dmods = DModManager.getNumDMods(member.getVariant());
            } else if (stats.getVariant() != null) {
                dmods = DModManager.getNumDMods(stats.getVariant());
            }
            float bonus = CR_MAX_BONUS - dmods * CR_MINUS_PER_DMOD;
            bonus = Math.round(bonus);
            if (bonus < 0.0f) {
                bonus = 0.0f;
            }
            stats.getMaxCombatReadiness().modifyFlat(id, bonus * 0.01f, "Hull Restoration skill");
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMaxCombatReadiness().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+" + (int)CR_MAX_BONUS + "% maximum combat readiness for all ships, minus " + (int)CR_MINUS_PER_DMOD + "% per d-mod (minimum of 0%)";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level4A
    implements FleetStatsSkillEffect {
        @Override
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
        }

        @Override
        public void unapply(MutableFleetStatsAPI stats, String id) {
        }

        @Override
        public String getEffectDescription(float level) {
            if (FieldRepairsScript.MONTHS_PER_DMOD_REMOVAL == 1) {
                return "Chance to remove one d-mod per month from a randomly selected ship in your fleet; faster for low-DP ships";
            }
            if (FieldRepairsScript.MONTHS_PER_DMOD_REMOVAL == 2) {
                return "Chance to remove a d-mod from a randomly selected ship in your fleet every two months";
            }
            return "Chance to remove a d-mod from a randomly selected ship in your fleet every " + FieldRepairsScript.MONTHS_PER_DMOD_REMOVAL + " months";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level4B
    implements FleetStatsSkillEffect {
        @Override
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
        }

        @Override
        public void unapply(MutableFleetStatsAPI stats, String id) {
        }

        @Override
        public String getEffectDescription(float level) {
            return "Chance to quickly remove one d-mod from newly acquired ships; higher for ships with more d-mods";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level5
    extends BaseSkillEffectDescription
    implements ShipSkillEffect {
        @Override
        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            float opad = 10.0f;
            Color c = Misc.getBasePlayerColor();
            info.addPara("Affects: %s", opad + 5.0f, Misc.getGrayColor(), c, "pristine and near-pristine ships (at most one d-mod)");
            info.addSpacer(opad);
            String max = "" + (int)DP_REDUCTION_MAX;
            String percent = Math.round(DP_REDUCTION * 100.0f) + "%";
            info.addPara("Deployment point cost reduced by %s or %s points, whichever is less", 0.0f, Misc.getHighlightColor(), Misc.getHighlightColor(), percent, max);
        }

        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            FleetMemberAPI member = stats.getFleetMember();
            float dmods = 0.0f;
            if (member != null) {
                dmods = DModManager.getNumDMods(member.getVariant());
            }
            if (dmods > 1.0f) {
                return;
            }
            float baseCost = stats.getSuppliesToRecover().getBaseValue();
            float reduction = Math.min(DP_REDUCTION_MAX, baseCost * DP_REDUCTION);
            stats.getDynamic().getMod("deployment_points_mod").modifyFlat(id, -reduction);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("deployment_points_mod").unmodifyFlat(id);
        }
    }
}

