/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.tutorial;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.CoreUITabId;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.DModManager;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.TransmitterTrapSpecial;
import com.fs.starfarer.api.impl.campaign.tutorial.RogueMinerMiscFleetManager;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialGoSlowDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialLayInCourseDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialLeashAssignmentAI;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialLevelUpDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialMissionIntel;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialPirateApproachesDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialSustainedBurnDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialTransponderDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialWelcomeDialogPluginImpl;
import com.fs.starfarer.api.ui.HintPanelAPI;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public class CampaignTutorialScript
implements EveryFrameScript {
    public static final String USE_TUTORIAL_RESPAWN = "$tutorialRespawn";
    protected boolean askedPlayerToSave = false;
    protected boolean playerSaved = false;
    protected float elapsed = 0.0f;
    protected float lastCheckDistToAncyra = -1.0f;
    protected StarSystemAPI system;
    protected PlanetAPI ancyra;
    protected SectorEntityToken derinkuyu;
    protected CampaignTutorialStage stage = CampaignTutorialStage.SHOW_WELCOME_DIALOG;
    protected boolean orbitalResetDone = false;
    protected CampaignTerrainAPI debrisField;
    protected CampaignFleetAPI pirateFleet;
    protected CampaignFleetAPI detachment;
    protected TutorialMissionIntel intel;
    protected CampaignTutorialStage quickSaveFrom = null;
    protected boolean charTabWasOpen = false;

    public CampaignTutorialScript(StarSystemAPI system) {
        this.system = system;
        this.debrisField = (CampaignTerrainAPI)system.getEntityById("debris_tutorial");
        this.ancyra = (PlanetAPI)system.getEntityById("ancyra");
        this.derinkuyu = system.getEntityById("derinkuyu_station");
        Global.getSector().getMemoryWithoutUpdate().set(USE_TUTORIAL_RESPAWN, true);
    }

    protected Object readResolve() {
        return this;
    }

    protected Object writeReplace() {
        if (this.askedPlayerToSave) {
            this.playerSaved = true;
            HintPanelAPI hints = Global.getSector().getCampaignUI().getHintPanel();
            if (hints != null) {
                hints.clearHints(false);
            }
        }
        return this;
    }

    protected boolean quickSaveNag(CampaignTutorialStage nagStage, CampaignTutorialStage next, float timeout) {
        HintPanelAPI hints = Global.getSector().getCampaignUI().getHintPanel();
        if (this.stage == nagStage) {
            this.quickSaveFrom = nagStage;
            hints.clearHints();
            String control = Global.getSettings().getControlStringForEnumName("QUICK_SAVE");
            if (timeout > 0.0f) {
                hints.setHint(0, "- Press %s to quick-save, if you like", true, Misc.getHighlightColor(), control);
            } else {
                hints.setHint(0, "- Press %s to quick-save and advance the tutorial", true, Misc.getHighlightColor(), control);
            }
            this.stage = CampaignTutorialStage.WAITING_TO_QUICKSAVE;
            this.elapsed = 0.0f;
            this.askedPlayerToSave = true;
            this.playerSaved = false;
            return true;
        }
        if (this.quickSaveFrom == nagStage && this.stage == CampaignTutorialStage.WAITING_TO_QUICKSAVE && (this.playerSaved || timeout > 0.0f && this.elapsed > timeout)) {
            hints.clearHints();
            this.stage = next;
            this.elapsed = 0.0f;
            this.playerSaved = false;
            this.askedPlayerToSave = false;
            this.quickSaveFrom = null;
            return true;
        }
        return false;
    }

    protected void leashToStartLocation() {
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        float dist = Misc.getDistance(pf.getLocation(), this.debrisField.getLocation());
        if (dist > 1500.0f) {
            Vector2f loc = this.debrisField.getLocation();
            pf.setLocation(loc.x, loc.y);
            Global.getSector().getCampaignUI().showMessageDialog("Please follow the instructions near the bottom of the screen and quicksave to advance the tutorial.");
        }
    }

    @Override
    public void advance(float amount) {
        String control;
        if (Global.getSector().isInFastAdvance()) {
            return;
        }
        if (!this.orbitalResetDone) {
            this.system.getEntityById("ancyra").setCircularOrbitAngle(55.0f);
            this.system.getEntityById("ancyra_relay").setCircularOrbitAngle(-5.0f);
            this.system.getEntityById("pontus").setCircularOrbitAngle(230.0f);
            this.system.getEntityById("pontus_L4").setCircularOrbitAngle(290.0f);
            this.system.getEntityById("pontus_L5").setCircularOrbitAngle(170.0f);
            this.system.getEntityById("galatia_probe").setCircularOrbitAngle(230.0f);
            this.system.getEntityById("galatia_jump_point_alpha").setCircularOrbitAngle(410.0f);
            this.system.getEntityById("tetra").setCircularOrbitAngle(340.0f);
            this.system.getEntityById("derinkuyu_station").setCircularOrbitAngle(135.0f);
            this.system.getEntityById("galatia_jump_point_fringe").setCircularOrbitAngle(160.0f);
            this.orbitalResetDone = true;
        }
        if (amount == 0.0f) {
            return;
        }
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        if (playerFleet == null) {
            return;
        }
        HintPanelAPI hints = Global.getSector().getCampaignUI().getHintPanel();
        if (hints == null) {
            return;
        }
        if (this.lastCheckDistToAncyra < 0.0f) {
            this.lastCheckDistToAncyra = Misc.getDistance(playerFleet.getLocation(), this.ancyra.getLocation());
        }
        this.elapsed += amount;
        if (this.stage == CampaignTutorialStage.SHOW_WELCOME_DIALOG && this.elapsed > 1.0f) {
            if (Global.getSector().getCampaignUI().showInteractionDialog(new TutorialWelcomeDialogPluginImpl(), null)) {
                this.addFleets();
                this.stage = CampaignTutorialStage.SHOW_DEBRIS_HINT;
            }
            return;
        }
        if (this.stage == CampaignTutorialStage.SHOW_DEBRIS_HINT) {
            String control2 = Global.getSettings().getControlStringForAbilitySlot(5);
            hints.setHint(1, "- Move up into the debris field");
            hints.setHint(0, "- Press %s to start scavenging", false, Misc.getHighlightColor(), control2);
            hints.makeDim(0);
            this.stage = CampaignTutorialStage.HEADING_TO_DEBRIS;
            return;
        }
        if (this.stage == CampaignTutorialStage.HEADING_TO_DEBRIS) {
            if (this.debrisField.getPlugin().containsEntity(playerFleet)) {
                this.stage = CampaignTutorialStage.REACHED_DEBRIS;
                hints.fadeOutHint(1);
                String control3 = Global.getSettings().getControlStringForAbilitySlot(5);
                hints.setHint(0, "- Press %s to start scavenging", true, Misc.getHighlightColor(), control3);
            }
            return;
        }
        if (this.stage == CampaignTutorialStage.REACHED_DEBRIS) {
            AbilityPlugin scavenge = playerFleet.getAbility("scavenge");
            if (scavenge != null && scavenge.isOnCooldown()) {
                this.stage = CampaignTutorialStage.SAVE_NAG_1;
            }
            return;
        }
        if (this.quickSaveFrom == CampaignTutorialStage.SAVE_NAG_1) {
            this.leashToStartLocation();
        }
        if (this.quickSaveNag(CampaignTutorialStage.SAVE_NAG_1, CampaignTutorialStage.SHOW_PIRATE_DIALOG, 0.0f)) {
            return;
        }
        if (this.stage == CampaignTutorialStage.SHOW_PIRATE_DIALOG && this.elapsed >= 1.0f) {
            if (Global.getSector().getCampaignUI().showInteractionDialog(new TutorialPirateApproachesDialogPluginImpl(), null)) {
                this.stage = CampaignTutorialStage.SHOW_PIRATE_HINT;
            }
            return;
        }
        if (this.stage == CampaignTutorialStage.SHOW_PIRATE_HINT) {
            this.addPirateFleet();
            hints.setHint(0, "- Wait for the pirates to approach, then engage and defeat them!");
            this.stage = CampaignTutorialStage.PIRATE_APPROACHES;
            return;
        }
        if (this.stage == CampaignTutorialStage.PIRATE_APPROACHES) {
            if (this.pirateFleet == null || !this.pirateFleet.isAlive()) {
                hints.clearHints();
                this.stage = CampaignTutorialStage.SAVE_NAG_2;
                this.elapsed = 0.0f;
                long xp = Global.getSector().getPlayerPerson().getStats().getXP();
                long add = Global.getSettings().getLevelupPlugin().getXPForLevel(2) - xp;
                if (add > 0L) {
                    Global.getSector().getPlayerPerson().getStats().addPoints(1);
                    Global.getSector().getPlayerPerson().getStats().addXP(add);
                }
            }
            return;
        }
        if (this.quickSaveNag(CampaignTutorialStage.SAVE_NAG_2, CampaignTutorialStage.SHOW_LEVELUP_DIALOG, 0.0f)) {
            return;
        }
        if (this.stage == CampaignTutorialStage.SHOW_LEVELUP_DIALOG && this.elapsed >= 1.0f) {
            if (Global.getSector().getCampaignUI().showInteractionDialog(new TutorialLevelUpDialogPluginImpl(), null)) {
                this.stage = CampaignTutorialStage.SHOW_LEVELUP_HINT;
            }
            return;
        }
        if (this.stage == CampaignTutorialStage.SHOW_LEVELUP_HINT) {
            String character = Global.getSettings().getControlStringForEnumName("CORE_CHARACTER");
            hints.setHint(0, "- Press %s to open the character tab and consider your options", true, Misc.getHighlightColor(), character);
            this.stage = CampaignTutorialStage.WAIT_CHAR_TAB;
            return;
        }
        if (this.stage == CampaignTutorialStage.WAIT_CHAR_TAB) {
            CoreUITabId tab = Global.getSector().getCampaignUI().getCurrentCoreTab();
            if (tab == CoreUITabId.CHARACTER) {
                this.charTabWasOpen = true;
            }
            if (this.charTabWasOpen && !Global.getSector().getCampaignUI().isShowingDialog()) {
                this.stage = CampaignTutorialStage.SHOW_LAY_IN_COURSE_DIALOG;
                this.elapsed = 0.0f;
                hints.clearHints();
            }
        }
        if (this.stage == CampaignTutorialStage.SHOW_LAY_IN_COURSE_DIALOG && this.elapsed >= 1.0f) {
            this.startTutorialMissionEvent();
            if (Global.getSector().getCampaignUI().showInteractionDialog(new TutorialLayInCourseDialogPluginImpl(this.ancyra.getMarket(), this.intel.getMainContact()), null)) {
                this.stage = CampaignTutorialStage.SHOW_LAY_IN_COURSE_HINT;
            }
            return;
        }
        if (this.stage == CampaignTutorialStage.SHOW_LAY_IN_COURSE_HINT) {
            String intel = Global.getSettings().getControlStringForEnumName("CORE_INTEL");
            String map = Global.getSettings().getControlStringForEnumName("CORE_MAP");
            String openMap = Global.getSettings().getControlStringForEnumName("SUBTAB_4");
            hints.setHint(2, "- Press %s to open the intel tab, and select the mission", false, Misc.getHighlightColor(), intel);
            hints.setHint(1, "- Press %s to open the map on the mission target", false, Misc.getHighlightColor(), openMap);
            hints.setHint(0, "- Click on " + this.ancyra.getName() + " and select " + "%s, then press %s to close the map", false, Misc.getHighlightColor(), "\"Lay in Course\"", map);
            this.stage = CampaignTutorialStage.WAITING_TO_LAY_IN_COURSE;
            return;
        }
        if (this.stage == CampaignTutorialStage.WAITING_TO_LAY_IN_COURSE) {
            boolean closedIn;
            float dist = Misc.getDistance(playerFleet.getLocation(), this.ancyra.getLocation());
            boolean bl = closedIn = dist < this.lastCheckDistToAncyra * 0.75f;
            if (closedIn || playerFleet.getInteractionTarget() != null && playerFleet.getInteractionTarget().getMarket() == this.ancyra.getMarket()) {
                this.lastCheckDistToAncyra = dist;
                hints.clearHints();
                this.stage = CampaignTutorialStage.SHOW_SUSTAINED_BURN_DIALOG;
                this.elapsed = 0.0f;
            }
            return;
        }
        if (this.stage == CampaignTutorialStage.SHOW_SUSTAINED_BURN_DIALOG && this.elapsed > 5.0f) {
            if (Global.getSector().getCampaignUI().showInteractionDialog(new TutorialSustainedBurnDialogPluginImpl(this.ancyra.getMarket()), null)) {
                this.stage = CampaignTutorialStage.SHOW_SUSTAINED_BURN_HINT;
            }
            return;
        }
        if (this.stage == CampaignTutorialStage.SHOW_SUSTAINED_BURN_HINT) {
            control = Global.getSettings().getControlStringForAbilitySlot(4);
            hints.setHint(0, "- Press %s to engage sustained burn", true, Misc.getHighlightColor(), control);
            this.stage = CampaignTutorialStage.WAIT_SUSTAINED_BURN_USE;
            this.elapsed = 0.0f;
            return;
        }
        if (this.stage == CampaignTutorialStage.WAIT_SUSTAINED_BURN_USE) {
            boolean closedIn;
            AbilityPlugin sb = playerFleet.getAbility("sustained_burn");
            float dist = Misc.getDistance(playerFleet.getLocation(), this.ancyra.getLocation());
            boolean bl = closedIn = dist < this.lastCheckDistToAncyra * 0.75f;
            if (sb != null && sb.isActive() && this.elapsed > 5.0f || closedIn) {
                this.lastCheckDistToAncyra = dist;
                hints.clearHints();
                this.stage = CampaignTutorialStage.SHOW_GO_SLOW_DIALOG;
                this.elapsed = 0.0f;
            }
            return;
        }
        if (this.stage == CampaignTutorialStage.SHOW_GO_SLOW_DIALOG && Global.getSector().getPlayerFleet().getLocation().length() < 9300.0f) {
            if (Global.getSector().getCampaignUI().showInteractionDialog(new TutorialGoSlowDialogPluginImpl(), null)) {
                this.stage = CampaignTutorialStage.SHOW_GO_SLOW_HINT;
            }
            return;
        }
        if (this.stage == CampaignTutorialStage.SHOW_GO_SLOW_HINT) {
            control = Global.getSettings().getControlStringForEnumName("GO_SLOW");
            hints.clearHints();
            hints.setHint(0, "- Press and hold %s to move slowly through the asteroid belt", true, Misc.getHighlightColor(), control);
            this.stage = CampaignTutorialStage.WAITING_TO_GO_SLOW;
            this.elapsed = 0.0f;
            return;
        }
        if (this.stage == CampaignTutorialStage.WAITING_TO_GO_SLOW && Global.getSector().getPlayerFleet().getLocation().length() < 7850.0f) {
            boolean closedIn;
            float dist = Misc.getDistance(playerFleet.getLocation(), this.ancyra.getLocation());
            boolean bl = closedIn = dist < this.lastCheckDistToAncyra * 0.75f;
            if (closedIn || playerFleet.getInteractionTarget() != null && playerFleet.getInteractionTarget().getMarket() == this.ancyra.getMarket()) {
                this.lastCheckDistToAncyra = dist;
                hints.clearHints();
                this.stage = CampaignTutorialStage.SHOW_TRANSPONDER_DIALOG;
                this.elapsed = 0.0f;
            }
            return;
        }
        if (this.stage == CampaignTutorialStage.SHOW_TRANSPONDER_DIALOG) {
            float dist = Misc.getDistance(playerFleet.getLocation(), this.ancyra.getLocation());
            if (dist < 6000.0f && Global.getSector().getCampaignUI().showInteractionDialog(new TutorialTransponderDialogPluginImpl(this.ancyra.getMarket()), null)) {
                this.stage = CampaignTutorialStage.SHOW_TRANSPONDER_HINT;
            }
            return;
        }
        if (this.stage == CampaignTutorialStage.SHOW_TRANSPONDER_HINT) {
            control = Global.getSettings().getControlStringForAbilitySlot(0);
            hints.setHint(0, "- Press %s twice to turn on the transponder", true, Misc.getHighlightColor(), control);
            this.stage = CampaignTutorialStage.WAIT_TRANSPONDER_USE;
            this.elapsed = 0.0f;
            return;
        }
        if (this.stage == CampaignTutorialStage.WAIT_TRANSPONDER_USE) {
            AbilityPlugin transponder = playerFleet.getAbility("transponder");
            if (transponder != null && transponder.isActive()) {
                hints.clearHints();
                this.stage = CampaignTutorialStage.DONE;
                this.elapsed = 0.0f;
            }
            return;
        }
    }

    protected void addFleets() {
        this.addSecurityDetachment();
        SectorEntityToken inner = this.system.getEntityById("galatia_jump_point_alpha");
        SectorEntityToken fringe = this.system.getEntityById("galatia_jump_point_fringe");
        SectorEntityToken derinkuyu = this.system.getEntityById("derinkuyu_station");
        CampaignFleetAPI g1 = RogueMinerMiscFleetManager.createGuardFleet(false);
        g1.addScript(new TutorialLeashAssignmentAI(g1, this.system, derinkuyu));
        this.system.addEntity(g1);
        g1.setLocation(derinkuyu.getLocation().x, derinkuyu.getLocation().y);
        CampaignFleetAPI g2 = RogueMinerMiscFleetManager.createGuardFleet(Misc.isEasy());
        if (!Misc.isEasy()) {
            FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "venture_Outdated");
            member.setVariant(member.getVariant().clone(), false, false);
            DModManager.setDHull(member.getVariant());
            member.getVariant().addPermaMod("comp_armor", false);
            member.getVariant().addPermaMod("faulty_grid", false);
            g2.getFleetData().addFleetMember(member);
        }
        g2.getFleetData().sort();
        g2.addScript(new TutorialLeashAssignmentAI(g2, this.system, inner));
        this.system.addEntity(g2);
        g2.setLocation(inner.getLocation().x, inner.getLocation().y);
        CampaignFleetAPI g3 = RogueMinerMiscFleetManager.createGuardFleet(true);
        g3.addScript(new TutorialLeashAssignmentAI(g3, this.system, inner));
        this.system.addEntity(g3);
        g3.setLocation(inner.getLocation().x, inner.getLocation().y);
        CampaignFleetAPI g4 = RogueMinerMiscFleetManager.createGuardFleet(true);
        g4.addScript(new TutorialLeashAssignmentAI(g4, this.system, fringe));
        this.system.addEntity(g4);
        g4.setLocation(fringe.getLocation().x, fringe.getLocation().y);
        CampaignFleetAPI g5 = RogueMinerMiscFleetManager.createGuardFleet(true);
        g5.addScript(new TutorialLeashAssignmentAI(g5, this.system, fringe));
        this.system.addEntity(g5);
        g5.setLocation(fringe.getLocation().x, fringe.getLocation().y);
    }

    protected void startTutorialMissionEvent() {
        if (this.intel == null) {
            this.intel = new TutorialMissionIntel();
        }
    }

    protected void addPirateFleet() {
        this.pirateFleet = RogueMinerMiscFleetManager.createEmptyRogueFleet("Rogue Miner", false);
        this.pirateFleet.getMemoryWithoutUpdate().set("$noShipRecovery", true);
        FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "cerberus_d_pirates_Standard");
        this.pirateFleet.getFleetData().addFleetMember(member);
        this.system.addEntity(this.pirateFleet);
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        this.pirateFleet.setLocation(playerFleet.getLocation().x + 750.0f, playerFleet.getLocation().y + 750.0f);
        TransmitterTrapSpecial.makeFleetInterceptPlayer(this.pirateFleet, true, true, 100.0f);
    }

    protected void addSecurityDetachment() {
        this.detachment = FleetFactoryV3.createEmptyFleet("hegemony", "patrolMedium", this.ancyra.getMarket());
        this.detachment.setName("Security Detachment");
        this.detachment.setNoFactionInName(true);
        this.detachment.getFleetData().addFleetMember("dominator_XIV_Elite");
        this.detachment.getFleetData().addFleetMember("mora_Strike");
        this.detachment.getFleetData().addFleetMember("enforcer_Escort");
        this.detachment.getFleetData().addFleetMember("enforcer_Assault");
        this.detachment.getFleetData().addFleetMember("lasher_CS");
        this.detachment.getFleetData().addFleetMember("lasher_CS");
        this.detachment.clearAbilities();
        this.detachment.addAbility("transponder");
        this.detachment.addAbility("go_dark");
        this.detachment.addAbility("sensor_burst");
        this.detachment.addAbility("emergency_burn");
        this.detachment.getMemoryWithoutUpdate().set("$isPatrol", true);
        this.detachment.getMemoryWithoutUpdate().set("$cfai_noJump", true);
        this.system.addEntity(this.detachment);
        this.detachment.setLocation(this.ancyra.getLocation().x, this.ancyra.getLocation().y);
        this.detachment.addScript(new TutorialLeashAssignmentAI(this.detachment, this.system, this.ancyra));
        this.detachment.setId("tutorial_security_detachment");
    }

    @Override
    public boolean isDone() {
        return this.stage == CampaignTutorialStage.DONE;
    }

    @Override
    public boolean runWhilePaused() {
        return this.stage == CampaignTutorialStage.WAIT_CHAR_TAB;
    }

    public static enum CampaignTutorialStage {
        SHOW_WELCOME_DIALOG,
        SHOW_DEBRIS_HINT,
        HEADING_TO_DEBRIS,
        REACHED_DEBRIS,
        SAVE_NAG_1,
        SHOW_PIRATE_DIALOG,
        SHOW_PIRATE_HINT,
        PIRATE_APPROACHES,
        SAVE_NAG_2,
        SHOW_LEVELUP_DIALOG,
        SHOW_LEVELUP_HINT,
        WAIT_CHAR_TAB,
        SHOW_LAY_IN_COURSE_DIALOG,
        SHOW_LAY_IN_COURSE_HINT,
        WAITING_TO_LAY_IN_COURSE,
        SHOW_GO_SLOW_DIALOG,
        SHOW_GO_SLOW_HINT,
        WAITING_TO_GO_SLOW,
        SHOW_SUSTAINED_BURN_DIALOG,
        SHOW_SUSTAINED_BURN_HINT,
        WAIT_SUSTAINED_BURN_USE,
        SHOW_TRANSPONDER_DIALOG,
        SHOW_TRANSPONDER_HINT,
        WAIT_TRANSPONDER_USE,
        DONE,
        WAITING_TO_QUICKSAVE;

    }
}

