/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.tutorial;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.PersistentUIDataAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.loading.AbilitySpecAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.Map;

public class TutorialWelcomeDialogPluginImpl
implements InteractionDialogPlugin {
    protected InteractionDialogAPI dialog;
    protected TextPanelAPI textPanel;
    protected OptionPanelAPI options;
    protected VisualPanelAPI visual;
    protected CampaignFleetAPI playerFleet;

    @Override
    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        this.textPanel = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.visual.showFleetInfo("Your fleet", this.playerFleet, null, null);
        this.optionSelected(null, (Object)OptionId.INIT);
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return null;
    }

    @Override
    public void backFromEngagement(EngagementResultAPI result) {
    }

    @Override
    public void optionSelected(String text, Object optionData) {
        if (optionData == null) {
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        if (text != null) {
            this.dialog.addOptionSelectedText((Object)option);
        }
        switch (option) {
            case INIT: {
                this.textPanel.addParagraph("Welcome to the Persean Sector! Your fleet is in the middle of nowhere and critically low on supplies.");
                this.textPanel.addParagraph("If you don't acquire more supplies, your fleet will suffer through a slow but ultimately fatal decline.");
                this.options.clearOptions();
                this.options.addOption("Continue", (Object)OptionId.CONT1, null);
                break;
            }
            case CONT1: {
                AbilitySpecAPI ability = Global.getSettings().getAbilitySpec("scavenge");
                this.textPanel.addPara("Fortunately, there's a debris field nearby. Move up into it and activate your %s ability to search it for useful cargo.", Misc.getHighlightColor(), "\"" + ability.getName() + "\"");
                this.textPanel.addParagraph("Scavenging requires Heavy Machinery, but there is some in your cargo holds.");
                Global.getSector().getCharacterData().addAbility(ability.getId());
                PersistentUIDataAPI.AbilitySlotsAPI slots = Global.getSector().getUIData().getAbilitySlotsAPI();
                slots.setCurrBarIndex(0);
                int slotIndex = 5;
                slots.getCurrSlotsCopy().get(slotIndex).setAbilityId(ability.getId());
                AddRemoveCommodity.addAbilityGainText(ability.getId(), this.textPanel);
                this.textPanel.addParagraph("Make sure to take all of the supplies and any other valuable cargo, but feel free to leave the cheap and bulky metals behind.");
                this.textPanel.addParagraph("To get your fleet moving, click on empty space in the direction you want to move.");
                this.options.clearOptions();
                this.options.addOption("Finish", (Object)OptionId.CONT2, null);
                break;
            }
            case CONT2: {
                Global.getSector().setPaused(false);
                this.dialog.dismiss();
            }
        }
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }

    @Override
    public void advance(float amount) {
    }

    @Override
    public Object getContext() {
        return null;
    }

    public static enum OptionId {
        INIT,
        CONT1,
        CONT2;

    }
}

