/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.velfield;

import com.fs.starfarer.api.impl.campaign.velfield.VelocityField;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public class TurbulenceCalc {
    public static Vector2f[] DIRECTIONS = new Vector2f[8];

    static {
        int i = 0;
        while (i < 8) {
            float angle = (float)i * 45.0f + 180.0f;
            TurbulenceCalc.DIRECTIONS[i] = Misc.getUnitVectorAtDegreeAngle(angle);
            ++i;
        }
    }

    public static void advance(VelocityField field, float propagationSpeed, float amount) {
        int j;
        Vector2f[][] f = field.getField();
        Vector2f[][] delta = new Vector2f[f.length][f[0].length];
        int i = 0;
        while (i < f.length) {
            int j2 = 0;
            while (j2 < f[0].length) {
                delta[i][j2] = new Vector2f();
                ++j2;
            }
            ++i;
        }
        Vector2f[][] delta2 = new Vector2f[f.length][f[0].length];
        int i2 = 0;
        while (i2 < f.length) {
            int j3 = 0;
            while (j3 < f[0].length) {
                delta2[i2][j3] = new Vector2f();
                ++j3;
            }
            ++i2;
        }
        float mult = propagationSpeed * amount;
        int i3 = 0;
        while (i3 < f.length) {
            j = 0;
            while (j < f[0].length) {
                TurbulenceCalc.addCell(f, delta, i3 + 1, j + 0, i3, j, DIRECTIONS[0], mult);
                TurbulenceCalc.addCell(f, delta, i3 + 1, j + 1, i3, j, DIRECTIONS[1], mult);
                TurbulenceCalc.addCell(f, delta, i3 + 0, j + 1, i3, j, DIRECTIONS[2], mult);
                TurbulenceCalc.addCell(f, delta, i3 - 1, j + 1, i3, j, DIRECTIONS[3], mult);
                TurbulenceCalc.addCell(f, delta, i3 - 1, j + 0, i3, j, DIRECTIONS[4], mult);
                TurbulenceCalc.addCell(f, delta, i3 - 1, j - 1, i3, j, DIRECTIONS[5], mult);
                TurbulenceCalc.addCell(f, delta, i3 - 0, j - 1, i3, j, DIRECTIONS[6], mult);
                TurbulenceCalc.addCell(f, delta, i3 + 1, j - 1, i3, j, DIRECTIONS[7], mult);
                ++j;
            }
            ++i3;
        }
        mult = -1.0f;
        i3 = 0;
        while (i3 < f.length) {
            j = 0;
            while (j < f[0].length) {
                TurbulenceCalc.addCell(delta, delta2, i3 + 1, j + 0, i3, j, DIRECTIONS[0], mult);
                TurbulenceCalc.addCell(delta, delta2, i3 + 1, j + 1, i3, j, DIRECTIONS[1], mult);
                TurbulenceCalc.addCell(delta, delta2, i3 + 0, j + 1, i3, j, DIRECTIONS[2], mult);
                TurbulenceCalc.addCell(delta, delta2, i3 - 1, j + 1, i3, j, DIRECTIONS[3], mult);
                TurbulenceCalc.addCell(delta, delta2, i3 - 1, j + 0, i3, j, DIRECTIONS[4], mult);
                TurbulenceCalc.addCell(delta, delta2, i3 - 1, j - 1, i3, j, DIRECTIONS[5], mult);
                TurbulenceCalc.addCell(delta, delta2, i3 - 0, j - 1, i3, j, DIRECTIONS[6], mult);
                TurbulenceCalc.addCell(delta, delta2, i3 + 1, j - 1, i3, j, DIRECTIONS[7], mult);
                ++j;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < f.length) {
            j = 0;
            while (j < f[0].length) {
                Vector2f.add((Vector2f)f[i3][j], (Vector2f)delta[i3][j], (Vector2f)f[i3][j]);
                ++j;
            }
            ++i3;
        }
    }

    public static Vector2f getCell(Vector2f[][] data, int i, int j) {
        if (i < 0 || j < 0) {
            return new Vector2f();
        }
        if (i >= data.length || j >= data[0].length) {
            return new Vector2f();
        }
        return data[i][j];
    }

    public static void addCell(Vector2f[][] field, Vector2f[][] delta, int fromX, int fromY, int x, int y, Vector2f dir, float propagationMult) {
        Vector2f cell = TurbulenceCalc.getCell(field, fromX, fromY);
        Vector2f d = TurbulenceCalc.getCell(delta, x, y);
        Vector2f dFrom = TurbulenceCalc.getCell(delta, fromX, fromY);
        float dot = Vector2f.dot((Vector2f)cell, (Vector2f)dir);
        d.x += dir.x * dot * propagationMult;
        d.y += dir.y * dot * propagationMult;
        dFrom.x -= dir.x * dot * propagationMult;
        dFrom.y -= dir.y * dot * propagationMult;
    }

    public static void addCell(Vector2f cell, Vector2f dir, Vector2f delta) {
        float dot = Vector2f.dot((Vector2f)cell, (Vector2f)dir);
        delta.x += dir.x * dot;
        delta.y += dir.y * dot;
    }
}

