/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.codex;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.ModPlugin;
import com.fs.starfarer.api.ModSpecAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.PlanetSpecAPI;
import com.fs.starfarer.api.campaign.SpecialItemPlugin;
import com.fs.starfarer.api.campaign.SpecialItemSpecAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.impl.items.MultiBlueprintItemPlugin;
import com.fs.starfarer.api.characters.MarketConditionSpecAPI;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.combat.ShipSystemSpecAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.SharedUnlockData;
import com.fs.starfarer.api.impl.campaign.econ.ResourceDepositsCondition;
import com.fs.starfarer.api.impl.campaign.econ.impl.InstallableItemEffect;
import com.fs.starfarer.api.impl.campaign.econ.impl.ItemEffectsRepo;
import com.fs.starfarer.api.impl.campaign.ids.ShipSystems;
import com.fs.starfarer.api.impl.codex.CodexCustomEntryExample;
import com.fs.starfarer.api.impl.codex.CodexDialogAPI;
import com.fs.starfarer.api.impl.codex.CodexEntryPlugin;
import com.fs.starfarer.api.impl.codex.CodexEntryV2;
import com.fs.starfarer.api.impl.codex.CodexTextEntryLoader;
import com.fs.starfarer.api.impl.combat.threat.EnergyLashActivatedSystem;
import com.fs.starfarer.api.loading.AbilitySpecAPI;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.loading.HullModSpecAPI;
import com.fs.starfarer.api.loading.IndustrySpecAPI;
import com.fs.starfarer.api.loading.WeaponSlotAPI;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.loading.WingRole;
import com.fs.starfarer.api.loading.WithSourceMod;
import com.fs.starfarer.api.ui.CustomPanelAPI;
import com.fs.starfarer.api.ui.TagDisplayAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.UIPanelAPI;
import com.fs.starfarer.api.util.CountingMap;
import com.fs.starfarer.api.util.ListMap;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.json.JSONException;

public class CodexDataV2 {
    public static boolean WITH_GAME_MECHANICS_CAT = false;
    public static boolean WITH_CUSTOM_EXAMPLE_CAT = false;
    public static boolean USE_KEY_NAMES_FOR_GALLERY = false;
    public static CodexEntryPlugin ROOT;
    public static Map<String, CodexEntryPlugin> ENTRIES;
    public static Map<String, CodexEntryPlugin> SEEN_STATION_MODULES;
    public static String TAG_EMPTY_MODULE;
    public static String CAT_ROOT;
    public static String CAT_SHIPS;
    public static String CAT_STATIONS;
    public static String CAT_FIGHTERS;
    public static String CAT_WEAPONS;
    public static String CAT_HULLMODS;
    public static String CAT_SHIP_SYSTEMS;
    public static String CAT_SPECIAL_ITEMS;
    public static String CAT_INDUSTRIES;
    public static String CAT_STARS_AND_PLANETS;
    public static String CAT_PLANETARY_CONDITIONS;
    public static String CAT_COMMODITIES;
    public static String CAT_GALLERY;
    public static String CAT_SKILLS;
    public static String CAT_ABILITIES;
    public static String CAT_GAME_MECHANICS;
    public static String CAT_CUSTOM_EXAMPLE;
    public static String UNKNOWN_ENTRY_ID;
    public static Map<String, Float> CAT_SORT_RELATED_ENTRIES;
    public static String ALL_TECHS;
    public static String ALL_APTITUDES;
    public static String ALL_SIZES;
    public static String ALL_TYPES;
    public static String ALL_DAMAGE_TYPES;
    public static String HIGH_EXPLOSIVE;
    public static String KINETIC;
    public static String DAM_ENERGY;
    public static String FRAGMENTATION;
    public static String FRIGATES;
    public static String DESTROYERS;
    public static String CRUISERS;
    public static String CAPITALS;
    public static String COMBAT_SHIPS;
    public static String PHASE_SHIPS;
    public static String CARRIERS;
    public static String CIVILIAN;
    public static String SMALL;
    public static String MEDIUM;
    public static String LARGE;
    public static String FIGHTER_WEAPON;
    public static String BALLISTIC;
    public static String MISSILE;
    public static String ENERGY;
    public static String HYBRID;
    public static String COMPOSITE;
    public static String SYNERGY;
    public static String UNIVERSAL;
    public static String BEAM;
    public static String FIGHTER;
    public static String BOMBER;
    public static String INTERCEPTOR;
    public static String OTHER;
    public static String DMODS;
    public static String INTRINSIC;
    public static String PLANETS;
    public static String STARS;
    public static String GAS_GIANTS;
    public static String HABITABLE;
    public static String COLONY;
    public static String AI_CORE;
    public static String BLUEPRINTS;
    public static String INDUSTRIES;
    public static String STRUCTURES;
    public static String STATIONS;
    public static String RESOURCES;
    public static String PILOTED_SHIP;

    static {
        ENTRIES = new LinkedHashMap<String, CodexEntryPlugin>();
        SEEN_STATION_MODULES = new LinkedHashMap<String, CodexEntryPlugin>();
        TAG_EMPTY_MODULE = "empty_module";
        CAT_ROOT = "root";
        CAT_SHIPS = "ships";
        CAT_STATIONS = "stations";
        CAT_FIGHTERS = "fighters";
        CAT_WEAPONS = "weapons";
        CAT_HULLMODS = "hullmods";
        CAT_SHIP_SYSTEMS = "ship_systems";
        CAT_SPECIAL_ITEMS = "special_items";
        CAT_INDUSTRIES = "industries";
        CAT_STARS_AND_PLANETS = "stars_and_planets";
        CAT_PLANETARY_CONDITIONS = "conditions";
        CAT_COMMODITIES = "commodities";
        CAT_GALLERY = "gallery";
        CAT_SKILLS = "skills";
        CAT_ABILITIES = "abilities";
        CAT_GAME_MECHANICS = "game_mechanics";
        CAT_CUSTOM_EXAMPLE = "custom_example";
        UNKNOWN_ENTRY_ID = "unknown_entry";
        CAT_SORT_RELATED_ENTRIES = new HashMap<String, Float>();
        CAT_SORT_RELATED_ENTRIES.put(CAT_SHIP_SYSTEMS, Float.valueOf(0.0f));
        CAT_SORT_RELATED_ENTRIES.put(CAT_HULLMODS, Float.valueOf(10.0f));
        CAT_SORT_RELATED_ENTRIES.put(CAT_WEAPONS, Float.valueOf(20.0f));
        CAT_SORT_RELATED_ENTRIES.put(CAT_FIGHTERS, Float.valueOf(30.0f));
        CAT_SORT_RELATED_ENTRIES.put(CAT_SHIPS, Float.valueOf(40.0f));
        CAT_SORT_RELATED_ENTRIES.put(CAT_STATIONS, Float.valueOf(45.0f));
        CAT_SORT_RELATED_ENTRIES.put(CAT_SKILLS, Float.valueOf(50.0f));
        CAT_SORT_RELATED_ENTRIES.put(CAT_ABILITIES, Float.valueOf(60.0f));
        CAT_SORT_RELATED_ENTRIES.put(CAT_INDUSTRIES, Float.valueOf(100.0f));
        CAT_SORT_RELATED_ENTRIES.put(CAT_SPECIAL_ITEMS, Float.valueOf(110.0f));
        CAT_SORT_RELATED_ENTRIES.put(CAT_STARS_AND_PLANETS, Float.valueOf(120.0f));
        CAT_SORT_RELATED_ENTRIES.put(CAT_COMMODITIES, Float.valueOf(130.0f));
        CAT_SORT_RELATED_ENTRIES.put(CAT_PLANETARY_CONDITIONS, Float.valueOf(140.0f));
        CAT_SORT_RELATED_ENTRIES.put(CAT_GAME_MECHANICS, Float.valueOf(150.0f));
        CAT_SORT_RELATED_ENTRIES.put(CAT_GALLERY, Float.valueOf(160.0f));
        ALL_TECHS = "All designs";
        ALL_APTITUDES = "All aptitudes";
        ALL_SIZES = "All sizes";
        ALL_TYPES = "All types";
        ALL_DAMAGE_TYPES = "All damage";
        HIGH_EXPLOSIVE = "High explosive";
        KINETIC = "Kinetic";
        DAM_ENERGY = "_Energy";
        FRAGMENTATION = "Fragmentation";
        FRIGATES = "Frigates";
        DESTROYERS = "Destroyers";
        CRUISERS = "Cruisers";
        CAPITALS = "Capitals";
        COMBAT_SHIPS = "Warships";
        PHASE_SHIPS = "Phase ships";
        CARRIERS = "Carriers";
        CIVILIAN = "Civilian";
        SMALL = "Small";
        MEDIUM = "Medium";
        LARGE = "Large";
        FIGHTER_WEAPON = "Fighter";
        BALLISTIC = "Ballistic";
        MISSILE = "Missile";
        ENERGY = "Energy";
        HYBRID = "Hybrid";
        COMPOSITE = "Composite";
        SYNERGY = "Synergy";
        UNIVERSAL = "Universal";
        BEAM = "Beam";
        FIGHTER = "Fighters";
        BOMBER = "Bombers";
        INTERCEPTOR = "Interceptors";
        OTHER = "Other";
        DMODS = "D-mods";
        INTRINSIC = "Intrinsic";
        PLANETS = "Planets";
        STARS = "Stars";
        GAS_GIANTS = "Gas giants";
        HABITABLE = "Habitable";
        COLONY = "Colony items";
        AI_CORE = "AI cores";
        BLUEPRINTS = "Blueprint packages";
        INDUSTRIES = "Industries";
        STRUCTURES = "Structures";
        STATIONS = "Stations";
        RESOURCES = "Resources";
        PILOTED_SHIP = "Piloted ship";
    }

    public static void init() {
        ROOT = new CodexEntryV2("root", "Codex categories", null);
        ROOT.setRetainOrderOfChildren(true);
        for (ModPlugin plugin : Global.getSettings().getModManager().getEnabledModPlugins()) {
            plugin.onAboutToStartGeneratingCodex();
        }
        CodexEntryV2 ships = CodexDataV2.createShipsCategory();
        CodexEntryV2 stations = CodexDataV2.createStationsCategory();
        CodexEntryV2 fighters = CodexDataV2.createFightersCategory();
        CodexEntryV2 weapons = CodexDataV2.createWeaponsCategory();
        CodexEntryV2 hullmods = CodexDataV2.createHullModsCategory();
        CodexEntryV2 shipSystems = CodexDataV2.createShipSystemsCategory();
        CodexEntryV2 items = CodexDataV2.createSpecialItemsCategory();
        CodexEntryV2 industries = CodexDataV2.createIndustriesCategory();
        CodexEntryV2 planets = CodexDataV2.createStarsAndPlanetsCategory();
        CodexEntryV2 conditions = CodexDataV2.createPlanetaryConditionsCategory();
        CodexEntryV2 commodities = CodexDataV2.createCommoditiesCategory();
        CodexEntryV2 gallery = CodexDataV2.createGalleryCategory();
        CodexEntryV2 skills = CodexDataV2.createSkillsCategory();
        CodexEntryV2 abilities = CodexDataV2.createAbilitiesCategory();
        ROOT.addChild(ships);
        ROOT.addChild(stations);
        ROOT.addChild(fighters);
        ROOT.addChild(weapons);
        ROOT.addChild(hullmods);
        ROOT.addChild(shipSystems);
        ROOT.addChild(items);
        ROOT.addChild(industries);
        ROOT.addChild(commodities);
        ROOT.addChild(planets);
        ROOT.addChild(conditions);
        ROOT.addChild(skills);
        ROOT.addChild(abilities);
        ROOT.addChild(gallery);
        if (WITH_GAME_MECHANICS_CAT) {
            CodexEntryV2 mechanics = CodexDataV2.createGameMechanicsCategory();
            ROOT.addChild(mechanics);
        }
        CodexDataV2.rebuildIdToEntryMap();
        CodexDataV2.setCatSort(ROOT, null);
        CodexDataV2.populateShipsAndStations(ships, stations);
        CodexDataV2.populateShipSystems(shipSystems, ships);
        CodexDataV2.populateHullMods(hullmods);
        CodexDataV2.populateWeapons(weapons);
        CodexDataV2.populateFighters(fighters);
        CodexDataV2.populateStarsAndPlanets(planets);
        CodexDataV2.populatePlanetaryConditions(conditions);
        CodexDataV2.populateSpecialItems(items);
        CodexDataV2.populateCommodities(commodities, items);
        CodexDataV2.populateIndustries(industries);
        CodexDataV2.populateSkills(skills);
        CodexDataV2.populateAbilities(abilities);
        CodexDataV2.populateGallery(gallery);
        CodexDataV2.addUnknownEntry();
        if (WITH_GAME_MECHANICS_CAT) {
            CodexTextEntryLoader.loadTextEntries();
        }
        CodexDataV2.rebuildIdToEntryMap();
        for (ModPlugin plugin : Global.getSettings().getModManager().getEnabledModPlugins()) {
            plugin.onAboutToLinkCodexEntries();
        }
        CodexDataV2.sortSkillsCategory();
        CodexDataV2.linkRelatedEntries();
        if (WITH_GAME_MECHANICS_CAT) {
            CodexTextEntryLoader.linkRelated();
        }
        if (WITH_CUSTOM_EXAMPLE_CAT) {
            CodexDataV2.addCustomCodexEntryDetailPanelExample();
        }
        for (ModPlugin plugin : Global.getSettings().getModManager().getEnabledModPlugins()) {
            plugin.onCodexDataGenerated();
        }
    }

    public static void addUnknownEntry() {
        ROOT.addChild(new CodexEntryV2(UNKNOWN_ENTRY_ID, "UNKNOWN ENTRY", null, UNKNOWN_ENTRY_ID){

            @Override
            public void createTitleForList(TooltipMakerAPI info, float width, CodexEntryPlugin.ListMode mode) {
                info.addPara("UNKNOWN ENTRY", Misc.getBasePlayerColor(), 0.0f);
            }

            @Override
            public boolean isVisible() {
                return false;
            }

            @Override
            public boolean isLocked() {
                return false;
            }

            @Override
            public boolean hasCustomDetailPanel() {
                return true;
            }

            @Override
            public void createCustomDetail(CustomPanelAPI panel, UIPanelAPI relatedEntries, CodexDialogAPI codex) {
                float opad = 10.0f;
                float width = panel.getPosition().getWidth();
                float horzBoxPad = 30.0f;
                float tw = width - 290.0f - opad - horzBoxPad + 10.0f;
                TooltipMakerAPI text = panel.createUIElement(tw, 0.0f, false);
                text.setParaSmallInsignia();
                text.addPara("UNKNOWN ENTRY\n\nPlease register your Tri-Tachyon datapad to receive the latest news and updates.", 0.0f);
                panel.updateUIElementSizeAndMakeItProcessInput(text);
                UIPanelAPI box = panel.wrapTooltipWithBox(text);
                panel.addComponent(box).inTL(0.0f, 0.0f);
                if (relatedEntries != null) {
                    panel.addComponent(relatedEntries).inTR(0.0f, 0.0f);
                }
                float height = box.getPosition().getHeight();
                if (relatedEntries != null) {
                    height = Math.max(height, relatedEntries.getPosition().getHeight());
                }
            }
        });
    }

    public static void addCustomCodexEntryDetailPanelExample() {
        if (Global.getSettings().isDevMode() && !Global.getSettings().getBoolean("playtestingMode")) {
            CodexEntryV2 custom = CodexDataV2.createCustomExampleCategory();
            ROOT.addChild(custom);
            CodexCustomEntryExample entry = new CodexCustomEntryExample("custom_example_1", "Custom detail example", CodexDataV2.getIcon(CAT_CUSTOM_EXAMPLE));
            entry.setParam("Has to be set to something for detail to show; usually this is the data for what the entry is about");
            entry.setParam(Global.getSettings().getHullSpec("paragon"));
            custom.addChild(entry);
            entry.addRelatedEntry(CodexDataV2.getEntry(CodexDataV2.getHullmodEntryId("advancedcore")));
            entry.addRelatedEntry(CodexDataV2.getEntry(CodexDataV2.getShipEntryId("onslaught")));
            entry.addRelatedEntry(CodexDataV2.getEntry(CodexDataV2.getWeaponEntryId("autopulse")));
            entry.addRelatedEntry(CodexDataV2.getEntry(CodexDataV2.getFighterEntryId("wasp_wing")));
        }
    }

    public static void setCatSort(CodexEntryPlugin root, Set<CodexEntryPlugin> seen) {
        if (seen == null) {
            seen = new LinkedHashSet<CodexEntryPlugin>();
        }
        if (seen.contains(root)) {
            return;
        }
        seen.add(root);
        for (CodexEntryPlugin cat : root.getChildren()) {
            if (!cat.isCategory()) continue;
            Float sort = CAT_SORT_RELATED_ENTRIES.get(cat.getId());
            if (sort == null) {
                sort = Float.valueOf(1000.0f);
            }
            cat.setCategorySortTierForRelatedEntries(sort.floatValue());
            CodexDataV2.setCatSort(cat, seen);
        }
    }

    public static CodexEntryV2 createHullModsCategory() {
        CodexEntryV2 hullmods = new CodexEntryV2(CAT_HULLMODS, "Hullmods", CodexDataV2.getIcon(CAT_HULLMODS)){

            @Override
            public boolean hasTagDisplay() {
                return true;
            }

            @Override
            public void configureTagDisplay(TagDisplayAPI tags) {
                CountingMap<String> techs = new CountingMap<String>();
                CountingMap<String> types = new CountingMap<String>();
                int dmods = 0;
                int intrinsic = 0;
                int total = 0;
                for (CodexEntryPlugin curr : this.getChildren()) {
                    if (!(curr.getParam() instanceof HullModSpecAPI) || !curr.isVisible() || curr.isLocked() || curr.skipForTags()) continue;
                    HullModSpecAPI spec = (HullModSpecAPI)curr.getParam();
                    if (spec.hasTag("dmod")) {
                        ++dmods;
                    } else if (spec.isHidden()) {
                        ++intrinsic;
                    }
                    techs.add(spec.getManufacturer());
                    for (String type : spec.getUITags()) {
                        types.add(type);
                    }
                    ++total;
                }
                if (dmods > 0) {
                    types.add(DMODS, dmods);
                }
                if (intrinsic > 0) {
                    types.add(INTRINSIC, intrinsic);
                }
                float opad = 10.0f;
                float pad = 3.0f;
                tags.beginGroup(false, ALL_TECHS);
                ArrayList keys = new ArrayList(techs.keySet());
                Collections.sort(keys);
                for (String tech : keys) {
                    tags.addTag(tech, tech, techs.getCount(tech));
                }
                tags.setTotalOverrideForCurrentGroup(total);
                tags.addGroup(0.0f);
                tags.beginGroup(false, ALL_TYPES);
                keys = new ArrayList(types.keySet());
                Collections.sort(keys);
                for (String type : keys) {
                    tags.addTag(type, type, types.getCount(type));
                }
                tags.setTotalOverrideForCurrentGroup(total);
                tags.addGroup(opad * 1.0f);
                tags.checkAll();
            }
        };
        return hullmods;
    }

    public static CodexEntryV2 createGameMechanicsCategory() {
        CodexEntryV2 cat = new CodexEntryV2(CAT_GAME_MECHANICS, "Spacer's Manual", CodexDataV2.getIcon(CAT_GAME_MECHANICS)){

            @Override
            public boolean hasCustomDetailPanel() {
                return true;
            }

            @Override
            public boolean hasDetail() {
                return true;
            }

            @Override
            public void createCustomDetail(CustomPanelAPI panel, UIPanelAPI relatedEntries, CodexDialogAPI codex) {
                Color color = Misc.getBasePlayerColor();
                Color dark = Misc.getDarkPlayerColor();
                Color h = Misc.getHighlightColor();
                Color g = Misc.getGrayColor();
                float opad = 10.0f;
                float pad = 3.0f;
                float small = 5.0f;
                float width = panel.getPosition().getWidth();
                float initPad = 0.0f;
                float horzBoxPad = 30.0f;
                float tw = width - 290.0f - opad - horzBoxPad + 10.0f;
                TooltipMakerAPI text = panel.createUIElement(tw, 0.0f, false);
                text.setParaSmallInsignia();
                text.addPara("Spacer's manual description test.", 0.0f);
                panel.updateUIElementSizeAndMakeItProcessInput(text);
                UIPanelAPI box = panel.wrapTooltipWithBox(text);
                panel.addComponent(box).inTL(0.0f, 0.0f);
                if (relatedEntries != null) {
                    panel.addComponent(relatedEntries).inTR(0.0f, 0.0f);
                }
                float height = box.getPosition().getHeight();
                if (relatedEntries != null) {
                    height = Math.max(height, relatedEntries.getPosition().getHeight());
                }
                panel.getPosition().setSize(width, height);
            }
        };
        return cat;
    }

    public static CodexEntryV2 createGalleryCategory() {
        CodexEntryV2 cat = new CodexEntryV2(CAT_GALLERY, "Gallery", CodexDataV2.getIcon(CAT_GALLERY));
        return cat;
    }

    public static CodexEntryV2 createCommoditiesCategory() {
        CodexEntryV2 cat = new CodexEntryV2(CAT_COMMODITIES, "Commodities", CodexDataV2.getIcon(CAT_COMMODITIES)){};
        return cat;
    }

    public static CodexEntryV2 createIndustriesCategory() {
        CodexEntryV2 cat = new CodexEntryV2(CAT_INDUSTRIES, "Industries", CodexDataV2.getIcon(CAT_INDUSTRIES)){

            @Override
            public boolean hasTagDisplay() {
                return true;
            }

            @Override
            public void configureTagDisplay(TagDisplayAPI tags) {
                int industry = 0;
                int structure = 0;
                int station = 0;
                int other = 0;
                int total = 0;
                for (CodexEntryPlugin curr : this.getChildren()) {
                    if (!curr.isVisible() || curr.isLocked() || curr.skipForTags() || !(curr.getParam() instanceof IndustrySpecAPI)) continue;
                    IndustrySpecAPI spec = (IndustrySpecAPI)curr.getParam();
                    if (spec.hasTag("industry")) {
                        ++industry;
                    } else if (spec.hasTag("station")) {
                        ++station;
                    } else if (spec.hasTag("structure")) {
                        ++structure;
                    } else {
                        ++other;
                    }
                    ++total;
                }
                tags.beginGroup(false, ALL_TYPES);
                tags.addTag(INDUSTRIES, industry);
                tags.addTag(STRUCTURES, structure);
                if (station > 0) {
                    tags.addTag(STATIONS, station);
                }
                if (other > 0) {
                    tags.addTag(OTHER, other);
                }
                tags.setTotalOverrideForCurrentGroup(total);
                tags.addGroup(0.0f);
                tags.checkAll();
            }
        };
        return cat;
    }

    public static CodexEntryV2 createSpecialItemsCategory() {
        CodexEntryV2 cat = new CodexEntryV2(CAT_SPECIAL_ITEMS, "Special items", CodexDataV2.getIcon(CAT_SPECIAL_ITEMS)){

            @Override
            public boolean hasTagDisplay() {
                return true;
            }

            @Override
            public void configureTagDisplay(TagDisplayAPI tags) {
                int colony = 0;
                int core = 0;
                int bp = 0;
                int other = 0;
                int total = 0;
                for (CodexEntryPlugin curr : this.getChildren()) {
                    if (!curr.isVisible() || curr.isLocked() || curr.skipForTags()) continue;
                    if (curr.getParam() instanceof SpecialItemSpecAPI) {
                        spec = (SpecialItemSpecAPI)curr.getParam();
                        if (spec.hasTag("colony_item")) {
                            ++colony;
                        } else if (spec.hasTag("package_bp")) {
                            ++bp;
                        } else {
                            ++other;
                        }
                    } else if (curr.getParam() instanceof CommoditySpecAPI) {
                        spec = (CommoditySpecAPI)curr.getParam();
                        if (spec.hasTag("ai_core")) {
                            ++core;
                        } else {
                            ++other;
                        }
                    }
                    ++total;
                }
                tags.beginGroup(false, ALL_TYPES);
                if (colony > 0) {
                    tags.addTag(COLONY, colony);
                }
                if (bp > 0) {
                    tags.addTag(BLUEPRINTS, bp);
                }
                if (core > 0) {
                    tags.addTag(AI_CORE, core);
                }
                if (other > 0) {
                    tags.addTag(OTHER, other);
                }
                tags.setTotalOverrideForCurrentGroup(total);
                tags.addGroup(0.0f);
                tags.checkAll();
            }
        };
        return cat;
    }

    public static CodexEntryV2 createPlanetaryConditionsCategory() {
        CodexEntryV2 cat = new CodexEntryV2(CAT_PLANETARY_CONDITIONS, "Planetary conditions", CodexDataV2.getIcon(CAT_PLANETARY_CONDITIONS)){

            @Override
            public boolean hasTagDisplay() {
                return true;
            }

            @Override
            public void configureTagDisplay(TagDisplayAPI tags) {
                int resource = 0;
                int other = 0;
                int total = 0;
                for (CodexEntryPlugin curr : this.getChildren()) {
                    if (!curr.isVisible() || curr.isLocked() || curr.skipForTags() || !(curr.getParam() instanceof MarketConditionSpecAPI)) continue;
                    MarketConditionSpecAPI spec = (MarketConditionSpecAPI)curr.getParam();
                    if (ResourceDepositsCondition.COMMODITY.containsKey(spec.getId())) {
                        ++resource;
                    } else {
                        ++other;
                    }
                    ++total;
                }
                tags.beginGroup(false, ALL_TYPES);
                tags.addTag(RESOURCES, resource);
                tags.addTag(OTHER, other);
                tags.setTotalOverrideForCurrentGroup(total);
                tags.addGroup(0.0f);
                tags.checkAll();
            }
        };
        return cat;
    }

    public static CodexEntryV2 createStarsAndPlanetsCategory() {
        CodexEntryV2 cat = new CodexEntryV2(CAT_STARS_AND_PLANETS, "Stars & planets", CodexDataV2.getIcon(CAT_STARS_AND_PLANETS)){

            @Override
            public boolean hasTagDisplay() {
                return true;
            }

            @Override
            public void configureTagDisplay(TagDisplayAPI tags) {
                int gasGiants = 0;
                int planets = 0;
                int stars = 0;
                int habitable = 0;
                int total = 0;
                for (CodexEntryPlugin curr : this.getChildren()) {
                    if (!(curr.getParam() instanceof PlanetSpecAPI) || !curr.isVisible() || curr.isLocked() || curr.skipForTags()) continue;
                    PlanetSpecAPI spec = (PlanetSpecAPI)curr.getParam();
                    if (Misc.canPlanetTypeRollHabitable(spec)) {
                        ++habitable;
                    }
                    if (spec.isGasGiant()) {
                        ++gasGiants;
                    } else if (spec.isStar()) {
                        ++stars;
                    } else {
                        ++planets;
                    }
                    ++total;
                }
                float opad = 10.0f;
                float pad = 3.0f;
                tags.beginGroup(false, ALL_TYPES, 120.0f);
                tags.addTag(STARS, stars);
                tags.addTag(GAS_GIANTS, gasGiants);
                tags.addTag(PLANETS, planets);
                tags.addTag(HABITABLE, habitable);
                tags.setTotalOverrideForCurrentGroup(total);
                tags.addGroup(opad);
                tags.checkAll();
            }
        };
        return cat;
    }

    public static CodexEntryV2 createShipSystemsCategory() {
        CodexEntryV2 shipSystems = new CodexEntryV2(CAT_SHIP_SYSTEMS, "Ship systems", CodexDataV2.getIcon(CAT_SHIP_SYSTEMS)){

            @Override
            public boolean hasTagDisplay() {
                return true;
            }

            @Override
            public void configureTagDisplay(TagDisplayAPI tags) {
                int total = 0;
                CountingMap<String> types = new CountingMap<String>();
                for (CodexEntryPlugin curr : this.getChildren()) {
                    if (!(curr.getParam() instanceof ShipSystemSpecAPI) || !curr.isVisible() || curr.isLocked() || curr.skipForTags()) continue;
                    ShipSystemSpecAPI spec = (ShipSystemSpecAPI)curr.getParam();
                    Description desc = Global.getSettings().getDescription(spec.getId(), Description.Type.SHIP_SYSTEM);
                    if (desc.hasText2()) {
                        String typeStr = desc.getText2();
                        types.add(typeStr);
                    } else {
                        types.add("Special");
                    }
                    ++total;
                }
                tags.beginGroup(false, ALL_TYPES);
                ArrayList keys = new ArrayList(types.keySet());
                Collections.sort(keys);
                for (String type : keys) {
                    tags.addTag(type, type, types.getCount(type));
                }
                tags.setTotalOverrideForCurrentGroup(total);
                tags.addGroup(0.0f);
                tags.checkAll();
            }
        };
        return shipSystems;
    }

    public static CodexEntryV2 createFightersCategory() {
        CodexEntryV2 fighters = new CodexEntryV2(CAT_FIGHTERS, "Fighters", CodexDataV2.getIcon(CAT_FIGHTERS)){

            @Override
            public boolean hasTagDisplay() {
                return true;
            }

            @Override
            public void configureTagDisplay(TagDisplayAPI tags) {
                int fighter = 0;
                int bomber = 0;
                int interceptor = 0;
                int other = 0;
                int total = 0;
                CountingMap<String> techs = new CountingMap<String>();
                for (CodexEntryPlugin curr : this.getChildren()) {
                    if (!(curr.getParam() instanceof FighterWingSpecAPI) || !curr.isVisible() || curr.isLocked() || curr.skipForTags()) continue;
                    FighterWingSpecAPI spec = (FighterWingSpecAPI)curr.getParam();
                    techs.add(spec.getVariant().getHullSpec().getManufacturer());
                    if (spec.getRole() == WingRole.FIGHTER) {
                        ++fighter;
                    } else if (spec.getRole() == WingRole.BOMBER) {
                        ++bomber;
                    } else if (spec.getRole() == WingRole.INTERCEPTOR) {
                        ++interceptor;
                    } else {
                        ++other;
                    }
                    ++total;
                }
                float opad = 10.0f;
                float pad = 3.0f;
                if (!techs.isEmpty()) {
                    tags.beginGroup(false, ALL_TECHS);
                    ArrayList keys = new ArrayList(techs.keySet());
                    Collections.sort(keys);
                    for (String tech : keys) {
                        tags.addTag(tech, tech, techs.getCount(tech));
                    }
                    tags.setTotalOverrideForCurrentGroup(total);
                    tags.addGroup(0.0f);
                }
                tags.beginGroup(false, ALL_TYPES, 120.0f);
                tags.addTag(FIGHTER, fighter);
                tags.addTag(BOMBER, bomber);
                tags.addTag(INTERCEPTOR, interceptor);
                tags.addTag(OTHER, other);
                tags.setTotalOverrideForCurrentGroup(total);
                tags.addGroup(opad);
                tags.checkAll();
            }
        };
        return fighters;
    }

    public static CodexEntryV2 createCustomExampleCategory() {
        CodexEntryV2 custom = new CodexEntryV2(CAT_CUSTOM_EXAMPLE, "Custom example", CodexDataV2.getIcon(CAT_CUSTOM_EXAMPLE));
        return custom;
    }

    public static CodexEntryV2 createWeaponsCategory() {
        CodexEntryV2 weapons = new CodexEntryV2(CAT_WEAPONS, "Weapons", CodexDataV2.getIcon(CAT_WEAPONS)){

            @Override
            public boolean hasTagDisplay() {
                return true;
            }

            @Override
            public void configureTagDisplay(TagDisplayAPI tags) {
                int small = 0;
                int medium = 0;
                int large = 0;
                int fighter = 0;
                int ballistic = 0;
                int missile = 0;
                int energy = 0;
                int hybrid = 0;
                int composite = 0;
                int synergy = 0;
                int universal = 0;
                int beam = 0;
                int damHE = 0;
                int damKinetic = 0;
                int damEnergy = 0;
                int damFrag = 0;
                int damOther = 0;
                int total = 0;
                CountingMap<String> techs = new CountingMap<String>();
                for (CodexEntryPlugin curr : this.getChildren()) {
                    if (!(curr.getParam() instanceof WeaponSpecAPI) || !curr.isVisible() || curr.isLocked() || curr.skipForTags()) continue;
                    WeaponSpecAPI spec = (WeaponSpecAPI)curr.getParam();
                    techs.add(spec.getManufacturer());
                    if (spec.getAIHints().contains((Object)WeaponAPI.AIHints.SYSTEM) && spec.getPrimaryRoleStr() != null && spec.getPrimaryRoleStr().endsWith("(Fighter)")) {
                        ++fighter;
                    } else if (spec.getSize() == WeaponAPI.WeaponSize.SMALL) {
                        ++small;
                    } else if (spec.getSize() == WeaponAPI.WeaponSize.MEDIUM) {
                        ++medium;
                    } else if (spec.getSize() == WeaponAPI.WeaponSize.LARGE) {
                        ++large;
                    }
                    if (spec.getType() == WeaponAPI.WeaponType.BALLISTIC) {
                        ++ballistic;
                    } else if (spec.getType() == WeaponAPI.WeaponType.MISSILE) {
                        ++missile;
                    } else if (spec.getType() == WeaponAPI.WeaponType.ENERGY) {
                        ++energy;
                    }
                    if (spec.getMountType() == WeaponAPI.WeaponType.HYBRID) {
                        ++hybrid;
                    } else if (spec.getMountType() == WeaponAPI.WeaponType.COMPOSITE) {
                        ++composite;
                    } else if (spec.getMountType() == WeaponAPI.WeaponType.SYNERGY) {
                        ++synergy;
                    } else if (spec.getMountType() == WeaponAPI.WeaponType.UNIVERSAL) {
                        ++universal;
                    }
                    if (spec.getDamageType() == DamageType.HIGH_EXPLOSIVE) {
                        ++damHE;
                    } else if (spec.getDamageType() == DamageType.KINETIC) {
                        ++damKinetic;
                    } else if (spec.getDamageType() == DamageType.ENERGY) {
                        ++damEnergy;
                    } else if (spec.getDamageType() == DamageType.FRAGMENTATION) {
                        ++damFrag;
                    } else if (spec.getDamageType() == DamageType.OTHER) {
                        ++damOther;
                    }
                    if (spec.isBeam()) {
                        ++beam;
                    }
                    ++total;
                }
                float opad = 10.0f;
                float pad = 3.0f;
                if (!techs.isEmpty()) {
                    tags.beginGroup(false, ALL_TECHS);
                    ArrayList keys = new ArrayList(techs.keySet());
                    Collections.sort(keys);
                    for (String tech : keys) {
                        tags.addTag(tech, tech, techs.getCount(tech));
                    }
                    tags.setTotalOverrideForCurrentGroup(total);
                    tags.addGroup(0.0f);
                }
                tags.beginGroup(false, ALL_SIZES, 120.0f);
                tags.addTag(SMALL, small);
                tags.addTag(MEDIUM, medium);
                tags.addTag(LARGE, large);
                if (fighter > 0) {
                    tags.addTag(FIGHTER_WEAPON, fighter);
                }
                tags.setTotalOverrideForCurrentGroup(total);
                tags.addGroup(opad * 1.0f);
                tags.beginGroup(false, ALL_TYPES, 120.0f);
                tags.addTag(BALLISTIC, ballistic);
                tags.addTag(MISSILE, missile);
                tags.addTag(ENERGY, energy);
                if (hybrid > 0) {
                    tags.addTag(HYBRID, hybrid);
                }
                if (composite > 0) {
                    tags.addTag(COMPOSITE, composite);
                }
                if (synergy > 0) {
                    tags.addTag(SYNERGY, synergy);
                }
                if (universal > 0) {
                    tags.addTag(UNIVERSAL, universal);
                }
                if (beam > 0) {
                    tags.addTag(BEAM, beam);
                }
                tags.setTotalOverrideForCurrentGroup(total);
                tags.addGroup(pad);
                tags.beginGroup(false, ALL_DAMAGE_TYPES, 140.0f);
                tags.addTag(HIGH_EXPLOSIVE, damHE);
                tags.addTag(KINETIC, damKinetic);
                tags.addTag(FRAGMENTATION, damFrag);
                tags.addTag(DAM_ENERGY, damEnergy);
                if (damOther > 0) {
                    tags.addTag(OTHER, damOther);
                }
                tags.setTotalOverrideForCurrentGroup(total);
                tags.addGroup(pad);
                tags.checkAll();
            }
        };
        return weapons;
    }

    public static CodexEntryV2 createSkillsCategory() {
        CodexEntryV2 skills = new CodexEntryV2(CAT_SKILLS, "Skills", CodexDataV2.getIcon(CAT_SKILLS)){

            @Override
            public boolean hasTagDisplay() {
                return true;
            }

            @Override
            public void configureTagDisplay(TagDisplayAPI tags) {
                int personal = 0;
                int other = 0;
                int total = 0;
                CountingMap<String> apts = new CountingMap<String>();
                for (CodexEntryPlugin curr : this.getChildren()) {
                    if (!(curr.getParam() instanceof SkillSpecAPI) || !curr.isVisible() || curr.isLocked() || curr.skipForTags()) continue;
                    SkillSpecAPI spec = (SkillSpecAPI)curr.getParam();
                    String apt = CodexDataV2.getAptitudeName(spec);
                    if (!apt.isEmpty()) {
                        apts.add(apt);
                    }
                    if (spec.isElite()) {
                        ++personal;
                    } else {
                        ++other;
                    }
                    ++total;
                }
                float opad = 10.0f;
                float pad = 3.0f;
                if (!apts.isEmpty()) {
                    tags.beginGroup(false, ALL_APTITUDES);
                    ArrayList keys = new ArrayList(apts.keySet());
                    Collections.sort(keys);
                    for (String tech : keys) {
                        tags.addTag(tech, tech, apts.getCount(tech));
                    }
                    tags.addGroup(0.0f);
                }
                tags.beginGroup(false, ALL_TYPES, 120.0f);
                tags.addTag(PILOTED_SHIP, personal);
                tags.addTag(OTHER, other);
                tags.setTotalOverrideForCurrentGroup(total);
                tags.addGroup(opad);
                tags.checkAll();
            }
        };
        skills.setRetainOrderOfChildren(true);
        return skills;
    }

    public static CodexEntryV2 createAbilitiesCategory() {
        CodexEntryV2 abilities = new CodexEntryV2(CAT_ABILITIES, "Abilities", CodexDataV2.getIcon(CAT_ABILITIES));
        return abilities;
    }

    public static CodexEntryV2 createShipsCategory() {
        CodexEntryV2 ships = new CodexEntryV2(CAT_SHIPS, "Ships", CodexDataV2.getIcon(CAT_SHIPS)){

            @Override
            public boolean hasTagDisplay() {
                return true;
            }

            @Override
            public void configureTagDisplay(TagDisplayAPI tags) {
                int carrier = 0;
                int civilian = 0;
                int phase = 0;
                int combat = 0;
                int frigate = 0;
                int destroyer = 0;
                int cruiser = 0;
                int capital = 0;
                int stations = 0;
                int total = 0;
                CountingMap<String> counts = new CountingMap<String>();
                for (CodexEntryPlugin curr : this.getChildren()) {
                    ShipHullSpecAPI spec;
                    if (!(curr.getParam() instanceof ShipHullSpecAPI) || !curr.isVisible() || curr.isLocked() || curr.skipForTags()) continue;
                    boolean station = false;
                    if (curr.getParam2() instanceof FleetMemberAPI) {
                        FleetMemberAPI fm = (FleetMemberAPI)curr.getParam2();
                        station = fm.isStation();
                    }
                    boolean isPhase = (spec = (ShipHullSpecAPI)curr.getParam()).isPhase() || spec.getHints().contains((Object)ShipHullSpecAPI.ShipTypeHints.PHASE);
                    counts.add(spec.getManufacturer());
                    if (spec.isCarrier()) {
                        ++carrier;
                    } else if (spec.isCivilianNonCarrier()) {
                        ++civilian;
                    } else if (isPhase) {
                        ++phase;
                    } else if (!station) {
                        ++combat;
                    }
                    if (spec.isCivilianNonCarrier() && isPhase) {
                        ++phase;
                    }
                    if (station) {
                        ++stations;
                    } else if (spec.getHullSize() == ShipAPI.HullSize.FRIGATE) {
                        ++frigate;
                    } else if (spec.getHullSize() == ShipAPI.HullSize.DESTROYER) {
                        ++destroyer;
                    } else if (spec.getHullSize() == ShipAPI.HullSize.CRUISER) {
                        ++cruiser;
                    } else if (spec.getHullSize() == ShipAPI.HullSize.CAPITAL_SHIP) {
                        ++capital;
                    }
                    ++total;
                }
                float opad = 10.0f;
                float pad = 3.0f;
                if (!counts.isEmpty()) {
                    tags.beginGroup(false, ALL_TECHS);
                    ArrayList keys = new ArrayList(counts.keySet());
                    Collections.sort(keys);
                    for (String tech : keys) {
                        tags.addTag(tech, tech, counts.getCount(tech));
                    }
                    tags.addGroup(0.0f);
                }
                tags.beginGroup(false, ALL_SIZES, 120.0f);
                tags.addTag(FRIGATES, frigate);
                tags.addTag(DESTROYERS, destroyer);
                tags.addTag(CRUISERS, cruiser);
                tags.addTag(CAPITALS, capital);
                if (stations > 0) {
                    tags.addTag(STATIONS, stations);
                }
                tags.setTotalOverrideForCurrentGroup(total);
                tags.addGroup(opad * 1.0f);
                tags.beginGroup(false, ALL_TYPES, 120.0f);
                tags.addTag(COMBAT_SHIPS, combat);
                tags.addTag(PHASE_SHIPS, phase);
                tags.addTag(CARRIERS, carrier);
                tags.addTag(CIVILIAN, civilian);
                tags.setTotalOverrideForCurrentGroup(total);
                tags.addGroup(pad);
                tags.setGroupChecked(0, true);
                tags.setGroupChecked(1, true);
                tags.setGroupChecked(2, true);
            }
        };
        return ships;
    }

    public static CodexEntryV2 createStationsCategory() {
        CodexEntryV2 stations = new CodexEntryV2(CAT_STATIONS, "Stations", CodexDataV2.getIcon(CAT_STATIONS)){

            @Override
            public boolean hasTagDisplay() {
                return true;
            }

            @Override
            public void configureTagDisplay(TagDisplayAPI tags) {
                int total = 0;
                CountingMap<String> counts = new CountingMap<String>();
                for (CodexEntryPlugin curr : this.getChildren()) {
                    if (!(curr.getParam() instanceof ShipHullSpecAPI) || !curr.isVisible() || curr.isLocked() || curr.skipForTags()) continue;
                    ShipHullSpecAPI spec = (ShipHullSpecAPI)curr.getParam();
                    counts.add(spec.getManufacturer());
                    ++total;
                }
                if (!counts.isEmpty()) {
                    tags.beginGroup(false, ALL_TECHS);
                    ArrayList keys = new ArrayList(counts.keySet());
                    Collections.sort(keys);
                    for (String tech : keys) {
                        tags.addTag(tech, tech, counts.getCount(tech));
                    }
                    tags.setTotalOverrideForCurrentGroup(total);
                    tags.addGroup(0.0f);
                }
                tags.checkAll();
            }
        };
        return stations;
    }

    public static void populateShipsAndStations(CodexEntryPlugin ships, CodexEntryPlugin stations) {
        List<ShipHullSpecAPI> shipSpecs = Global.getSettings().getAllShipHullSpecs();
        for (final ShipHullSpecAPI spec : shipSpecs) {
            ShipVariantAPI variant;
            if (spec.getHullSize() == ShipAPI.HullSize.FIGHTER && !spec.hasTag("show_in_codex_as_ship") || spec.getHints().contains((Object)ShipHullSpecAPI.ShipTypeHints.HIDE_IN_CODEX) || spec.hasTag("hide_in_codex") || spec.isDefaultDHull() || spec.getHullId().equals("shuttlepod")) continue;
            final boolean station = spec.getHints().contains((Object)ShipHullSpecAPI.ShipTypeHints.STATION);
            String name = spec.getHullNameWithDashClass();
            String designation = "";
            if (spec.hasDesignation() && !spec.getDesignation().equals(spec.getHullName())) {
                designation = " " + spec.getDesignation().toLowerCase();
            }
            if (station) {
                designation = "";
                name = spec.getHullName();
            }
            CodexEntryV2 curr = new CodexEntryV2(CodexDataV2.getShipEntryId(spec.getHullId()), String.valueOf(spec.getHullNameWithDashClass()) + designation, null, spec){

                @Override
                public String getSortTitle() {
                    return spec.getHullName();
                }

                @Override
                public String getSearchString() {
                    if (station) {
                        return String.valueOf(super.getSearchString()) + " Station";
                    }
                    return super.getSearchString();
                }

                @Override
                public void createTitleForList(TooltipMakerAPI info, float width, CodexEntryPlugin.ListMode mode) {
                    info.addPara(spec.getHullName(), Misc.getBasePlayerColor(), 0.0f);
                    if (station) {
                        if (mode == CodexEntryPlugin.ListMode.RELATED_ENTRIES) {
                            info.addPara("Station", Misc.getGrayColor(), 0.0f);
                        }
                    } else if (spec.hasDesignation() && !spec.getDesignation().equals(spec.getHullName())) {
                        info.addPara(Misc.ucFirst(spec.getDesignation().toLowerCase()), Misc.getGrayColor(), 0.0f);
                    }
                }

                @Override
                public boolean matchesTags(Set<String> tags) {
                    boolean combat;
                    boolean phaseCiv;
                    ShipAPI.HullSize size = spec.getHullSize();
                    if (station) {
                        String m = spec.getManufacturer();
                        return m == null || tags.contains(m) || tags.contains(ALL_TECHS);
                    }
                    String sizeTag = null;
                    if (size == ShipAPI.HullSize.FRIGATE) {
                        sizeTag = FRIGATES;
                    }
                    if (size == ShipAPI.HullSize.DESTROYER) {
                        sizeTag = DESTROYERS;
                    }
                    if (size == ShipAPI.HullSize.CRUISER) {
                        sizeTag = CRUISERS;
                    }
                    if (size == ShipAPI.HullSize.CAPITAL_SHIP) {
                        sizeTag = CAPITALS;
                    }
                    if (sizeTag != null && !tags.contains(sizeTag)) {
                        return false;
                    }
                    boolean isPhase = spec.isPhase() || spec.getHints().contains((Object)ShipHullSpecAPI.ShipTypeHints.PHASE);
                    boolean bl = phaseCiv = isPhase && spec.isCivilianNonCarrier();
                    if (!phaseCiv && isPhase && !tags.contains(PHASE_SHIPS)) {
                        return false;
                    }
                    if (!phaseCiv && spec.isCivilianNonCarrier() && !tags.contains(CIVILIAN)) {
                        return false;
                    }
                    if (phaseCiv && !tags.contains(PHASE_SHIPS) && !tags.contains(CIVILIAN)) {
                        return false;
                    }
                    if (spec.isCarrier() && !tags.contains(CARRIERS)) {
                        return false;
                    }
                    boolean bl2 = combat = !isPhase && !spec.isCarrier() && !spec.isCivilianNonCarrier();
                    if (combat && !tags.contains(COMBAT_SHIPS)) {
                        return false;
                    }
                    String m = spec.getManufacturer();
                    return m == null || tags.contains(m) || tags.contains(ALL_TECHS);
                }

                @Override
                public Set<String> getUnlockRelatedTags() {
                    return spec.getTags();
                }

                @Override
                public boolean isUnlockedIfRequiresUnlock() {
                    return SharedUnlockData.get().isPlayerAwareOfShip(spec.getHullId());
                }
            };
            if (station) {
                stations.addChild(curr);
            } else {
                ships.addChild(curr);
            }
            String variantId = String.valueOf(spec.getHullId()) + "_Hull";
            if (spec.getCodexVariantId() != null && !spec.getCodexVariantId().isBlank()) {
                variantId = spec.getCodexVariantId();
            }
            if ((variant = Global.getSettings().getVariant(variantId)) == null) continue;
            CodexEntryPlugin parent = ships;
            if (station) {
                parent = stations;
            }
            int relBefore = curr.getRelatedEntries().size();
            List<CodexEntryPlugin> added = CodexDataV2.addModulesForVariant(variant, true, curr, parent);
            if (added.isEmpty() && relBefore >= curr.getRelatedEntryIds().size()) continue;
            FleetMemberAPI member = Global.getSettings().createFleetMember(FleetMemberType.SHIP, variant);
            curr.setParam2(member);
        }
    }

    public static List<CodexEntryPlugin> addModulesForVariant(ShipVariantAPI variant, boolean isEmptyHull, CodexEntryPlugin entry, CodexEntryPlugin parent) {
        ArrayList<CodexEntryPlugin> result = new ArrayList<CodexEntryPlugin>();
        HashSet<String> seenVariants = new HashSet<String>();
        for (String slotId : variant.getStationModules().keySet()) {
            ShipVariantAPI moduleVariant = variant.getModuleVariant(slotId);
            if (moduleVariant == null || moduleVariant.hasHullMod("vastbulk")) continue;
            String moduleEntryId = CodexDataV2.getShipEntryId(moduleVariant.getHullSpec().getHullId());
            if (isEmptyHull) {
                if (SEEN_STATION_MODULES.containsKey(moduleEntryId) || ENTRIES.containsKey(moduleEntryId)) {
                    CodexDataV2.makeRelated(entry, SEEN_STATION_MODULES.get(moduleEntryId));
                    continue;
                }
            } else {
                try {
                    String test = moduleVariant.toJSONObject().toString(4);
                    if (seenVariants.contains(test)) continue;
                    seenVariants.add(test);
                }
                catch (JSONException test) {
                    // empty catch block
                }
            }
            FleetMemberAPI moduleMember = Global.getSettings().createFleetMember(FleetMemberType.SHIP, moduleVariant);
            CodexEntryPlugin module = CodexDataV2.addModuleEntry(parent, entry, moduleMember, isEmptyHull);
            SEEN_STATION_MODULES.put(moduleEntryId, module);
            CodexDataV2.makeRelated(entry, module);
            result.add(module);
            if (isEmptyHull) continue;
            CodexDataV2.linkFleetMemberEntryToRelated(module, moduleMember, false);
        }
        return result;
    }

    public static CodexEntryPlugin addModuleEntry(CodexEntryPlugin parent, final CodexEntryPlugin entryForParentShip, FleetMemberAPI member, boolean isEmptyHull) {
        final ShipHullSpecAPI spec = member.getHullSpec();
        String moduleEntryId = CodexDataV2.getShipEntryId(spec.getHullId());
        if (!isEmptyHull) {
            moduleEntryId = UUID.randomUUID().toString();
        }
        CodexEntryV2 curr = new CodexEntryV2(moduleEntryId, spec.getHullName(), null, spec){

            @Override
            public String getSortTitle() {
                return spec.getHullName();
            }

            @Override
            public void createTitleForList(TooltipMakerAPI info, float width, CodexEntryPlugin.ListMode mode) {
                info.addPara(spec.getHullName(), Misc.getBasePlayerColor(), 0.0f);
                info.addPara("Module", Misc.getGrayColor(), 0.0f);
            }

            @Override
            public boolean matchesTags(Set<String> tags) {
                return false;
            }

            @Override
            public boolean checkTagsWhenLocked() {
                return true;
            }

            @Override
            public boolean isVisible() {
                return entryForParentShip.isVisible();
            }

            @Override
            public boolean isLocked() {
                return entryForParentShip.isLocked();
            }

            @Override
            public String getSearchString() {
                return "";
            }

            @Override
            public boolean skipForTags() {
                return true;
            }
        };
        curr.setParam2(member);
        if (isEmptyHull) {
            curr.addTag(TAG_EMPTY_MODULE);
        }
        if (parent != null) {
            parent.addChild(curr);
        }
        return curr;
    }

    public static void populateShipSystems(CodexEntryPlugin parent, CodexEntryPlugin ships) {
        List<ShipSystemSpecAPI> specs = Global.getSettings().getAllShipSystemSpecs();
        for (final ShipSystemSpecAPI spec : specs) {
            if (spec.getTags().contains("hide_in_codex")) continue;
            final Description desc = Global.getSettings().getDescription(spec.getId(), Description.Type.SHIP_SYSTEM);
            final String typeStr = desc.getText2();
            CodexEntryV2 curr = new CodexEntryV2(CodexDataV2.getShipSystemEntryId(spec.getId()), spec.getName(), spec.getIconSpriteName(), spec){

                @Override
                public void createTitleForList(TooltipMakerAPI info, float width, CodexEntryPlugin.ListMode mode) {
                    info.addPara(spec.getName(), Misc.getBasePlayerColor(), 0.0f);
                    if (mode == CodexEntryPlugin.ListMode.RELATED_ENTRIES) {
                        info.addPara("Ship system", Misc.getGrayColor(), 0.0f);
                    } else if (desc.hasText2()) {
                        info.addPara(typeStr, Misc.getGrayColor(), 0.0f);
                    } else {
                        info.addPara("Special", Misc.getGrayColor(), 0.0f);
                    }
                }

                @Override
                public boolean matchesTags(Set<String> tags) {
                    if (tags.contains(ALL_TYPES)) {
                        return true;
                    }
                    Description desc2 = Global.getSettings().getDescription(spec.getId(), Description.Type.SHIP_SYSTEM);
                    String typeStr2 = desc2.getText2();
                    if (!desc2.hasText2()) {
                        typeStr2 = "Special";
                    }
                    return tags.contains(typeStr2);
                }

                @Override
                public boolean isVignetteIcon() {
                    return true;
                }

                @Override
                public Color getIconColor() {
                    return Misc.getBasePlayerColor();
                }

                @Override
                public Set<String> getUnlockRelatedTags() {
                    LinkedHashSet<String> tags = new LinkedHashSet<String>(spec.getTags());
                    tags.add("codex_require_related");
                    return tags;
                }

                @Override
                public boolean isUnlockedIfRequiresUnlock() {
                    return SharedUnlockData.get().isPlayerAwareOfShipSystem(spec.getId());
                }

                @Override
                public String getSearchString() {
                    return super.getSearchString();
                }
            };
            parent.addChild(curr);
        }
    }

    public static void populateSkills(CodexEntryPlugin parent) {
        List<String> skillIds = Global.getSettings().getSkillIds();
        for (String skillId : skillIds) {
            final SkillSpecAPI spec = Global.getSettings().getSkillSpec(skillId);
            String aptitude = CodexDataV2.getAptitudeName(spec);
            String aptStr = "";
            if (aptitude != null && !aptitude.isBlank()) {
                aptStr = " - " + aptitude + " skill";
            }
            if (spec.hasTag("hide_in_codex") || spec.isAptitudeEffect() || !spec.hasTag("show_in_codex") && !spec.hasTag("codex_unlockable") && (spec.hasTag("npc_only") || spec.hasTag("ai_core_only")) || spec.hasTag("deprecated")) continue;
            CodexEntryV2 curr = new CodexEntryV2(CodexDataV2.getSkillEntryId(spec.getId()), String.valueOf(spec.getName()) + aptStr, spec.getSpriteName(), spec){

                @Override
                public void createTitleForList(TooltipMakerAPI info, float width, CodexEntryPlugin.ListMode mode) {
                    info.addPara(spec.getName(), Misc.getBasePlayerColor(), 0.0f);
                    String aptitude = CodexDataV2.getAptitudeName(spec);
                    if (aptitude != null && !aptitude.isBlank()) {
                        info.addPara(String.valueOf(aptitude) + " skill", Misc.getGrayColor(), 0.0f);
                    } else {
                        info.addPara("Skill", Misc.getGrayColor(), 0.0f);
                    }
                }

                @Override
                public boolean matchesTags(Set<String> tags) {
                    if (spec.isElite() && !tags.contains(PILOTED_SHIP)) {
                        return false;
                    }
                    if (!spec.isElite() && !tags.contains(OTHER)) {
                        return false;
                    }
                    String aptitude = CodexDataV2.getAptitudeName(spec);
                    if ((aptitude == null || aptitude.isBlank()) && !tags.contains(ALL_APTITUDES)) {
                        return false;
                    }
                    return tags.contains(aptitude);
                }

                @Override
                public boolean isVignetteIcon() {
                    return true;
                }

                @Override
                public Color getIconColor() {
                    return Color.white;
                }

                @Override
                public Set<String> getUnlockRelatedTags() {
                    return spec.getTags();
                }

                @Override
                public boolean isUnlockedIfRequiresUnlock() {
                    return SharedUnlockData.get().isPlayerAwareOfSkill(spec.getId());
                }

                @Override
                public String getSearchString() {
                    String aptitude = CodexDataV2.getAptitudeName(spec);
                    return String.valueOf(super.getSearchString()) + " " + aptitude;
                }
            };
            parent.addChild(curr);
        }
    }

    public static void populateAbilities(CodexEntryPlugin parent) {
        List<String> ids = Global.getSettings().getSortedAbilityIds();
        for (String id : ids) {
            final AbilitySpecAPI spec = Global.getSettings().getAbilitySpec(id);
            if (spec.hasTag("hide_in_codex")) continue;
            CodexEntryV2 curr = new CodexEntryV2(CodexDataV2.getAbilityEntryId(spec.getId()), spec.getName(), spec.getIconName(), spec){

                @Override
                public void createTitleForList(TooltipMakerAPI info, float width, CodexEntryPlugin.ListMode mode) {
                    info.addPara(spec.getName(), Misc.getBasePlayerColor(), 0.0f);
                    if (mode == CodexEntryPlugin.ListMode.RELATED_ENTRIES) {
                        info.addPara("Ability", Misc.getGrayColor(), 0.0f);
                    }
                }

                @Override
                public boolean matchesTags(Set<String> tags) {
                    return super.matchesTags(tags);
                }

                @Override
                public boolean isVignetteIcon() {
                    return true;
                }

                @Override
                public Color getIconColor() {
                    return Color.white;
                }

                @Override
                public Set<String> getUnlockRelatedTags() {
                    return spec.getTags();
                }

                @Override
                public boolean isUnlockedIfRequiresUnlock() {
                    return SharedUnlockData.get().isPlayerAwareOfAbility(spec.getId());
                }

                @Override
                public String getSearchString() {
                    return super.getSearchString();
                }
            };
            parent.addChild(curr);
        }
    }

    public static String getAptitudeName(SkillSpecAPI spec) {
        String aptitude = spec.getGoverningAptitudeName();
        if (spec.hasTag("ai_core_only")) {
            aptitude = "AI core";
        }
        return aptitude;
    }

    public static void sortSkillsCategory() {
        CodexEntryPlugin skills = CodexDataV2.getEntry(CAT_SKILLS);
        Collections.sort(skills.getChildren(), new Comparator<CodexEntryPlugin>(){

            @Override
            public int compare(CodexEntryPlugin o1, CodexEntryPlugin o2) {
                SkillSpecAPI s1 = null;
                SkillSpecAPI s2 = null;
                if (o1.getParam() instanceof SkillSpecAPI) {
                    s1 = (SkillSpecAPI)o1.getParam();
                }
                if (o2.getParam() instanceof SkillSpecAPI) {
                    s2 = (SkillSpecAPI)o2.getParam();
                }
                if (s1 != null && s2 == null) {
                    return Integer.MIN_VALUE;
                }
                if (s2 != null && s1 == null) {
                    return Integer.MAX_VALUE;
                }
                if (s1 == null && s2 == null) {
                    return o1.getTitle().compareTo(o2.getTitle());
                }
                int tier1 = 0;
                int tier2 = 0;
                if (s1.hasTag("ai_core_only")) {
                    tier1 = 5;
                }
                if (s2.hasTag("ai_core_only")) {
                    tier2 = 5;
                }
                if (tier1 != tier2) {
                    return tier1 - tier2;
                }
                int diff = s1.getGoverningAptitudeOrder() - s2.getGoverningAptitudeOrder();
                if (diff != 0) {
                    return diff;
                }
                return (int)Math.signum(s1.getOrder() - s2.getOrder());
            }
        });
    }

    public static void populateWeapons(CodexEntryPlugin parent) {
        for (final WeaponSpecAPI spec : Global.getSettings().getActuallyAllWeaponSpecs()) {
            if (spec.hasTag("hide_in_codex") || (spec.getAIHints().contains((Object)WeaponAPI.AIHints.SYSTEM) || spec.getType() == WeaponAPI.WeaponType.SYSTEM) && !spec.getAIHints().contains((Object)WeaponAPI.AIHints.SHOW_IN_CODEX) && !spec.hasTag("show_in_codex")) continue;
            CodexEntryV2 curr = new CodexEntryV2(CodexDataV2.getWeaponEntryId(spec.getWeaponId()), spec.getWeaponName(), null, spec){

                @Override
                public void createTitleForList(TooltipMakerAPI info, float width, CodexEntryPlugin.ListMode mode) {
                    info.addPara(spec.getWeaponName(), Misc.getBasePlayerColor(), 0.0f);
                    String size = spec.getSize().getDisplayName();
                    WeaponAPI.WeaponType type = spec.getMountType();
                    if (type == null) {
                        type = spec.getType();
                    }
                    info.addPara(String.valueOf(size) + " " + type.getDisplayName().toLowerCase() + " weapon", Misc.getGrayColor(), 0.0f);
                }

                @Override
                public boolean matchesTags(Set<String> tags) {
                    WeaponAPI.WeaponSize size = spec.getSize();
                    String sizeTag = null;
                    if (size == WeaponAPI.WeaponSize.SMALL) {
                        sizeTag = SMALL;
                    }
                    if (size == WeaponAPI.WeaponSize.MEDIUM) {
                        sizeTag = MEDIUM;
                    }
                    if (size == WeaponAPI.WeaponSize.LARGE) {
                        sizeTag = LARGE;
                    }
                    if (spec.getAIHints().contains((Object)WeaponAPI.AIHints.SYSTEM) && spec.getPrimaryRoleStr() != null && spec.getPrimaryRoleStr() != null && spec.getPrimaryRoleStr().endsWith("(Fighter)")) {
                        sizeTag = FIGHTER_WEAPON;
                    }
                    if (sizeTag != null && !tags.contains(sizeTag)) {
                        return false;
                    }
                    String damTypeTag = null;
                    DamageType type = spec.getDamageType();
                    if (type == DamageType.HIGH_EXPLOSIVE) {
                        damTypeTag = HIGH_EXPLOSIVE;
                    }
                    if (type == DamageType.KINETIC) {
                        damTypeTag = KINETIC;
                    }
                    if (type == DamageType.ENERGY) {
                        damTypeTag = DAM_ENERGY;
                    }
                    if (type == DamageType.FRAGMENTATION) {
                        damTypeTag = FRAGMENTATION;
                    }
                    if (type == DamageType.OTHER) {
                        damTypeTag = OTHER;
                    }
                    if (damTypeTag != null && !tags.contains(damTypeTag)) {
                        return false;
                    }
                    String m = spec.getManufacturer();
                    if (m != null && !tags.contains(m) && !tags.contains(ALL_TECHS)) {
                        return false;
                    }
                    if (spec.getMountType() == WeaponAPI.WeaponType.HYBRID && tags.contains(HYBRID)) {
                        return true;
                    }
                    if (spec.getMountType() == WeaponAPI.WeaponType.COMPOSITE && tags.contains(COMPOSITE)) {
                        return true;
                    }
                    if (spec.getMountType() == WeaponAPI.WeaponType.SYNERGY && tags.contains(SYNERGY)) {
                        return true;
                    }
                    if (spec.getMountType() == WeaponAPI.WeaponType.UNIVERSAL && tags.contains(UNIVERSAL)) {
                        return true;
                    }
                    if (spec.isBeam() && tags.contains(BEAM)) {
                        return true;
                    }
                    if (spec.getType() == WeaponAPI.WeaponType.BALLISTIC && !tags.contains(BALLISTIC)) {
                        return false;
                    }
                    if (spec.getType() == WeaponAPI.WeaponType.MISSILE && !tags.contains(MISSILE)) {
                        return false;
                    }
                    return spec.getType() != WeaponAPI.WeaponType.ENERGY || tags.contains(ENERGY);
                }

                @Override
                public Set<String> getUnlockRelatedTags() {
                    return spec.getTags();
                }

                @Override
                public boolean isUnlockedIfRequiresUnlock() {
                    return SharedUnlockData.get().isPlayerAwareOfWeapon(spec.getWeaponId());
                }
            };
            parent.addChild(curr);
        }
    }

    public static void populateFighters(CodexEntryPlugin parent) {
        for (final FighterWingSpecAPI spec : Global.getSettings().getAllFighterWingSpecs()) {
            if (spec.getVariant().getHints().contains((Object)ShipHullSpecAPI.ShipTypeHints.HIDE_IN_CODEX) || spec.getTags().contains("hide_in_codex")) continue;
            ShipVariantAPI variant = spec.getVariant();
            String nameStr = String.valueOf(variant.getHullSpec().getHullName()) + " " + variant.getDisplayName();
            if (spec.hasTag("swarm_fighter")) {
                nameStr = String.valueOf(variant.getDisplayName()) + " " + variant.getHullSpec().getHullName();
            }
            if (variant.getDisplayName().isEmpty()) {
                nameStr = variant.getHullSpec().getHullName();
            }
            final String nameStr2 = nameStr;
            CodexEntryV2 curr = new CodexEntryV2(CodexDataV2.getFighterEntryId(spec.getId()), nameStr2, null, spec){

                @Override
                public void createTitleForList(TooltipMakerAPI info, float width, CodexEntryPlugin.ListMode mode) {
                    info.addPara(nameStr2, Misc.getBasePlayerColor(), 0.0f);
                    String role = spec.getRole().name().toLowerCase();
                    role = Misc.ucFirst(role);
                    if (spec.getRoleDesc() != null && !spec.getRoleDesc().isEmpty()) {
                        role = spec.getRoleDesc();
                    }
                    info.addPara(role, Misc.getGrayColor(), 0.0f);
                }

                @Override
                public boolean matchesTags(Set<String> tags) {
                    if (spec.getRole() == WingRole.FIGHTER ? !tags.contains(FIGHTER) : (spec.getRole() == WingRole.BOMBER ? !tags.contains(BOMBER) : (spec.getRole() == WingRole.INTERCEPTOR ? !tags.contains(INTERCEPTOR) : !tags.contains(OTHER)))) {
                        return false;
                    }
                    String m = spec.getVariant().getHullSpec().getManufacturer();
                    return m == null || tags.contains(m) || tags.contains(ALL_TECHS);
                }

                @Override
                public Set<String> getUnlockRelatedTags() {
                    return spec.getTags();
                }

                @Override
                public boolean isUnlockedIfRequiresUnlock() {
                    return SharedUnlockData.get().isPlayerAwareOfFighter(spec.getId());
                }
            };
            parent.addChild(curr);
        }
    }

    public static void populateGallery(CodexEntryPlugin parent) {
        String cat = "illustrations";
        for (final String key : Global.getSettings().getSpriteKeys(cat)) {
            String sprite = Global.getSettings().getSpriteName(cat, key);
            final Description desc = Global.getSettings().getDescription(key, Description.Type.GALLERY);
            if (desc.getText3().toLowerCase().contains("hide_in_codex") || !desc.hasText1()) continue;
            if (USE_KEY_NAMES_FOR_GALLERY) {
                String text = key.replaceAll("_", " ");
                text = Misc.ucFirst(text);
                desc.setText1(text);
                desc.setText2(text);
            }
            GalleryEntryData data = new GalleryEntryData();
            data.sprite = sprite;
            data.desc = desc;
            data.sourceMod = desc.getSourceMod();
            CodexEntryV2 curr = new CodexEntryV2(CodexDataV2.getGalleryEntryId(key), desc.getText1(), sprite, data){

                @Override
                public void createTitleForList(TooltipMakerAPI info, float width, CodexEntryPlugin.ListMode mode) {
                    info.addPara(desc.getText1(), Misc.getBasePlayerColor(), 0.0f);
                    if (mode == CodexEntryPlugin.ListMode.RELATED_ENTRIES) {
                        info.addPara("Illustration", Misc.getGrayColor(), 0.0f);
                    }
                }

                @Override
                public boolean isVignetteIcon() {
                    return true;
                }

                @Override
                public boolean isVisible() {
                    return super.isVisible();
                }

                @Override
                public boolean isLocked() {
                    if (CodexDataV2.codexFullyUnlocked()) {
                        return false;
                    }
                    if (SharedUnlockData.get().isPlayerAwareOfIllustration(key)) {
                        return false;
                    }
                    return !desc.getText3().toLowerCase().contains("unlocked");
                }
            };
            parent.addChild(curr);
        }
    }

    public static void populateSpecialItems(CodexEntryPlugin parent) {
        List<SpecialItemSpecAPI> specs = Global.getSettings().getAllSpecialItemSpecs();
        for (final SpecialItemSpecAPI spec : specs) {
            if (spec.hasTag("single_bp") || spec.hasTag("modspec") || spec.getId().equals("industry_bp") || spec.hasTag("hide_in_codex")) continue;
            CodexEntryV2 curr = new CodexEntryV2(CodexDataV2.getItemEntryId(spec.getId()), spec.getName(), spec.getIconName(), spec){

                @Override
                public void createTitleForList(TooltipMakerAPI info, float width, CodexEntryPlugin.ListMode mode) {
                    info.addPara(spec.getName(), Misc.getBasePlayerColor(), 0.0f);
                    if (mode == CodexEntryPlugin.ListMode.RELATED_ENTRIES) {
                        info.addPara("Special item", Misc.getGrayColor(), 0.0f);
                    }
                }

                @Override
                public boolean matchesTags(Set<String> tags) {
                    boolean colony = spec.hasTag("colony_item");
                    boolean bp = spec.hasTag("package_bp");
                    if (tags.contains(OTHER) && !colony && !bp) {
                        return true;
                    }
                    if (tags.contains(COLONY) && colony) {
                        return true;
                    }
                    return tags.contains(BLUEPRINTS) && bp;
                }

                @Override
                public Set<String> getUnlockRelatedTags() {
                    return spec.getTags();
                }

                @Override
                public boolean isUnlockedIfRequiresUnlock() {
                    return SharedUnlockData.get().isPlayerAwareOfSpecialItem(spec.getId());
                }
            };
            parent.addChild(curr);
        }
    }

    public static void populateCommodities(CodexEntryPlugin commodities, CodexEntryPlugin items) {
        List<CommoditySpecAPI> specs = Global.getSettings().getAllCommoditySpecs();
        for (final CommoditySpecAPI spec : specs) {
            if (spec.hasTag("hide_in_codex")) continue;
            final boolean special = spec.hasTag("ai_core") || spec.hasTag("nonecon");
            CodexEntryV2 curr = new CodexEntryV2(CodexDataV2.getCommodityEntryId(spec.getId()), spec.getName(), spec.getIconName(), spec){

                @Override
                public void createTitleForList(TooltipMakerAPI info, float width, CodexEntryPlugin.ListMode mode) {
                    info.addPara(spec.getName(), Misc.getBasePlayerColor(), 0.0f);
                    if (mode == CodexEntryPlugin.ListMode.RELATED_ENTRIES) {
                        if (special) {
                            info.addPara("Special item", Misc.getGrayColor(), 0.0f);
                        } else {
                            info.addPara("Commodity", Misc.getGrayColor(), 0.0f);
                        }
                    }
                }

                @Override
                public boolean matchesTags(Set<String> tags) {
                    if (special) {
                        boolean aiCore = spec.hasTag("ai_core");
                        if (tags.contains(OTHER) && !aiCore) {
                            return true;
                        }
                        return tags.contains(AI_CORE) && aiCore;
                    }
                    return super.matchesTags(tags);
                }

                @Override
                public Set<String> getUnlockRelatedTags() {
                    return spec.getTags();
                }

                @Override
                public boolean isUnlockedIfRequiresUnlock() {
                    return SharedUnlockData.get().isPlayerAwareOfCommodity(spec.getId());
                }
            };
            if (special) {
                items.addChild(curr);
                continue;
            }
            commodities.addChild(curr);
        }
    }

    public static void populateHullMods(CodexEntryPlugin parent) {
        List<HullModSpecAPI> specs = Global.getSettings().getAllHullModSpecs();
        for (final HullModSpecAPI spec : specs) {
            if (spec.isHiddenEverywhere() || spec.hasTag("hide_in_codex")) continue;
            CodexEntryV2 curr = new CodexEntryV2(CodexDataV2.getHullmodEntryId(spec.getId()), spec.getDisplayName(), spec.getSpriteName(), spec){

                @Override
                public void createTitleForList(TooltipMakerAPI info, float width, CodexEntryPlugin.ListMode mode) {
                    info.addPara(spec.getDisplayName(), Misc.getBasePlayerColor(), 0.0f);
                    if (mode == CodexEntryPlugin.ListMode.RELATED_ENTRIES) {
                        info.addPara("Hullmod", Misc.getGrayColor(), 0.0f);
                    }
                }

                @Override
                public boolean isVignetteIcon() {
                    return true;
                }

                @Override
                public boolean matchesTags(Set<String> tags) {
                    if (!tags.contains(spec.getManufacturer())) {
                        return false;
                    }
                    if (tags.contains(ALL_TYPES)) {
                        return true;
                    }
                    boolean hasATag = false;
                    for (String tag : spec.getUITags()) {
                        if (!tags.contains(tag)) continue;
                        hasATag = true;
                    }
                    if (spec.hasTag("dmod") && tags.contains(DMODS)) {
                        hasATag = true;
                    }
                    if (spec.isHidden() && !spec.hasTag("dmod") && tags.contains(INTRINSIC)) {
                        hasATag = true;
                    }
                    return hasATag;
                }

                @Override
                public Set<String> getUnlockRelatedTags() {
                    return spec.getTags();
                }

                @Override
                public boolean isUnlockedIfRequiresUnlock() {
                    return SharedUnlockData.get().isPlayerAwareOfHullmod(spec.getId());
                }
            };
            parent.addChild(curr);
        }
    }

    public static void populateIndustries(CodexEntryPlugin parent) {
        List<IndustrySpecAPI> specs = Global.getSettings().getAllIndustrySpecs();
        for (final IndustrySpecAPI spec : specs) {
            if (spec.hasTag("parent_item") || spec.hasTag("hide_in_codex")) continue;
            CodexEntryV2 curr = new CodexEntryV2(CodexDataV2.getIndustryEntryId(spec.getId()), spec.getName(), spec.getImageName(), spec){

                @Override
                public void createTitleForList(TooltipMakerAPI info, float width, CodexEntryPlugin.ListMode mode) {
                    info.addPara(spec.getName(), Misc.getBasePlayerColor(), 0.0f);
                    boolean structure = spec.hasTag("structure");
                    String type = "Industry";
                    if (structure) {
                        type = "Structure";
                    }
                    info.addPara(type, Misc.getGrayColor(), 0.0f);
                }

                @Override
                public boolean isVignetteIcon() {
                    return true;
                }

                @Override
                public boolean matchesTags(Set<String> tags) {
                    boolean industry = spec.hasTag("industry");
                    boolean structure = spec.hasTag("structure");
                    boolean station = spec.hasTag("station");
                    if (tags.contains(OTHER) && !industry && !structure && !station) {
                        return true;
                    }
                    if (tags.contains(INDUSTRIES) && industry) {
                        return true;
                    }
                    if (tags.contains(STRUCTURES) && structure && !station) {
                        return true;
                    }
                    return tags.contains(STATIONS) && station;
                }

                @Override
                public Set<String> getUnlockRelatedTags() {
                    return spec.getTags();
                }

                @Override
                public boolean isUnlockedIfRequiresUnlock() {
                    return SharedUnlockData.get().isPlayerAwareOfIndustry(spec.getId());
                }
            };
            parent.addChild(curr);
        }
    }

    public static void populateStarsAndPlanets(CodexEntryPlugin parent) {
        List<PlanetSpecAPI> specs = Global.getSettings().getAllPlanetSpecs();
        for (final PlanetSpecAPI spec : specs) {
            if (spec.hasTag("hide_in_codex")) continue;
            CodexEntryV2 curr = new CodexEntryV2(CodexDataV2.getPlanetEntryId(spec.getPlanetType()), spec.getName(), spec.getIconTexture(), spec){

                @Override
                public void createTitleForList(TooltipMakerAPI info, float width, CodexEntryPlugin.ListMode mode) {
                    info.addPara(spec.getName(), Misc.getBasePlayerColor(), 0.0f);
                    String type = "Planet";
                    if (spec.isGasGiant()) {
                        type = "Gas giant";
                    } else if (spec.isNebulaCenter()) {
                        type = "Nebula";
                    } else if (spec.isStar()) {
                        type = "Star";
                    }
                    if (mode == CodexEntryPlugin.ListMode.RELATED_ENTRIES) {
                        info.addPara(type, Misc.getGrayColor(), 0.0f);
                    }
                }

                @Override
                public boolean matchesTags(Set<String> tags) {
                    if (tags.contains(ALL_TYPES)) {
                        return true;
                    }
                    if (tags.contains(HABITABLE) && Misc.canPlanetTypeRollHabitable(spec)) {
                        return true;
                    }
                    if (spec.isGasGiant() && !tags.contains(GAS_GIANTS)) {
                        return false;
                    }
                    if (spec.isStar() && !tags.contains(STARS)) {
                        return false;
                    }
                    return spec.isGasGiant() || spec.isStar() || tags.contains(PLANETS);
                }

                @Override
                public Set<String> getUnlockRelatedTags() {
                    return spec.getTags();
                }

                @Override
                public boolean isUnlockedIfRequiresUnlock() {
                    return SharedUnlockData.get().isPlayerAwareOfPlanet(spec.getPlanetType());
                }
            };
            parent.addChild(curr);
        }
    }

    public static void populatePlanetaryConditions(CodexEntryPlugin parent) {
        List<MarketConditionSpecAPI> specs = Global.getSettings().getAllMarketConditionSpecs();
        for (final MarketConditionSpecAPI spec : specs) {
            if (spec.hasTag("hide_in_codex") || spec.getGenSpec() == null && !spec.hasTag("show_in_planet_list") && !spec.hasTag("show_in_codex")) continue;
            CodexEntryV2 curr = new CodexEntryV2(CodexDataV2.getConditionEntryId(spec.getId()), spec.getName(), spec.getIcon(), spec){

                @Override
                public void createTitleForList(TooltipMakerAPI info, float width, CodexEntryPlugin.ListMode mode) {
                    info.addPara(spec.getName(), Misc.getBasePlayerColor(), 0.0f);
                    if (mode == CodexEntryPlugin.ListMode.RELATED_ENTRIES) {
                        info.addPara("Planetary condition", Misc.getGrayColor(), 0.0f);
                    }
                }

                @Override
                public boolean isVignetteIcon() {
                    return true;
                }

                @Override
                public boolean matchesTags(Set<String> tags) {
                    boolean res = ResourceDepositsCondition.COMMODITY.containsKey(spec.getId());
                    if (tags.contains(OTHER) && !res) {
                        return true;
                    }
                    return tags.contains(RESOURCES) && res;
                }

                @Override
                public Set<String> getUnlockRelatedTags() {
                    return spec.getTags();
                }

                @Override
                public boolean isUnlockedIfRequiresUnlock() {
                    return SharedUnlockData.get().isPlayerAwareOfCondition(spec.getId());
                }
            };
            parent.addChild(curr);
        }
    }

    public static void linkRelatedEntries() {
        WithSourceMod spec;
        Object gasGiant2;
        Object spec2;
        Iterator<CodexEntryPlugin> spec3;
        CodexEntryPlugin mod;
        String key;
        ShipHullSpecAPI spec4;
        CodexEntryPlugin ships = CodexDataV2.getEntry(CAT_SHIPS);
        CodexEntryPlugin stations = CodexDataV2.getEntry(CAT_STATIONS);
        CodexEntryPlugin fighters = CodexDataV2.getEntry(CAT_FIGHTERS);
        CodexEntryPlugin weapons = CodexDataV2.getEntry(CAT_WEAPONS);
        CodexEntryPlugin hullmods = CodexDataV2.getEntry(CAT_HULLMODS);
        CodexEntryPlugin shipSystems = CodexDataV2.getEntry(CAT_SHIP_SYSTEMS);
        CodexEntryPlugin planets = CodexDataV2.getEntry(CAT_STARS_AND_PLANETS);
        CodexEntryPlugin conditions = CodexDataV2.getEntry(CAT_PLANETARY_CONDITIONS);
        CodexEntryPlugin items = CodexDataV2.getEntry(CAT_SPECIAL_ITEMS);
        CodexEntryPlugin commodities = CodexDataV2.getEntry(CAT_COMMODITIES);
        CodexEntryPlugin industries = CodexDataV2.getEntry(CAT_INDUSTRIES);
        CodexEntryPlugin skills = CodexDataV2.getEntry(CAT_SKILLS);
        CodexEntryPlugin abilities = CodexDataV2.getEntry(CAT_ABILITIES);
        ArrayList<CodexEntryPlugin> shipsAndStations = new ArrayList<CodexEntryPlugin>();
        shipsAndStations.addAll(ships.getChildren());
        shipsAndStations.addAll(stations.getChildren());
        ListMap<CodexEntryPlugin> relatedHulls = new ListMap<CodexEntryPlugin>();
        for (CodexEntryPlugin ship : shipsAndStations) {
            if (!(ship.getParam() instanceof ShipHullSpecAPI)) continue;
            spec4 = (ShipHullSpecAPI)ship.getParam();
            String baseId = CodexDataV2.getBaseHullIdEvenIfNotRestorableTo(spec4);
            relatedHulls.add(baseId, ship);
            if (!spec4.hasTag("dweller")) continue;
            relatedHulls.add("dweller_allParts", ship);
        }
        for (List list : relatedHulls.values()) {
            CodexDataV2.makeRelated(list);
        }
        for (CodexEntryPlugin ship : shipsAndStations) {
            Iterator<String> drone;
            String key2;
            CodexEntryPlugin sys;
            if (!(ship.getParam() instanceof ShipHullSpecAPI)) continue;
            spec4 = (ShipHullSpecAPI)ship.getParam();
            String sysId = spec4.getShipSystemId();
            if (sysId != null && !sysId.isBlank() && (sys = CodexDataV2.getEntry(key2 = CodexDataV2.getShipSystemEntryId(sysId))) != null) {
                ShipSystemSpecAPI sysSpec;
                sys.addRelatedEntry(ship);
                ship.addRelatedEntry(sys);
                if (sys.getParam() instanceof ShipSystemSpecAPI && (sysSpec = (ShipSystemSpecAPI)sys.getParam()).getDroneVariant() != null && (drone = Global.getSettings().getVariant(sysSpec.getDroneVariant())) != null) {
                    String droneHullId = CodexDataV2.getBaseHullId(drone.getHullSpec());
                    String droneEntryId = CodexDataV2.getShipEntryId(droneHullId);
                    CodexDataV2.makeRelated(ship.getId(), droneEntryId);
                    CodexDataV2.makeRelated(sys.getId(), droneEntryId);
                }
            }
            if (!spec4.isPhase() && (sys = CodexDataV2.getEntry(key2 = CodexDataV2.getShipSystemEntryId(sysId = spec4.getShipDefenseId()))) != null) {
                sys.addRelatedEntry(ship);
                ship.addRelatedEntry(sys);
            }
            String variantId = String.valueOf(spec4.getHullId()) + "_Hull";
            if (spec4.getCodexVariantId() != null && !spec4.getCodexVariantId().isBlank()) {
                variantId = spec4.getCodexVariantId();
            }
            ShipVariantAPI variant = Global.getSettings().getVariant(variantId);
            for (String id : variant.getHullMods()) {
                key = CodexDataV2.getHullmodEntryId(id);
                mod = CodexDataV2.getEntry(key);
                if (mod == null) continue;
                mod.addRelatedEntry(ship);
                ship.addRelatedEntry(mod);
                if (!id.equals("vast_hangar")) continue;
                ship.addRelatedEntry(CodexDataV2.getEntry(CodexDataV2.getHullmodEntryId("converted_hangar")));
            }
            for (String slotId : variant.getFittedWeaponSlots()) {
                String id;
                String key3;
                CodexEntryPlugin weapon;
                WeaponSlotAPI slot = spec4.getWeaponSlot(slotId);
                if (slot == null || slot.isDecorative() || slot.isSystemSlot() || (weapon = CodexDataV2.getEntry(key3 = CodexDataV2.getWeaponEntryId(id = variant.getWeaponId(slotId)))) == null) continue;
                weapon.addRelatedEntry(ship);
                ship.addRelatedEntry(weapon);
            }
            drone = variant.getWings().iterator();
            while (drone.hasNext()) {
                String id;
                id = drone.next();
                key = CodexDataV2.getFighterEntryId(id);
                CodexEntryPlugin fighter = CodexDataV2.getEntry(key);
                if (fighter == null) continue;
                fighter.addRelatedEntry(ship);
                ship.addRelatedEntry(fighter);
            }
        }
        for (CodexEntryPlugin fighter : fighters.getChildren()) {
            String key4;
            Iterator<String> sys;
            if (!(fighter.getParam() instanceof FighterWingSpecAPI)) continue;
            FighterWingSpecAPI wing = (FighterWingSpecAPI)fighter.getParam();
            ShipVariantAPI variant = wing.getVariant();
            ShipHullSpecAPI spec5 = variant.getHullSpec();
            Object sysId = spec5.getShipSystemId();
            if (sysId != null && (sys = CodexDataV2.getEntry(key4 = CodexDataV2.getShipSystemEntryId((String)sysId))) != null) {
                sys.addRelatedEntry(fighter);
                fighter.addRelatedEntry((CodexEntryPlugin)((Object)sys));
            }
            if (!spec5.isPhase() && (sys = CodexDataV2.getEntry(key4 = CodexDataV2.getShipSystemEntryId((String)(sysId = spec5.getShipDefenseId())))) != null) {
                sys.addRelatedEntry(fighter);
                fighter.addRelatedEntry((CodexEntryPlugin)((Object)sys));
            }
            for (String id : variant.getHullMods()) {
                key = CodexDataV2.getHullmodEntryId(id);
                mod = CodexDataV2.getEntry(key);
                if (mod == null) continue;
                mod.addRelatedEntry(fighter);
                fighter.addRelatedEntry(mod);
            }
            sys = variant.getFittedWeaponSlots().iterator();
            while (sys.hasNext()) {
                String slotId;
                slotId = sys.next();
                String id = variant.getWeaponId(slotId);
                String key5 = CodexDataV2.getWeaponEntryId(id);
                CodexEntryPlugin weapon = CodexDataV2.getEntry(key5);
                if (weapon == null) continue;
                weapon.addRelatedEntry(fighter);
                fighter.addRelatedEntry(weapon);
            }
        }
        ArrayList<CodexEntryPlugin> dem = new ArrayList<CodexEntryPlugin>();
        for (CodexEntryPlugin weapon : weapons.getChildren()) {
            WeaponSpecAPI spec6;
            if (!(weapon.getParam() instanceof WeaponSpecAPI) || !(spec6 = (WeaponSpecAPI)weapon.getParam()).hasTag("damage_soft_flux") || !spec6.hasTag("damage_special")) continue;
            dem.add(weapon);
        }
        CodexDataV2.makeRelated(dem);
        ListMap<CodexEntryPlugin> relatedPlanets = new ListMap<CodexEntryPlugin>();
        String gasGiantListId = "gas_giant_related_id";
        ArrayList<CodexEntryPlugin> habitablePlanets = new ArrayList<CodexEntryPlugin>();
        for (CodexEntryPlugin planet : planets.getChildren()) {
            if (!(planet.getParam() instanceof PlanetSpecAPI)) continue;
            PlanetSpecAPI spec7 = (PlanetSpecAPI)planet.getParam();
            String id = spec7.getDescriptionId();
            if (id == null) {
                id = spec7.getPlanetType();
            }
            relatedPlanets.add(id, planet);
            if (spec7.isNebulaCenter()) {
                relatedPlanets.add("nebula_related_id", planet);
            }
            if (spec7.isGasGiant()) {
                relatedPlanets.add(gasGiantListId, planet);
            }
            if (spec7.isPulsar()) {
                relatedPlanets.add("pulsar_related_id", planet);
            }
            if (spec7.isBlackHole()) {
                relatedPlanets.add("black_hole_related_id", planet);
            }
            if (!Misc.canPlanetTypeRollHabitable(spec7)) continue;
            habitablePlanets.add(planet);
        }
        for (List list : relatedPlanets.values()) {
            CodexDataV2.makeRelated(list);
        }
        CodexDataV2.makeRelated(CodexDataV2.getPlanetEntryId("lava"), CodexDataV2.getPlanetEntryId("lava_minor"));
        ListMap<CodexEntryPlugin> relatedDeposits = new ListMap<CodexEntryPlugin>();
        for (String cid : ResourceDepositsCondition.COMMODITY.keySet()) {
            String commodityId = ResourceDepositsCondition.COMMODITY.get(cid);
            relatedDeposits.add(commodityId, CodexDataV2.getEntry(CodexDataV2.getConditionEntryId(cid)));
        }
        for (List list : relatedDeposits.values()) {
            CodexDataV2.makeRelated(list);
        }
        CodexDataV2.makeRelated(CodexDataV2.getConditionEntryId("ruins_scattered"), CodexDataV2.getConditionEntryId("ruins_widespread"), CodexDataV2.getConditionEntryId("ruins_extensive"), CodexDataV2.getConditionEntryId("ruins_vast"));
        CodexDataV2.makeRelated(CodexDataV2.getConditionEntryId("no_atmosphere"), CodexDataV2.getConditionEntryId("thin_atmosphere"), CodexDataV2.getConditionEntryId("toxic_atmosphere"), CodexDataV2.getConditionEntryId("dense_atmosphere"));
        CodexDataV2.makeRelated(CodexDataV2.getConditionEntryId("decivilized"), CodexDataV2.getConditionEntryId("decivilized_subpop"));
        CodexDataV2.makeRelated(CodexDataV2.getConditionEntryId("cold"), CodexDataV2.getConditionEntryId("very_cold"));
        CodexDataV2.makeRelated(CodexDataV2.getConditionEntryId("hot"), CodexDataV2.getConditionEntryId("very_hot"));
        CodexDataV2.makeRelated(CodexDataV2.getConditionEntryId("low_gravity"), CodexDataV2.getConditionEntryId("high_gravity"));
        CodexDataV2.makeRelated(CodexDataV2.getConditionEntryId("poor_light"), CodexDataV2.getConditionEntryId("dark"));
        CodexDataV2.makeRelated(CodexDataV2.getConditionEntryId("habitable"), CodexDataV2.getConditionEntryId("mild_climate"));
        CodexDataV2.makeRelated(CodexDataV2.getConditionEntryId("tectonic_activity"), CodexDataV2.getConditionEntryId("extreme_tectonic_activity"));
        CodexEntryPlugin habitable = CodexDataV2.getEntry(CodexDataV2.getConditionEntryId("habitable"));
        for (CodexEntryPlugin planet : habitablePlanets) {
            CodexDataV2.makeRelated(habitable, planet);
        }
        ListMap<CodexEntryPlugin> commoditiesByDemandClass = new ListMap<CodexEntryPlugin>();
        for (CodexEntryPlugin item : items.getChildren()) {
            if (!(item.getParam() instanceof CommoditySpecAPI)) continue;
            spec3 = (CommoditySpecAPI)item.getParam();
            commoditiesByDemandClass.add(spec3.getDemandClass(), item);
        }
        for (CodexEntryPlugin item : commodities.getChildren()) {
            if (!(item.getParam() instanceof CommoditySpecAPI)) continue;
            spec3 = (CommoditySpecAPI)item.getParam();
            commoditiesByDemandClass.add(spec3.getDemandClass(), item);
        }
        for (List list : commoditiesByDemandClass.values()) {
            CodexDataV2.makeRelated(list);
        }
        List gasGiants = relatedPlanets.getList(gasGiantListId);
        for (CodexEntryPlugin item : items.getChildren()) {
            if (item.getParam() instanceof SpecialItemSpecAPI) {
                spec2 = (SpecialItemSpecAPI)item.getParam();
                if (spec2.hasTag("colony_item")) {
                    InstallableItemEffect effect = ItemEffectsRepo.ITEM_EFFECTS.get(spec2.getId());
                    Set<String> relatedConditions = effect.getConditionsRelatedToRequirements(null);
                    for (String conditionId : relatedConditions) {
                        CodexEntryPlugin condition = CodexDataV2.getEntry(CodexDataV2.getConditionEntryId(conditionId));
                        if (condition == null) continue;
                        item.addRelatedEntry(condition);
                        condition.addRelatedEntry(item);
                    }
                    List<String> req = effect.getRequirements(null);
                    if (req == null || !req.contains(ItemEffectsRepo.GAS_GIANT) && !req.contains(ItemEffectsRepo.NOT_A_GAS_GIANT)) continue;
                    for (Object gasGiant2 : gasGiants) {
                        item.addRelatedEntry((CodexEntryPlugin)gasGiant2);
                        gasGiant2.addRelatedEntry(item);
                    }
                    continue;
                }
                if (!spec2.hasTag("package_bp")) continue;
                SpecialItemPlugin plugin = spec2.getNewPluginInstance(null);
                plugin.init(null);
                if (!(plugin instanceof MultiBlueprintItemPlugin)) continue;
                MultiBlueprintItemPlugin multi = (MultiBlueprintItemPlugin)plugin;
                for (String shipId : multi.getProvidedShips()) {
                    CodexDataV2.makeRelated(item.getId(), CodexDataV2.getShipEntryId(shipId));
                }
                for (String fighterId : multi.getProvidedFighters()) {
                    CodexDataV2.makeRelated(item.getId(), CodexDataV2.getFighterEntryId(fighterId));
                }
                gasGiant2 = multi.getProvidedWeapons().iterator();
                while (gasGiant2.hasNext()) {
                    String weaponId = (String)gasGiant2.next();
                    CodexDataV2.makeRelated(item.getId(), CodexDataV2.getWeaponEntryId(weaponId));
                }
                continue;
            }
            if (!(item.getParam() instanceof CommoditySpecAPI)) continue;
            spec2 = (CommoditySpecAPI)item.getParam();
        }
        for (CodexEntryPlugin curr : items.getChildren()) {
            if (!(curr.getParam() instanceof SpecialItemSpecAPI) || !(spec2 = (SpecialItemSpecAPI)curr.getParam()).hasTag("colony_item")) continue;
            gasGiant2 = spec2.getParams().split(",");
            int weaponId = ((String[])gasGiant2).length;
            int multi = 0;
            while (multi < weaponId) {
                Object industryId = gasGiant2[multi];
                CodexDataV2.makeRelated(curr.getId(), CodexDataV2.getIndustryEntryId(((String)industryId).trim()));
                ++multi;
            }
        }
        ListMap<String> commodityToResourceConditions = new ListMap<String>();
        for (String condId : ResourceDepositsCondition.COMMODITY.keySet()) {
            String commodityId = ResourceDepositsCondition.COMMODITY.get(condId);
            commodityToResourceConditions.add(commodityId, condId);
        }
        for (CodexEntryPlugin curr : industries.getChildren()) {
            IndustrySpecAPI other;
            if (!(curr.getParam() instanceof IndustrySpecAPI)) continue;
            spec = (IndustrySpecAPI)curr.getParam();
            for (String comId : Global.getSettings().getIndustryDemand(spec.getId())) {
                CodexDataV2.makeRelated(curr.getId(), CodexDataV2.getCommodityEntryId(comId));
            }
            for (String comId : Global.getSettings().getIndustrySupply(spec.getId())) {
                CodexDataV2.makeRelated(curr.getId(), CodexDataV2.getCommodityEntryId(comId));
                if (spec.getId().equals("aquaculture")) continue;
                Iterator<Object> iterator = commodityToResourceConditions.get(comId).iterator();
                while (iterator.hasNext()) {
                    String condId = (String)iterator.next();
                    CodexDataV2.makeRelated(curr.getId(), CodexDataV2.getConditionEntryId(condId));
                }
            }
            String otherId = spec.getUpgrade();
            HashSet<String> seen = new HashSet<String>();
            while (otherId != null && !seen.contains(otherId)) {
                seen.add(otherId);
                CodexDataV2.makeRelated(curr.getId(), CodexDataV2.getIndustryEntryId(otherId));
                other = Global.getSettings().getIndustrySpec(otherId);
                otherId = other.getUpgrade();
            }
            otherId = spec.getDowngrade();
            while (otherId != null && !seen.contains(otherId)) {
                seen.add(otherId);
                CodexDataV2.makeRelated(curr.getId(), CodexDataV2.getIndustryEntryId(otherId));
                other = Global.getSettings().getIndustrySpec(otherId);
                otherId = other.getDowngrade();
            }
        }
        CodexDataV2.makeRelated(CodexDataV2.getIndustryEntryId("aquaculture"), CodexDataV2.getConditionEntryId("water_surface"));
        CodexDataV2.makeRelated(CodexDataV2.getIndustryEntryId("aquaculture"), CodexDataV2.getPlanetEntryId("water"));
        CodexDataV2.makeRelated(CodexDataV2.getIndustryEntryId("aquaculture"), CodexDataV2.getConditionEntryId("volturnian_lobster_pens"));
        CodexDataV2.makeRelated(CodexDataV2.getIndustryEntryId("aquaculture"), CodexDataV2.getIndustryEntryId("farming"));
        CodexDataV2.makeUnrelated(CodexDataV2.getIndustryEntryId("farming"), CodexDataV2.getConditionEntryId("volturnian_lobster_pens"));
        CodexDataV2.makeUnrelated(CodexDataV2.getIndustryEntryId("farming"), CodexDataV2.getConditionEntryId("water_surface"));
        CodexDataV2.makeUnrelated(CodexDataV2.getIndustryEntryId("farming"), CodexDataV2.getCommodityEntryId("lobster"));
        CodexDataV2.makeRelated(CodexDataV2.getConditionEntryId("water_surface"), CodexDataV2.getPlanetEntryId("water"));
        for (String comId : commodityToResourceConditions.keySet()) {
            Iterator otherId = commodityToResourceConditions.get(comId).iterator();
            while (otherId.hasNext()) {
                String condId = (String)otherId.next();
                CodexDataV2.makeRelated(CodexDataV2.getCommodityEntryId(comId), CodexDataV2.getConditionEntryId(condId));
            }
        }
        for (CodexEntryPlugin weapon : weapons.getChildren()) {
            if (!(weapon.getParam() instanceof WeaponSpecAPI) || (spec = (WeaponSpecAPI)weapon.getParam()).getAIHints().contains((Object)WeaponAPI.AIHints.SYSTEM) && spec.getPrimaryRoleStr() != null && spec.getPrimaryRoleStr().endsWith("(Fighter)")) continue;
            String id = weapon.getId();
            if (spec.usesAmmo() && (spec.getType() == WeaponAPI.WeaponType.BALLISTIC || spec.getType() == WeaponAPI.WeaponType.ENERGY)) {
                CodexDataV2.makeRelated(id, CodexDataV2.getHullmodEntryId("magazines"));
            }
            if (spec.usesAmmo() && spec.getAmmoPerSecond() <= 0.0f && spec.getType() == WeaponAPI.WeaponType.MISSILE && spec.getSize() == WeaponAPI.WeaponSize.SMALL) {
                CodexDataV2.makeRelated(id, CodexDataV2.getHullmodEntryId("missile_autoloader"));
            }
            if (spec.getMountType() != WeaponAPI.WeaponType.HYBRID || spec.getSize() == WeaponAPI.WeaponSize.LARGE || spec.getAIHints().contains((Object)WeaponAPI.AIHints.PD)) continue;
            CodexDataV2.makeRelated(id, CodexDataV2.getHullmodEntryId("ballistic_rangefinder"));
        }
        for (CodexEntryPlugin skill : skills.getChildren()) {
            if (!(skill.getParam() instanceof SkillSpecAPI)) continue;
            String id = skill.getId();
            SkillSpecAPI spec8 = (SkillSpecAPI)skill.getParam();
            for (String hullmodId : spec8.getAllHullmodUnlocks()) {
                CodexDataV2.makeRelated(id, CodexDataV2.getHullmodEntryId(hullmodId));
            }
            for (String abilityId : spec8.getAllAbilityUnlocks()) {
                CodexDataV2.makeRelated(id, CodexDataV2.getAbilityEntryId(abilityId));
            }
            if (!spec8.hasTag("ai_core_only")) continue;
            if (spec8.isAdminSkill()) {
                CodexDataV2.makeRelated(id, CodexDataV2.getCommodityEntryId("alpha_core"));
                continue;
            }
            CodexDataV2.makeRelated(id, CodexDataV2.getCommodityEntryId("alpha_core"));
            CodexDataV2.makeRelated(id, CodexDataV2.getCommodityEntryId("beta_core"));
            CodexDataV2.makeRelated(id, CodexDataV2.getCommodityEntryId("gamma_core"));
        }
        for (CodexEntryPlugin hullmod : hullmods.getChildren()) {
            CargoStackAPI req;
            if (!(hullmod.getParam() instanceof HullModSpecAPI)) continue;
            spec = (HullModSpecAPI)hullmod.getParam();
            if (spec.hasTag("dmod")) {
                CodexDataV2.makeRelated(CodexDataV2.getSkillEntryId("derelict_contingent"), CodexDataV2.getHullmodEntryId(spec.getId()));
                if (spec.hasTag("damage")) {
                    CodexDataV2.makeRelated(CodexDataV2.getSkillEntryId("hull_restoration"), CodexDataV2.getHullmodEntryId(spec.getId()));
                }
            }
            if ((req = spec.getEffect().getRequiredItem()) == null) continue;
            if (req.getType() == CargoAPI.CargoItemType.RESOURCES) {
                CodexDataV2.makeRelated(CodexDataV2.getHullmodEntryId(spec.getId()), CodexDataV2.getCommodityEntryId(req.getCommodityId()));
                continue;
            }
            if (req.getType() != CargoAPI.CargoItemType.SPECIAL) continue;
            CodexDataV2.makeRelated(CodexDataV2.getHullmodEntryId(spec.getId()), CodexDataV2.getItemEntryId(req.getSpecialItemSpecIfSpecial().getId()));
        }
        for (CodexEntryPlugin curr : shipSystems.getChildren()) {
            if (!(curr.getParam() instanceof ShipSystemSpecAPI) || !((spec = (ShipSystemSpecAPI)curr.getParam()).getStatsScript() instanceof EnergyLashActivatedSystem)) continue;
            CodexDataV2.makeRelated(CodexDataV2.getShipSystemEntryId(ShipSystems.ENERGY_LASH), CodexDataV2.getShipSystemEntryId(spec.getId()));
        }
        CodexDataV2.makeRelated(CodexDataV2.getSkillEntryId("automated_ships"), CodexDataV2.getHullmodEntryId("automated"));
        CodexDataV2.makeRelated(CodexDataV2.getSkillEntryId("phase_corps"), CodexDataV2.getHullmodEntryId("phasefield"));
        CodexDataV2.makeRelated(CodexDataV2.getSkillEntryId("containment_procedures"), CodexDataV2.getAbilityEntryId("emergency_burn"));
        CodexDataV2.makeRelated(CodexDataV2.getSkillEntryId("navigation"), CodexDataV2.getAbilityEntryId("sustained_burn"));
        CodexDataV2.makeRelated(CodexDataV2.getSkillEntryId("sensors"), CodexDataV2.getAbilityEntryId("go_dark"));
        CodexDataV2.makeRelated(CodexDataV2.getSkillEntryId("sensors"), CodexDataV2.getAbilityEntryId("sensor_burst"));
        CodexDataV2.makeRelated(CodexDataV2.getAbilityEntryId("interdiction_pulse"), CodexDataV2.getAbilityEntryId("sensor_burst"));
        CodexDataV2.makeRelated(CodexDataV2.getAbilityEntryId("interdiction_pulse"), CodexDataV2.getAbilityEntryId("sustained_burn"));
        CodexDataV2.makeRelated(CodexDataV2.getAbilityEntryId("interdiction_pulse"), CodexDataV2.getAbilityEntryId("emergency_burn"));
        CodexDataV2.makeRelated(CodexDataV2.getAbilityEntryId("interdiction_pulse"), CodexDataV2.getAbilityEntryId("fracture_jump"));
        CodexDataV2.makeRelated(CodexDataV2.getSkillEntryId("tactical_drills"), CodexDataV2.getCommodityEntryId("marines"));
        CodexDataV2.makeRelated(CodexDataV2.getHullmodEntryId("ground_support"), CodexDataV2.getCommodityEntryId("marines"));
        CodexDataV2.makeRelated(CodexDataV2.getHullmodEntryId("advanced_ground_support"), CodexDataV2.getCommodityEntryId("marines"));
        CodexDataV2.makeRelated(CodexDataV2.getHullmodEntryId("neural_integrator"), CodexDataV2.getHullmodEntryId("automated"));
        CodexDataV2.makeRelated(CodexDataV2.getSkillEntryId("neural_link"), CodexDataV2.getHullmodEntryId("automated"));
        CodexDataV2.makeRelated(CodexDataV2.getSkillEntryId("neural_link"), CodexDataV2.getHullmodEntryId("automated"));
        CodexDataV2.makeRelated(CodexDataV2.getShipSystemEntryId("displacer"), CodexDataV2.getShipSystemEntryId("displacer_degraded"));
        CodexDataV2.makeRelated(CodexDataV2.getFighterEntryId("terminator_wing"), CodexDataV2.getShipSystemEntryId("drone_strike"));
        CodexDataV2.makeRelated(CodexDataV2.getHullmodEntryId("vast_hangar"), CodexDataV2.getHullmodEntryId("converted_hangar"));
        CodexDataV2.makeRelated(CodexDataV2.getHullmodEntryId("design_compromises"), CodexDataV2.getHullmodEntryId("converted_hangar"));
        CodexDataV2.makeRelated(CodexDataV2.getIndustryEntryId("techmining"), CodexDataV2.getConditionEntryId("ruins_scattered"));
        CodexDataV2.makeRelated(CodexDataV2.getIndustryEntryId("techmining"), CodexDataV2.getConditionEntryId("ruins_widespread"));
        CodexDataV2.makeRelated(CodexDataV2.getIndustryEntryId("techmining"), CodexDataV2.getConditionEntryId("ruins_extensive"));
        CodexDataV2.makeRelated(CodexDataV2.getIndustryEntryId("techmining"), CodexDataV2.getConditionEntryId("ruins_vast"));
        String substrateEntryId = CodexDataV2.getItemEntryId("shrouded_substrate");
        CodexEntryPlugin substrateEntry = CodexDataV2.getEntry(substrateEntryId);
        if (substrateEntry != null) {
            Iterator iterator = relatedHulls.get("dweller_allParts").iterator();
            while (iterator.hasNext()) {
                CodexEntryPlugin dwellerPart = (CodexEntryPlugin)iterator.next();
                CodexDataV2.makeRelated(substrateEntry, dwellerPart);
            }
        }
        CodexDataV2.makeRelated(CodexDataV2.getWeaponEntryId("vortex_launcher"), CodexDataV2.getShipEntryId("shrouded_vortex"));
    }

    public static void makeRelated(CodexEntryPlugin ... plugins) {
        CodexEntryPlugin[] codexEntryPluginArray = plugins;
        int n = plugins.length;
        int n2 = 0;
        while (n2 < n) {
            CodexEntryPlugin one = codexEntryPluginArray[n2];
            CodexEntryPlugin[] codexEntryPluginArray2 = plugins;
            int n3 = plugins.length;
            int n4 = 0;
            while (n4 < n3) {
                CodexEntryPlugin two = codexEntryPluginArray2[n4];
                if (one != two) {
                    one.addRelatedEntry(two);
                    two.addRelatedEntry(one);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static void makeRelated(List<CodexEntryPlugin> plugins) {
        for (CodexEntryPlugin one : plugins) {
            for (CodexEntryPlugin two : plugins) {
                if (one == two) continue;
                one.addRelatedEntry(two);
                two.addRelatedEntry(one);
            }
        }
    }

    public static void makeRelated(String ... ids) {
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id1 = stringArray[n2];
            CodexEntryPlugin one = CodexDataV2.getEntry(id1);
            if (one != null) {
                String[] stringArray2 = ids;
                int n3 = ids.length;
                int n4 = 0;
                while (n4 < n3) {
                    CodexEntryPlugin two;
                    String id2 = stringArray2[n4];
                    if (id1 != id2 && (two = CodexDataV2.getEntry(id2)) != null) {
                        one.addRelatedEntry(two);
                        two.addRelatedEntry(one);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public static void makeUnrelated(String ... ids) {
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id1 = stringArray[n2];
            CodexEntryPlugin one = CodexDataV2.getEntry(id1);
            if (one != null) {
                String[] stringArray2 = ids;
                int n3 = ids.length;
                int n4 = 0;
                while (n4 < n3) {
                    CodexEntryPlugin two;
                    String id2 = stringArray2[n4];
                    if (id1 != id2 && (two = CodexDataV2.getEntry(id2)) != null) {
                        one.removeRelatedEntry(two);
                        two.removeRelatedEntry(one);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public static String getBaseHullIdEvenIfNotRestorableTo(ShipHullSpecAPI spec) {
        String baseId = spec.getBaseHullId();
        return baseId;
    }

    public static String getBaseHullId(ShipHullSpecAPI spec) {
        ShipHullSpecAPI base = spec.getDParentHull();
        if (!spec.isDefaultDHull() && !spec.isRestoreToBase()) {
            base = spec;
        }
        if (base == null && spec.isRestoreToBase()) {
            base = spec.getBaseHull();
        }
        if (base == null) {
            base = spec;
        }
        return base.getHullId();
    }

    public static String getFleetMemberEntryId(FleetMemberAPI member) {
        return CodexDataV2.getShipEntryId(CodexDataV2.getFleetMemberBaseHullId(member));
    }

    public static String getFleetMemberBaseHullId(FleetMemberAPI member) {
        ShipHullSpecAPI spec = member.getHullSpec();
        ShipHullSpecAPI base = spec.getDParentHull();
        if (!spec.isDefaultDHull() && !spec.isRestoreToBase()) {
            base = spec;
        }
        if (base == null && spec.isRestoreToBase()) {
            base = spec.getBaseHull();
        }
        if (base == null) {
            base = spec;
        }
        return base.getHullId();
    }

    public static String getShipEntryId(String shipId) {
        return "codex_hull_" + shipId;
    }

    public static String getWeaponEntryId(String weaponId) {
        return "codex_weapon_" + weaponId;
    }

    public static String getFighterEntryId(String wingId) {
        return "codex_fighter_" + wingId;
    }

    public static String getShipSystemEntryId(String shipSystemId) {
        return "codex_system_" + shipSystemId;
    }

    public static String getHullmodEntryId(String hullModId) {
        return "codex_hullmod_" + hullModId;
    }

    public static String getPlanetEntryId(String planetId) {
        return "codex_planet_" + planetId;
    }

    public static String getConditionEntryId(String conditionId) {
        return "codex_condition_" + conditionId;
    }

    public static String getItemEntryId(String itemId) {
        return "codex_item_" + itemId;
    }

    public static String getIndustryEntryId(String industryId) {
        return "codex_industry_" + industryId;
    }

    public static String getCommodityEntryId(String commodityId) {
        return "codex_commodity_" + commodityId;
    }

    public static String getFactionEntryId(String factionId) {
        return "codex_faction_" + factionId;
    }

    public static String getMechanicEntryId(String mechanicId) {
        return "codex_mechanic_" + mechanicId;
    }

    public static String getGalleryEntryId(String galleryId) {
        return "codex_gallery_" + galleryId;
    }

    public static String getSkillEntryId(String skillId) {
        return "codex_skill_" + skillId;
    }

    public static String getAbilityEntryId(String abilityId) {
        return "codex_ability_" + abilityId;
    }

    public static String getIcon(String key) {
        return Global.getSettings().getSpriteName("codex", key);
    }

    public static CodexEntryPlugin getEntry(String id) {
        return ENTRIES.get(id);
    }

    public static void rebuildIdToEntryMap() {
        ENTRIES.clear();
        if (ROOT == null) {
            return;
        }
        ENTRIES.put(ROOT.getId(), ROOT);
        CodexDataV2.rebuildIdToEntryMap(ROOT);
    }

    public static void rebuildIdToEntryMap(CodexEntryPlugin curr) {
        for (CodexEntryPlugin child : curr.getChildren()) {
            ENTRIES.put(child.getId(), child);
            if (child.getChildren().isEmpty()) continue;
            CodexDataV2.rebuildIdToEntryMap(child);
        }
    }

    public static boolean codexFullyUnlocked() {
        return Global.getSettings().getBoolean("allCodexEntriesUnlocked");
    }

    public static List<CodexEntryPlugin> createTempFleetMemberEntry(final FleetMemberAPI member) {
        final ShipHullSpecAPI spec = member.getHullSpec();
        final ShipVariantAPI variant = member.getVariant();
        String entryId = UUID.randomUUID().toString();
        boolean station = spec.getHints().contains((Object)ShipHullSpecAPI.ShipTypeHints.STATION);
        boolean limited = variant.hasTag("ship_limited_tooltip");
        if (!SharedUnlockData.get().isPlayerAwareOfShip(variant.getHullSpec().getRestoredToHullId())) {
            limited |= variant.hasTag("limited_tooltip_if_locked");
            limited |= member.getHullSpec().hasTag("limited_tooltip_if_locked");
        }
        final boolean limited2 = limited;
        final Description desc = Global.getSettings().getDescription(spec.getDescriptionId(), Description.Type.SHIP);
        String entryName = variant.getFullDesignationWithHullNameForShip();
        if (!(station || member.getShipName() == null || member.getShipName().isBlank() || member.isFighterWing())) {
            entryName = String.valueOf(member.getShipName()) + ", " + entryName;
        }
        if (limited) {
            entryName = desc.getText2();
        }
        CodexEntryV2 entry = new CodexEntryV2(entryId, entryName, null, member){

            @Override
            public void createTitleForList(TooltipMakerAPI info, float width, CodexEntryPlugin.ListMode mode) {
                String name = member.getShipName();
                if (name == null || name.isBlank()) {
                    name = spec.getHullName();
                }
                info.addPara(name, Misc.getBasePlayerColor(), 0.0f);
                if (limited2) {
                    info.addPara(Misc.ucFirst(desc.getText2().toLowerCase()), Misc.getGrayColor(), 0.0f);
                } else if (spec.hasDesignation() && !spec.getDesignation().equals(spec.getHullName())) {
                    info.addPara(Misc.ucFirst(variant.getFullDesignationForShip().toLowerCase()), Misc.getGrayColor(), 0.0f);
                } else if (spec.getHints().contains((Object)ShipHullSpecAPI.ShipTypeHints.STATION)) {
                    info.addPara("Station", Misc.getGrayColor(), 0.0f);
                } else if (spec.getHints().contains((Object)ShipHullSpecAPI.ShipTypeHints.MODULE)) {
                    info.addPara("Module", Misc.getGrayColor(), 0.0f);
                }
            }

            @Override
            public boolean matchesTags(Set<String> tags) {
                return false;
            }

            @Override
            public boolean isVisible() {
                return true;
            }

            @Override
            public boolean isLocked() {
                return false;
            }
        };
        CodexDataV2.linkFleetMemberEntryToRelated(entry, member, true);
        CodexEntryPlugin parent = CodexDataV2.getEntry(CAT_SHIPS);
        if (station) {
            parent = CodexDataV2.getEntry(CAT_STATIONS);
        }
        entry.setParent(parent);
        ArrayList<CodexEntryPlugin> result = new ArrayList<CodexEntryPlugin>();
        result.add(entry);
        List<CodexEntryPlugin> modules = CodexDataV2.addModulesForVariant(member.getVariant(), false, entry, parent);
        result.addAll(modules);
        return result;
    }

    public static void linkFleetMemberEntryToRelated(CodexEntryPlugin entry, FleetMemberAPI member, boolean linkCaptainSkills) {
        CodexEntryPlugin other;
        String key;
        CodexEntryPlugin sys;
        String sysId;
        ShipHullSpecAPI spec = member.getHullSpec();
        ShipVariantAPI variant = member.getVariant();
        CodexEntryPlugin hullEntry = CodexDataV2.getEntry(CodexDataV2.getFleetMemberEntryId(member));
        if (hullEntry != null) {
            for (CodexEntryPlugin rel : hullEntry.getRelatedEntries()) {
                if (rel.hasTag(TAG_EMPTY_MODULE) || rel.getParam2() instanceof FleetMemberAPI) continue;
                entry.addRelatedEntry(rel);
                rel.addRelatedEntry(entry);
            }
        }
        if ((sysId = spec.getShipSystemId()) != null && !sysId.isBlank() && (sys = CodexDataV2.getEntry(key = CodexDataV2.getShipSystemEntryId(sysId))) != null) {
            ShipVariantAPI drone;
            ShipSystemSpecAPI sysSpec;
            sys.addRelatedEntry(entry);
            entry.addRelatedEntry(sys);
            if (sys.getParam() instanceof ShipSystemSpecAPI && (sysSpec = (ShipSystemSpecAPI)sys.getParam()).getDroneVariant() != null && (drone = Global.getSettings().getVariant(sysSpec.getDroneVariant())) != null) {
                String droneHullId = CodexDataV2.getBaseHullId(drone.getHullSpec());
                String droneEntryId = CodexDataV2.getShipEntryId(droneHullId);
                CodexDataV2.makeRelated(entry.getId(), droneEntryId);
                CodexDataV2.makeRelated(sys.getId(), droneEntryId);
            }
        }
        for (String slotId : variant.getFittedWeaponSlots()) {
            String wid = variant.getWeaponId(slotId);
            CodexEntryPlugin other2 = CodexDataV2.getEntry(CodexDataV2.getWeaponEntryId(wid));
            if (other2 == null) continue;
            entry.addRelatedEntry(other2);
            other2.addRelatedEntry(entry);
        }
        for (String wingId : variant.getFittedWings()) {
            other = CodexDataV2.getEntry(CodexDataV2.getFighterEntryId(wingId));
            if (other == null) continue;
            entry.addRelatedEntry(other);
            other.addRelatedEntry(entry);
        }
        for (String hullmodId : variant.getHullMods()) {
            other = CodexDataV2.getEntry(CodexDataV2.getHullmodEntryId(hullmodId));
            if (other == null) continue;
            entry.addRelatedEntry(other);
            other.addRelatedEntry(entry);
        }
        if (linkCaptainSkills && member.getCaptain() != null && !member.getCaptain().isDefault()) {
            for (MutableCharacterStatsAPI.SkillLevelAPI sl : member.getCaptain().getStats().getSkillsCopy()) {
                if (!(sl.getLevel() > 0.0f) || !sl.getSkill().isCombatOfficerSkill() || (other = CodexDataV2.getEntry(CodexDataV2.getSkillEntryId(sl.getSkill().getId()))) == null) continue;
                entry.addRelatedEntry(other);
                other.addRelatedEntry(entry);
            }
        }
    }

    public static boolean hasUnlockedEntry(String entryId) {
        CodexEntryPlugin entry = CodexDataV2.getEntry(entryId);
        return entry != null && !entry.isLocked();
    }

    public static boolean hasUnlockedEntryForShip(String hullId) {
        CodexEntryPlugin entry = CodexDataV2.getEntry(CodexDataV2.getShipEntryId(hullId));
        return entry != null && !entry.isLocked();
    }

    public static void unlinkAndRemoveTempEntry(CodexEntryPlugin entry) {
        if (entry == null) {
            return;
        }
        for (CodexEntryPlugin rel : entry.getRelatedEntries()) {
            rel.removeRelatedEntry(entry.getId());
            entry.removeRelatedEntry(rel.getId());
        }
        ENTRIES.remove(entry.getId());
        LinkedHashSet<String> remove = new LinkedHashSet<String>();
        for (String id : SEEN_STATION_MODULES.keySet()) {
            if (SEEN_STATION_MODULES.get(id) != entry) continue;
            remove.add(id);
        }
        for (String id : remove) {
            SEEN_STATION_MODULES.remove(id);
        }
        if (entry.getParent() != null) {
            entry.getParent().getChildren().remove(entry);
        }
    }

    public static class GalleryEntryData
    implements WithSourceMod {
        public String sprite;
        public Description desc;
        public ModSpecAPI sourceMod;

        @Override
        public ModSpecAPI getSourceMod() {
            return this.sourceMod;
        }
    }
}

