/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.GameState;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.EmpArcEntityAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.AdvanceableListener;
import com.fs.starfarer.api.impl.combat.CombatEntityPluginWithParticles;
import com.fs.starfarer.api.impl.combat.RiftCascadeEffect;
import com.fs.starfarer.api.impl.combat.RiftLanceEffect;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class RealityDisruptorChargeGlow
extends CombatEntityPluginWithParticles {
    public static float ARC_RATE_MULT = 2.0f;
    public static int MAX_ARC_RANGE = 600;
    public static float REPAIR_RATE_MULT = 0.5f;
    public static float REPAIR_RATE_DEBUFF_DUR = 5.0f;
    public static Color UNDERCOLOR = RiftCascadeEffect.EXPLOSION_UNDERCOLOR;
    public static Color RIFT_COLOR = RiftCascadeEffect.STANDARD_RIFT_COLOR;
    public static Object STATUS_KEY = new Object();
    protected WeaponAPI weapon;
    protected DamagingProjectileAPI proj;
    protected IntervalUtil interval = new IntervalUtil(0.1f, 0.2f);
    protected IntervalUtil arcInterval = new IntervalUtil(0.17f, 0.23f);
    protected float delay = 1.0f;

    public RealityDisruptorChargeGlow(WeaponAPI weapon) {
        this.weapon = weapon;
        this.arcInterval = new IntervalUtil(0.17f, 0.23f);
        this.delay = 0.5f;
        this.setSpriteSheetKey("fx_particles2");
    }

    public void attachToProjectile(DamagingProjectileAPI proj) {
        this.proj = proj;
    }

    @Override
    public void advance(float amount) {
        boolean keepSpawningParticles;
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        if (this.proj != null) {
            this.entity.getLocation().set((ReadableVector2f)this.proj.getLocation());
        } else {
            this.entity.getLocation().set((ReadableVector2f)this.weapon.getFirePoint(0));
        }
        super.advance(amount);
        boolean bl = keepSpawningParticles = RealityDisruptorChargeGlow.isWeaponCharging(this.weapon) || this.proj != null && !RealityDisruptorChargeGlow.isProjectileExpired(this.proj) && !this.proj.isFading();
        if (keepSpawningParticles) {
            this.interval.advance(amount);
            if (this.interval.intervalElapsed()) {
                this.addChargingParticles(this.weapon);
            }
        }
        if (this.proj != null && !RealityDisruptorChargeGlow.isProjectileExpired(this.proj) && !this.proj.isFading()) {
            this.delay -= amount;
            if (this.delay <= 0.0f) {
                this.arcInterval.advance(amount * ARC_RATE_MULT);
                if (this.arcInterval.intervalElapsed()) {
                    this.spawnArc();
                }
            }
        }
        if (this.proj != null) {
            Global.getSoundPlayer().playLoop("realitydisruptor_loop", this.proj, 1.0f, 1.0f * this.proj.getBrightness(), this.proj.getLocation(), this.proj.getVelocity());
        }
    }

    @Override
    public void render(CombatEngineLayers layer, ViewportAPI viewport) {
        super.render(layer, viewport, null);
    }

    @Override
    public boolean isExpired() {
        boolean keepSpawningParticles;
        boolean bl = keepSpawningParticles = RealityDisruptorChargeGlow.isWeaponCharging(this.weapon) || this.proj != null && !RealityDisruptorChargeGlow.isProjectileExpired(this.proj) && !this.proj.isFading();
        return super.isExpired() && (!keepSpawningParticles || !this.weapon.getShip().isAlive() && this.proj == null);
    }

    @Override
    public float getRenderRadius() {
        return 500.0f;
    }

    @Override
    protected float getGlobalAlphaMult() {
        if (this.proj != null && this.proj.isFading()) {
            return this.proj.getBrightness();
        }
        return super.getGlobalAlphaMult();
    }

    public void spawnArc() {
        CombatEngineAPI engine = Global.getCombatEngine();
        float emp = this.proj.getEmpAmount();
        float dam = this.proj.getDamageAmount();
        CombatEntityAPI target = this.findTarget(this.proj, this.weapon, engine);
        float thickness = 20.0f;
        float coreWidthMult = 0.67f;
        Color color = this.weapon.getSpec().getGlowColor();
        if (target != null) {
            EmpArcEntityAPI arc = engine.spawnEmpArc(this.proj.getSource(), this.proj.getLocation(), null, target, DamageType.ENERGY, dam, emp, 100000.0f, "realitydisruptor_emp_impact", thickness, color, new Color(255, 255, 255, 255));
            arc.setCoreWidthOverride(thickness * coreWidthMult);
            RealityDisruptorChargeGlow.spawnEMPParticles(EMPArcHitType.SOURCE, this.proj, this.proj.getLocation(), null);
            RealityDisruptorChargeGlow.spawnEMPParticles(EMPArcHitType.DEST, this.proj, arc.getTargetLocation(), target);
            if (target instanceof ShipAPI) {
                ShipAPI s = (ShipAPI)target;
                List<RDRepairRateDebuff> listeners = s.getListeners(RDRepairRateDebuff.class);
                if (listeners.isEmpty()) {
                    s.addListener(new RDRepairRateDebuff(s, REPAIR_RATE_DEBUFF_DUR));
                } else {
                    listeners.get(0).resetDur(REPAIR_RATE_DEBUFF_DUR);
                }
            }
        } else {
            Vector2f from = new Vector2f((ReadableVector2f)this.proj.getLocation());
            Vector2f to = this.pickNoTargetDest(this.proj, this.weapon, engine);
            EmpArcEntityAPI arc = engine.spawnEmpArcVisual(from, null, to, null, thickness, color, Color.white);
            arc.setCoreWidthOverride(thickness * coreWidthMult);
            Global.getSoundPlayer().playSound("realitydisruptor_emp_impact", 1.0f, 1.0f, to, new Vector2f());
            RealityDisruptorChargeGlow.spawnEMPParticles(EMPArcHitType.SOURCE, this.proj, from, null);
            RealityDisruptorChargeGlow.spawnEMPParticles(EMPArcHitType.DEST_NO_TARGET, this.proj, to, null);
        }
    }

    public Vector2f pickNoTargetDest(DamagingProjectileAPI projectile, WeaponAPI weapon, CombatEngineAPI engine) {
        float range = 200.0f;
        Vector2f from = projectile.getLocation();
        Vector2f dir = Misc.getUnitVectorAtDegreeAngle((float)Math.random() * 360.0f);
        dir.scale(range);
        Vector2f.add((Vector2f)from, (Vector2f)dir, (Vector2f)dir);
        dir = Misc.getPointWithinRadius(dir, range * 0.25f);
        return dir;
    }

    public CombatEntityAPI findTarget(DamagingProjectileAPI projectile, WeaponAPI weapon, CombatEngineAPI engine) {
        float range = MAX_ARC_RANGE;
        Vector2f from = projectile.getLocation();
        Iterator<Object> iter = Global.getCombatEngine().getAllObjectGrid().getCheckIterator(from, range * 2.0f, range * 2.0f);
        int owner = weapon.getShip().getOwner();
        CombatEntityAPI best = null;
        float minScore = Float.MAX_VALUE;
        while (iter.hasNext()) {
            float score;
            ShipAPI otherShip;
            CombatEntityAPI other;
            Object o = iter.next();
            if (!(o instanceof MissileAPI) && !(o instanceof ShipAPI) || (other = (CombatEntityAPI)o).getOwner() == owner || other instanceof ShipAPI && ((otherShip = (ShipAPI)other).isHulk() || otherShip.isPhased() || !otherShip.isTargetable()) || other.getCollisionClass() == CollisionClass.NONE) continue;
            float radius = Misc.getTargetingRadius(from, other, false);
            float dist = Misc.getDistance(from, other.getLocation()) - radius - 50.0f;
            if (dist > range || !((score = dist) < minScore)) continue;
            minScore = score;
            best = other;
        }
        return best;
    }

    public void addChargingParticles(WeaponAPI weapon) {
        Color color = RiftLanceEffect.getColorForDarkening(RIFT_COLOR);
        float size = 50.0f;
        float underSize = 75.0f;
        float in = 0.25f;
        float out = 0.75f;
        out *= 3.0f;
        float velMult = 0.2f;
        if (RealityDisruptorChargeGlow.isWeaponCharging(weapon)) {
            size *= 0.25f + weapon.getChargeLevel() * 0.75f;
        }
        this.addDarkParticle(size, in, out, 1.0f, size * 0.5f * velMult, 0.0f, color);
        this.randomizePrevParticleLocation(size * 0.33f);
        if (this.proj != null) {
            Vector2f offset;
            Vector2f dir = Misc.getUnitVectorAtDegreeAngle(this.proj.getFacing() + 180.0f);
            if (this.proj.getElapsed() > 0.2f) {
                this.addDarkParticle(size, in, out, 1.5f, size * 0.5f * velMult, 0.0f, color);
                offset = new Vector2f((ReadableVector2f)dir);
                offset.scale(size * 0.6f + (float)Math.random() * 0.2f);
                Vector2f.add((Vector2f)this.prev.offset, (Vector2f)offset, (Vector2f)this.prev.offset);
            }
            if (this.proj.getElapsed() > 0.4f) {
                this.addDarkParticle(size * 1.0f, in, out, 1.3f, size * 0.5f * velMult, 0.0f, color);
                offset = new Vector2f((ReadableVector2f)dir);
                offset.scale(size * 1.2f + (float)Math.random() * 0.2f);
                Vector2f.add((Vector2f)this.prev.offset, (Vector2f)offset, (Vector2f)this.prev.offset);
            }
            if (this.proj.getElapsed() > 0.6f) {
                this.addDarkParticle(size * 0.8f, in, out, 1.1f, size * 0.5f * velMult, 0.0f, color);
                offset = new Vector2f((ReadableVector2f)dir);
                offset.scale(size * 1.6f + (float)Math.random() * 0.2f);
                Vector2f.add((Vector2f)this.prev.offset, (Vector2f)offset, (Vector2f)this.prev.offset);
            }
            if (this.proj.getElapsed() > 0.8f) {
                this.addDarkParticle(size * 0.8f, in, out, 1.1f, size * 0.5f * velMult, 0.0f, color);
                offset = new Vector2f((ReadableVector2f)dir);
                offset.scale(size * 2.0f + (float)Math.random() * 0.2f);
                Vector2f.add((Vector2f)this.prev.offset, (Vector2f)offset, (Vector2f)this.prev.offset);
            }
        }
        this.addParticle(underSize * 0.5f, in, out, 4.5f, 0.0f, 0.0f, UNDERCOLOR);
        this.randomizePrevParticleLocation(underSize * 0.67f);
        this.addParticle(underSize * 0.5f, in, out, 4.5f, 0.0f, 0.0f, UNDERCOLOR);
        this.randomizePrevParticleLocation(underSize * 0.67f);
    }

    public static void spawnEMPParticles(EMPArcHitType type, DamagingProjectileAPI proj, Vector2f point, CombatEntityAPI target) {
        CombatEngineAPI engine = Global.getCombatEngine();
        Color color = RiftLanceEffect.getColorForDarkening(RIFT_COLOR);
        float size = 30.0f;
        float baseDuration = 1.5f;
        Vector2f vel = new Vector2f();
        int numNegative = 5;
        int numSwirly = 7;
        switch (type) {
            case DEST: {
                size = 50.0f;
                vel.set((ReadableVector2f)target.getVelocity());
                if (!(vel.length() > 100.0f)) break;
                vel.scale(100.0f / vel.length());
                break;
            }
            case DEST_NO_TARGET: {
                break;
            }
            case INIMICAL_EMANATION: {
                numNegative = 5;
                numSwirly = 7;
                size = 25.0f;
                color = RiftLanceEffect.getColorForDarkening(UNDERCOLOR);
                baseDuration = 1.0f;
                if (target == null || target instanceof MissileAPI) break;
                vel.set((ReadableVector2f)target.getVelocity());
                break;
            }
            case SOURCE: {
                size = 40.0f;
                numNegative = 10;
            }
        }
        boolean inimical = type == EMPArcHitType.INIMICAL_EMANATION;
        int i = 0;
        while (i < numNegative) {
            float dur = baseDuration + baseDuration * (float)Math.random();
            float nSize = size;
            if (type == EMPArcHitType.SOURCE) {
                nSize *= 1.5f;
            }
            float scatterMult = 1.0f;
            if (inimical) {
                scatterMult = 0.25f;
            }
            Vector2f pt = Misc.getPointWithinRadius(point, nSize * 0.5f * scatterMult);
            Vector2f v = Misc.getUnitVectorAtDegreeAngle((float)Math.random() * 360.0f);
            v.scale(nSize + nSize * (float)Math.random() * 0.5f);
            v.scale(0.2f);
            float endSizeMult = 2.0f;
            if (type == EMPArcHitType.SOURCE) {
                Vector2f dir = Misc.getUnitVectorAtDegreeAngle(proj.getFacing() + 180.0f);
                pt = Misc.getPointWithinRadius(point, nSize * 0.0f);
                Vector2f offset = new Vector2f((ReadableVector2f)dir);
                offset.scale(size * 0.2f * (float)i);
                Vector2f.add((Vector2f)pt, (Vector2f)offset, (Vector2f)pt);
                endSizeMult = 1.5f;
                v.scale(0.5f);
            }
            Vector2f.add((Vector2f)vel, (Vector2f)v, (Vector2f)v);
            float maxSpeed = nSize * 1.5f * 0.2f;
            float minSpeed = nSize * 1.0f * 0.2f;
            float overMin = v.length() - minSpeed;
            if (overMin > 0.0f) {
                float durMult = 1.0f - overMin / (maxSpeed - minSpeed);
                if (durMult < 0.1f) {
                    durMult = 0.1f;
                }
                dur *= 0.5f + 0.5f * durMult;
            }
            float rampUp = 0.25f / dur;
            if (inimical) {
                rampUp = 0.0f;
            }
            engine.addNegativeNebulaParticle(pt, v, nSize * 1.0f, endSizeMult, rampUp, 0.0f, dur, color);
            ++i;
        }
        float dur = baseDuration;
        float rampUp = 0.5f / dur;
        if (inimical) {
            rampUp = 0.0f;
        }
        color = UNDERCOLOR;
        int i2 = 0;
        while (i2 < numSwirly) {
            Vector2f loc = new Vector2f((ReadableVector2f)point);
            float scatterMult = 1.0f;
            if (inimical) {
                scatterMult = 0.5f;
            }
            loc = Misc.getPointWithinRadius(loc, size * 1.0f * scatterMult);
            float s = size * 4.0f * (0.5f + (float)Math.random() * 0.5f);
            engine.addSwirlyNebulaParticle(loc, vel, s, 1.5f, rampUp, 0.0f, dur, color, false);
            ++i2;
        }
    }

    public static boolean isProjectileExpired(DamagingProjectileAPI proj) {
        return proj.isExpired() || proj.didDamage() || !Global.getCombatEngine().isEntityInPlay(proj);
    }

    public static boolean isWeaponCharging(WeaponAPI weapon) {
        return weapon.getChargeLevel() > 0.0f && weapon.getCooldownRemaining() <= 0.0f;
    }

    public static enum EMPArcHitType {
        SOURCE,
        DEST,
        DEST_NO_TARGET,
        INIMICAL_EMANATION;

    }

    public static class RDRepairRateDebuff
    implements AdvanceableListener {
        public static String DEBUFF_ID = "reality_disruptor_repair_debuff";
        public ShipAPI ship;
        public float dur = REPAIR_RATE_DEBUFF_DUR;

        public RDRepairRateDebuff(ShipAPI ship, float dur) {
            this.ship = ship;
            this.dur = dur;
            ship.getMutableStats().getCombatEngineRepairTimeMult().modifyMult(DEBUFF_ID, 1.0f / REPAIR_RATE_MULT);
            ship.getMutableStats().getCombatWeaponRepairTimeMult().modifyMult(DEBUFF_ID, 1.0f / REPAIR_RATE_MULT);
        }

        public void resetDur(float dur) {
            this.dur = Math.max(this.dur, dur);
        }

        @Override
        public void advance(float amount) {
            this.dur -= amount;
            if (Global.getCurrentState() == GameState.COMBAT && Global.getCombatEngine() != null && Global.getCombatEngine().getPlayerShip() == this.ship) {
                Global.getCombatEngine().maintainStatusForPlayerShip(STATUS_KEY, Global.getSettings().getSpriteName("ui", "icon_tactical_reality_disruptor"), "REALITY DISRUPTED", "SLOWER REPAIRS: " + Math.max(1, Math.round(this.dur)) + " SEC", true);
            }
            if (this.dur <= 0.0f) {
                this.ship.removeListener(this);
                this.ship.getMutableStats().getCombatEngineRepairTimeMult().unmodify(DEBUFF_ID);
                this.ship.getMutableStats().getCombatWeaponRepairTimeMult().unmodify(DEBUFF_ID);
            }
        }
    }
}

